/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.queue;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.MessageDriver;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.jms.queue.QueueConnection;
import java.util.Properties;
import java.util.Vector;

public class JMSQueueDriver
implements MessageDriver {
    public static final String CONTEXT_FACTORY = "contextFactory";
    public static final String JNDI_URL = "jndiURL";
    public static final String SECURITY_CREDENTIAL = "securityCredential";
    public static final String SECURITY_PRINCIPAL = "securityPrincipal";
    public static final String CONNECTION_FACTORY_JNDINAME = "connectionFactoryJNDIName";
    public static final String QUEUE_JNDINAME = "queueJNDIName";

    @Override
    public Connection connect(String url, Properties info) throws MessageException {
        if (!this.acceptsURL(url)) {
            throw new MessageException("url not suitable for this driver");
        }
        return new QueueConnection(url, info);
    }

    @Override
    public boolean acceptsURL(String url) throws MessageException {
        String[] protocol = JMSQueueDriver.split(url, ":");
        if (protocol.length < 3) {
            return false;
        }
        if (!protocol[0].equalsIgnoreCase("bosmessage")) {
            return false;
        }
        if (!protocol[1].equalsIgnoreCase("jms")) {
            return false;
        }
        return protocol[2].equalsIgnoreCase("queue");
    }

    private static String[] split(String line, String seperator) {
        int j;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while ((j = line.indexOf(seperator, i)) >= 0) {
            v.addElement(line.substring(i, j).trim());
            i = j + seperator.length();
        }
        v.addElement(line.substring(i).trim());
        int size = v.size();
        Object[] ps = new String[size];
        if (size > 0) {
            v.copyInto(ps);
        }
        return ps;
    }
}

