/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.queue;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.jms.MessageConvert;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;

public class QueueMessageProducer
implements MessageProducer {
    QueueConnection queueConnection;
    Queue queue;
    QueueSession session;
    QueueSender sender;
    boolean transactionSupport;
    int acknowledgeMode;

    public QueueMessageProducer(QueueConnection queueConnection, Queue queue, Properties props) throws MessageException {
        try {
            this.queueConnection = queueConnection;
            this.queue = queue;
            if (props != null) {
                Object amObj;
                block14: {
                    Object tsObj = props.get("transactionSupport");
                    if (tsObj != null) {
                        try {
                            if (tsObj instanceof Boolean) {
                                this.transactionSupport = (Boolean)tsObj;
                                break block14;
                            }
                            this.transactionSupport = Boolean.valueOf(tsObj.toString());
                        }
                        catch (Exception exception) {}
                    } else {
                        this.transactionSupport = false;
                    }
                }
                if ((amObj = props.get("acknowledgeMode")) != null) {
                    try {
                        this.acknowledgeMode = amObj instanceof Integer ? (Integer)amObj : Integer.parseInt(amObj.toString());
                        if (this.acknowledgeMode != 1 && this.acknowledgeMode != 2 && this.acknowledgeMode != 3) {
                            throw new MessageException("invalid acknowledge mode setting");
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    this.acknowledgeMode = 1;
                }
            } else {
                this.transactionSupport = false;
                this.acknowledgeMode = 1;
            }
            this.session = queueConnection.createQueueSession(this.transactionSupport, this.acknowledgeMode);
            this.sender = this.session.createSender(queue);
        }
        catch (JMSException me) {
            throw new MessageException("JMS Exception", me);
        }
    }

    @Override
    public void send(Message message) throws MessageException {
        try {
            this.sender.send(MessageConvert.convertToJMS((Session)this.session, message));
        }
        catch (JMSException me) {
            throw new MessageException("JMS Exception", me);
        }
    }

    @Override
    public void close() throws MessageException {
        if (this.sender != null) {
            try {
                this.sender.close();
            }
            catch (JMSException me) {
                throw new MessageException("JMS Exception", me);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException me) {
                throw new MessageException("JMS Exception", me);
            }
        }
    }
}

