/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.topic;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.MessageDriver;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.jms.topic.TopicConnection;
import com.kingdee.util.StringUtils;
import java.util.Properties;

public class JMSTopicDriver
implements MessageDriver {
    public static final String CONTEXT_FACTORY = "contextFactory";
    public static final String JNDI_URL = "jndiURL";
    public static final String SECURITY_CREDENTIAL = "securityCredential";
    public static final String SECURITY_PRINCIPAL = "securityPrincipal";
    public static final String CONNECTION_FACTORY_JNDINAME = "connectionFactoryJNDIName";
    public static final String TOPIC_JNDINAME = "topicJNDIName";
    public static final String IS_DEFAULT_LOCAL = "isLocal";

    @Override
    public Connection connect(String url, Properties info) throws MessageException {
        if (!this.acceptsURL(url)) {
            throw new MessageException("url not suitable for this driver");
        }
        return new TopicConnection(url, info);
    }

    @Override
    public boolean acceptsURL(String url) {
        String[] protocol = StringUtils.split((String)url, (String)":");
        if (protocol.length < 3) {
            return false;
        }
        if (!protocol[0].equalsIgnoreCase("bosmessage")) {
            return false;
        }
        if (!protocol[1].equalsIgnoreCase("jms")) {
            return false;
        }
        return protocol[2].equalsIgnoreCase("topic");
    }
}

