/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.jms.topic;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.jms.JMSMessageListenerImpl;
import com.kingdee.bos.service.message.jms.MessageConvert;
import com.kingdee.util.TypeConversionUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.log4j.Logger;

public class TopicMessageConsumer
implements MessageConsumer {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.message.jms.topic.TopicMessageConsumer");
    TopicConnection topicConnection;
    Topic topic;
    TopicSession session;
    TopicSubscriber receiver;
    JMSMessageListenerImpl listener;
    boolean transactionSupport;
    int acknowledgeMode;
    String selector;

    public TopicMessageConsumer(TopicConnection topicConnection, Topic topic, Properties props) throws MessageException {
        try {
            this.topicConnection = topicConnection;
            this.topic = topic;
            if (props != null) {
                Object tsObj = props.get("transactionSupport");
                this.transactionSupport = tsObj != null ? TypeConversionUtils.objToBoolean((Object)tsObj) : false;
                this.getAcknowledgeMode(props);
                this.buildSelector(props);
            } else {
                this.transactionSupport = false;
                this.acknowledgeMode = 1;
            }
            this.session = this.topicConnection.createTopicSession(this.transactionSupport, this.acknowledgeMode);
            if (props != null && TypeConversionUtils.objToBoolean((Object)props.get("durable"))) {
                String subscribeId = (String)props.get("subscribeId");
                if (subscribeId == null) {
                    throw new MessageException("subscribeId cannot be null when durable subscribe");
                }
                this.receiver = this.session.createDurableSubscriber(topic, subscribeId, this.selector, false);
            } else {
                this.receiver = this.session.createSubscriber(this.topic, this.selector, false);
            }
        }
        catch (JMSException me) {
            throw new MessageException("is ...", me);
        }
    }

    @Override
    public Message receive() throws MessageException {
        try {
            javax.jms.Message jmsMessage = this.receiver.receive();
            if (jmsMessage instanceof TextMessage) {
                return MessageConvert.convertFromJMS(jmsMessage);
            }
            return null;
        }
        catch (JMSException me) {
            throw new MessageException("", me);
        }
    }

    @Override
    public Message receive(long timeout) throws MessageException {
        try {
            javax.jms.Message jmsMessage = this.receiver.receive(timeout);
            if (jmsMessage instanceof TextMessage) {
                return MessageConvert.convertFromJMS(jmsMessage);
            }
            return null;
        }
        catch (JMSException me) {
            throw new MessageException("", me);
        }
    }

    @Override
    public Message receiveNoWait() throws MessageException {
        try {
            javax.jms.Message jmsMessage = this.receiver.receiveNoWait();
            if (jmsMessage instanceof TextMessage) {
                return MessageConvert.convertFromJMS(jmsMessage);
            }
            return null;
        }
        catch (JMSException me) {
            throw new MessageException("", me);
        }
    }

    @Override
    public void setMessageListener(MessageListener listener) throws MessageException {
        if (this.listener == null) {
            this.listener = new JMSMessageListenerImpl(listener);
            try {
                this.receiver.setMessageListener((javax.jms.MessageListener)this.listener);
            }
            catch (JMSException ex) {
                throw new MessageException("JMS Exception", ex);
            }
        }
    }

    @Override
    public void close() throws MessageException {
        if (this.receiver != null) {
            try {
                this.receiver.close();
            }
            catch (JMSException me) {
                throw new MessageException("", me);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException me) {
                throw new MessageException("", me);
            }
        }
    }

    private void getAcknowledgeMode(Properties props) throws MessageException {
        Object amObj = props.get("acknowledgeMode");
        if (amObj != null) {
            try {
                this.acknowledgeMode = amObj instanceof Integer ? (Integer)amObj : Integer.parseInt(amObj.toString());
                if (this.acknowledgeMode != 1 && this.acknowledgeMode != 2 && this.acknowledgeMode != 3) {
                    throw new MessageException("invalid acknowledge mode setting");
                }
            }
            catch (Exception exception) {}
        } else {
            this.acknowledgeMode = 1;
        }
    }

    private void buildSelector(Properties props) {
        String filterString;
        HashMap headerSelector;
        String domain = (String)props.get("messageDomianPrefix");
        StringBuffer sb = new StringBuffer("");
        if (domain != null) {
            sb.append("BosMessageDomain");
            sb.append(" LIKE '");
            sb.append(domain);
            sb.append("%'");
        }
        if ((headerSelector = (HashMap)props.get("selector")) != null) {
            Iterator iter = headerSelector.keySet().iterator();
            boolean i = false;
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object headerValue = headerSelector.get(name);
                if (i || !i && sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append("BosHeader_");
                sb.append(name);
                sb.append(" = ");
                if (!(headerValue instanceof String)) {
                    sb.append(headerValue.toString());
                    continue;
                }
                sb.append("'").append(headerValue.toString()).append("'");
            }
        }
        if ((filterString = props.getProperty("filter")) != null && filterString.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(filterString);
        }
        this.selector = sb.toString();
        log.debug((Object)("message selector is :" + this.selector));
    }
}

