/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.mail;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.mail.MailMessageConsumer;
import com.kingdee.bos.service.message.mail.MailMessageProducer;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public class MailConnection
implements Connection {
    String smtpServer;
    String pop3Server;
    String authUser;
    String authPassword;
    String user;
    String password;
    boolean needAuth;
    Session session;

    public MailConnection(Properties info) throws MessageException {
        this.smtpServer = info.getProperty("smtpServer");
        this.pop3Server = info.getProperty("pop3Server");
        this.needAuth = false;
        Object naObj = info.get("needAuth");
        if (naObj != null) {
            if (naObj instanceof Boolean) {
                this.needAuth = (Boolean)naObj;
            } else {
                try {
                    this.needAuth = Boolean.valueOf(naObj.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.authUser = info.getProperty("authUser", "");
        this.authPassword = info.getProperty("authPassword", "");
        this.authUser = info.getProperty("user", "");
        this.authPassword = info.getProperty("password", "");
        Properties props = new Properties();
        if (this.smtpServer != null) {
            props.setProperty("mail.smtp.host", this.smtpServer);
        }
        if (this.needAuth) {
            props.put("mail.smtp.auth", "true");
            SMTPAuthenticator auth = new SMTPAuthenticator(this.authUser, this.authPassword);
            this.session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
        } else {
            this.session = Session.getDefaultInstance((Properties)props);
        }
    }

    @Override
    public MessageProducer createSender(Properties props) throws MessageException {
        return new MailMessageProducer(this, props);
    }

    @Override
    public MessageConsumer createRecevier(Properties props) throws MessageException {
        return new MailMessageConsumer(this, props);
    }

    @Override
    public void close() throws MessageException {
    }

    private static class SMTPAuthenticator
    extends Authenticator {
        String userName;
        String password;

        public SMTPAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password);
        }
    }
}

