/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.mail;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.mail.MailConnection;
import com.kingdee.bos.service.message.mail.MailMessage;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;

public class MailMessageConsumer
implements MessageConsumer {
    MailConnection connection;

    public MailMessageConsumer(MailConnection connection, Properties props) {
        this.connection = connection;
    }

    @Override
    public Message receive() throws MessageException {
        try {
            Store store = this.connection.session.getStore("pop3");
            store.connect(this.connection.pop3Server, this.connection.user, this.connection.password);
            Folder folder = store.getDefaultFolder();
            if (folder == null) {
                throw new MessageException("folder is null");
            }
            if ((folder = folder.getFolder("INBOX")) == null) {
                throw new MessageException("inbox folder is null");
            }
            folder.open(1);
            javax.mail.Message[] messages = folder.getMessages();
            if (messages == null || messages.length == 0) {
                return null;
            }
            MailMessage mm = new MailMessage();
            javax.mail.Message m = messages[0];
            mm.from(((InternetAddress)m.getFrom()[0]).getAddress());
            mm.setSubject(m.getSubject());
            return mm;
        }
        catch (MessagingException ex) {
            throw new MessageException("", ex);
        }
    }

    @Override
    public Message receive(long timeout) throws MessageException {
        return this.receive();
    }

    @Override
    public Message receiveNoWait() throws MessageException {
        return this.receive();
    }

    @Override
    public void setMessageListener(MessageListener listener) throws MessageException {
        throw new UnsupportedOperationException("not implements this method");
    }

    @Override
    public void close() throws MessageException {
    }
}

