/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.message.mail;

import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageProducer;
import com.kingdee.bos.service.message.mail.MailConnection;
import com.kingdee.bos.service.message.mail.MailMessage;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailMessageProducer
implements MessageProducer {
    MailConnection connection;

    public MailMessageProducer(MailConnection connection, Properties props) {
        this.connection = connection;
    }

    @Override
    public void send(Message message) throws MessageException {
        try {
            if (!(message instanceof MailMessage)) {
                throw new MessageException("you MUST send MailMesage");
            }
            MailMessage mail = (MailMessage)message;
            MimeMessage mm = new MimeMessage(this.connection.session);
            mm.setFrom((Address)new InternetAddress(mail.getFrom()));
            Iterator toList = mail.toList();
            while (toList.hasNext()) {
                mm.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress((String)toList.next()));
            }
            Iterator ccList = mail.ccList();
            while (ccList.hasNext()) {
                mm.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress((String)ccList.next()));
            }
            mm.setSubject(mail.getSubject());
            mm.setText(mail.getBody());
            Transport.send((javax.mail.Message)mm);
        }
        catch (MessagingException ex) {
            throw new MessageException("mail send error", ex);
        }
    }

    @Override
    public void close() throws MessageException {
    }
}

