/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationException;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOSLocaleUtil {
    private static final Logger logger = Logger.getLogger(BOSLocaleUtil.class);
    private static SolutionInfo _solution = null;
    private static final List<LanguageInfo> configLanguages;
    private static final Map<String, Object> properties;
    public static final String NUMBERFORMAT = "numberFormat";
    public static final String DECIMALFORMAT = "decimalFormat";
    public static final String CURRENCYFORMAT = "currencyFormat";
    public static final String DECIMALFORMATSYMBOLS = "decimalFormatSymbols";
    public static final String DATEFORMAT = "dateFormat";
    public static final String TIMEFORMAT = "timeFormat";
    public static final String DATETIMEFORMAT = "dateTimeFormat";
    public static final String DATEFORMATSYMBOLS = "dateFormatSymbols";
    public static final String DATESTYLE = "dateStyle";
    public static final String TIMESTYLE = "timeStyle";
    public static final Locale EN_US;
    public static final Locale ZH_CN;
    public static final Locale ZH_TW;
    public static final String COLLATOR = "collator";
    public static final String MESSAGEFORMAT = "messageFormat";
    private static final LanguageInfo lang_en_US;
    private static final LanguageInfo lang_zh_CN;
    private static final LanguageInfo lang_zh_TW;
    public static final Locale[] EAS_LOCALES;
    public static final Locale[] EAS_LOCALE_LANGS;

    public static synchronized void init(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ctx);
        SolutionInfo solution = loader.getSolution();
        BOSLocaleUtil.init(solution);
    }

    public static synchronized void init(SolutionInfo solution) {
        if (solution == null) {
            return;
        }
        if (_solution != null && _solution.equals(solution)) {
            return;
        }
        _solution = solution;
        LanguageCollection languages = _solution.getLanguages();
        LocaleUtils.clear();
        for (int i = 0; i < languages.size(); ++i) {
            String postfix = languages.get(i).getPostfix();
            LocaleUtils.getLocale((String)postfix);
            LocaleUtils.addShortCode((Locale)LocaleUtils.getLocale((String)languages.get(i).getLocaleString()), (String)postfix);
        }
        LocaleUtils.setDefaultLocale((Locale)_solution.getDefaultLanguage().getOriginalLocale());
    }

    public static synchronized void reset(SolutionInfo solution) {
        BOSLocaleUtil.init(solution);
    }

    public static String getShortCode(Locale locale) {
        return LocaleUtils.getShortCode((Locale)locale);
    }

    public static Locale getLocale(String localeString) {
        if (StringUtils.isEmpty((String)localeString)) {
            return null;
        }
        return LocaleUtils.getShortLocale((Locale)LocaleUtils.getLocale((String)localeString));
    }

    public static Locale getOriginalLocale(Locale locale) {
        return LocaleUtils.getFirstOriginLocale((Locale)locale);
    }

    public static Locale getLocale(Context ctx) {
        if (ctx == null) {
            return null;
        }
        return ctx.getLocale();
    }

    public static Locale getSolutionDefaultLocale() {
        if (_solution == null) {
            return null;
        }
        return _solution.getDefaultLanguage().getLocale();
    }

    public static Locale getDefaultLocale() {
        return LocaleUtils.getDefaultLocale();
    }

    public static void setDefaultLocale(Locale locale) {
        LocaleUtils.setDefaultLocale((Locale)locale);
    }

    public static boolean isSupportedLocale(Locale locale) {
        if (locale == null || _solution == null) {
            return false;
        }
        LanguageCollection languages = _solution.getLanguages();
        for (int i = 0; i < languages.size(); ++i) {
            if (!languages.get(i).getOriginalLocale().equals(locale) && !languages.get(i).getLocale().equals(locale)) continue;
            return true;
        }
        return false;
    }

    public static LanguageCollection getLanguages() {
        if (_solution == null) {
            return null;
        }
        return _solution.getLanguages();
    }

    public static List<LanguageInfo> getConfigLanguages() {
        return configLanguages;
    }

    private static List<LanguageInfo> initConfigLanguages() {
        ArrayList<LanguageInfo> configLangs = new ArrayList<LanguageInfo>(3);
        ConfigurationItem configItem = null;
        try {
            configItem = Configuration.getInstance().getConfigItem("supportlanguage");
            if (configItem == null) {
                configItem = Configuration.getInstance().getConfigItemByPath("uiframe/supportlanguage");
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (configItem != null) {
            Map configLangMap = configItem.getProperties();
            if (configLangMap != null && configLangMap.size() > 0) {
                for (Map.Entry entry : configLangMap.entrySet()) {
                    String[] locales;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (StringUtils.isEmpty((String)key) || (locales = StringUtils.split((String)key, (String)"#")).length <= 1) continue;
                    String postfix = locales[0];
                    String localeString = locales[1];
                    configLangs.add(new LanguageInfo(value, LocaleUtils.getLocaleString((Locale)LocaleUtils.getLocale((String)localeString)), postfix));
                    LocaleUtils.addShortCode((Locale)LocaleUtils.getLocale((String)localeString), (String)postfix, (boolean)true);
                }
            }
        } else {
            logger.warn((Object)"Cant NOT found configuration item 'supportlanguage' in bosconfig.xml");
        }
        return configLangs;
    }

    public static LanguageInfo getLanguage(Locale locale) {
        if (locale == null || _solution == null) {
            return null;
        }
        if (LocaleUtils.locale_l2.equals(locale)) {
            return lang_zh_CN;
        }
        if (LocaleUtils.locale_L2.equals(locale)) {
            return lang_zh_CN;
        }
        if (LocaleUtils.locale_zh_CN.equals(locale)) {
            return lang_zh_CN;
        }
        if (LocaleUtils.locale_l1.equals(locale)) {
            return lang_en_US;
        }
        if (LocaleUtils.locale_L1.equals(locale)) {
            return lang_en_US;
        }
        if (LocaleUtils.locale_en.equals(locale)) {
            return lang_en_US;
        }
        if (LocaleUtils.locale_en_US.equals(locale)) {
            return lang_en_US;
        }
        if (LocaleUtils.locale_l3.equals(locale)) {
            return lang_zh_TW;
        }
        if (LocaleUtils.locale_L3.equals(locale)) {
            return lang_zh_TW;
        }
        if (LocaleUtils.locale_zh_TW.equals(locale)) {
            return lang_zh_TW;
        }
        List<LanguageInfo> langs = BOSLocaleUtil.getConfigLanguages();
        for (LanguageInfo l : langs) {
            if (!l.getOriginalLocale().equals(locale) && !l.getLocale().equals(locale)) continue;
            return l;
        }
        LanguageCollection col = BOSLocaleUtil.getLanguages();
        if (col != null) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                LanguageInfo lang = col.get(i);
                if (!lang.getOriginalLocale().equals(locale) && !lang.getLocale().equals(locale)) continue;
                return lang;
            }
        }
        return new LanguageInfo(null, locale.toString(), null);
    }

    public static LanguageInfo getLanguage(String localeString) {
        if (StringUtils.isEmpty((String)localeString)) {
            return null;
        }
        return BOSLocaleUtil.getLanguage(LocaleUtils.getLocale((String)localeString));
    }

    public static Locale[] getSupportedLocales() {
        return BOSLocaleUtil.innerGetSupportedLocales(false);
    }

    private static Locale[] innerGetSupportedLocales(boolean isOrigin) {
        LanguageCollection col = BOSLocaleUtil.getLanguages();
        if (col == null) {
            return null;
        }
        Locale[] locales = new Locale[col.size()];
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            locales[i] = isOrigin ? col.get(i).getOriginalLocale() : col.get(i).getLocale();
        }
        return locales;
    }

    public static Locale[] getSupportedOriginLocales() {
        return BOSLocaleUtil.innerGetSupportedLocales(true);
    }

    public static void setProperty(String option, Object value) {
        BOSLocaleUtil.setProperty(option, value, BOSLocaleUtil.getDefaultLocale());
    }

    public static Object getProperty(String option) {
        return BOSLocaleUtil.getProperty(option, BOSLocaleUtil.getDefaultLocale());
    }

    private static String getLocaleKey(Locale locale) {
        return LocaleUtils.getLocaleString((Locale)BOSLocaleUtil.getOriginalLocale(locale));
    }

    public static void setProperty(String option, Object value, Locale locale) {
        String localeKey = BOSLocaleUtil.getLocaleKey(locale);
        if (StringUtils.isEmpty((String)option) || localeKey == null) {
            return;
        }
        String key = option + "_" + localeKey;
        properties.put(key, value);
    }

    public static Object getProperty(String option, Locale locale) {
        String localeKey = BOSLocaleUtil.getLocaleKey(locale);
        if (StringUtils.isEmpty((String)option) || localeKey == null) {
            return null;
        }
        String key = option + "_" + localeKey;
        return properties.get(key);
    }

    public static NumberFormat getNumberFormat() {
        return BOSLocaleUtil.getNumberFormat(BOSLocaleUtil.getDefaultLocale());
    }

    public static NumberFormat getDecimalFormat() {
        return BOSLocaleUtil.getDecimalFormat(BOSLocaleUtil.getDefaultLocale());
    }

    public static NumberFormat getCurrencyFormat() {
        return BOSLocaleUtil.getCurrencyFormat(BOSLocaleUtil.getDefaultLocale());
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        return BOSLocaleUtil.getDecimalFormatSymbols(BOSLocaleUtil.getDefaultLocale());
    }

    public static DateFormat getDateFormat() {
        return BOSLocaleUtil.getDateFormat(BOSLocaleUtil.getDefaultLocale());
    }

    public static DateFormat getTimeFormat() {
        return BOSLocaleUtil.getTimeFormat(BOSLocaleUtil.getDefaultLocale());
    }

    public static DateFormat getDateTimeFormat() {
        return BOSLocaleUtil.getDateTimeFormat(BOSLocaleUtil.getDefaultLocale());
    }

    public static DateFormatSymbols getDateFormatSymbols() {
        return BOSLocaleUtil.getDateFormatSymbols(BOSLocaleUtil.getDefaultLocale());
    }

    public static int getDateStyle() {
        return BOSLocaleUtil.getDateStyle(BOSLocaleUtil.getDefaultLocale());
    }

    public static int getDateStyle(Locale locale) {
        if (locale == null) {
            return 2;
        }
        String key = "dateStyle_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof Integer) {
                return (Integer)format;
            }
            return 2;
        }
        return 2;
    }

    public static int getTimeStyle() {
        return BOSLocaleUtil.getTimeStyle(BOSLocaleUtil.getDefaultLocale());
    }

    private static int getTimeStyle(Locale locale) {
        if (locale == null) {
            return 2;
        }
        String key = "timeStyle_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof Integer) {
                return (Integer)format;
            }
            return 2;
        }
        return 2;
    }

    public static DateFormat getTimeFormat(Locale locale) {
        if (locale == null) {
            return null;
        }
        String key = "timeFormat_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof DateFormat) {
                return (DateFormat)format;
            }
            Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
            return DateFormat.getTimeInstance(BOSLocaleUtil.getTimeStyle(locale), originalLocale);
        }
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return DateFormat.getTimeInstance(BOSLocaleUtil.getTimeStyle(locale), originalLocale);
    }

    public static DateFormat getDateFormat(Locale locale) {
        if (locale == null) {
            return null;
        }
        String key = "dateFormat_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof DateFormat) {
                return (DateFormat)format;
            }
            Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
            return DateFormat.getDateInstance(BOSLocaleUtil.getDateStyle(locale), originalLocale);
        }
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return DateFormat.getDateInstance(BOSLocaleUtil.getDateStyle(locale), originalLocale);
    }

    public static DateFormat getDateTimeFormat(Locale locale) {
        if (locale == null) {
            return null;
        }
        String key = "dateTimeFormat_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof DateFormat) {
                return (DateFormat)format;
            }
            Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
            return DateFormat.getDateTimeInstance(BOSLocaleUtil.getDateStyle(locale), BOSLocaleUtil.getTimeStyle(locale), originalLocale);
        }
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return DateFormat.getDateTimeInstance(BOSLocaleUtil.getDateStyle(locale), BOSLocaleUtil.getTimeStyle(locale), originalLocale);
    }

    public static DateFormatSymbols getDateFormatSymbols(Locale locale) {
        if (locale == null) {
            return null;
        }
        String key = "dateFormatSymbols_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof DateFormatSymbols) {
                return (DateFormatSymbols)format;
            }
            Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
            return new DateFormatSymbols(originalLocale);
        }
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return new DateFormatSymbols(originalLocale);
    }

    public static NumberFormat getNumberFormat(Locale locale) {
        if (locale == null) {
            return null;
        }
        String key = "numberFormat_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof NumberFormat) {
                return (NumberFormat)format;
            }
            Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
            return NumberFormat.getInstance(originalLocale);
        }
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return NumberFormat.getInstance(originalLocale);
    }

    public static NumberFormat getDecimalFormat(Locale locale) {
        if (locale == null) {
            return null;
        }
        String key = "decimalFormat_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof NumberFormat) {
                return (NumberFormat)format;
            }
            Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
            return DecimalFormat.getInstance(originalLocale);
        }
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return DecimalFormat.getInstance(originalLocale);
    }

    public static NumberFormat getCurrencyFormat(Locale locale) {
        if (locale == null) {
            return null;
        }
        String key = "currencyFormat_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof NumberFormat) {
                return (NumberFormat)format;
            }
            Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
            return NumberFormat.getCurrencyInstance(originalLocale);
        }
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return NumberFormat.getCurrencyInstance(originalLocale);
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
        if (locale == null) {
            return null;
        }
        String key = "decimalFormatSymbols_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof DecimalFormatSymbols) {
                return (DecimalFormatSymbols)format;
            }
            Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
            return new DecimalFormatSymbols(originalLocale);
        }
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return new DecimalFormatSymbols(originalLocale);
    }

    public static Collator getCollator() {
        return BOSLocaleUtil.getCollator(BOSLocaleUtil.getDefaultLocale());
    }

    public static Collator getCollator(Locale locale) {
        if (locale == null) {
            return null;
        }
        String key = "collator_" + BOSLocaleUtil.getLocaleKey(locale);
        if (properties.containsKey(key)) {
            Object format = properties.get(key);
            if (format instanceof Collator) {
                return (Collator)format;
            }
            Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
            return Collator.getInstance(originalLocale);
        }
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return Collator.getInstance(originalLocale);
    }

    public static MessageFormat getMessageFormat(String pattern) {
        return BOSLocaleUtil.getMessageFormat(pattern, BOSLocaleUtil.getDefaultLocale());
    }

    public static MessageFormat getMessageFormat(String pattern, Locale locale) {
        Locale originalLocale = BOSLocaleUtil.getOriginalLocale(locale);
        return new MessageFormat(pattern, originalLocale);
    }

    static {
        properties = new HashMap<String, Object>();
        EN_US = LocaleUtils.locale_en_US;
        ZH_CN = LocaleUtils.locale_zh_CN;
        ZH_TW = LocaleUtils.locale_zh_TW;
        EAS_LOCALES = new Locale[]{LocaleUtils.locale_L1, LocaleUtils.locale_L2, LocaleUtils.locale_L3};
        EAS_LOCALE_LANGS = new Locale[]{LocaleUtils.locale_en_US, LocaleUtils.locale_zh_CN, LocaleUtils.locale_zh_TW};
        SolutionInfo solution = new SolutionInfo();
        solution.setName("eas");
        lang_en_US = new LanguageInfo();
        lang_en_US.setName("English");
        lang_en_US.setLocaleString("en_US");
        lang_en_US.setPostfix("l1");
        solution.getLanguages().add(lang_en_US);
        lang_zh_CN = new LanguageInfo();
        lang_zh_CN.setName("\u7b80\u4f53\u4e2d\u6587");
        lang_zh_CN.setLocaleString("zh_CN");
        lang_zh_CN.setPostfix("l2");
        solution.getLanguages().add(lang_zh_CN);
        lang_zh_TW = new LanguageInfo();
        lang_zh_TW.setName("\u7e41\u9ad4\u4e2d\u6587");
        lang_zh_TW.setLocaleString("zh_TW");
        lang_zh_TW.setPostfix("l3");
        solution.getLanguages().add(lang_zh_TW);
        solution.setDefaultLanguage(lang_zh_CN);
        BOSLocaleUtil.init(solution);
        configLanguages = BOSLocaleUtil.initConfigLanguages();
    }
}

