/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.Context2;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.IRemoteBOSObjectFactory;
import com.kingdee.bos.LocalBOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.rpcwrapper.ISession;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GeniusBOSFactory
implements IRemoteBOSObjectFactory {
    private static Logger logger = Logger.getLogger(GeniusBOSFactory.class);
    private static ThreadLocal thLocal = new ThreadLocal();
    private static final HashMap sessions = new HashMap();
    public static final String ENV_KEY_URL = "URL";
    public static final String ENV_KEY_SESSIONID = "SESSIONID";
    public static final String ENV_KEY_BOSCTX = "BOSCTX";
    public static final String ENV_KEY_NEEDCACHE = "NEEDCACHE";
    public static final String URL_LOCAL = "[LOCAL]";
    private Context ctx;

    private GeniusBOSFactory(Context ctx) {
        this.ctx = ctx;
    }

    public static void setEnvContext(Map envContext) {
        thLocal.set(envContext);
    }

    public static void cleanEnvContext() {
        thLocal.set(null);
    }

    public static Map getCurrentServiceEnv() {
        Map env = (Map)thLocal.get();
        if (env != null) {
            return Collections.unmodifiableMap(env);
        }
        return null;
    }

    public static boolean needCache() {
        Map env = GeniusBOSFactory.getCurrentServiceEnv();
        boolean needcache = true;
        if (env != null) {
            needcache = "TRUE".equals(env.get(ENV_KEY_NEEDCACHE)) || "true".equals(env.get(ENV_KEY_NEEDCACHE)) || Boolean.TRUE.equals(env.get(ENV_KEY_NEEDCACHE)) || env.get(ENV_KEY_NEEDCACHE) == null;
        }
        return needcache;
    }

    public static void clearSession(String sessionid) {
        RemoteBOSObjectFactory remoteBOSObjectFactory = (RemoteBOSObjectFactory)sessions.remove(sessionid);
        if (remoteBOSObjectFactory != null) {
            remoteBOSObjectFactory.clearSession();
        }
    }

    public static IRemoteBOSObjectFactory getRemoteBOSObjectFactory(Map rpcEnv) {
        if (rpcEnv == null) {
            String rpcURL = ORMRPCServiceLocator.getCurrentServiceURL();
            return RemoteBOSObjectFactory.getInstance(rpcURL);
        }
        String sessionid = (String)rpcEnv.get(ENV_KEY_SESSIONID);
        String rpcURL = (String)rpcEnv.get(ENV_KEY_URL);
        Context ctx = (Context)rpcEnv.get(ENV_KEY_BOSCTX);
        IRemoteBOSObjectFactory bosObjectFactory = null;
        if (URL_LOCAL.equals(rpcURL)) {
            bosObjectFactory = new GeniusBOSFactory(ctx);
        } else {
            if (sessionid == null) {
                throw new IllegalArgumentException("When remote call, sessionid should not be NULL!");
            }
            if (StringUtils.isEmpty((String)rpcURL)) {
                throw new IllegalArgumentException("When remote call, rpcURL should not be Empty!");
            }
            bosObjectFactory = (IRemoteBOSObjectFactory)sessions.get(sessionid);
            if (bosObjectFactory == null) {
                bosObjectFactory = new RemoteBOSObjectFactory(rpcURL);
                sessions.put(sessionid, bosObjectFactory);
            }
        }
        return bosObjectFactory;
    }

    public static IBOSObject createRemoteBOSObject(BOSObjectType bosType, Class model) throws BOSException {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        return GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).createBOSObject(bosType, model);
    }

    public static IBOSObject createRemoteBOSObjectWithObjectContext(BOSObjectType bosType, Class model, Context objectCtx) throws BOSException {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        return GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).createBOSObject(bosType, model, objectCtx);
    }

    public static IBOSObject createRemoteBOSObject(String className, Class model) throws BOSException {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        logger.debug((Object)("gennius createRemoteBOSObject className=" + className + " .rpcEnv=" + rpcEnv));
        return (IBOSObject)GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).createObject(className, model);
    }

    public static IORMModel createRemoteObject(String className, Class model, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        logger.debug((Object)("gennius createRemoteBOSObject className=" + className + " .rpcEnv=" + rpcEnv));
        return GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).createObject(className, model, initArgTypes, initArgValues);
    }

    public static IBOSObject createRemoteBOSObjectWithObjectContext(String className, Class model, Context objectCtx) throws BOSException {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        return (IBOSObject)GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).createObject(className, model, objectCtx);
    }

    public static IBOSObject createRemoteCommonBOSObject(IMetaDataPK pk) throws BOSException {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        return GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).createCommonBOSObject(pk);
    }

    public static IBOSObject createRemoteCommonBOSObject(IMetaDataPK pk, Context objectCtx) throws BOSException {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        return GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).createCommonBOSObject(pk, objectCtx);
    }

    public static IBOSObject createRemoteCommonBOSObjectWithObjectContext(IMetaDataPK pk, Context objectCtx) throws BOSException {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        return (IBOSObject)GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).createCommonObject(pk, objectCtx);
    }

    public static IBOSObject createRemoteCommonBOSObject(IMetaDataPK pk, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        return (IBOSObject)GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).createCommonObject(pk, initArgTypes, initArgValues);
    }

    @Override
    public IBOSObject createBOSObject(BOSObjectType type, Class model) throws BOSException {
        return LocalBOSObjectFactory.getInstance(this.ctx).createBOSObject(type);
    }

    @Override
    public IBOSObject createBOSObject(BOSObjectType bosType, Class model, Context objectCtx) throws BOSException {
        Context2 ctx2 = new Context2(this.ctx);
        objectCtx.remove((Object)"IS_OBJECT_CONTEXT");
        ctx2.initOwnContext(objectCtx);
        return LocalBOSObjectFactory.getInstance((Context)ctx2).createBOSObject(bosType);
    }

    @Override
    public IBOSObject createCommonBOSObject(IMetaDataPK pk) throws BOSException {
        return LocalBOSObjectFactory.getInstance(this.ctx).createCommonBOSObject(pk);
    }

    @Override
    public IBOSObject createCommonBOSObject(IMetaDataPK pk, Context objectCtx) throws BOSException {
        Context2 ctx2 = new Context2(this.ctx);
        objectCtx.remove((Object)"IS_OBJECT_CONTEXT");
        ctx2.initOwnContext(objectCtx);
        return LocalBOSObjectFactory.getInstance((Context)ctx2).createCommonBOSObject(pk);
    }

    @Override
    public IORMModel createCommonObject(IMetaDataPK pk, Context objectCtx) throws BOSException {
        Context2 ctx2 = new Context2(this.ctx);
        objectCtx.remove((Object)"IS_OBJECT_CONTEXT");
        ctx2.initOwnContext(objectCtx);
        return LocalBOSObjectFactory.getInstance((Context)ctx2).createCommonBOSObject(pk);
    }

    @Override
    public IORMModel createCommonObject(IMetaDataPK pk, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        return this.createCommonBOSObject(pk);
    }

    @Override
    public IORMModel createObject(String className, Class model, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        IORMModel object;
        try {
            Class<?> cls = Class.forName(className);
            object = (IORMModel)cls.getConstructor(initArgTypes).newInstance(initArgValues);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return object.queryInterface(model);
    }

    @Override
    public IORMModel createObject(String className, Class model) throws BOSException {
        return LocalBOSObjectFactory.getInstance(this.ctx).createBOSObject(className, model);
    }

    @Override
    public IORMModel createObject(String className, Class model, Context objectCtx) throws BOSException {
        Context2 ctx2 = new Context2(this.ctx);
        objectCtx.remove((Object)"IS_OBJECT_CONTEXT");
        ctx2.initOwnContext(objectCtx);
        return LocalBOSObjectFactory.getInstance((Context)ctx2).createBOSObject(className, model);
    }

    @Override
    public void clearSession() {
        this.ctx = null;
    }

    @Override
    public ISession getSession() {
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        return GeniusBOSFactory.getRemoteBOSObjectFactory(rpcEnv).getSession();
    }
}

