/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.IRemoteBOSObjectFactory;
import com.kingdee.bos.LazyRemoteObjectCreator;
import com.kingdee.bos.ORMRPCObjectFactory;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.IObjectFactory;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCSession;
import com.kingdee.bos.rpc.impl.ContainerBase;
import com.kingdee.bos.rpc.impl.RPCService;
import com.kingdee.bos.rpc.io.driver.SocketPool;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpc.security.AES;
import com.kingdee.bos.rpc.security.EncryptUtil;
import com.kingdee.bos.rpc.security.Encryptor;
import com.kingdee.bos.rpc.security.EncryptorType;
import com.kingdee.bos.rpc.security.RPCEncryptFactory;
import com.kingdee.bos.rpcwrapper.ISession;
import com.kingdee.bos.rpcwrapper.RMIEngineWrapper;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.LRUMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RemoteBOSObjectFactory
implements IRemoteBOSObjectFactory {
    private final String rpcURL;
    private final ReconnectableSession session;
    private static final HashMap factories;
    private final LRUMap remoteBOSObjectCache;
    private static final Logger logger;
    private boolean enableStubCache = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    RemoteBOSObjectFactory(String rpcURL) {
        this.rpcURL = rpcURL;
        this.remoteBOSObjectCache = new LRUMap();
        this.remoteBOSObjectCache.setMaxSize(10240);
        this.session = new ReconnectableSession();
        this.guessEnableStubCache();
    }

    RemoteBOSObjectFactory(String rpcURL, boolean enableStubCache) {
        this.rpcURL = rpcURL;
        this.remoteBOSObjectCache = new LRUMap();
        this.remoteBOSObjectCache.setMaxSize(10240);
        this.session = new ReconnectableSession();
        this.enableStubCache = enableStubCache;
    }

    private void guessEnableStubCache() {
        if (System.getProperty("ormrpc.trace") != null && System.getProperty("ormrpc.trace").equalsIgnoreCase("true")) {
            this.enableStubCache = false;
        }
        if (System.getProperty("ormrpc.trace.path") != null) {
            this.enableStubCache = false;
        }
        if (RPCEngineFactory.getEngine(null) instanceof RMIEngineWrapper) {
            this.enableStubCache = false;
        }
    }

    private boolean isStateful(Class model) {
        return "com.kingdee.bos.dao.query.server.IVirtualModeDataAccess".equals(model.getName()) || "com.kingdee.bos.dao.query.server.IQueryDataAccess".equals(model.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSession() {
        if (!$assertionsDisabled && this.session == null) {
            throw new AssertionError();
        }
        this.session.close();
        HashMap hashMap = factories;
        synchronized (hashMap) {
            factories.remove(new ServerKey(this.rpcURL, true));
            factories.remove(new ServerKey(this.rpcURL, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteBOSObjectFactory getInstance(String rpcURL) {
        String key = null;
        key = rpcURL == null || rpcURL.length() == 0 ? "tcp://localhost" : rpcURL.trim();
        ServerKey serverKey = new ServerKey(key, true);
        RemoteBOSObjectFactory factory = (RemoteBOSObjectFactory)factories.get(serverKey);
        if (factory != null) {
            return factory;
        }
        HashMap hashMap = factories;
        synchronized (hashMap) {
            factory = (RemoteBOSObjectFactory)factories.get(serverKey);
            if (factory == null) {
                factory = new RemoteBOSObjectFactory(key);
                factories.put(serverKey, factory);
            }
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteBOSObjectFactory getInstance(String rpcURL, boolean enableStubCache) {
        String key = null;
        key = rpcURL == null || rpcURL.length() == 0 ? "tcp://localhost" : rpcURL.trim();
        ServerKey serverKey = new ServerKey(key, enableStubCache);
        RemoteBOSObjectFactory factory = (RemoteBOSObjectFactory)factories.get(serverKey);
        if (factory != null) {
            return factory;
        }
        HashMap hashMap = factories;
        synchronized (hashMap) {
            factory = (RemoteBOSObjectFactory)factories.get(serverKey);
            if (factory == null) {
                factory = new RemoteBOSObjectFactory(key, enableStubCache);
                factories.put(serverKey, factory);
            }
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBOSObject createBOSObject(BOSObjectType type, Class model) throws BOSException {
        String key = "$bosobj$" + type.toString();
        String cacheKey = key + model.getName();
        if (this.enableStubCache && !this.session.isClosed() && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                IBOSObject cached_bosObject;
                if (this.remoteBOSObjectCache.containsKey((Object)cacheKey) && model.isAssignableFrom((cached_bosObject = (IBOSObject)this.remoteBOSObjectCache.get((Object)cacheKey)).getClass())) {
                    logger.debug((Object)("get stub from cache with key " + cacheKey));
                    return cached_bosObject;
                }
            }
        }
        IBOSObject bosObject = null;
        if (!this.session.isClosed() && RPCService.inServiceInvoke.get() == null && !ILoginModule.class.isAssignableFrom(model)) {
            LazyRemoteObjectCreator creator = LazyRemoteObjectCreator.getLazyObjectCreator(this.session, key, model);
            if ((bosObject = (IBOSObject)this.createCacheInterceptor((Object)bosObject, type, creator, model, key, null, null)) == null) {
                bosObject = (IBOSObject)creator.lazyCreate();
            }
        } else {
            bosObject = (IBOSObject)this.session.createObject(key, model);
        }
        if (this.enableStubCache && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                this.remoteBOSObjectCache.put((Object)cacheKey, (Object)bosObject);
                logger.debug((Object)("put stub to cache with key " + cacheKey));
            }
        }
        return bosObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBOSObject createBOSObject(BOSObjectType type, Class model, Context objectCtx) throws BOSException {
        IBOSObject bosObject;
        String key = "$bosobj$" + type.toString();
        if (objectCtx != null) {
            objectCtx.put((Object)"IS_OBJECT_CONTEXT", (Object)"true");
        }
        String sStringkey = key + model.getName();
        StubKeyWithContext cacheKey = new StubKeyWithContext(sStringkey, objectCtx);
        if (this.enableStubCache && !this.session.isClosed() && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                IBOSObject cached_bosObject;
                if (this.remoteBOSObjectCache.containsKey((Object)cacheKey) && model.isAssignableFrom((cached_bosObject = (IBOSObject)this.remoteBOSObjectCache.get((Object)cacheKey)).getClass())) {
                    logger.debug((Object)("get stub from cache with key " + cacheKey));
                    return cached_bosObject;
                }
            }
        }
        if (!this.session.isClosed() && RPCService.inServiceInvoke.get() == null && !ILoginModule.class.isAssignableFrom(model)) {
            LazyRemoteObjectCreator creator = LazyRemoteObjectCreator.getLazyObjectCreator(this.session, key, model, new Class[]{Context.class}, new Object[]{objectCtx});
            bosObject = (IBOSObject)this.createCacheInterceptor(null, type, objectCtx, creator, model, key, null, null);
            if (bosObject == null) {
                bosObject = (IBOSObject)creator.lazyCreate();
            }
        } else {
            bosObject = (IBOSObject)this.session.createObject(key, model, new Class[]{Context.class}, new Object[]{objectCtx});
        }
        if (this.enableStubCache && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                this.remoteBOSObjectCache.put((Object)cacheKey, (Object)bosObject);
                logger.debug((Object)("put stub to cache with key " + cacheKey));
            }
        }
        return bosObject;
    }

    @Override
    public IORMModel createObject(String className, Class model) throws BOSException {
        return this.createObject(className, model, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IORMModel createObject(String className, Class model, boolean cacheStub) throws BOSException {
        IORMModel bosObject;
        String cacheKey = "$bosobj$" + className + model.getName();
        if (this.enableStubCache && !this.session.isClosed() && !this.isStateful(model) && cacheStub) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                IORMModel cached_bosObject;
                if (this.remoteBOSObjectCache.containsKey((Object)cacheKey) && model.isAssignableFrom((cached_bosObject = (IORMModel)this.remoteBOSObjectCache.get((Object)cacheKey)).getClass())) {
                    logger.debug((Object)("get stub from cache with key " + cacheKey));
                    return cached_bosObject;
                }
            }
        }
        if (!this.session.isClosed() && RPCService.inServiceInvoke.get() == null && !ILoginModule.class.isAssignableFrom(model)) {
            LazyRemoteObjectCreator creator = LazyRemoteObjectCreator.getLazyObjectCreator(this.session, className, model);
            bosObject = (IORMModel)this.createCacheInterceptor(null, className, creator, model, className, null, null);
            if (bosObject == null) {
                bosObject = (IORMModel)creator.lazyCreate();
            }
        } else {
            bosObject = this.session.createObject(className, model);
        }
        if (this.enableStubCache && !this.isStateful(model) && cacheStub) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                this.remoteBOSObjectCache.put((Object)cacheKey, (Object)bosObject);
                logger.debug((Object)("put stub to cache with key " + cacheKey));
            }
        }
        return bosObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IORMModel createObject(String className, Class model, Context objectCtx) throws BOSException {
        IORMModel bosObject;
        String strKey = className + model.getName();
        StubKeyWithContext cacheKey = new StubKeyWithContext(strKey, objectCtx);
        if (objectCtx != null) {
            objectCtx.put((Object)"IS_OBJECT_CONTEXT", (Object)"true");
        }
        if (this.enableStubCache && !this.session.isClosed() && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                IORMModel cached_bosObject;
                if (this.remoteBOSObjectCache.containsKey((Object)cacheKey) && model.isAssignableFrom((cached_bosObject = (IORMModel)this.remoteBOSObjectCache.get((Object)cacheKey)).getClass())) {
                    logger.debug((Object)("get stub from cache with key " + cacheKey));
                    return cached_bosObject;
                }
            }
        }
        if (!this.session.isClosed() && RPCService.inServiceInvoke.get() == null && !ILoginModule.class.isAssignableFrom(model)) {
            LazyRemoteObjectCreator creator = LazyRemoteObjectCreator.getLazyObjectCreator(this.session, className, model, new Class[]{Context.class}, new Object[]{objectCtx});
            bosObject = (IORMModel)this.createCacheInterceptor(null, className, creator, model, className, null, null);
            if (bosObject == null) {
                bosObject = (IORMModel)creator.lazyCreate();
            }
        } else {
            bosObject = this.session.createObject(className, model, new Class[]{Context.class}, new Object[]{objectCtx});
        }
        if (this.enableStubCache && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                this.remoteBOSObjectCache.put((Object)cacheKey, (Object)bosObject);
                logger.debug((Object)("put stub to cache with key " + cacheKey));
            }
        }
        return bosObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IORMModel createObject(String className, Class model, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        IORMModel bosObject;
        String strKey = className + model.getName();
        for (int i = 0; i < initArgTypes.length; ++i) {
            strKey = strKey + ":" + (initArgTypes[i] == null ? "" : initArgTypes[i].getName());
        }
        StubKeyWithParameters cacheKey = new StubKeyWithParameters(strKey, initArgValues);
        if (this.enableStubCache && !this.session.isClosed() && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                if (this.remoteBOSObjectCache.containsKey((Object)cacheKey)) {
                    IORMModel cached_bosObject = (IORMModel)this.remoteBOSObjectCache.get((Object)cacheKey);
                    logger.debug((Object)("get stub from cache with key " + cacheKey));
                    return cached_bosObject;
                }
            }
        }
        if (!this.session.isClosed() && RPCService.inServiceInvoke.get() == null && !ILoginModule.class.isAssignableFrom(model)) {
            LazyRemoteObjectCreator creator = LazyRemoteObjectCreator.getLazyObjectCreator(this.session, className, model, initArgTypes, initArgValues);
            bosObject = (IORMModel)this.createCacheInterceptor(null, className, creator, model, className, initArgTypes, initArgValues);
            if (bosObject == null) {
                bosObject = (IORMModel)creator.lazyCreate();
            }
        } else {
            bosObject = this.session.createObject(className, model, initArgTypes, initArgValues);
        }
        if (this.enableStubCache && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                this.remoteBOSObjectCache.put((Object)cacheKey, (Object)bosObject);
                logger.debug((Object)("put stub to cache with key " + cacheKey));
            }
        }
        return bosObject;
    }

    private Object createCacheInterceptor(Object bosObject, String className, LazyRemoteObjectCreator lazyCreator, Class model, String objectName, Class[] argTypes, Object[] args) {
        try {
            Class<?> clazz = Class.forName("com.kingdee.bos.framework.cache.CachedInvokeInterceptor2");
            Object obj = clazz.getConstructor(Object.class, String.class, LazyRemoteObjectCreator.class, String.class, String.class, Class.class, Class[].class, Object[].class).newInstance(bosObject, className, lazyCreator, this.rpcURL, objectName, model, argTypes, args);
            bosObject = (IORMModel)Proxy.newProxyInstance(model.getClassLoader(), new Class[]{model}, (InvocationHandler)obj);
        }
        catch (Exception e) {
            logger.error((Object)("the Client Cache create error. className = " + className + " ;class = " + model.getName() + " errorMessage = " + e.getMessage()), (Throwable)e);
        }
        return bosObject;
    }

    private Object createCacheInterceptor(Object bosObject, BOSObjectType bosType, LazyRemoteObjectCreator lazyCreator, Class model, String objectName, Class[] argTypes, Object[] args) {
        try {
            Class<?> clazz = Class.forName("com.kingdee.bos.framework.cache.CachedInvokeInterceptor2");
            Object obj = clazz.getConstructor(Object.class, BOSObjectType.class, LazyRemoteObjectCreator.class, String.class, String.class, Class.class, Class[].class, Object[].class).newInstance(bosObject, bosType, lazyCreator, this.rpcURL, objectName, model, argTypes, args);
            bosObject = (IORMModel)Proxy.newProxyInstance(model.getClassLoader(), new Class[]{model}, (InvocationHandler)obj);
        }
        catch (Exception e) {
            logger.error((Object)("the Client Cache create error. bosType = " + bosType + " ;class = " + model.getName() + " errorMessage = " + e.getMessage()), (Throwable)e);
        }
        return bosObject;
    }

    private Object createCacheInterceptor(Object bosObject, BOSObjectType bosType, Context objectContext, LazyRemoteObjectCreator lazyCreator, Class model, String objectName, Class[] argTypes, Object[] args) {
        try {
            Class<?> clazz = Class.forName("com.kingdee.bos.framework.cache.CachedInvokeInterceptor2");
            Object obj = clazz.getConstructor(Object.class, BOSObjectType.class, Context.class, LazyRemoteObjectCreator.class, String.class, String.class, Class.class, Class[].class, Object[].class).newInstance(bosObject, bosType, objectContext, lazyCreator, this.rpcURL, objectName, model, argTypes, args);
            bosObject = (IORMModel)Proxy.newProxyInstance(model.getClassLoader(), new Class[]{model}, (InvocationHandler)obj);
        }
        catch (Exception e) {
            logger.error((Object)("the Client Cache create error. bosType = " + bosType + " ;class = " + model.getName() + " errorMessage = " + e.getMessage()), (Throwable)e);
        }
        return bosObject;
    }

    @Override
    public ISession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBOSObject createCommonBOSObject(IMetaDataPK pk) throws BOSException {
        BusinessObjectInfo bo = (BusinessObjectInfo)MetaDataLoaderFactory.getRemoteMetaDataLoader().get(MetaDataTypeList.ENTITY, pk);
        String bi = bo.getBusinessInterface();
        Class<?> model = null;
        try {
            model = Class.forName(bi);
        }
        catch (ClassNotFoundException e) {
            String msg = "Class not found. name=" + bi;
            logger.error((Object)msg, (Throwable)e);
            throw new BOSException(msg, (Throwable)e);
        }
        String key = "$dynbosobj$" + pk.getFullName();
        String cacheKey = key + model.getName();
        if (this.enableStubCache && !this.session.isClosed() && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                IBOSObject cached_bosObject;
                if (this.remoteBOSObjectCache.containsKey((Object)cacheKey) && model.isAssignableFrom((cached_bosObject = (IBOSObject)this.remoteBOSObjectCache.get((Object)cacheKey)).getClass())) {
                    logger.debug((Object)("get stub from cache with key " + cacheKey));
                    return cached_bosObject;
                }
            }
        }
        IBOSObject bosObject = null;
        if (!this.session.isClosed() && RPCService.inServiceInvoke.get() == null && !ILoginModule.class.isAssignableFrom(model)) {
            LazyRemoteObjectCreator creator = LazyRemoteObjectCreator.getLazyObjectCreator(this.session, key, model);
            if ((bosObject = (IBOSObject)this.createCacheInterceptor((Object)bosObject, (String)null, creator, model, key, null, null)) == null) {
                bosObject = (IBOSObject)creator.lazyCreate();
            }
        } else {
            bosObject = (IBOSObject)this.session.createObject(key, model);
        }
        if (this.enableStubCache && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                this.remoteBOSObjectCache.put((Object)cacheKey, (Object)bosObject);
                logger.debug((Object)("put stub to cache with key " + cacheKey));
            }
        }
        return bosObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBOSObject createCommonBOSObject(IMetaDataPK pk, Context objectCtx) throws BOSException {
        BusinessObjectInfo bo = (BusinessObjectInfo)MetaDataLoaderFactory.getRemoteMetaDataLoader().get(MetaDataTypeList.ENTITY, pk);
        String bi = bo.getBusinessInterface();
        Class<?> model = null;
        try {
            model = Class.forName(bi);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String key = "$dynbosobj$" + pk.getFullName();
        if (objectCtx != null) {
            objectCtx.put((Object)"IS_OBJECT_CONTEXT", (Object)"true");
        }
        String sStringkey = key + model.getName();
        StubKeyWithContext cacheKey = new StubKeyWithContext(sStringkey, objectCtx);
        if (this.enableStubCache && !this.session.isClosed() && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                IBOSObject cached_bosObject;
                if (this.remoteBOSObjectCache.containsKey((Object)cacheKey) && model.isAssignableFrom((cached_bosObject = (IBOSObject)this.remoteBOSObjectCache.get((Object)cacheKey)).getClass())) {
                    logger.debug((Object)("get stub from cache with key " + cacheKey));
                    return cached_bosObject;
                }
            }
        }
        IBOSObject bosObject = null;
        if (!this.session.isClosed() && RPCService.inServiceInvoke.get() == null && !ILoginModule.class.isAssignableFrom(model)) {
            LazyRemoteObjectCreator creator = LazyRemoteObjectCreator.getLazyObjectCreator(this.session, key, model, new Class[]{Context.class}, new Object[]{objectCtx});
            bosObject = (IBOSObject)this.createCacheInterceptor(null, bo.getType(), objectCtx, creator, model, key, null, null);
            if (bosObject == null) {
                bosObject = (IBOSObject)creator.lazyCreate();
            }
        } else {
            bosObject = (IBOSObject)this.session.createObject(key, model, new Class[]{Context.class}, new Object[]{objectCtx});
        }
        if (this.enableStubCache && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                this.remoteBOSObjectCache.put((Object)cacheKey, (Object)bosObject);
                logger.debug((Object)("put stub to cache with key " + cacheKey));
            }
        }
        return bosObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IORMModel createCommonObject(IMetaDataPK pk, Context objectCtx) throws BOSException {
        IORMModel bosObject;
        BusinessObjectInfo bo = (BusinessObjectInfo)MetaDataLoaderFactory.getRemoteMetaDataLoader().get(MetaDataTypeList.ENTITY, pk);
        String bi = bo.getBusinessInterface();
        Class<?> model = null;
        try {
            model = Class.forName(bi);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String strKey = "$dynbosobj$" + pk.getFullName();
        StubKeyWithContext cacheKey = new StubKeyWithContext(strKey, objectCtx);
        if (objectCtx != null) {
            objectCtx.put((Object)"IS_OBJECT_CONTEXT", (Object)"true");
        }
        if (this.enableStubCache && !this.session.isClosed() && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                IORMModel cached_bosObject;
                if (this.remoteBOSObjectCache.containsKey((Object)cacheKey) && model.isAssignableFrom((cached_bosObject = (IORMModel)this.remoteBOSObjectCache.get((Object)cacheKey)).getClass())) {
                    logger.debug((Object)("get stub from cache with key " + cacheKey));
                    return cached_bosObject;
                }
            }
        }
        if (!this.session.isClosed() && RPCService.inServiceInvoke.get() == null && !ILoginModule.class.isAssignableFrom(model)) {
            LazyRemoteObjectCreator creator = LazyRemoteObjectCreator.getLazyObjectCreator(this.session, strKey, model, new Class[]{Context.class}, new Object[]{objectCtx});
            bosObject = (IORMModel)this.createCacheInterceptor(null, strKey, creator, model, strKey, null, null);
            if (bosObject == null) {
                bosObject = (IORMModel)creator.lazyCreate();
            }
        } else {
            bosObject = this.session.createObject(strKey, model, new Class[]{Context.class}, new Object[]{objectCtx});
        }
        if (this.enableStubCache && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                this.remoteBOSObjectCache.put((Object)cacheKey, (Object)bosObject);
                logger.debug((Object)("put stub to cache with key " + cacheKey));
            }
        }
        return bosObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IORMModel createCommonObject(IMetaDataPK pk, Class[] initArgTypes, Object[] initArgValues) throws BOSException {
        IORMModel bosObject;
        BusinessObjectInfo bo = (BusinessObjectInfo)MetaDataLoaderFactory.getRemoteMetaDataLoader().get(MetaDataTypeList.ENTITY, pk);
        String bi = bo.getBusinessInterface();
        Class<?> model = null;
        try {
            model = Class.forName(bi);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String strKey = "$dynbosobj$" + pk.getFullName();
        for (int i = 0; i < initArgTypes.length; ++i) {
            strKey = strKey + ":" + (initArgTypes[i] == null ? "" : initArgTypes[i].getName());
        }
        StubKeyWithParameters cacheKey = new StubKeyWithParameters(strKey, initArgValues);
        if (this.enableStubCache && !this.session.isClosed() && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                if (this.remoteBOSObjectCache.containsKey((Object)cacheKey)) {
                    IORMModel cached_bosObject = (IORMModel)this.remoteBOSObjectCache.get((Object)cacheKey);
                    logger.debug((Object)("get stub from cache with key " + cacheKey));
                    return cached_bosObject;
                }
            }
        }
        if (!this.session.isClosed() && RPCService.inServiceInvoke.get() == null && !ILoginModule.class.isAssignableFrom(model)) {
            LazyRemoteObjectCreator creator = LazyRemoteObjectCreator.getLazyObjectCreator(this.session, strKey, model, initArgTypes, initArgValues);
            bosObject = (IORMModel)this.createCacheInterceptor(null, strKey, creator, model, strKey, initArgTypes, initArgValues);
            if (bosObject == null) {
                bosObject = (IORMModel)creator.lazyCreate();
            }
        } else {
            bosObject = this.session.createObject(strKey, model, initArgTypes, initArgValues);
        }
        if (this.enableStubCache && !this.isStateful(model)) {
            LRUMap lRUMap = this.remoteBOSObjectCache;
            synchronized (lRUMap) {
                this.remoteBOSObjectCache.put((Object)cacheKey, (Object)bosObject);
                logger.debug((Object)("put stub to cache with key " + cacheKey));
            }
        }
        return bosObject;
    }

    static {
        boolean bl = $assertionsDisabled = !RemoteBOSObjectFactory.class.desiredAssertionStatus();
        if (RPCService.inServiceInvoke.get() == null) {
            RPCEngineFactory.registerObjectFactory((IObjectFactory)new ORMRPCObjectFactory());
        }
        factories = new HashMap();
        logger = Logger.getLogger(RemoteBOSObjectFactory.class);
    }

    static class ServerKey {
        String rpcURL;
        String shortURL;
        boolean enableStub;

        ServerKey(String rpcURL, boolean enableStub) {
            this.enableStub = enableStub;
            this.rpcURL = rpcURL;
            int i = rpcURL.indexOf("?");
            this.shortURL = i > 0 ? rpcURL.substring(0, i) : rpcURL;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ServerKey)) {
                return false;
            }
            return this.shortURL.equalsIgnoreCase(((ServerKey)o).shortURL) && ((ServerKey)o).enableStub == this.enableStub;
        }

        public int hashCode() {
            int flag = 0;
            if (this.enableStub) {
                flag = 1;
            }
            return this.shortURL.hashCode() + flag;
        }
    }

    class StubKeyWithParameters {
        String sStringKey;
        Object[] args;

        public StubKeyWithParameters(String sStringKey, Object[] args) {
            this.args = args;
            this.sStringKey = sStringKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StubKeyWithParameters)) {
                return false;
            }
            return (this.sStringKey == ((StubKeyWithParameters)o).sStringKey || this.sStringKey != null && this.sStringKey.equals(((StubKeyWithParameters)o).sStringKey)) && (this.args == ((StubKeyWithParameters)o).args || this.args != null && Arrays.equals(this.args, ((StubKeyWithParameters)o).args));
        }

        public int hashCode() {
            int hashcode = this.sStringKey == null ? 0 : this.sStringKey.hashCode();
            int code = 0;
            if (this.args != null) {
                code = 1;
                for (int i = 0; i < this.args.length; ++i) {
                    code = 31 * code + (this.args[i] == null ? 0 : this.args[i].hashCode());
                }
            }
            return hashcode ^ code;
        }
    }

    class StubKeyWithContext {
        String sStringKey;
        Context ctx;

        public StubKeyWithContext(String sStringKey, Context ctx) {
            this.ctx = ctx;
            this.sStringKey = sStringKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StubKeyWithContext)) {
                return false;
            }
            return (this.sStringKey == ((StubKeyWithContext)o).sStringKey || this.sStringKey != null && this.sStringKey.equals(((StubKeyWithContext)o).sStringKey)) && (this.ctx == ((StubKeyWithContext)o).ctx || this.ctx != null && this.ctx.ctx.equals(((StubKeyWithContext)o).ctx.ctx));
        }

        public int hashCode() {
            return (this.sStringKey == null ? 0 : this.sStringKey.hashCode()) ^ (this.ctx == null || this.ctx.ctx == null ? 0 : this.ctx.ctx.hashCode());
        }
    }

    private class ReconnectableSession
    implements ISession {
        private volatile ISession delegate;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() {
            if (this.delegate != null && !this.delegate.isClosed()) {
                return;
            }
            ReconnectableSession reconnectableSession = this;
            synchronized (reconnectableSession) {
                if (this.delegate != null && !this.delegate.isClosed()) {
                    return;
                }
                this.delegate = RPCEngineFactory.getEngine((String)RemoteBOSObjectFactory.this.rpcURL).createSession();
                if (ServerManager.getConfig().rpcEncrypt) {
                    try {
                        RPCSession rpcSession = (RPCSession)this.delegate.getDelegate();
                        RSAPublicKey publicKey = (RSAPublicKey)rpcSession.removeContext((Object)"$rsaPublickey$");
                        Encryptor encryptor = EncryptUtil.getEncryptor((EncryptorType)EncryptorType.RSA);
                        String aesKey = AES.generateKey();
                        byte[] aesBytes = encryptor.encrypt(aesKey.getBytes(), (Key)publicKey);
                        boolean result = RPCEncryptFactory.getInstance((String)RemoteBOSObjectFactory.this.rpcURL).setAesKey(aesBytes);
                        if (result) {
                            EncryptUtil.setAESKey((ContainerBase)rpcSession, (String)aesKey);
                        }
                    }
                    catch (Throwable e) {
                        logger.error((Object)"rpc call setAesKey error.", e);
                    }
                }
                logger.info((Object)("session to " + RemoteBOSObjectFactory.this.rpcURL + " created! " + this.delegate));
                if (RemoteBOSObjectFactory.this.remoteBOSObjectCache != null) {
                    RemoteBOSObjectFactory.this.remoteBOSObjectCache.clear();
                }
            }
        }

        private void handleException(RuntimeException re) {
            if (Utils.isRPCException((Throwable)re) && Utils.getRPCErrorCode((Throwable)re) == 1005) {
                this.close();
                this.initialize();
            }
        }

        public IORMModel createObject(String objectName, Class model, Class[] initArgTypes, Object[] initArgs) {
            try {
                this.initialize();
                return this.delegate.createObject(objectName, model, initArgTypes, initArgs);
            }
            catch (RuntimeException re) {
                if (System.getProperty("easclient.root") == null) {
                    if (RPCException.getErrorCode((Throwable)re) == 1002) {
                        this.close();
                        this.initialize();
                        return this.delegate.createObject(objectName, model, initArgTypes, initArgs);
                    }
                    this.handleException(re);
                    if (this.delegate != null) {
                        logger.debug((Object)re, (Throwable)re);
                        return this.delegate.createObject(objectName, model, initArgTypes, initArgs);
                    }
                    throw re;
                }
                boolean redistribute = false;
                try {
                    Class<?> clazz = Class.forName("com.kingdee.bos.framework.cache.CachedInvokeInterceptor2");
                    Method m = clazz.getMethod("isRedistributed", new Class[0]);
                    Object o = m.invoke(null, new Object[0]);
                    if (o instanceof Boolean) {
                        redistribute = (Boolean)o;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (redistribute) {
                    if (Utils.isRPCException((Throwable)re) && Utils.getRPCErrorCode((Throwable)re) == 1005) {
                        this.close();
                        SocketPool.getPool((String)RemoteBOSObjectFactory.this.rpcURL).setEngineId(null);
                        this.initialize();
                    }
                    if (this.delegate != null) {
                        logger.debug((Object)re, (Throwable)re);
                        return this.delegate.createObject(objectName, model, initArgTypes, initArgs);
                    }
                }
                throw re;
            }
        }

        public IORMModel createObject(String objectName, Class model) {
            return this.createObject(objectName, model, null, null);
        }

        public Object getDelegate() {
            return this.delegate == null ? null : this.delegate.getDelegate();
        }

        public void close() {
            if (this.delegate != null) {
                ISession temp = this.delegate;
                this.delegate = null;
                temp.close();
                logger.info((Object)("session to " + RemoteBOSObjectFactory.this.rpcURL + " closed! " + temp));
            }
            if (RemoteBOSObjectFactory.this.remoteBOSObjectCache != null) {
                RemoteBOSObjectFactory.this.remoteBOSObjectCache.clear();
            }
        }

        public boolean isClosed() {
            if (this.delegate != null) {
                return this.delegate.isClosed();
            }
            return true;
        }
    }
}

