/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectCollectionChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectCollectionChangeEvent;
import com.kingdee.bos.dao.TypelessObjectCollection;
import com.kingdee.bos.metadata.access.IMetaDataAccess;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractBaseObjectCollection
implements IObjectCollection {
    private static Logger logger = Logger.getLogger(AbstractBaseObjectCollection.class);
    protected List<IObjectValue> list;
    private Class<?> itemType = null;
    protected volatile transient Map<Object, Integer> indexes = null;
    protected transient List<IObjectCollectionChangeListener> listeners = null;

    public AbstractBaseObjectCollection() {
        this(null);
    }

    public AbstractBaseObjectCollection(int initialCapacity) {
        this.list = new ArrayList<IObjectValue>(initialCapacity);
    }

    protected AbstractBaseObjectCollection(Class<?> itemType) {
        this(2);
        this.itemType = itemType;
    }

    protected final void checkClass(IObjectValue o) throws IllegalArgumentException {
        if (this.itemType == null) {
            return;
        }
        if (!this.itemType.isInstance(o)) {
            throw new IllegalArgumentException("error type:need " + this.itemType.getName() + " but " + (o == null ? " the parameter IObjectValue is null " : o.getClass().getName()));
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean containsObject(IObjectValue o) {
        this.checkClass(o);
        return this.list.contains(o);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getIndex().containsKey(key);
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean addObject(IObjectValue o) {
        Object tmp;
        int i;
        this.checkClass(o);
        boolean add = false;
        if (o.getPKField() != null && o.get(o.getPKField()) != null && (i = this.indexOf(tmp = o.get(o.getPKField()))) != -1) {
            this.fireEvent(2, null, o, i, i);
            this.list.set(i, o);
            add = true;
            this.fireEvent(3, null, o, i, i);
            return add;
        }
        this.fireEvent(0, null, o, -1, this.list.size());
        add = this.list.add(o);
        Integer size = this.list.size() - 1;
        if (o.getPKField() != null && o.get(o.getPKField()) != null) {
            this.getIndex().put(o.get(o.getPKField()), size);
        } else {
            this.getIndex().put(o.hashCode(), size);
        }
        this.fireEvent(1, null, o, -1, this.list.size() - 1);
        return add;
    }

    @Override
    public boolean addObjectCollection(IObjectCollection c) {
        if (c == null) {
            return false;
        }
        if (c == this) {
            return true;
        }
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            this.addObject(c.getObject(i));
        }
        return true;
    }

    @Override
    public boolean removeObject(IObjectValue o) {
        this.checkClass(o);
        int seq = this.list.indexOf(o);
        this.fireEvent(4, o, null, seq, -1);
        boolean remove = this.list.remove(o);
        this.innerUpdateIndex();
        this.fireEvent(5, o, null, seq, -1);
        return remove;
    }

    @Override
    public int indexOf(IObjectValue o) {
        return this.list.indexOf(o);
    }

    @Override
    public int indexOf(Object key) {
        Integer i = this.getIndex().get(key);
        if (i != null) {
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(IObjectValue o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public void clear() {
        this.fireEvent(6, null, null, -1, -1);
        this.list.clear();
        this.indexes = null;
        this.fireEvent(7, null, null, -1, -1);
    }

    @Override
    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that == null || !(that instanceof AbstractBaseObjectCollection)) {
            return false;
        }
        if (!this.getClass().getName().equals(that.getClass().getName())) {
            return false;
        }
        return this.list.equals(((AbstractBaseObjectCollection)that).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public IObjectValue getObject(int index) {
        if (index >= this.list.size() || index < 0) {
            return null;
        }
        IObjectValue o = this.list.get(index);
        if (o == null) {
            return null;
        }
        return o;
    }

    @Override
    public IObjectValue getObject(Object key) {
        int i = this.indexOf(key);
        if (i == -1) {
            return null;
        }
        return this.getObject(i);
    }

    @Override
    public IObjectValue removeObject(Object key) {
        int i = this.indexOf(key);
        if (i == -1) {
            return null;
        }
        return this.removeObject(i);
    }

    @Override
    public IObjectValue setObject(int index, IObjectValue element) {
        return this.setObject(index, element, true);
    }

    private IObjectValue setObject(int index, IObjectValue element, boolean checkDup) {
        Object tmp;
        int i;
        this.checkClass(element);
        IObjectValue oldObj = this.getObject(index);
        this.fireEvent(2, oldObj, element, index, index);
        if (checkDup && element.getPKField() != null && element.get(element.getPKField()) != null && (i = this.indexOf(tmp = element.get(element.getPKField()))) != -1) {
            if (i > index) {
                this.list.remove(i);
            } else if (i < index) {
                this.list.remove(i);
                --index;
            }
        }
        IObjectValue set = this.list.set(index, element);
        this.innerUpdateIndex();
        this.fireEvent(3, oldObj, element, index, index);
        return set;
    }

    @Override
    public void appendObject(IObjectValue element) {
        this.addObject(this.size(), element);
    }

    @Override
    public void addObject(int index, IObjectValue element) {
        Object tmp;
        int i;
        this.checkClass(element);
        this.fireEvent(0, null, element, -1, index);
        if (element.getPKField() != null && element.get(element.getPKField()) != null && (i = this.indexOf(tmp = element.get(element.getPKField()))) != -1) {
            this.list.remove(i);
            if (i <= index) {
                --index;
            }
        }
        if (index < 0) {
            index = 0;
        }
        this.list.add(index, element);
        this.innerUpdateIndex();
        this.fireEvent(1, null, element, -1, index);
    }

    @Override
    public void insertObject(int index, IObjectValue ov) {
        this.addObject(index + 1, ov);
    }

    @Override
    public void insertObject(Object key, IObjectValue ov) {
        int i;
        if (key == null) {
            this.appendObject(ov);
        }
        if ((i = this.indexOf(key)) == -1) {
            this.appendObject(ov);
        } else {
            this.addObject(i + 1, ov);
        }
    }

    @Override
    public void insertObject(IObjectValue old, IObjectValue ov) {
        int i;
        if (old == null) {
            this.appendObject(ov);
        }
        if ((i = this.indexOf(old)) == -1) {
            this.appendObject(ov);
        } else {
            this.addObject(i + 1, ov);
        }
    }

    @Override
    public IObjectValue removeObject(int index) {
        IObjectValue item = this.getObject(index);
        this.fireEvent(4, item, null, index, -1);
        IObjectValue objVal = this.list.remove(index);
        this.innerUpdateIndex();
        this.fireEvent(5, item, null, index, -1);
        return objVal;
    }

    @Override
    public void changeIndex(int oldIndex, int newIndex) {
        IObjectValue o = this.getObject(oldIndex);
        this.fireEvent(8, o, o, oldIndex, newIndex);
        this.list.remove(oldIndex);
        this.list.add(newIndex, o);
        this.innerUpdateIndex();
        this.fireEvent(9, o, o, oldIndex, newIndex);
    }

    @Override
    public void updateIndex() {
        this.innerUpdateIndex();
    }

    private final void innerUpdateIndex() {
        Map<Object, Integer> i = this.indexes;
        this.indexes = null;
        if (i != null) {
            i.clear();
        }
    }

    @Override
    public void addEventListener(IObjectCollectionChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.checkListeners();
        this.listeners.add(listener);
    }

    @Override
    public IObjectCollectionChangeListener[] getEventListeners() {
        if (this.listeners == null) {
            return new IObjectCollectionChangeListener[0];
        }
        IObjectCollectionChangeListener[] os = this.listeners.toArray(new IObjectCollectionChangeListener[this.listeners.size()]);
        if (os != null) {
            return os;
        }
        return null;
    }

    @Override
    public void removeEventListener(IObjectCollectionChangeListener listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireEvent(int type, IObjectValue oldItem, IObjectValue newItem, int changedIndex, int index) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            ObjectCollectionChangeEvent ev = new ObjectCollectionChangeEvent(type, this, oldItem, newItem, changedIndex, index);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).objectCollectionChange(ev);
            }
        }
    }

    @Override
    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = this.getObject(i);
        }
        return objs;
    }

    @Override
    public boolean swap(int indexA, int indexB) {
        if (indexA == indexB) {
            return true;
        }
        if (indexA < 0 || indexB < 0) {
            return false;
        }
        if (indexA > this.size() || indexB > this.size()) assert (false) : "Invalidate parameter";
        IObjectValue a = this.getObject(indexA);
        IObjectValue b = this.setObject(indexB, a, false);
        this.setObject(indexA, b, false);
        return true;
    }

    @Override
    public boolean swap(Object keyA, Object keyB) {
        int a = this.indexOf(keyA);
        int b = this.indexOf(keyB);
        if (a == -1 || b == -1) {
            return false;
        }
        return this.swap(a, b);
    }

    @Override
    public boolean swap(IObjectValue ova, IObjectValue ovb) {
        int a = this.indexOf(ova);
        int b = this.indexOf(ovb);
        return this.swap(a, b);
    }

    @Override
    public boolean move(int fromIndex, int toAfterIndex) {
        if (fromIndex > toAfterIndex) {
            ++toAfterIndex;
        }
        if (fromIndex == -1 || toAfterIndex == -1) {
            return false;
        }
        if (fromIndex == toAfterIndex) {
            return true;
        }
        this.changeIndex(fromIndex, toAfterIndex);
        return true;
    }

    @Override
    public boolean move(Object fromKey, Object toKey) {
        int a = this.indexOf(fromKey);
        int b = this.indexOf(toKey);
        if (a == -1 || b == -1) {
            return false;
        }
        return this.move(a, b);
    }

    @Override
    public boolean move(int fromIndex, Object toAfterKey) {
        int toAfterIndex = this.indexOf(toAfterKey);
        if (toAfterIndex == -1) {
            return false;
        }
        return this.move(fromIndex, toAfterIndex);
    }

    @Override
    public boolean move(Object fromKey, IObjectValue toAfterObj) {
        int a = this.indexOf(fromKey);
        int b = this.indexOf(toAfterObj);
        if (a == -1 || b == -1) {
            return false;
        }
        return this.move(a, b);
    }

    public Object clone() {
        try {
            return ObjectUtils.createCopy((Object)this);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    @Override
    public IObjectCollection cast(Class clz) {
        if (clz.isAssignableFrom(IObjectCollection.class)) {
            throw new ClassCastException("Invalidate class type " + clz);
        }
        try {
            AbstractBaseObjectCollection oc = (AbstractBaseObjectCollection)clz.newInstance();
            oc.indexes = this.indexes;
            oc.list = this.list;
            oc.listeners = this.listeners;
            return oc;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new ClassCastException(e.getMessage());
        }
    }

    @Override
    public boolean reOrder(int[] newIndexes) {
        if (this.getIndex().size() != newIndexes.length) {
            return false;
        }
        TypelessObjectCollection oc = new TypelessObjectCollection();
        for (int i = 0; i < newIndexes.length; ++i) {
            oc.addObject(this.getObject(newIndexes[i]));
        }
        this.list = oc.list;
        this.indexes = oc.indexes;
        return true;
    }

    private void checkListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IObjectCollectionChangeListener>(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Integer> getIndex() {
        if (this.indexes != null) {
            return this.indexes;
        }
        AbstractBaseObjectCollection abstractBaseObjectCollection = this;
        synchronized (abstractBaseObjectCollection) {
            if (this.indexes == null) {
                HashMap<Object, Integer> idx = new HashMap<Object, Integer>(this.size());
                Iterator<IObjectValue> it = this.list.iterator();
                IObjectValue o = null;
                int i = 0;
                while (it.hasNext()) {
                    o = it.next();
                    if (o.getPKField() != null && o.get(o.getPKField()) != null) {
                        idx.put(o.get(o.getPKField()), i);
                    } else {
                        idx.put(o.hashCode(), i);
                    }
                    ++i;
                }
                this.indexes = idx;
                return idx;
            }
            return this.indexes;
        }
    }

    @Override
    public void trimToSize() {
        this.indexes = null;
        this.listeners = null;
        if (this.list instanceof ArrayList) {
            ((ArrayList)this.list).trimToSize();
        }
    }

    @Override
    public void addObjectDirect(IObjectValue o) {
        this.checkClass(o);
        this.list.add(o);
    }

    public void marshal(Marshaller marshaller) throws IOException {
        if (this.itemType == null) {
            marshaller.writeObject(null);
        } else {
            marshaller.writeObject((Object)this.itemType.getName());
        }
        marshaller.writeInt(this.list.size());
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            marshaller.writeObject((Object)this.list.get(i));
        }
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        String itemTypeName = (String)unmarshaller.readObject();
        if (itemTypeName != null) {
            this.itemType = Class.forName(itemTypeName);
        }
        int size = unmarshaller.readInt();
        for (int i = 0; i < size; ++i) {
            this.list.add((IObjectValue)unmarshaller.readObject());
        }
        this.trimToSize();
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }

    @Override
    public void intern() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        this.intern(map);
        map.clear();
    }

    private int intern(HashMap<Object, Object> map) {
        int replaceCount = 0;
        Iterator<IObjectValue> iter = this.list.iterator();
        while (iter.hasNext()) {
            replaceCount += this.intern(iter.next(), map);
        }
        return replaceCount;
    }

    private int intern(IObjectValue ov, HashMap<Object, Object> map) {
        int replaceCount = 0;
        Enumeration e = ov.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = ov.get(key);
            if (value instanceof String) continue;
            Object value2 = map.get(value);
            if (value2 != null) {
                if (value == value2) continue;
                ov.put(key, value2);
                ++replaceCount;
                continue;
            }
            if (!(value instanceof BOSUuid) && !(value instanceof Uuid) && !(value instanceof Number) && !(value instanceof String)) continue;
            map.put(value, value);
            if (value instanceof IObjectValue) {
                IObjectValue ov2 = (IObjectValue)value;
                replaceCount += this.intern(ov2, map);
                continue;
            }
            if (!(value instanceof AbstractBaseObjectCollection)) continue;
            AbstractBaseObjectCollection oc = (AbstractBaseObjectCollection)value;
            replaceCount += oc.intern(map);
        }
        return replaceCount;
    }

    @Override
    public void sort() {
        if (this.list == null || this.list.size() <= 1) {
            return;
        }
        String seq = null;
        try {
            BOSObjectType type = this.list.get(0).getBOSType();
            IMetaDataAccess loader = ConfigMDUtil.isClient() ? MetaDataAccessFactory.getRemoteInstance() : MetaDataAccessFactory.getLocalInstance(ConfigMDUtil.getContext());
            EntitySelect select = new EntitySelect(type);
            select.selectSequenceProperty();
            SimpleEntity entity = loader.select(select);
            if (entity != null) {
                seq = entity.getSequenceProperty();
            }
        }
        catch (Exception e) {
            seq = null;
        }
        this.sort(seq);
    }

    @Override
    public void sort(final String propertyName) {
        if (StringUtils.isEmpty((String)propertyName)) {
            return;
        }
        if (this.list == null || this.list.size() <= 1) {
            return;
        }
        Collections.sort(this.list, new Comparator<IObjectValue>(){

            @Override
            public int compare(IObjectValue o1, IObjectValue o2) {
                Object k1 = o1.get(propertyName);
                Object k2 = o2.get(propertyName);
                if (k1 != null && k2 != null) {
                    if (k1 instanceof Comparable) {
                        return ((Comparable)k1).compareTo(k2);
                    }
                } else {
                    if (k1 == null && k2 == null) {
                        return 0;
                    }
                    if (k1 == null) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        });
    }
}

