/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.CompareUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.IObjectValueChangeListener;
import com.kingdee.bos.dao.ObjectValueChangeEvent;
import com.kingdee.bos.dao.UnloadedPropertyException;
import com.kingdee.bos.metadata.access.IMetaDataAccess;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.EntryOrderInfo;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.SortedStringObjectMap;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractBaseObjectValue
extends PropertyContainer
implements IObjectValue {
    private static Logger logger = Logger.getLogger(AbstractBaseObjectValue.class);
    private Locale defaultLocale = null;
    private boolean isLoaded = false;
    private String pkField;
    protected Map extendedProps = null;
    protected transient List<IObjectValueChangeListener> listeners = null;

    protected AbstractBaseObjectValue(boolean init) {
        super(init);
    }

    public AbstractBaseObjectValue(int initialCapacity) {
        super(initialCapacity);
    }

    public AbstractBaseObjectValue(int initialCapacity, String pkField) {
        super(initialCapacity);
        this.pkField = pkField;
        this.defaultLocale = ContextUtils.getLocaleFromEnv();
    }

    public AbstractBaseObjectValue(int initialCapacity, String pkField, boolean isMD) {
        super(initialCapacity);
        this.pkField = pkField;
    }

    public AbstractBaseObjectValue() {
        this(null);
    }

    protected AbstractBaseObjectValue(String pkField) {
        this(30, pkField);
    }

    @Override
    public abstract BOSObjectType getBOSType();

    @Override
    public String getPKField() {
        return this.pkField;
    }

    @Override
    public void setPKField(String pkField) {
        this.pkField = pkField;
    }

    private static final String localedKeyName(String key, Locale locale) {
        return key.trim() + "_" + BOSLocaleUtil.getShortCode(locale);
    }

    @Override
    public Object get(String key, Locale locale) {
        if (locale == null) {
            locale = ContextUtils.getLocaleFromEnv();
        }
        if (this.defaultLocale != null && locale.equals(this.defaultLocale)) {
            return super.get(key);
        }
        return super.get(AbstractBaseObjectValue.localedKeyName(key, locale));
    }

    @Override
    public Object get(String key, Object defaultValue, Locale locale) {
        if (locale == null) {
            locale = ContextUtils.getLocaleFromEnv();
        }
        if (this.defaultLocale != null && locale.equals(this.defaultLocale)) {
            return this.get(key, defaultValue);
        }
        return this.get(AbstractBaseObjectValue.localedKeyName(key, locale), defaultValue);
    }

    @Override
    public IObjectValue getObjectValue(String key) {
        return (IObjectValue)this.get(key);
    }

    @Override
    public Object put(String key, Object value, Locale locale) {
        if (locale == null) {
            locale = ContextUtils.getLocaleFromEnv();
        }
        if (this.defaultLocale != null && locale.equals(this.defaultLocale)) {
            super.put(AbstractBaseObjectValue.localedKeyName(key, this.defaultLocale), value);
        } else {
            key = AbstractBaseObjectValue.localedKeyName(key, locale);
        }
        if (this.listeners == null || this.listeners.isEmpty()) {
            return super.put(key, value);
        }
        boolean isAdding = !this.containsKey(key);
        Object oldValue = super.get(key);
        boolean isChanging = false;
        isChanging = oldValue != null ? !CompareUtils.equalsTo(oldValue, value) : value != null;
        if (isAdding) {
            this.fireEvent(2, key, oldValue, value);
        } else if (isChanging) {
            this.fireEvent(0, key, oldValue, value);
        }
        Object val = super.put(key, value);
        if (isAdding) {
            this.fireEvent(3, key, oldValue, value);
        } else if (isChanging) {
            this.fireEvent(1, key, oldValue, value);
        }
        return val;
    }

    @Override
    public boolean containsKey(String key, Locale locale) {
        if (this.defaultLocale != null && locale.equals(this.defaultLocale)) {
            return this.containsKey(key);
        }
        return this.containsKey(AbstractBaseObjectValue.localedKeyName(key, locale));
    }

    @Override
    public Object remove(String key, Locale locale) {
        if (this.defaultLocale != null && locale.equals(this.defaultLocale)) {
            return this.remove(key);
        }
        return this.remove(AbstractBaseObjectValue.localedKeyName(key, locale));
    }

    public Object put(String key, Object value) throws ORMCoreException {
        if ("description".equalsIgnoreCase(key) || "alias".equalsIgnoreCase(key)) {
            return this.put(key, value, null);
        }
        if (this.listeners == null || this.listeners.isEmpty()) {
            return super.put(key, value);
        }
        boolean isAdding = !this.containsKey(key);
        Object oldValue = super.get(key);
        boolean isChanging = false;
        isChanging = oldValue != null ? !CompareUtils.equalsTo(oldValue, value) : value != null;
        if (isAdding) {
            this.fireEvent(2, key, oldValue, value);
        } else if (isChanging) {
            this.fireEvent(0, key, oldValue, value);
        }
        Object val = super.put(key, value);
        if (isAdding) {
            this.fireEvent(3, key, oldValue, value);
        } else if (isChanging) {
            this.fireEvent(1, key, oldValue, value);
        }
        return val;
    }

    public Object remove(String key) {
        Object oldValue = this.get(key);
        this.fireEvent(4, key, oldValue, null);
        Object val = super.remove(key);
        this.fireEvent(5, key, oldValue, null);
        return val;
    }

    @Override
    public void addEventListener(IObjectValueChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.ensureListenerNotNull();
        }
        this.listeners.add(listener);
    }

    protected void ensureListenerNotNull() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IObjectValueChangeListener>(2);
        }
    }

    @Override
    public IObjectValueChangeListener[] getEventListeners() {
        if (this.listeners == null) {
            return new IObjectValueChangeListener[0];
        }
        IObjectValueChangeListener[] os = this.listeners.toArray(new IObjectValueChangeListener[this.listeners.size()]);
        if (os != null) {
            return os;
        }
        return null;
    }

    @Override
    public void removeEventListener(IObjectValueChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void fireEvent(int type, String propertyName, Object oldValue, Object newValue) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            ObjectValueChangeEvent ev = new ObjectValueChangeEvent(type, this, propertyName, oldValue, newValue);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).objectValueChange(ev);
            }
        }
    }

    @Override
    public void setDefaultLocale(Locale locale) {
        if (this.defaultLocale == null) {
            this.defaultLocale = locale;
        }
    }

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public String toString() {
        if (this.pkField != null) {
            String pkValue = "null";
            if (this.get(this.pkField) != null) {
                pkValue = this.get(this.pkField).toString();
            }
            return "[" + this.pkField + ": " + pkValue + "]" + super.toString();
        }
        return super.toString();
    }

    public boolean equalsPK(IObjectValue ov) {
        if (this.pkField == null) {
            throw new IllegalArgumentException("IF pkfiled == null, cannot user this method!");
        }
        if (!this.pkField.equalsIgnoreCase(ov.getPKField())) {
            return false;
        }
        if (this.get(this.pkField) == null) {
            return false;
        }
        return this.get(this.pkField).equals(ov.get(ov.getPKField()));
    }

    @Override
    public void putAll(IObjectValue ov) {
        if (ov == null || this == ov) {
            return;
        }
        this.clear();
        AbstractBaseObjectValue aov = (AbstractBaseObjectValue)ov;
        this.values.putAll(aov.values);
        if (aov.extendedProps != null) {
            this.getExtendedProps().putAll(aov.getExtendedProps());
        }
        this.defaultLocale = aov.defaultLocale;
        if (aov.listeners != null && aov.listeners.size() > 0) {
            if (this.listeners == null) {
                this.ensureListenerNotNull();
            }
            this.listeners.addAll(aov.listeners);
        }
        this.pkField = aov.pkField;
    }

    @Override
    public void clear() {
        this.values.clear();
        this.extendedProps = null;
        this.defaultLocale = null;
        this.listeners = null;
        this.pkField = null;
    }

    @Override
    public void setExtendedProperty(String key, String value) {
        this.getExtendedProps().put(key, value);
    }

    @Override
    public void setExtendedProperty(String key, String value, Locale locale) {
        this.setExtendedProperty(key, value);
    }

    @Override
    public String getExtendedProperty(String key) {
        return (String)this.getExtendedProps().get(key);
    }

    @Override
    public String getExtendedProperty(String key, Locale locale) {
        return this.getExtendedProperty(key);
    }

    @Override
    public boolean containsExtendedPropertyKey(String key) {
        return this.getExtendedProps().containsKey(key);
    }

    @Override
    public boolean containsExtendedPropertyKey(String key, Locale locale) {
        return this.containsExtendedPropertyKey(key);
    }

    @Override
    public Map getExtendedProperties() {
        return this.getExtendedProps();
    }

    @Override
    public boolean isExtendedPropertiesEmpty() {
        return this.getExtendedProps().isEmpty();
    }

    @Override
    public void clearExtendedProperties() {
        this.getExtendedProps().clear();
    }

    @Override
    public void removeExtendedProperty(String key, Locale locale) {
        this.removeExtendedProperty(key);
    }

    @Override
    public void removeExtendedProperty(String key) {
        this.getExtendedProps().remove(key);
    }

    @Override
    public IObjectValue cast(Class clz) {
        if (clz.isAssignableFrom(IObjectValue.class)) {
            throw new ClassCastException("Invalidate class type " + clz);
        }
        try {
            AbstractBaseObjectValue ov = (AbstractBaseObjectValue)clz.newInstance();
            ov.defaultLocale = this.defaultLocale;
            if (this.extendedProps != null) {
                ov.extendedProps = this.extendedProps;
            }
            ov.listeners = this.listeners;
            ov.pkField = this.pkField;
            ov.values = this.values;
            return ov;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new ClassCastException(e.getMessage());
        }
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setIsLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public Object get(String key, Object defaultValue) {
        if ("description".equalsIgnoreCase(key) || "alias".equalsIgnoreCase(key)) {
            return this.get(key, defaultValue, null);
        }
        if (this.isLoaded()) {
            if (this.values.containsKey(key)) {
                return super.get(key, defaultValue);
            }
            throw new UnloadedPropertyException("The Object[" + this.getBOSType() + "]'s key" + key + "] has not be loaded! please load yourself!");
        }
        return super.get(key, defaultValue);
    }

    public Object get(String key) {
        if ("description".equalsIgnoreCase(key) || "alias".equalsIgnoreCase(key)) {
            return this.get(key, null);
        }
        if (this.isLoaded()) {
            if (this.values.containsKey(key)) {
                return super.get(key);
            }
            throw new UnloadedPropertyException("The Object[" + this.getBOSType() + "]'s key" + key + "] has not be loaded! please load yourself!");
        }
        return super.get(key);
    }

    public Object get(String key, boolean isNoException) {
        if (isNoException) {
            return super.get(key);
        }
        return this.get(key);
    }

    public boolean isNull(String key) {
        return super.get(key) == null;
    }

    private Map getExtendedProps() {
        if (this.extendedProps == null) {
            this.extendedProps = new SortedStringObjectMap();
        }
        return this.extendedProps;
    }

    public void trimToSize() {
        IdentityHashMap trimed = new IdentityHashMap();
        this.trimToSize(trimed);
    }

    void trimToSize(Map trimed) {
        super.trimToSize();
        if (this.extendedProps != null && this.extendedProps instanceof SortedStringObjectMap) {
            ((SortedStringObjectMap)this.extendedProps).trimToSize();
        }
        for (Object value : this.values.values()) {
            if (value instanceof AbstractObjectValue) {
                AbstractObjectValue v = (AbstractObjectValue)value;
                if (trimed.containsKey(v)) continue;
                trimed.put(v, null);
                v.trimToSize(trimed);
                continue;
            }
            if (!(value instanceof IObjectCollection)) continue;
            IObjectCollection col = (IObjectCollection)value;
            col.trimToSize();
            int m = col.size();
            for (int j = 0; j < m; ++j) {
                AbstractObjectValue v = (AbstractObjectValue)col.getObject(j);
                if (trimed.containsKey(v)) continue;
                trimed.put(v, null);
                v.trimToSize(trimed);
            }
        }
    }

    public boolean equals(Object that) {
        PropertyContainer.IdentityStack thisRefStack = new PropertyContainer.IdentityStack();
        PropertyContainer.IdentityStack thatRefStack = new PropertyContainer.IdentityStack();
        return AbstractBaseObjectValue.equalsValue(this, that, thisRefStack, thatRefStack);
    }

    private static final boolean equalsValue(AbstractBaseObjectValue thisObject, Object thatObject, PropertyContainer.IdentityStack thisRefStack, PropertyContainer.IdentityStack thatRefStack) {
        if (thatObject == thisObject) {
            return true;
        }
        if (!(thatObject instanceof AbstractObjectValue)) {
            return false;
        }
        if (!thisObject.getClass().getName().equals(thatObject.getClass().getName())) {
            return false;
        }
        int thisRefDeepth = thisRefStack.search((Object)thisObject);
        int thatRefDeepth = thatRefStack.search(thatObject);
        if (thisRefDeepth >= 0) {
            return thisRefDeepth == thatRefDeepth;
        }
        thisRefStack.push((Object)thisObject);
        thatRefStack.push(thatObject);
        Map thisValues = thisObject.values;
        Map thatValues = ((AbstractBaseObjectValue)thatObject).values;
        if (thisValues.size() != thatValues.size()) {
            return false;
        }
        try {
            for (Map.Entry e : thisValues.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? thatValues.get(key) != null || !thatValues.containsKey(key) : (value instanceof AbstractBaseObjectValue ? !AbstractBaseObjectValue.equalsValue((AbstractBaseObjectValue)value, thatValues.get(key), thisRefStack, thatRefStack) : (value instanceof IObjectCollection ? !AbstractBaseObjectValue.equalsCollection((IObjectCollection)value, thatValues.get(key), thisRefStack, thatRefStack) : !value.equals(thatValues.get(key)))))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        thisRefStack.pop();
        thatRefStack.pop();
        return true;
    }

    private static final boolean equalsCollection(IObjectCollection thisCollection, Object thatCollection, PropertyContainer.IdentityStack thisRefStack, PropertyContainer.IdentityStack thatRefStack) {
        if (thatCollection == null) {
            return false;
        }
        if (thatCollection == thisCollection) {
            return true;
        }
        if (!(thatCollection instanceof IObjectCollection)) {
            return false;
        }
        if (!thisCollection.getClass().getName().equals(thatCollection.getClass().getName())) {
            return false;
        }
        int size = thisCollection.size();
        if (((IObjectCollection)thatCollection).size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            AbstractBaseObjectValue thisObject = (AbstractBaseObjectValue)thisCollection.getObject(i);
            IObjectValue thatObject = ((IObjectCollection)thatCollection).getObject(i);
            if (thisObject != null ? AbstractBaseObjectValue.equalsValue(thisObject, thatObject, thisRefStack, thatRefStack) : thatObject == null) continue;
            return false;
        }
        return true;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeObject((Object)this.defaultLocale);
        marshaller.writeBoolean(this.isLoaded);
        marshaller.writeObject((Object)this.pkField);
        if (this.extendedProps == null || this.extendedProps.size() == 0) {
            marshaller.writeBoolean(false);
        } else {
            marshaller.writeBoolean(true);
            ((SortedStringObjectMap)this.extendedProps).marshal(marshaller);
        }
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.defaultLocale = (Locale)unmarshaller.readObject();
        this.isLoaded = unmarshaller.readBoolean();
        this.pkField = (String)unmarshaller.readObject();
        if (unmarshaller.readBoolean()) {
            this.extendedProps = new SortedStringObjectMap();
            ((SortedStringObjectMap)this.extendedProps).unmarshal(unmarshaller);
        }
    }

    @Override
    public void sort() {
        List<EntryOrderInfo> entryOrderInfo = null;
        try {
            BOSObjectType type = this.getBOSType();
            IMetaDataAccess loader = ConfigMDUtil.isClient() ? MetaDataAccessFactory.getRemoteInstance() : MetaDataAccessFactory.getLocalInstance(ConfigMDUtil.getContext());
            EntitySelect select = new EntitySelect(type);
            select.selectEntryOrderInfo();
            SimpleEntity entity = loader.select(select);
            if (entity != null) {
                entryOrderInfo = entity.getEntryOrderInfo();
            }
        }
        catch (Exception e) {
            entryOrderInfo = null;
        }
        AbstractBaseObjectValue.sort(this, entryOrderInfo);
    }

    private static void sort(IObjectValue ov, List<EntryOrderInfo> entries) {
        if (entries != null && ov != null) {
            for (EntryOrderInfo entry : entries) {
                IObjectCollection col = (IObjectCollection)ov.get(entry.getEntry());
                if (col == null) continue;
                col.sort(entry.getSequence());
                if (entry.getSubEntries() == null) continue;
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    AbstractBaseObjectValue.sort(col.getObject(i), entry.getSubEntries());
                }
            }
        }
    }
}

