/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.DeleContext;
import com.kingdee.bos.dao.DeleContextUtil;
import com.kingdee.bos.dao.IDelegate;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractObjectCollectionDele
extends AbstractObjectCollection {
    private AbstractObjectCollection target;
    private List lstRemove;
    protected DeleContext ctx;

    public AbstractObjectCollectionDele(AbstractObjectCollection target, DeleContext ctx) {
        this.target = target;
        this.ctx = ctx;
        this.lstRemove = new ArrayList(2);
    }

    public DeleContext getContext() {
        return this.ctx;
    }

    public boolean addDele(IDelegate o) {
        IObjectValue t = o.getTarget();
        return this.addObject(t);
    }

    @Override
    public boolean addObjectCollection(IObjectCollection c) {
        if (c == null) {
            return false;
        }
        if (c == this) {
            return true;
        }
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue value = c.getObject(i);
            if (value instanceof IDelegate) {
                this.addDele((IDelegate)value);
                continue;
            }
            this.addObject(value);
        }
        return true;
    }

    @Override
    public IObjectValue removeObject(Object key) {
        return null;
    }

    @Override
    public IObjectValue removeObject(int index) {
        int size = this.size();
        if (index < 0 || index >= size) {
            return null;
        }
        int rtSize = super.size();
        int virginSize = size - rtSize;
        if (index >= virginSize) {
            return this.handleDelegate(super.removeObject(index - virginSize));
        }
        IObjectValue obj = null;
        if (this.lstRemove.size() == 0) {
            obj = this.target.getObject(index);
            this.lstRemove.add(obj);
            return this.handleDelegate(obj);
        }
        int i = 0;
        int j = 0;
        while (i <= index) {
            obj = this.target.getObject(j);
            if (!this.lstRemove.contains(obj)) {
                ++i;
            }
            ++j;
        }
        if (obj == null) {
            return null;
        }
        this.lstRemove.add(obj);
        return this.handleDelegate(obj);
    }

    @Override
    public IObjectValue getObject(int index) {
        int size = this.size();
        if (index < 0 || index >= size) {
            return null;
        }
        int rtSize = super.size();
        int virginSize = size - rtSize;
        if (index >= virginSize) {
            return this.handleDelegate(super.getObject(index - virginSize));
        }
        if (this.lstRemove.size() == 0) {
            return this.handleDelegate(this.target.getObject(index));
        }
        IObjectValue obj = null;
        int i = 0;
        int j = 0;
        while (i <= index) {
            obj = this.target.getObject(j);
            if (!this.lstRemove.contains(obj)) {
                ++i;
            }
            ++j;
        }
        return this.handleDelegate(obj);
    }

    @Override
    public IObjectValue getObject(Object key) {
        return null;
    }

    @Override
    public Iterator iterator() {
        ArrayList<IObjectValue> list = new ArrayList<IObjectValue>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            list.add(this.getObject(i));
        }
        return list.iterator();
    }

    private IDelegate handleDelegate(IObjectValue target) {
        if (target == null) {
            return null;
        }
        IDelegate dele = DeleContextUtil.get(target.getBOSType(), this.ctx, target);
        if (dele == null) {
            dele = this.createDelegate(target);
            DeleContextUtil.put(this.ctx, dele);
        }
        return dele;
    }

    protected abstract IDelegate createDelegate(IObjectValue var1);

    public void reset() {
        super.clear();
        this.lstRemove.clear();
    }

    @Override
    public int size() {
        return this.target.size() + super.size() - this.lstRemove.size();
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.target);
        s.append("[");
        s.append(super.toString());
        s.append("][D|");
        s.append(this.lstRemove);
        s.append("]");
        return s.toString();
    }
}

