/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.IMetadataHandle;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.RefImpl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BinaryLoader {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.dao.xml.BinaryLoader");
    private final MetaDataClassLoader cl;
    private final Context ctx;
    private final Map handleCache = new IdentityHashMap();

    private static String pk2path(BOSObjectType type, IMetaDataPK pk) {
        return "/" + pk.getFullName().replace('.', '/') + Utils.getMetaDataSuffix(type);
    }

    public BinaryLoader(Context ctx) {
        this.ctx = ctx;
        this.cl = new MetaDataClassLoader(Utils.getMetadataPath(ctx));
    }

    public IObjectValue find(BOSObjectType type, IMetaDataPK pk) throws DataAccessException {
        String resPath = BinaryLoader.pk2path(type, pk);
        InputStream is = null;
        try {
            is = this.cl.getResourceAsStream(resPath);
            if (is == null) {
                logger.error((Object)("Stream is null for " + pk));
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            AbstractMetaDataValue obj = (AbstractMetaDataValue)ois.readObject();
            this.refreshHandles(obj);
            ois.close();
            AbstractMetaDataValue abstractMetaDataValue = obj;
            return abstractMetaDataValue;
        }
        catch (IOException ioe) {
            throw new DataAccessException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DataAccessException(cnfe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
        }
    }

    public synchronized IObjectValue load(BOSObjectType type, IMetaDataPK pk) throws DataAccessException {
        String key = (pk.getFullName() + Utils.getMetaDataSuffix(type)).intern();
        Object value = this.handleCache.get(key);
        if (value == null) {
            value = this.pk2handle(type, pk);
            if (value == null) {
                AbstractMetaDataValue vv = (AbstractMetaDataValue)this.find(type, pk);
                BOSObjectType realType = vv.getBOSType();
                value = this.pk2handle(realType, pk);
            }
            this.handleCache.put(key, value);
        }
        return (IObjectValue)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SolutionInfo loadSolution() throws DataAccessException {
        IMetaDataPK[] pks = this.cl.getMDContext().pkIndexs.getMetaDataPKs(MetaDataTypeList.SOLUTION);
        assert (pks != null && pks.length > 0);
        String rsName = null;
        rsName = StringUtils.isEmpty((String)pks[0].getPackage()) ? "/" + pks[0].toString() + "." + "solution" : "/" + pks[0].getPackage().replace('.', '/') + '/' + pks[0].getName() + "." + "solution";
        SolutionInfo slnInfo = null;
        InputStream is = null;
        try {
            is = this.cl.getResourceAsStream(rsName);
            assert (is != null);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(is);
                slnInfo = (SolutionInfo)ois.readObject();
            }
            catch (IOException ioe) {
                throw new DataAccessException(ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new DataAccessException(cnfe);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return slnInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Map map = this.handleCache;
        synchronized (map) {
            for (Object h : this.handleCache.values()) {
                try {
                    IMetadataHandle mh = (IMetadataHandle)h;
                    mh.clearMetadata();
                }
                catch (Exception exception) {}
            }
        }
    }

    private IMetadataHandle pk2handle(BOSObjectType type, IMetaDataPK pk) throws DataAccessException {
        String handleClass = BinaryLoader.getHandleClassName(type);
        try {
            Class<?> c = Class.forName(handleClass, false, pk.getClass().getClassLoader());
            IMetadataHandle h = (IMetadataHandle)c.newInstance();
            RefImpl r = new RefImpl(pk, type, this.ctx);
            h.initHandle(r);
            return h;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getHandleClassName(BOSObjectType type) {
        String ctrlClass = "";
        if (type.equals((Object)MetaDataTypeList.DATATABLE)) {
            ctrlClass = "com.kingdee.bos.metadata.data.DataTableInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.ABSTRACTTABLE)) {
            ctrlClass = "com.kingdee.bos.metadata.data.AbstractTableInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.CROSSTABLE)) {
            ctrlClass = "com.kingdee.bos.metadata.data.CrossTableInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.EXTENDEDTABLE)) {
            ctrlClass = "com.kingdee.bos.metadata.data.ExtendedTableInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.SOLUTION)) {
            ctrlClass = "com.kingdee.bos.metadata.management.SolutionInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.APPVIEW)) {
            ctrlClass = "com.kingdee.bos.metadata.management.application.AppViewInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BIZENUM)) {
            ctrlClass = "com.kingdee.bos.metadata.resource.BizEnumInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BIZEXCEPTION)) {
            ctrlClass = "com.kingdee.bos.metadata.resource.BizExceptionInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BIZDATATYPE)) {
            ctrlClass = "com.kingdee.bos.metadata.resource.BizDataTypeInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.PACKAGE)) {
            ctrlClass = "com.kingdee.bos.metadata.management.PackageInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.ENTITY)) {
            ctrlClass = "com.kingdee.bos.metadata.entity.EntityObjectInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BIZRULESET)) {
            ctrlClass = "com.kingdee.bos.metadata.bizrule.RuleSetInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BIZUNIT)) {
            ctrlClass = "com.kingdee.bos.metadata.bizunit.BizUnitInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BIZTEMPLATE)) {
            ctrlClass = "com.kingdee.bos.metadata.bizunit.BizTemplateInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.DATAX)) {
            ctrlClass = "com.kingdee.bos.metadata.datax.DataXInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.REPORT)) {
            ctrlClass = "com.kingdee.bos.metadata.report.ReportInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.UIOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.ui.UIObjectInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.WEBUIOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.webui.WebUIObjectInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.FACADE)) {
            ctrlClass = "com.kingdee.bos.metadata.facade.FacadeInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.WORKFLOW)) {
            ctrlClass = "com.kingdee.bos.workflow.wfdesigner.WorkFlowInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.RELATIONSHIP)) {
            ctrlClass = "com.kingdee.bos.metadata.entity.RelationshipInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.FUNCTION)) {
            ctrlClass = "com.kingdee.bos.metadata.function.FunctionObjectInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.JOINQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.query.JoinQueryInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BASEQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.query.QueryInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.UNIONQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.query.UnionQueryInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.VIRTUALQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.query.VirtualQueryInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.RULE)) {
            ctrlClass = "com.kingdee.bos.metadata.rule.RuleInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.MULTILANGUAGE)) {
            ctrlClass = "com.kingdee.bos.metadata.resource.I18nResourceInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.PERMISSION)) {
            ctrlClass = "com.kingdee.bos.service.permission.metadata.PermissionInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.MDQUERY)) {
            ctrlClass = "com.kingdee.bos.metadata.mdquery.MDQueryInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.MUTEX)) {
            ctrlClass = "com.kingdee.bos.service.mutex.MutexInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.EVENT_FOR_WF)) {
            ctrlClass = "com.kingdee.bos.metadata.event.EventInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.LOG)) {
            ctrlClass = "com.kingdee.bos.service.log.define.LogInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BOTMAPPING)) {
            ctrlClass = "com.kingdee.bos.metadata.bot.BOTMappingInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.METADATABRIEFVIEW)) {
            ctrlClass = "com.kingdee.bos.metadata.view.MetaDataBriefViewInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BASE_TEMPLATE_REF_SET)) {
            ctrlClass = "com.kingdee.bos.metadata.management.BaseTemplateRefSetInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BIZRULESET)) {
            ctrlClass = "com.kingdee.bos.metadata.bizrule.RuleSetInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BIZUNIT)) {
            ctrlClass = "com.kingdee.bos.metadata.bizunit.BizUnitInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.BIZTEMPLATE)) {
            ctrlClass = "com.kingdee.bos.metadata.bizunit.BizUnitInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.INTEGRATION_TYPE)) {
            ctrlClass = "com.kingdee.bos.metadata.eai.IntegrationInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.APPLICATION_TYPE)) {
            ctrlClass = "com.kingdee.bos.metadata.eai.ApplicationInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.APPLICATION_NODE_TYPE)) {
            ctrlClass = "com.kingdee.bos.metadata.eai.ApplicationNodeInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.WEBPAGEOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.webpage.WebPageObjectInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.WEBCOMPONENTOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.webcomponent.WebComponentObjectInfoHandle";
        } else if (type.equals((Object)MetaDataTypeList.WEBCONTROLOBJECT)) {
            ctrlClass = "com.kingdee.bos.metadata.webcontrol.WebControlObjectInfoHandle";
        }
        return ctrlClass;
    }

    private void refreshHandles(AbstractMetaDataValue info) {
        IdentityHashMap seen = new IdentityHashMap();
        this.refreshHandles0(info, seen);
    }

    private void refreshHandles0(IObjectValue info, Map seen) {
        if (info == null) {
            return;
        }
        Enumeration keys = info.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = info.get(key);
            if (value instanceof IObjectCollection) {
                IObjectCollection vs = (IObjectCollection)value;
                for (int i = 0; i < vs.size(); ++i) {
                    IObjectValue v = vs.getObject(i);
                    if (v instanceof AbstractMetaDataValue) {
                        if (!(v instanceof IMetadataHandle)) continue;
                        vs.setObject(i, (IObjectValue)((Object)this.resolveHandle((IMetadataHandle)((Object)v))));
                        continue;
                    }
                    if (!(v instanceof IObjectValue) || seen.containsKey(v)) continue;
                    seen.put(v, null);
                    this.refreshHandles0(v, seen);
                }
                continue;
            }
            if (value instanceof AbstractMetaDataValue) {
                info.put(key, this.resolveHandle((IMetadataHandle)value));
                continue;
            }
            if (!(value instanceof IObjectValue) || seen.containsKey(value)) continue;
            seen.put(value, null);
            this.refreshHandles0((IObjectValue)value, seen);
        }
    }

    private synchronized IMetadataHandle resolveHandle(IMetadataHandle oldHandle) {
        String key = (oldHandle.getHandle().getResolvePK().getFullName() + Utils.getMetaDataSuffix(oldHandle.getHandle().getResolveType())).intern();
        Object value = this.handleCache.get(key);
        if (value == null) {
            oldHandle.reBandingContext(this.ctx);
            this.handleCache.put(key, oldHandle);
            return oldHandle;
        }
        return (IMetadataHandle)value;
    }

    public InputStream getStream(String path) {
        return this.cl.getResourceAsStream(path);
    }
}

