/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.Checker;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.XMLChecker;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.DynamicMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.validate.IValidate;
import com.kingdee.bos.metadata.validate.ValidateItem;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Stack;

class ReferIntegrityChecker
extends Checker {
    ArrayList items = new ArrayList();

    public ReferIntegrityChecker(XMLChecker checker, BOSObjectType type, IObjectPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) {
        super(checker, type, pk, filter, report, os);
    }

    public ReferIntegrityChecker(XMLChecker checker, BOSObjectType type, AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report, OutputStream os) {
        super(checker, type, ui, filter, report, os);
    }

    @Override
    CheckReportItem[] check() {
        try {
            InputStream is = XMLAccessEngine.getXMLLoader(this.checker.ctx).loadMetaInputStream(this.type, this.pk);
            if (is != null) {
                is.close();
                this.checkRefIntegrity();
            } else {
                CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 5, new String[]{this.pk + "is not exists!"});
                this.items.add(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.items.size() <= 0) {
            return null;
        }
        return this.items.toArray(new CheckReportItem[1]);
    }

    private NetFile checkObjectExist() {
        NetFile file = Utils.getNetFile(this.checker.fileSrc, this.type, this.pk);
        if (!file.exists()) {
            try {
                CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 5, new String[]{file.toURL().toString() + "is not exists!"});
                this.items.add(item);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        return file;
    }

    private void checkRefIntegrity() {
        try {
            IObjectValue ov = null;
            ov = this.vo != null ? this.vo : DynamicMetaDataCtrl.getMetadataCtrl(this.checker.ctx, this.type).getValue((IMetaDataPK)this.pk);
            EntityObjectInfo meta = XMLAccessEngine.getXMLLoader(this.checker.ctx).loadMeta(ov.getBOSType());
            if (ov instanceof EntityObjectInfo) {
                EntityObjectInfo entity = (EntityObjectInfo)ov;
                this.checkRefIntegrity(ov, meta);
            } else if (!(ov instanceof FunctionObjectInfo) && !(ov instanceof PermissionInfo)) {
                this.checkRefIntegrity(ov, meta);
            }
            this.validateObject(ov);
        }
        catch (MissingDAOMetaDataException me) {
            CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 9, new String[]{me.getMessage()});
            this.items.add(item);
        }
        catch (DataAccessException dae) {
            CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 9, new String[]{dae.getMessage()});
            this.items.add(item);
        }
        catch (BOSException de) {
            CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 10, new String[]{de.getMessage()});
            this.items.add(item);
        }
    }

    private void validateObject(IObjectValue ov) {
        if (ov instanceof IValidate) {
            ValidateList epList = ((IValidate)((Object)ov)).validate();
            ValidateItem[] items = null;
            if (epList != null) {
                items = epList.getItems(0);
                this.checkObjectVerify(items);
                items = epList.getItems(1);
                this.checkObjectVerify(items);
                items = epList.getItems(2);
                this.checkObjectVerify(items);
            }
        }
    }

    private void checkObjectVerify(ValidateItem[] vldItems) {
        if (vldItems != null) {
            for (int j = 0; j < vldItems.length; ++j) {
                CheckReportItem item = new CheckReportItem(vldItems[j].getLevel(), (IMetaDataPK)this.pk, this.type, this.pk.toString(), 11, new String[]{vldItems[j].getMessage()});
                this.items.add(item);
            }
        }
    }

    private void checkRefIntegrity(IObjectValue ov, EntityObjectInfo meta) {
        boolean isAbstract = false;
        if (ov instanceof EntityObjectInfo) {
            EntityObjectInfo en = (EntityObjectInfo)ov;
            isAbstract = en.isAbstract();
        }
        Stack<String> pathStack = new Stack<String>();
        pathStack.push("[ROOT]");
        this.checkRefIntegrity(ov, meta, isAbstract, pathStack);
    }

    private void checkRefIntegrity(IObjectValue ov, EntityObjectInfo meta, boolean isAbstract, Stack stack) {
        PropertyCollection props = meta.getInheritedProperties();
        PropertyInfo prop = null;
        LinkPropertyInfo linkProp = null;
        RelationshipInfo relation = null;
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo) || !ov.containsKey(prop.getName())) continue;
            linkProp = (LinkPropertyInfo)prop;
            relation = linkProp.getRelationship();
            CardinalityType suppCaty = relation.getSupplierCardinality();
            if (suppCaty.equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || suppCaty.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
                EntityObjectInfo entity;
                IObjectValue o;
                int j;
                IObjectCollection oc = (IObjectCollection)ov.get(prop.getName());
                if (ov instanceof LogicalKeyInfo) {
                    for (j = 0; j < oc.size(); ++j) {
                        o = oc.getObject(j);
                        if (o.get("_state_") == null) continue;
                        try {
                            entity = XMLAccessEngine.getXMLLoader(this.checker.ctx).loadMeta(relation.getSupplierObject().getType(), o);
                            stack.push(prop.getName() + "[" + this.keyString(entity, o) + "]");
                            this.processObjectNotExist(linkProp, relation, o, isAbstract, stack);
                            stack.pop();
                            continue;
                        }
                        catch (Exception e) {
                            XMLChecker.logger.error((Object)e, (Throwable)e);
                        }
                    }
                    continue;
                }
                for (j = 0; j < oc.size(); ++j) {
                    o = oc.getObject(j);
                    if (o.get("_state_") != null) {
                        try {
                            entity = XMLAccessEngine.getXMLLoader(this.checker.ctx).loadMeta(relation.getSupplierObject().getType(), o);
                            stack.push(prop.getName() + "[" + this.keyString(entity, o) + "]");
                            this.processObjectNotExist(linkProp, relation, o, isAbstract, stack);
                            stack.pop();
                        }
                        catch (Exception e) {
                            XMLChecker.logger.error((Object)e, (Throwable)e);
                        }
                        continue;
                    }
                    try {
                        entity = XMLAccessEngine.getXMLLoader(this.checker.ctx).loadMeta(relation.getSupplierObject().getType(), o);
                        if (relation.getType().equals((Object)RelationshipType.ASSOCIATION) || !relation.getType().equals((Object)RelationshipType.COMPOSITION)) continue;
                        stack.push(prop.getName() + "[" + this.keyString(entity, o) + "]");
                        this.checkRefIntegrity(o, entity, isAbstract, stack);
                        continue;
                    }
                    catch (Exception e) {
                        XMLChecker.logger.error((Object)e, (Throwable)e);
                    }
                }
                continue;
            }
            IObjectValue o = (IObjectValue)ov.get(prop.getName());
            if (o == null) continue;
            if (o.get("_state_") == null) {
                if (relation.getType().equals((Object)RelationshipType.ASSOCIATION) || !relation.getType().equals((Object)RelationshipType.COMPOSITION)) continue;
                stack.push(prop.getName());
                this.checkRefIntegrity(o, relation.getSupplierObject(), isAbstract, stack);
                continue;
            }
            stack.push(prop.getName());
            this.processObjectNotExist(linkProp, relation, o, isAbstract, stack);
            stack.pop();
        }
        stack.pop();
    }

    private String keyString(EntityObjectInfo meta, IObjectValue ov) {
        StringBuffer buff = new StringBuffer();
        PropertyCollection pc = meta.getLogicalKey().getKeyPropertys();
        for (int i = 0; i < pc.size(); ++i) {
            PropertyInfo prop = pc.get(i);
            if (i > 0) {
                buff.append(",");
            }
            try {
                buff.append(prop.getName() + "=" + ov.getString(prop.getName()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buff.toString();
    }

    private String lineStack(Stack stack) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            String ele = (String)stack.get(i);
            if (i > 0) {
                buff.append("->");
            }
            buff.append(ele);
        }
        return buff.toString();
    }

    private void processObjectNotExist(LinkPropertyInfo linkProp, RelationshipInfo relation, IObjectValue o, boolean isAbstract, Stack stack) {
        if (isAbstract && "mappingField".equals(linkProp.getName()) && o instanceof ColumnInfo) {
            return;
        }
        CheckReportItem item = new CheckReportItem(0, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 1, new String[]{"Reference Object {" + this.lineStack(stack) + "} not exists or not complete"});
        this.items.add(item);
    }
}

