/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.InnerMetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.management.PackageCtrl;
import com.kingdee.bos.metadata.management.application.MetaDataCollection;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.mr.MetadataParser;
import com.kingdee.bos.metadata.mr.Ref;
import com.kingdee.bos.metadata.mr.Tree;
import com.kingdee.bos.util.BOSObjectType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RelationManager {
    private static Logger logger = Logger.getLogger(RelationManager.class);
    private static final String FILE_NAME = "relation_index.properties";
    private boolean changed = false;
    private Context ctx;
    private Tree rt = new Tree();
    private static boolean enabled = false;
    public static boolean needInit = true;
    private int state = 1;
    private static final int STATE_NULL = 1;
    private static final int STATE_INIT = 2;
    private static final int STATE_OPEN = 4;
    private static final int STATE_CLOSE = 8;

    public RelationManager(Context ctx) {
        this.ctx = ctx;
        this.init();
    }

    public synchronized void modelLoad(IObjectValue ov) {
        if (ov instanceof AbstractMetaDataValue) {
            AbstractMetaDataValue model = (AbstractMetaDataValue)ov;
            this.changed |= this.rt.updateRefRelation(MetadataParser.getRefByObject(model), MetadataParser.getObjectLinkRefs(model));
        }
    }

    public synchronized void modelUpdate(IObjectValue ov) {
        if (ov instanceof AbstractMetaDataValue) {
            AbstractMetaDataValue model = (AbstractMetaDataValue)ov;
            this.changed |= this.rt.updateRefRelation(MetadataParser.getRefByObject(model), MetadataParser.getObjectLinkRefs(model));
        }
    }

    public synchronized void modelDelete(String fullName, BOSObjectType bosType) {
        Ref ref = new Ref(fullName, bosType.toString());
        this.rt.deleteRefRelation(ref);
        this.changed = true;
    }

    public void clearRelation() {
        this.rt = new Tree();
        File rf = this.getRelationFile();
        if (rf != null) {
            rf.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeRelation() {
        File file = this.getRelationFile();
        if (file == null || !file.exists()) {
            return;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.rt = Tree.deserialize(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRelation() {
        boolean old = RelationManager.isEnabled();
        if (old) {
            return;
        }
        boolean oldInit = needInit;
        RelationManager.setNeedInit(false);
        try {
            PackageCtrl pc = new PackageCtrl(this.ctx);
            MetaDataCollection mc = pc.getMetaDatas();
            for (int i = 0; i < mc.size(); ++i) {
                MetaDataInfo md = mc.get(i);
                IObjectValue ov = this.loadMetaDataByInfo(md);
                if (ov == null) continue;
                this.modelUpdate(ov);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)e, (Throwable)((Object)e));
        }
        finally {
            RelationManager.setNeedInit(oldInit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRelation() {
        this.clearRelation();
        boolean oldInit = needInit;
        RelationManager.setNeedInit(false);
        try {
            PackageCtrl pc = new PackageCtrl(this.ctx);
            MetaDataCollection mc = pc.getMetaDatasExceptPackage();
            for (int i = 0; i < mc.size(); ++i) {
                MetaDataInfo md = mc.get(i);
                IObjectValue ov = this.loadMetaDataByInfo(md);
                if (ov == null) continue;
                this.modelUpdate(ov);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)e, (Throwable)((Object)e));
        }
        finally {
            RelationManager.setNeedInit(oldInit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaDataInfo[] syncRelation(String targetDir) {
        String rootname = (String)this.ctx.get((Object)"METADATAPATH");
        File src = new File(rootname);
        File des = new File(targetDir);
        if (!des.exists() || !des.isDirectory()) {
            return new MetaDataInfo[0];
        }
        boolean old = RelationManager.isEnabled();
        RelationManager.setEnabled(false);
        MetaDataCollection syncs = new MetaDataCollection();
        try {
            PackageCtrl pc = new PackageCtrl(this.ctx);
            MetaDataCollection mc = pc.getMetaDatas("com");
            IMetaDataLoader loader = InnerMetaDataLoaderFactory.getInstance(this.ctx);
            for (int i = 0; i < mc.size(); ++i) {
                MetaDataInfo md = mc.get(i);
                String fileName = md.getFullName().replace('.', File.separatorChar) + Utils.getMetaDataSuffix(BOSObjectType.create((String)md.getMetaDataType()));
                File srcFile = new File(src, fileName);
                File desFile = new File(des, fileName);
                if (srcFile.lastModified() == desFile.lastModified() && srcFile.length() == desFile.length()) continue;
                syncs.add(md);
                try {
                    IObjectValue ov = loader.get(BOSObjectType.create((String)md.getMetaDataType()), MetaDataPK.create(md.getFullName()));
                    this.modelUpdate(ov);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)e, (Throwable)((Object)e));
        }
        finally {
            RelationManager.setEnabled(old);
        }
        if (syncs.size() > 0) {
            this.saveRelation();
        }
        MetaDataInfo[] rtv = new MetaDataInfo[syncs.size()];
        for (int i = 0; i < rtv.length; ++i) {
            rtv[i] = syncs.get(i);
        }
        return rtv;
    }

    synchronized void saveRelation0() {
        this.changed = true;
        this.saveRelation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveRelation() {
        if (!this.changed) {
            return;
        }
        File file = this.getRelationFile();
        if (file == null || !file.exists()) {
            return;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            Tree.serialize(this.rt, os);
            ((OutputStream)os).close();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close OutputStream error!", (Throwable)e);
            }
        }
        this.changed = false;
    }

    private File getRelationFile() {
        String rootname = (String)this.ctx.get((Object)"METADATAPATH");
        File root = new File(rootname);
        File rf = new File(root.getParentFile(), FILE_NAME);
        if (!rf.exists()) {
            try {
                rf.createNewFile();
            }
            catch (IOException e) {
                return null;
            }
        }
        return rf;
    }

    public Collection linkings(AbstractMetaDataValue info) {
        Ref ref = MetadataParser.getRefByObject(info);
        return this.rt.getAllLinking(ref);
    }

    public Collection linkeds(AbstractMetaDataValue info) {
        Ref ref = MetadataParser.getRefByObject(info);
        return this.rt.getAllLinked(ref);
    }

    public Collection linking(AbstractMetaDataValue info) {
        Ref ref = MetadataParser.getRefByObject(info);
        return this.rt.getDirectLinking(ref);
    }

    public Collection linked(AbstractMetaDataValue info) {
        Ref ref = MetadataParser.getRefByObject(info);
        return this.rt.getDirectLinked(ref);
    }

    public Tree relationTree() {
        return this.rt;
    }

    public void init() {
        File root;
        if (RelationManager.isEnabled() && (root = new File((String)this.ctx.get((Object)"METADATAPATH"))).exists() && root.isDirectory()) {
            File rf = new File(root.getParentFile(), FILE_NAME);
            if (rf.exists()) {
                this.activeRelation();
            } else {
                this.initRelation();
            }
        }
        this.state = 2;
    }

    public void open() {
        this.state = 4;
    }

    public void shudown() {
        this.state = 8;
        if (RelationManager.isEnabled()) {
            this.saveRelation();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        RelationManager.enabled = enabled;
    }

    public static boolean isNeedInit() {
        return enabled && needInit;
    }

    public static void setNeedInit(boolean needInit) {
        RelationManager.needInit = needInit;
    }

    public IObjectValue loadMetaDataByInfo(MetaDataInfo info) {
        BOSObjectType type = BOSObjectType.create((String)info.getMetaDataType());
        MetaDataPK pk = MetaDataPK.create(info.getFullName());
        try {
            IMetaDataCtrl ctrl = (IMetaDataCtrl)BOSObjectFactory.createBOSObject(this.ctx, type);
            Method method = ctrl.getClass().getMethod("getValue", IMetaDataPK.class);
            return (IObjectValue)method.invoke((Object)ctrl, pk);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

