/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.Checker;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLChecker;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.SAXBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class SchemaChecker
extends Checker
implements ErrorHandler,
EntityResolver {
    ArrayList items = new ArrayList();
    static final String PARSER = "org.apache.xerces.parsers.SAXParser";
    static final String APACHE_VALIDATION = "http://apache.org/xml/features/validation/schema";
    static final String APACHE_NS_SCHEMALOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    static final String XMLORG_NS = "http://xml.org/sax/features/namespaces";
    static final String METADATA_URL = "http://www.kingdee.com/bos/schmea/";
    static final String XSD_TABLE = "dataObject.xsd";
    static final String XSD_COMMON = "common.xsd";
    static final String XSD_ENTITY = "entityObject.xsd";
    static final String XSD_ENUM = "bizEnum.xsd";
    static final String XSD_EXCEPTION = "bizException.xsd";
    static final String XSD_FACADE = "facade.xsd";
    static final String XSD_FUNCTION = "function.xsd";
    static final String XSD_QUERY = "query.xsd";
    static final String XSD_RELATIONSHIP = "relationship.xsd";
    static final String XSD_RULE = "rule.xsd";
    static final String XSD_SOLUTION = "solution.xsd";
    static final String XSD_UIOBJECT = "uiObject.xsd";
    static final String XSD_WORKFLOW = "workFlow.xsd";

    public SchemaChecker(XMLChecker checker, BOSObjectType type, IObjectPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) {
        super(checker, type, pk, filter, report, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CheckReportItem[] check() {
        SAXBuilder builder = SAXBuilderFactory.create((boolean)true);
        builder.setFeature(APACHE_VALIDATION, true);
        builder.setFeature(XMLORG_NS, true);
        builder.setErrorHandler((ErrorHandler)this);
        builder.setEntityResolver((EntityResolver)this);
        builder.setProperty(APACHE_NS_SCHEMALOCATION, (Object)("com.kingdee.bos.metadata http://www.kingdee.com/bos/schmea/" + this.getSchema()));
        InputStream is = null;
        try {
            is = Utils.getObjectInputStream(this.checker.fileSrc, this.type, this.pk);
            builder.build(is, Utils.getNetFileURL(this.checker.fileSrc, this.type, this.pk).toString());
        }
        catch (IOException ioe) {
            CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 1, new String[]{ioe.getMessage()});
            XMLChecker.logger.error((Object)"", (Throwable)ioe);
            ioe.printStackTrace(System.out);
            this.items.add(item);
        }
        catch (JDOMException jdome) {
            CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 1, new String[]{jdome.getMessage()});
            jdome.printStackTrace(System.out);
            XMLChecker.logger.error((Object)"", (Throwable)jdome);
            this.items.add(item);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    XMLChecker.logger.error((Object)e, (Throwable)e);
                }
            }
        }
        if (this.items.size() <= 0) {
            return null;
        }
        return this.items.toArray(new CheckReportItem[1]);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 6, this.getMessages(exception));
        this.items.add(item);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 8, this.getMessages(exception));
        this.items.add(item);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        CheckReportItem item = new CheckReportItem(2, (IMetaDataPK)this.pk, this.type, this.pk.toString(), 7, this.getMessages(exception));
        this.items.add(item);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inSrc = new InputSource();
        if (systemId != null) {
            inSrc.setSystemId(systemId);
            String schema = systemId.substring(systemId.lastIndexOf(47) + 1, systemId.length());
            InputStream is = this.getClass().getResourceAsStream("/schemas/" + schema);
            assert (is != null) : "Cannot load schema " + schema;
            inSrc.setByteStream(is);
        }
        return inSrc;
    }

    private String[] getMessages(SAXParseException exception) {
        String[] msgs = new String[]{exception.getMessage(), "at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber(), "in entity " + exception.getSystemId()};
        return msgs;
    }

    private String getSchema() {
        String schema = null;
        if (this.type.equals((Object)MetaDataTypeList.DATATABLE) || this.type.equals((Object)MetaDataTypeList.EXTENDEDTABLE) || this.type.equals((Object)MetaDataTypeList.CROSSTABLE) || this.type.equals((Object)MetaDataTypeList.ABSTRACTTABLE)) {
            schema = XSD_TABLE;
        } else if (this.type.equals((Object)MetaDataTypeList.BIZENUM)) {
            schema = XSD_ENUM;
        } else if (this.type.equals((Object)MetaDataTypeList.BIZEXCEPTION)) {
            schema = XSD_EXCEPTION;
        } else if (this.type.equals((Object)MetaDataTypeList.ENTITY)) {
            schema = XSD_ENTITY;
        } else if (this.type.equals((Object)MetaDataTypeList.FACADE)) {
            schema = XSD_FACADE;
        } else if (this.type.equals((Object)MetaDataTypeList.FUNCTION)) {
            schema = XSD_FUNCTION;
        } else if (this.type.equals((Object)MetaDataTypeList.JOINQUERY) || this.type.equals((Object)MetaDataTypeList.UNIONQUERY)) {
            schema = XSD_QUERY;
        } else if (this.type.equals((Object)MetaDataTypeList.SOLUTION)) {
            schema = XSD_SOLUTION;
        } else if (this.type.equals((Object)MetaDataTypeList.RELATIONSHIP)) {
            schema = XSD_RELATIONSHIP;
        } else if (this.type.equals((Object)MetaDataTypeList.RULE)) {
            schema = XSD_RULE;
        } else if (this.type.equals((Object)MetaDataTypeList.UIOBJECT)) {
            schema = XSD_UIOBJECT;
        } else if (this.type.equals((Object)MetaDataTypeList.WORKFLOW)) {
            schema = XSD_WORKFLOW;
        }
        assert (schema != null) : "Cannot found schema define at SchemaChecker " + this.type.toString();
        return schema;
    }
}

