/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLIOException;
import com.kingdee.bos.dao.xml.XMLParseException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class SolutionInfoLoader {
    public static SolutionInfo loadSolution(Context ctx, MetaDataClassLoader clsLoader) throws DataAccessException, IOException {
        IMetaDataPK[] pks = clsLoader.getMDContext().pkIndexs.getMetaDataPKs(MetaDataTypeList.SOLUTION);
        assert (pks != null && pks.length > 0);
        String rsName = null;
        rsName = pks[0].getPackage() == null ? "/" + pks[0].toString() + "." + "solution" : "/" + pks[0].getPackage().replace('.', '/') + '/' + pks[0].getName() + "." + "solution";
        InputStream is = clsLoader.getResourceAsStream(rsName);
        assert (is != null);
        SolutionInfo slnInfo = SolutionInfoLoader.load(ctx, is);
        is.close();
        return slnInfo;
    }

    public static SolutionInfo loadSolution(Context ctx) throws DataAccessException, IOException {
        SolutionInfo slnInfo = null;
        NetFileSource fileSrc = Utils.getMetaDataFileSrc(ctx);
        NetFileFactory fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)fileSrc);
        NetFile slnFile = fileFactory.createNetFile("");
        String fileName = null;
        String[] files = slnFile.list();
        if (files != null) {
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                if (files[i].lastIndexOf(Utils.getMetaDataSuffix(MetaDataTypeList.SOLUTION)) == -1) continue;
                fileName = files[i];
                break;
            }
        }
        if (StringUtils.isEmpty(fileName)) {
            throw new XMLIOException("The metadata path is error! System canot found the solution metadata!");
        }
        slnFile = fileFactory.createNetFile(fileName);
        if (!slnFile.exists()) {
            throw new XMLIOException("The solution file doesn't exist!");
        }
        InputStream is = fileFactory.createNetFileInputStream(slnFile);
        slnInfo = SolutionInfoLoader.load(ctx, is);
        is.close();
        return slnInfo;
    }

    protected static SolutionInfo load(Context ctx, InputStream is) throws DataAccessException {
        try {
            Element root = new SAXBuilder().build(is).getRootElement();
            SolutionInfo slnInfo = new SolutionInfo();
            slnInfo.setName(ctx.getSolution());
            Element langs = root.getChild("languages", root.getNamespace());
            if (langs != null) {
                Element key;
                String defaultName = null;
                Element defaultLang = root.getChild("defaultLang", root.getNamespace());
                if (defaultLang != null && (key = defaultLang.getChild("key", root.getNamespace())) != null) {
                    defaultName = key.getAttributeValue("value");
                }
                for (Element lang : langs.getChildren("language", root.getNamespace())) {
                    LanguageInfo langInfo = new LanguageInfo();
                    langInfo.setName(lang.getChildText("name", root.getNamespace()));
                    langInfo.setPostfix(lang.getChildText("postfix", root.getNamespace()));
                    langInfo.setLocaleString(lang.getChildText("localeString", root.getNamespace()));
                    slnInfo.getLanguages().add(langInfo);
                    if (langInfo.getName() == null || !langInfo.getName().equals(defaultName)) continue;
                    slnInfo.setDefaultLanguage(langInfo);
                }
            } else {
                LanguageInfo langInfo = new LanguageInfo();
                langInfo.setName("chinese");
                langInfo.setPostfix("L1");
                langInfo.setLocaleString("zh_CN");
                slnInfo.getLanguages().add(langInfo);
                slnInfo.setDefaultLanguage(langInfo);
            }
            return slnInfo;
        }
        catch (JDOMException de) {
            throw new XMLParseException(de);
        }
        catch (IOException ioe) {
            throw new XMLIOException(ioe);
        }
    }
}

