/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDPath;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldTemplateSetInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldViewInfo;
import com.kingdee.bos.metadata.bizunit.BizTemplateInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bo.StrategyInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.datax.DataXInfo;
import com.kingdee.bos.metadata.eai.ApplicationInfo;
import com.kingdee.bos.metadata.eai.ApplicationNodeInfo;
import com.kingdee.bos.metadata.eai.IntegrationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.NumericConstraintInfo;
import com.kingdee.bos.metadata.entity.RegexConstraintInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.ScriptConstraintInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.mdquery.MDQueryInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.report.ReportInfo;
import com.kingdee.bos.metadata.resource.BizDataTypeInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.metadata.rule.RuleInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webcomponent.WebComponentObjectInfo;
import com.kingdee.bos.metadata.webcontrol.WebControlObjectInfo;
import com.kingdee.bos.metadata.webmacro.WebMacroInfo;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import com.kingdee.bos.metadata.webrule.WebRuleInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class Utils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.dao.xml.Utils");
    public static final String METADATA_NAMESPACE = "com.kingdee.bos.metadata";
    public static final String RESOURCE = "resource";
    public static final String IMAGE_RESOURCE = "imageresource";
    public static final String PACKAGE = "package";
    public static final String NAME = "name";
    public static final String ALIAS = "alias";
    public static final String VALUE = "value";
    public static final String LOCALE = "locale";
    public static final String XMLNODERELATIONSHIP = "xmlNodeRelationship";
    public static final String PARENT = "parent";
    public static final String THIS = "this";
    public static final String ROOT = "root";
    public static final String METADATAPK = "com.kingdee.bos.metadata.common.MetaDataPK";
    public static final String PROPERTIES = "properties";
    public static final String KEY = "key";
    public static final String RS = "rs";
    public static final String LANG = "lang";
    public static final String SUFFIX_TABLE = "table";
    public static final String SUFFIX_RELATIONSHIP = "relation";
    public static final String SUFFIX_SOLUTION = "solution";
    public static final String SUFFIX_BIZDATATYPE = "bizdatatype";
    public static final String SUFFIX_ENUM = "enum";
    public static final String SUFFIX_EXCEPTION = "exception";
    public static final String SUFFIX_RESOURCE = "resource";
    public static final String SUFFIX_IMAGE_RESOURCE = "imageresource";
    public static final String SUFFIX_QUERY = "query";
    public static final String SUFFIX_FACADE = "facade";
    public static final String SUFFIX_FUNCTION = "function";
    public static final String SUFFIX_RULE = "rule";
    public static final String SUFFIX_UIOBJECT = "ui";
    public static final String SUFFIX_WEBUIOBJECT = "webui";
    public static final String SUFFIX_BIZRULESET = "ruleset";
    public static final String SUFFIX_BIZUNIT = "bizunit";
    public static final String SUFFIX_DATAX = "datax";
    public static final String SUFFIX_BIZTEMPLATE = "biztemplate";
    public static final String SUFFIX_BIZFIELDTEMPLATESET = "bizfieldtemplateset";
    public static final String SUFFIX_REPORT = "report";
    public static final String SUFFIX_ENTITYOBJECT = "entity";
    public static final String SUFFIX_ENTITYDIGRAM = "";
    public static final String SUFFIX_INTEGRATION = "integration";
    public static final String SUFFIX_APPLICATION = "eapp";
    public static final String SUFFIX_APPLICATION_NODE = "appnode";
    public static final String SUFFIX_APPVIEW = "appview";
    public static final String SUFFIX_SERVICE = "service";
    public static final String SUFFIX_WFROLE = "wfrole";
    public static final String SUFFIX_WORKFLOW = "kdwf";
    public static final String SUFFIX_MUTEX = "mutex";
    public static final String SUFFIX_PERMISSION = "permission";
    public static final String SUFFIX_MDQUERY = "mdquery";
    public static final String SUFFIX_LOG = "log";
    public static final String SUFFIX_BOTMAPPING = "botmapping";
    public static final String SUFFIX_PACKAGE = "package";
    public static final String SUFFIX_METADATABRIEFVIEW = "mdbview";
    public static final String SUFFIX_EVENT = "event";
    public static final String SUFFIX_BASETEMPLATEREFSET = "templateset";
    public static final String CLOSED_PROJECT = "closed project";
    private static Map expandPaths = new HashMap(4);
    private static Map mdpID = new HashMap(4);
    public static final String SUFFIX_WEBPAGEOBJECT = "wbpage";
    public static final String SUFFIX_WEBCOMPONENTOBJECT = "wbcom";
    public static final String SUFFIX_WEBCONTROLOBJECT = "wbctl";
    public static final String SUFFIX_WEBRULE = "wbrule";
    public static final String SUFFIX_WEBMACRO = "wbmacro";
    private static Pattern p = Pattern.compile("[Ss][Pp][-]([!#$%&'+-.=@^`~\\w])*[-][Mm][Ee][Tt][Aa][Ss].jar");
    private static final String SPLIT_D = "[;" + File.pathSeparator + "]";
    private static final String[] NULL_PATH = new String[0];

    public static String getMetaDataSuffix(BOSObjectType bosType) {
        if (bosType.equals((Object)MetaDataTypeList.DATATABLE) || bosType.equals((Object)MetaDataTypeList.ABSTRACTTABLE) || bosType.equals((Object)MetaDataTypeList.CROSSTABLE) || bosType.equals((Object)MetaDataTypeList.EXTENDEDTABLE)) {
            return ".table";
        }
        if (bosType.equals((Object)MetaDataTypeList.ENTITY)) {
            return ".entity";
        }
        if (bosType.equals((Object)MetaDataTypeList.RELATIONSHIP)) {
            return ".relation";
        }
        if (bosType.equals((Object)MetaDataTypeList.SOLUTION)) {
            return ".solution";
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZRULESET)) {
            return ".ruleset";
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZUNIT)) {
            return ".bizunit";
        }
        if (bosType.equals((Object)MetaDataTypeList.DATAX)) {
            return ".datax";
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZTEMPLATE)) {
            return ".biztemplate";
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZFIELDTEMPLATESET)) {
            return ".bizfieldtemplateset";
        }
        if (bosType.equals((Object)MetaDataTypeList.REPORT)) {
            return ".report";
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZDATATYPE)) {
            return ".bizdatatype";
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZENUM)) {
            return ".enum";
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZEXCEPTION)) {
            return ".exception";
        }
        if (bosType.equals((Object)MetaDataTypeList.MULTILANGUAGE)) {
            return ".resource";
        }
        if (bosType.equals((Object)MetaDataTypeList.IMAGE_RESOURCE_TYPE)) {
            return ".imageresource";
        }
        if (bosType.equals((Object)MetaDataTypeList.JOINQUERY) || bosType.equals((Object)MetaDataTypeList.BASEQUERY) || bosType.equals((Object)MetaDataTypeList.UNIONQUERY)) {
            return ".query";
        }
        if (bosType.equals((Object)MetaDataTypeList.FACADE)) {
            return ".facade";
        }
        if (bosType.equals((Object)MetaDataTypeList.FUNCTION)) {
            return ".function";
        }
        if (bosType.equals((Object)MetaDataTypeList.RULE)) {
            return ".rule";
        }
        if (bosType.equals((Object)MetaDataTypeList.APPVIEW)) {
            return ".appview";
        }
        if (bosType.equals((Object)MetaDataTypeList.SERVICE)) {
            return ".service";
        }
        if (bosType.equals((Object)MetaDataTypeList.WFROLE)) {
            return ".wfrole";
        }
        if (bosType.equals((Object)MetaDataTypeList.UIOBJECT)) {
            return ".ui";
        }
        if (bosType.equals((Object)MetaDataTypeList.WORKFLOW)) {
            return ".kdwf";
        }
        if (bosType.equals((Object)MetaDataTypeList.MUTEX)) {
            return ".mutex";
        }
        if (bosType.equals((Object)MetaDataTypeList.EVENT_FOR_WF)) {
            return ".event";
        }
        if (bosType.equals((Object)MetaDataTypeList.PERMISSION)) {
            return ".permission";
        }
        if (bosType.equals((Object)MetaDataTypeList.MDQUERY)) {
            return ".mdquery";
        }
        if (bosType.equals((Object)MetaDataTypeList.LOG)) {
            return ".log";
        }
        if (bosType.equals((Object)MetaDataTypeList.INTEGRATION_TYPE)) {
            return ".integration";
        }
        if (bosType.equals((Object)MetaDataTypeList.APPLICATION_TYPE)) {
            return ".eapp";
        }
        if (bosType.equals((Object)MetaDataTypeList.APPLICATION_NODE_TYPE)) {
            return ".appnode";
        }
        if (bosType.equals((Object)MetaDataTypeList.BOTMAPPING)) {
            return ".botmapping";
        }
        if (bosType.equals((Object)MetaDataTypeList.PACKAGE)) {
            return ".package";
        }
        if (bosType.equals((Object)MetaDataTypeList.METADATABRIEFVIEW)) {
            return ".mdbview";
        }
        if (bosType.equals((Object)MetaDataTypeList.BASE_TEMPLATE_REF_SET)) {
            return ".templateset";
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBUIOBJECT)) {
            return ".webui";
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBPAGEOBJECT)) {
            return ".wbpage";
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBCOMPONENTOBJECT)) {
            return ".wbcom";
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBCONTROLOBJECT)) {
            return ".wbctl";
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBRULE)) {
            return ".wbrule";
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBMACRO)) {
            return ".wbmacro";
        }
        return null;
    }

    public static String getBOSTypeBySuffix(String suffix) {
        String noDotSuffix = suffix;
        if (noDotSuffix.startsWith(".")) {
            noDotSuffix = noDotSuffix.substring(1, noDotSuffix.length());
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_TABLE)) {
            return MetaDataTypeList.ABSTRACTTABLE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_ENTITYOBJECT)) {
            return MetaDataTypeList.ENTITY.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_RELATIONSHIP)) {
            return MetaDataTypeList.RELATIONSHIP.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_SOLUTION)) {
            return MetaDataTypeList.SOLUTION.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_BIZDATATYPE)) {
            return MetaDataTypeList.BIZDATATYPE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_ENUM)) {
            return MetaDataTypeList.BIZENUM.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_EXCEPTION)) {
            return MetaDataTypeList.BIZEXCEPTION.toString();
        }
        if (noDotSuffix.equalsIgnoreCase("resource")) {
            return MetaDataTypeList.MULTILANGUAGE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase("imageresource")) {
            return MetaDataTypeList.IMAGE_RESOURCE_TYPE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_QUERY)) {
            return MetaDataTypeList.BASEQUERY.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_FACADE)) {
            return MetaDataTypeList.FACADE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_FUNCTION)) {
            return MetaDataTypeList.FUNCTION.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_RULE)) {
            return MetaDataTypeList.RULE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_APPVIEW)) {
            return MetaDataTypeList.APPVIEW.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_SERVICE)) {
            return MetaDataTypeList.SERVICE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_WFROLE)) {
            return MetaDataTypeList.WFROLE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_UIOBJECT)) {
            return MetaDataTypeList.UIOBJECT.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_WEBUIOBJECT)) {
            return MetaDataTypeList.WEBUIOBJECT.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_INTEGRATION)) {
            return MetaDataTypeList.INTEGRATION_TYPE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_APPLICATION)) {
            return MetaDataTypeList.APPLICATION_TYPE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_APPLICATION_NODE)) {
            return MetaDataTypeList.APPLICATION_NODE_TYPE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_WORKFLOW)) {
            return MetaDataTypeList.WORKFLOW.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_MUTEX)) {
            return MetaDataTypeList.MUTEX.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_EVENT)) {
            return MetaDataTypeList.EVENT_FOR_WF.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_PERMISSION)) {
            return MetaDataTypeList.PERMISSION.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_MDQUERY)) {
            return MetaDataTypeList.MDQUERY.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_LOG)) {
            return MetaDataTypeList.LOG.toString();
        }
        if (noDotSuffix.equalsIgnoreCase("package")) {
            return MetaDataTypeList.PACKAGE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_BOTMAPPING)) {
            return MetaDataTypeList.BOTMAPPING.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_BIZUNIT)) {
            return MetaDataTypeList.BIZUNIT.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_DATAX)) {
            return MetaDataTypeList.DATAX.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_BIZTEMPLATE)) {
            return MetaDataTypeList.BIZTEMPLATE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_BIZFIELDTEMPLATESET)) {
            return MetaDataTypeList.BIZFIELDTEMPLATESET.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_REPORT)) {
            return MetaDataTypeList.REPORT.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_METADATABRIEFVIEW)) {
            return MetaDataTypeList.METADATABRIEFVIEW.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_BASETEMPLATEREFSET)) {
            return MetaDataTypeList.BASE_TEMPLATE_REF_SET.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_BIZRULESET)) {
            return MetaDataTypeList.BIZRULESET.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_BIZUNIT)) {
            return MetaDataTypeList.BIZUNIT.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_BIZTEMPLATE)) {
            return MetaDataTypeList.BIZTEMPLATE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_WEBPAGEOBJECT)) {
            return MetaDataTypeList.WEBPAGEOBJECT.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_WEBCOMPONENTOBJECT)) {
            return MetaDataTypeList.WEBCOMPONENTOBJECT.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_WEBCONTROLOBJECT)) {
            return MetaDataTypeList.WEBCONTROLOBJECT.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_WEBRULE)) {
            return MetaDataTypeList.WEBRULE.toString();
        }
        if (noDotSuffix.equalsIgnoreCase(SUFFIX_WEBMACRO)) {
            return MetaDataTypeList.WEBMACRO.toString();
        }
        return null;
    }

    public static String getMetadataSrc(Context ctx) {
        String tempMetadataPath = null;
        tempMetadataPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("metadata.path");
            }
        });
        if (!(tempMetadataPath != null && tempMetadataPath.length() != 0 || (tempMetadataPath = (String)ctx.get((Object)"METADATAPATH")) != null && tempMetadataPath.length() != 0)) {
            try {
                SolutionDeployInfo slnDeployInfo = DeployInfoManagerFactory.getDeployInfoManager().getSolutionDeployInfo(ctx.getSolution());
                if (slnDeployInfo != null) {
                    tempMetadataPath = slnDeployInfo.getMetaDataPath();
                }
            }
            catch (Exception slnDeployInfo) {
                // empty catch block
            }
            if (tempMetadataPath == null || tempMetadataPath.length() == 0) {
                try {
                    File dir = new File("metas");
                    if (dir.isDirectory()) {
                        tempMetadataPath = dir.getCanonicalPath();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (tempMetadataPath == null || tempMetadataPath.length() == 0) {
                    logger.error((Object)"Can NOT find metadata path.");
                    return null;
                }
            }
        }
        return Utils.expandPaths(tempMetadataPath);
    }

    public static String expandPaths(String paths) {
        String ep = (String)expandPaths.get(paths);
        if (ep != null) {
            return ep;
        }
        String[] items = paths.split(SPLIT_D);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            buff.append(Utils.expendPath(items[i]));
        }
        ep = buff.toString();
        expandPaths.put(paths, ep);
        return ep;
    }

    private static String expendPath(String path) {
        if (path == null || path.length() == 0 || path.indexOf("configure") >= 0) {
            return SUFFIX_ENTITYDIGRAM;
        }
        int pos = path.indexOf("*");
        if (pos == -1) {
            File testFile = new File(path);
            if (testFile.exists()) {
                try {
                    return testFile.getCanonicalPath() + File.pathSeparator;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            logger.warn((Object)(testFile + " not exists!"));
            return SUFFIX_ENTITYDIGRAM;
        }
        String dir = path.substring(0, pos);
        final String suffix = path.substring(pos + 1);
        try {
            File fdir = new File(dir);
            StringBuffer bf = new StringBuffer();
            File[] files = fdir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(suffix);
                }
            });
            if (files == null) {
                logger.warn((Object)(dir + " has't " + suffix));
                return SUFFIX_ENTITYDIGRAM;
            }
            ArrayList<File> spJarFiles = new ArrayList<File>();
            ArrayList<File> normalJarFiles = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                if (Utils.isSpJarFile(files[i])) {
                    spJarFiles.add(files[i]);
                    continue;
                }
                normalJarFiles.add(files[i]);
            }
            Comparator fileTimeStampComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    long l2;
                    if (o1 == o2) {
                        return 0;
                    }
                    long l1 = ((File)o1).lastModified();
                    if (l1 > (l2 = ((File)o2).lastModified())) {
                        return -1;
                    }
                    if (l1 == l2) {
                        return 0;
                    }
                    return 1;
                }
            };
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            try {
                Collections.sort(spJarFiles, fileTimeStampComparator);
                Collections.sort(normalJarFiles, fileTimeStampComparator);
            }
            catch (Throwable e) {
                logger.error((Object)"\u8fd9\u4e2a\u5f02\u5e38\u53ef\u80fd\u5f71\u54cd\u5305\u7684\u52a0\u8f7d\u987a\u5e8f", e);
            }
            Iterator iter = spJarFiles.iterator();
            while (iter.hasNext()) {
                bf.append(((File)iter.next()).getCanonicalPath());
                bf.append(";");
            }
            iter = normalJarFiles.iterator();
            while (iter.hasNext()) {
                bf.append(((File)iter.next()).getCanonicalPath());
                bf.append(";");
            }
            return bf.toString();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return SUFFIX_ENTITYDIGRAM;
        }
    }

    private static boolean isSpJarFile(File file) {
        return p.matcher(file.getName()).matches();
    }

    public static MDPath getMetadataSrcAndPath(Context ctx) {
        String src = Utils.getMetadataSrc(ctx);
        String[] path = NULL_PATH;
        if (src != null) {
            path = src.split(SPLIT_D);
        }
        return new MDPath(src, path);
    }

    public static String[] getMetadataPath(Context ctx) {
        String expandPath = Utils.getMetadataSrc(ctx);
        if (expandPath != null) {
            return expandPath.split(SPLIT_D);
        }
        return NULL_PATH;
    }

    public static NetFileSource getMetaDataFileSrc(Context ctx) {
        String[] userDir = Utils.getMetadataPath(ctx);
        try {
            return new NetFileSource(new File(userDir[0]).toURL().toString());
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new Error("Invalidate NetFileSource: " + userDir[0]);
        }
    }

    public static NetFileSource getMetaDataFileSrcWithExist(Context ctx, String fileName) {
        String[] userDir = Utils.getMetadataPath(ctx);
        for (int i = 0; i < userDir.length; ++i) {
            File file = new File(userDir[i] + File.separator + fileName);
            if (!file.exists()) continue;
            try {
                return new NetFileSource(new File(userDir[i]).toURL().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getMetaDataPathIdentifier(Context ctx) {
        String path = SUFFIX_ENTITYDIGRAM;
        String expandPath = Utils.getMetadataSrc(ctx);
        if (expandPath == null) {
            return path;
        }
        path = (String)mdpID.get(expandPath);
        if (path != null) {
            return path;
        }
        path = SUFFIX_ENTITYDIGRAM;
        String[] userDir = expandPath.split(SPLIT_D);
        for (int i = 0; i < userDir.length; ++i) {
            NetFileSource nfSrc = null;
            try {
                nfSrc = new NetFileSource(new File(userDir[i]).toURL().toString());
            }
            catch (Throwable e) {
                throw new Error("Invalidate NetFileSource: " + userDir[i], e);
            }
            path = path + ";" + nfSrc.getFileSourceIdentifier();
        }
        mdpID.put(expandPath, path);
        return path;
    }

    public static InputStream getObjectInputStream(NetFileSource fileSrc, BOSObjectType type, IObjectPK pk) throws FileNotFoundException {
        NetFile file = Utils.getNetFile(fileSrc, type, pk);
        NetFileFactory fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)fileSrc);
        InputStream is = null;
        if (file.exists()) {
            is = fileFactory.createNetFileInputStream(file);
        }
        return is;
    }

    public static NetFile getNetFile(NetFileSource fileSrc, BOSObjectType type, IObjectPK pk) {
        String suffix = Utils.getMetaDataSuffix(type);
        MetaDataPK filePK = null;
        filePK = pk instanceof MetaDataPK ? (MetaDataPK)pk : MetaDataPK.create(SUFFIX_ENTITYDIGRAM, pk.toString());
        NetFileFactory fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)fileSrc);
        NetFile file = fileFactory.createNetFile(filePK.toString() + suffix);
        return file;
    }

    public static URL getNetFileURL(NetFileSource fileSrc, BOSObjectType type, IObjectPK pk) {
        NetFile file = Utils.getNetFile(fileSrc, type, pk);
        try {
            return file.toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IObjectValue createInfo(BOSObjectType bosType) {
        if (bosType.equals((Object)MetaDataTypeList.DATATABLE)) {
            return new DataTableInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.EXTENDEDTABLE)) {
            return new ExtendedTableInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZEXCEPTION)) {
            return new BizExceptionInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.ENTITY)) {
            return new EntityObjectInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.MDQUERY)) {
            return new MDQueryInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.REGEX_CONSTRAINT)) {
            return new RegexConstraintInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.NUMERIC_CONSTRAINT)) {
            return new NumericConstraintInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.SCRIPT_CONSTRAINT)) {
            return new ScriptConstraintInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.RELATIONSHIP)) {
            return new RelationshipInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.FACADE)) {
            return new FacadeInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.UIOBJECT)) {
            return new UIObjectInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.FUNCTION)) {
            return new FunctionObjectInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBUIOBJECT)) {
            return new WebUIObjectInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZRULESET)) {
            return new RuleSetInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZUNIT)) {
            return new BizUnitInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZTEMPLATE)) {
            return new BizTemplateInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.DATAX)) {
            return new DataXInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZFIELDTEMPLATESET)) {
            return new BizFieldTemplateSetInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZFIELD)) {
            return new BizFieldInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZFIELDVIEW)) {
            return new BizFieldViewInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.REPORT)) {
            return new ReportInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.STRATEGY)) {
            return new StrategyInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.RULE)) {
            return new RuleInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.FILTER)) {
            return new QueryFilterInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZENUM)) {
            return new BizEnumInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.BIZDATATYPE)) {
            return new BizDataTypeInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.JOINQUERY)) {
            return new JoinQueryInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.INTEGRATION_TYPE)) {
            return new IntegrationInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.APPLICATION_TYPE)) {
            return new ApplicationInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.APPLICATION_NODE_TYPE)) {
            return new ApplicationNodeInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBPAGEOBJECT)) {
            return new WebPageObjectInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBCOMPONENTOBJECT)) {
            return new WebComponentObjectInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBCONTROLOBJECT)) {
            return new WebControlObjectInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBRULE)) {
            return new WebRuleInfo();
        }
        if (bosType.equals((Object)MetaDataTypeList.WEBMACRO)) {
            return new WebMacroInfo();
        }
        logger.warn((Object)("not initial bosType----------" + bosType));
        return null;
    }

    public static void dump(IObjectValue ov) {
        HashMap map = new HashMap();
        StringBuffer sb = new StringBuffer();
        Utils.dump(ov, map, 0, sb);
    }

    private static void dump(IObjectValue ov, HashMap map, int level, StringBuffer sb) {
        if (map.containsKey(ov)) {
            sb.append(Utils.dump(level) + "Ref: ");
            Utils.dump(ov, level);
            return;
        }
        sb.append(Utils.dump(level));
        Utils.dump(ov, level);
        map.put(ov, 0);
        Enumeration keys = ov.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            Object o = ov.get(key);
            if (o instanceof IObjectValue) {
                logger.info((Object)(Utils.dump(level) + "ObjectValue: " + key));
                Utils.dump(ov, map, level + 1, sb);
            }
            if (!(o instanceof IObjectCollection)) continue;
            logger.info((Object)(Utils.dump(level) + "ObjectCollection: " + key));
            IObjectCollection oc = (IObjectCollection)o;
            int n = oc.size();
            for (int i = 0; i < n; ++i) {
                Utils.dump(oc.getObject(i), map, level + 1, sb);
            }
        }
    }

    private static String dump(int level) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            sb.append("    ");
        }
        return sb.toString();
    }

    private static void dump(IObjectValue ov, int level) {
        StringBuffer sb = new StringBuffer();
        Enumeration enumeration = ov.keys();
        sb.append(Utils.dump(level) + "[");
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Object value = ov.get(key);
            if (value instanceof IObjectValue || value instanceof IObjectCollection) continue;
            sb.append(key + "=" + value + "; ");
        }
        sb.append("]");
        logger.info((Object)sb);
    }

    public static void dumpClassLoader(String name, ClassLoader loader) {
        logger.info((Object)("before dump classloader :" + name));
        int i = 0;
        ClassLoader tmp = loader;
        while (tmp != null) {
            logger.info((Object)(Utils.dump(i) + tmp));
            tmp = tmp.getParent();
            if (tmp == loader) break;
            ++i;
        }
        logger.info((Object)("after dump classloader :" + name));
    }

    public static Element build(Context ctx, BOSObjectType metaType, IMetaDataPK pk) throws DataAccessException, IOException, JDOMException {
        InputStream is = XMLAccessEngine.getXMLLoader(ctx).loadMetaInputStream(metaType, pk);
        if (is == null) {
            throw new FileNotFoundException(metaType + ":" + pk);
        }
        Element root = new SAXBuilder().build(is).getRootElement();
        is.close();
        return root;
    }

    public static Document buildDoc(Context ctx, BOSObjectType metaType, IMetaDataPK pk) throws DataAccessException, IOException, JDOMException {
        InputStream is = XMLAccessEngine.getXMLLoader(ctx).loadMetaInputStream(metaType, pk);
        if (is == null) {
            throw new FileNotFoundException(metaType + ":" + pk);
        }
        Document root = new SAXBuilder().build(is);
        is.close();
        return root;
    }

    private Utils() {
    }

    public static boolean acceptSuffix(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        int dot = fileName.lastIndexOf(46);
        if (dot < 1) {
            return false;
        }
        String suffix = fileName.substring(dot + 1);
        return suffix.equals(SUFFIX_ENTITYOBJECT) || suffix.equals(SUFFIX_FACADE) || suffix.equals(SUFFIX_UIOBJECT) || suffix.equals(SUFFIX_RELATIONSHIP) || suffix.equals(SUFFIX_ENUM) || suffix.equals(SUFFIX_QUERY) || suffix.equals(SUFFIX_BIZUNIT) || suffix.equals(SUFFIX_APPLICATION) || suffix.equals(SUFFIX_APPLICATION_NODE) || suffix.equals(SUFFIX_APPVIEW) || suffix.equals(SUFFIX_BASETEMPLATEREFSET) || suffix.equals(SUFFIX_BIZDATATYPE) || suffix.equals(SUFFIX_BIZFIELDTEMPLATESET) || suffix.equals(SUFFIX_BIZRULESET) || suffix.equals(SUFFIX_BIZTEMPLATE) || suffix.equals(SUFFIX_BOTMAPPING) || suffix.equals(SUFFIX_DATAX) || suffix.equals(SUFFIX_EVENT) || suffix.equals(SUFFIX_EXCEPTION) || suffix.equals(SUFFIX_FUNCTION) || suffix.equals("imageresource") || suffix.equals(SUFFIX_INTEGRATION) || suffix.equals(SUFFIX_LOG) || suffix.equals(SUFFIX_MDQUERY) || suffix.equals(SUFFIX_METADATABRIEFVIEW) || suffix.equals(SUFFIX_MUTEX) || suffix.equals("package") || suffix.equals(SUFFIX_PERMISSION) || suffix.equals("resource") || suffix.equals(SUFFIX_REPORT) || suffix.equals(SUFFIX_RULE) || suffix.equals(SUFFIX_SERVICE) || suffix.equals(SUFFIX_SOLUTION) || suffix.equals(SUFFIX_TABLE) || suffix.equals(SUFFIX_WEBUIOBJECT) || suffix.equals(SUFFIX_WFROLE) || suffix.equals(SUFFIX_WORKFLOW) || suffix.equals(SUFFIX_WEBPAGEOBJECT) || suffix.equals(SUFFIX_WEBCOMPONENTOBJECT) || suffix.equals(SUFFIX_WEBCONTROLOBJECT);
    }

    public static class SourceAndPath {
        public final String source;
        public final String[] path;

        private SourceAndPath(String source, String[] path) {
            this.source = source;
            this.path = path;
        }
    }
}

