/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.BinaryLoader;
import com.kingdee.bos.dao.xml.RelationManager;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLChecker;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.dao.xml.XMLStore;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.Element;

public final class XMLAccessEngine {
    public static boolean useBinaryMetadata = false;
    private static final Cache<Context, XMLLoader> xmlLoaders = new Cache<Context, XMLLoader>(2, new AbstractProvider<XMLLoader>(){

        @Override
        public XMLLoader getInstance(Context k) {
            return new XMLLoader(k);
        }
    });
    private static final Cache<Context, BinaryLoader> binaryLoaders = new Cache<Context, BinaryLoader>(2, new AbstractProvider<BinaryLoader>(){

        @Override
        public BinaryLoader getInstance(Context k) {
            return new BinaryLoader(k);
        }
    });
    private static final Cache<Context, XMLStore> xmlGenerators = new Cache<Context, XMLStore>(2, new AbstractProvider<XMLStore>(){

        @Override
        public XMLStore getInstance(Context k) throws DataAccessException {
            return new XMLStore(k);
        }
    });
    private static final Cache<Context, XMLChecker> xmlCheckers = new Cache<Context, XMLChecker>(2, new AbstractProvider<XMLChecker>(){

        @Override
        public XMLChecker getInstance(Context k) throws DataAccessException {
            return new XMLChecker(k);
        }
    });
    private static final Cache<Context, RelationManager> relationManagers = new Cache<Context, RelationManager>(2, new AbstractProvider<RelationManager>(){

        @Override
        public RelationManager getInstance(Context k) throws DataAccessException {
            return new RelationManager(k);
        }
    });

    private XMLAccessEngine() {
    }

    public static void clearEngines(Context ctx) {
        XMLLoader loader = xmlLoaders.remove(ctx);
        if (loader != null) {
            loader.close();
        }
        binaryLoaders.remove(ctx);
        xmlGenerators.remove(ctx);
        xmlCheckers.remove(ctx);
    }

    public static void clearEngines() {
        Iterator<XMLLoader> i = xmlLoaders.iterator();
        while (i.hasNext()) {
            i.next().close();
        }
        xmlLoaders.clear();
        binaryLoaders.clear();
        xmlGenerators.clear();
        xmlCheckers.clear();
    }

    public static RelationManager getRelationManager(Context ctx) {
        try {
            return relationManagers.get(ctx);
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public static XMLChecker getXMLChecker(Context ctx) {
        try {
            return xmlCheckers.get(ctx);
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public static XMLLoader getXMLLoader(Context ctx) throws DataAccessException {
        return xmlLoaders.get(ctx);
    }

    public static BinaryLoader getBinaryLoader(Context ctx) throws DataAccessException {
        return binaryLoaders.get(ctx);
    }

    public static XMLStore getXMLStore(Context ctx) throws DataAccessException {
        return xmlGenerators.get(ctx);
    }

    public static EntityObjectInfo loadMeta(Context ctx, IObjectValue ov) throws DataAccessException {
        EntityObjectInfo meta = XMLAccessEngine.getXMLLoader(ctx).loadMeta(ov.getBOSType(), ov);
        meta.trimToSize();
        return meta;
    }

    public static IObjectValue load(Context ctx, BOSObjectType type, IObjectPK pk) throws DataAccessException {
        IObjectValue rtv = null;
        if (useBinaryMetadata) {
            if (MetaDataTypeList.SOLUTION.equals((Object)type)) {
                return XMLAccessEngine.getBinaryLoader(ctx).loadSolution();
            }
            rtv = XMLAccessEngine.getBinaryLoader(ctx).load(type, (IMetaDataPK)pk);
            if (rtv != null) {
                return rtv;
            }
        }
        IObjectValue ov = XMLAccessEngine.getXMLLoader(ctx).load(type, pk);
        ov.trimToSize();
        return ov;
    }

    public static IObjectValue load(Context ctx, BOSObjectType bosType, InputStream is) throws DataAccessException {
        IObjectValue ov = XMLAccessEngine.getXMLLoader(ctx).load(bosType, is);
        ov.trimToSize();
        return ov;
    }

    public static IObjectValue loadMetametaData(Context ctx, IObjectPK pk) throws DataAccessException {
        IObjectValue ov = XMLAccessEngine.getXMLLoader(ctx).loadMetametaData(pk);
        ov.trimToSize();
        return ov;
    }

    public static IObjectValue load(Context ctx, BOSObjectType bosType, Element root) throws DataAccessException {
        IObjectValue ov = XMLAccessEngine.getXMLLoader(ctx).load(bosType, root);
        ov.trimToSize();
        return ov;
    }

    public static void store(Context ctx, BOSObjectType bosType, IObjectValue ov) throws DataAccessException {
        XMLAccessEngine.getXMLStore(ctx).store(bosType, ov);
    }

    public static void update4Mdbview(Context ctx, BOSObjectType bosType, IObjectValue ov) throws DataAccessException {
        XMLAccessEngine.getXMLStore(ctx).update4Mdbview(bosType, ov);
    }

    public static void store(Context ctx, BOSObjectType bosType, IObjectValue ov, OutputStream os) throws DataAccessException {
        XMLAccessEngine.getXMLStore(ctx).store(bosType, ov, os);
    }

    public static Element generate(Context ctx, BOSObjectType bosType, IObjectValue ov) throws DataAccessException {
        return XMLAccessEngine.getXMLStore(ctx).generate(bosType, ov);
    }

    public static Map loadResource(Context ctx, BOSObjectType bosType, IObjectPK pk) throws DataAccessException {
        return XMLAccessEngine.getXMLLoader(ctx).loadResource(bosType, pk);
    }

    public static Map loadResource(Context ctx, InputStream is) throws DataAccessException {
        return XMLAccessEngine.getXMLLoader(ctx).loadResource(is);
    }

    public static void storeResource(Context ctx, BOSObjectType bosType, IObjectPK pk, Map resource) throws DataAccessException {
        XMLAccessEngine.getXMLStore(ctx).storeResource(bosType, pk, (Map<String, Map<String, String>>)resource);
    }

    public static void storeResource(Context ctx, InputStream is, OutputStream os, Map resource) throws DataAccessException {
        XMLAccessEngine.getXMLStore(ctx).storeResource(is, os, (Map<String, Map<String, String>>)resource);
    }

    public static IObjectValue find(Context ctx, BOSObjectType type, IObjectPK pk) throws DataAccessException {
        return XMLAccessEngine.getBinaryLoader(ctx).find(type, (IMetaDataPK)pk);
    }

    public static void redeployMetadata(Context ctx) throws DataAccessException {
        XMLAccessEngine.getBinaryLoader(ctx).refresh();
    }

    private static abstract class AbstractProvider<V>
    implements Provider<Context, V> {
        private AbstractProvider() {
        }

        @Override
        public String trans(Context k) {
            return Utils.getMetaDataPathIdentifier(k);
        }
    }

    private static interface Provider<K, V> {
        public V getInstance(K var1) throws DataAccessException;

        public String trans(K var1);
    }

    private static class Cache<K, V> {
        private final Hashtable<String, V> table;
        private Entry<K, V> last = null;
        private final Provider<K, V> provider;

        Cache(int size, Provider<K, V> p) {
            this.table = new Hashtable(size);
            this.provider = p;
        }

        V get(K key) throws DataAccessException {
            if (this.last != null && this.last.key == key) {
                return this.last.value;
            }
            String k = this.provider.trans(key);
            V v = this.table.get(k);
            if (v != null) {
                this.last = new Entry<K, V>(key, v);
                return v;
            }
            v = this.provider.getInstance(key);
            this.table.put(k, v);
            this.last = new Entry<K, V>(key, v);
            return v;
        }

        V remove(K key) {
            if (this.last != null && this.last.key == key) {
                this.last = null;
            }
            String k = this.provider.trans(key);
            return this.table.remove(k);
        }

        void clear() {
            this.last = null;
            this.table.clear();
        }

        Iterator<V> iterator() {
            return this.table.values().iterator();
        }

        private static final class Entry<K, V> {
            final K key;
            final V value;

            Entry(K key, V value) {
                this.key = key;
                this.value = value;
            }
        }
    }
}

