/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ObjectExistsException;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.IXMLDAO;
import com.kingdee.bos.dao.xml.RelationManager;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.HostType;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.rule.RuleInfo;
import com.kingdee.bos.metadata.rule.RuleUtils;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.bos.service.permission.metadata.BizRefCollection;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;

public class XMLDAO
implements IXMLDAO {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.dao.xml.XMLDAO");
    private final BOSObjectType bosType;
    private final Context ctx;
    private NetFileSource fileSrc;

    public XMLDAO(BOSObjectType bosType, Context ctx) throws DataAccessException {
        this.bosType = bosType;
        this.ctx = ctx;
    }

    @Override
    public void addnew(IObjectPK pk, IObjectValue value) throws DataAccessException {
        value.put("package", pk.getKeyValue("package"));
        value.put("name", pk.getKeyValue("name"));
        this.addnew(value);
    }

    @Override
    public IObjectPK addnew(IObjectValue value) throws DataAccessException {
        MetaDataPK pk = MetaDataPK.create(value.getString("package"), value.getString("name"));
        if (this.exists(pk)) {
            throw new ObjectExistsException("The object " + pk.toString() + " is exist");
        }
        if (this.bosType.equals((Object)MetaDataTypeList.ENTITY) || this.bosType.equals((Object)MetaDataTypeList.FACADE)) {
            XMLDAO.fillBusinessObject((BusinessObjectInfo)value);
        }
        if (this.bosType.equals((Object)MetaDataTypeList.RULE)) {
            XMLDAO.compileRule(this.ctx, (RuleInfo)value);
        }
        if (this.bosType.equals((Object)MetaDataTypeList.PERMISSION)) {
            this.fillPermissionID(this.ctx, (PermissionInfo)value);
        }
        XMLAccessEngine.store(this.ctx, this.bosType, value);
        return pk;
    }

    @Override
    public boolean exists(IObjectPK pk) throws DataAccessException {
        try {
            InputStream is = XMLAccessEngine.getXMLLoader(this.ctx).loadMetaInputStream(this.bosType, pk);
            if (is != null) {
                is.close();
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }

    @Override
    public BOSObjectType getType() {
        return this.bosType;
    }

    @Override
    public IObjectValue getValue(IObjectPK pk) throws DataAccessException {
        try {
            IObjectValue ov = null;
            ov = MDHostType.RUNTIME.isSameType((HostType)this.ctx.get(HostType.class)) ? MetaDataLoaderFactory.getMetaDataLoader(this.ctx).get(this.bosType, (IMetaDataPK)pk) : XMLAccessEngine.load(this.ctx, this.bosType, pk);
            if (this.bosType.equals((Object)MetaDataTypeList.RULE)) {
                XMLDAO.deCompileRule(this.ctx, (RuleInfo)ov);
            }
            return ov;
        }
        catch (DataAccessException e) {
            logger.error((Object)("Load pk[" + pk + "] error."), (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public void delete(IObjectPK pk) throws DataAccessException {
        NetFileFactory fileFactory;
        NetFile file;
        String pgName = (String)pk.getKeyValue("package");
        String name = (String)pk.getKeyValue("name");
        MetaDataPK metaType = MetaDataPK.create(pgName, name);
        if (this.fileSrc == null) {
            this.fileSrc = Utils.getMetaDataFileSrc(this.ctx);
        }
        if (!(file = (fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)this.fileSrc)).createNetFile(((Object)metaType).toString() + Utils.getMetaDataSuffix(this.getType()))).exists()) {
            throw new ObjectNotFoundException("The object " + pk.toString() + " is not exist");
        }
        file.delete();
        if (RelationManager.isEnabled()) {
            XMLAccessEngine.getRelationManager(this.ctx).modelDelete(metaType.getFullName(), this.bosType);
        }
    }

    @Override
    public void update(IObjectPK pk, IObjectValue value) throws DataAccessException {
        if (this.bosType.equals((Object)MetaDataTypeList.ENTITY) || this.bosType.equals((Object)MetaDataTypeList.FACADE)) {
            XMLDAO.fillBusinessObject((BusinessObjectInfo)value);
        }
        if (this.bosType.equals((Object)MetaDataTypeList.RULE)) {
            XMLDAO.compileRule(this.ctx, (RuleInfo)value);
        }
        if (this.bosType.equals((Object)MetaDataTypeList.PERMISSION)) {
            this.fillPermissionID(this.ctx, (PermissionInfo)value);
        }
        XMLAccessEngine.store(this.ctx, this.bosType, value);
    }

    @Override
    public IObjectCollection getCollection() throws DataAccessException {
        return this.getCollection(null);
    }

    @Override
    public IObjectCollection getCollection(String pgName) throws DataAccessException {
        EntityObjectInfo entityInfo = XMLAccessEngine.getXMLLoader(this.ctx).loadMeta(this.getType());
        String ocClass = entityInfo.getObjectCollectionClass();
        IObjectCollection oc = null;
        try {
            oc = (IObjectCollection)Class.forName(ocClass).newInstance();
        }
        catch (Exception e) {
            throw new InvalidDAOMetaDataException("Cannot load class " + ocClass);
        }
        IObjectPK[] pks = this.getPKList(pgName);
        if (pks == null) {
            return oc;
        }
        for (int i = 0; i < pks.length; ++i) {
            IObjectValue temp = this.getValue(pks[i]);
            oc.addObject(temp);
        }
        return oc;
    }

    @Override
    public IObjectPK[] getPKList() throws DataAccessException {
        return this.getPKList(null);
    }

    @Override
    public IObjectPK[] getPKList(String pgName) throws DataAccessException {
        return this.getPKList(Utils.getMetaDataSuffix(this.getType()), pgName);
    }

    private IObjectPK[] getPKList(String suffix, String pgName) throws DataAccessException {
        return XMLAccessEngine.getXMLLoader((Context)this.ctx).getMetaDataClassLoader().getMDContext().pkIndexs.getMetaDataPKs(BOSObjectType.create((String)Utils.getBOSTypeBySuffix(suffix)), pgName);
    }

    @Override
    public void loadMetametaData(IObjectPK pk) throws DataAccessException {
        if (MDHostType.RUNTIME.isSameType((HostType)this.ctx.get(HostType.class))) {
            XMLAccessEngine.loadMetametaData(this.ctx, pk);
        } else {
            XMLAccessEngine.loadMetametaData(this.ctx, pk);
        }
    }

    @Override
    public Map loadResource(IObjectPK pk) throws DataAccessException {
        return XMLAccessEngine.loadResource(this.ctx, this.getType(), pk);
    }

    @Override
    public Map loadResource(InputStream is) throws DataAccessException {
        return XMLAccessEngine.loadResource(this.ctx, is);
    }

    @Override
    public void storeResource(IObjectPK pk, Map resource) throws DataAccessException {
        XMLAccessEngine.storeResource(this.ctx, this.getType(), pk, resource);
    }

    @Override
    public void storeResource(IObjectValue metadata, Map resources) throws DataAccessException {
        MetaDataPK pk = MetaDataPK.create(metadata.getString("package"), metadata.getString("name"));
        XMLAccessEngine.storeResource(this.ctx, this.getType(), pk, resources);
    }

    @Override
    public void storeResource(InputStream is, OutputStream os, Map hash) throws DataAccessException {
        XMLAccessEngine.storeResource(this.ctx, is, os, hash);
    }

    @Override
    public void check(IObjectPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), pk, filter, report, os);
    }

    @Override
    public void check(IObjectPK pk, CheckReportFilter filter, ICheckReport report) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), pk, filter, report);
    }

    @Override
    public void check(IObjectPK pk, CheckReportFilter filter, OutputStream os) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), pk, filter, os);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report, OutputStream os) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), ui, filter, report, os);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), ui, filter, report);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, OutputStream os) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), ui, filter, os);
    }

    @Override
    public IObjectValue load(InputStream is) throws DataAccessException {
        IObjectValue ov = XMLAccessEngine.getXMLLoader(this.ctx).load(this.getType(), is);
        if (this.bosType.equals((Object)MetaDataTypeList.RULE)) {
            XMLDAO.deCompileRule(this.ctx, (RuleInfo)ov);
        }
        return ov;
    }

    @Override
    public void store(IObjectValue ov, OutputStream os) throws DataAccessException {
        if (this.bosType.equals((Object)MetaDataTypeList.ENTITY) || this.bosType.equals((Object)MetaDataTypeList.FACADE)) {
            XMLDAO.fillBusinessObject((BusinessObjectInfo)ov);
        }
        if (this.bosType.equals((Object)MetaDataTypeList.RULE)) {
            XMLDAO.compileRule(this.ctx, (RuleInfo)ov);
        }
        if (this.bosType.equals((Object)MetaDataTypeList.PERMISSION)) {
            this.fillPermissionID(this.ctx, (PermissionInfo)ov);
        }
        XMLAccessEngine.getXMLStore(this.ctx).store(ov.getBOSType(), ov, os);
    }

    public static void compileRule(Context ctx, RuleInfo rule) {
        RuleUtils.translate(ctx, rule);
    }

    public static void deCompileRule(Context ctx, RuleInfo rule) {
    }

    public static void clearCache(Context ctx, BOSObjectType bosType) throws DataAccessException {
        XMLAccessEngine.getXMLLoader(ctx).clearCacheByType(bosType);
        if (MDHostType.RUNTIME.isSameType((HostType)ctx.get(HostType.class))) {
            MetaDataLoaderFactory.getMetaDataLoader(ctx).clear(bosType);
        }
    }

    public static void clearCache(Context ctx, BOSObjectType bosType, MetaDataPK pk) throws DataAccessException {
        XMLAccessEngine.getXMLLoader(ctx).clearCacheByPK(bosType, pk);
        if (MDHostType.RUNTIME.isSameType((HostType)ctx.get(HostType.class))) {
            MetaDataLoaderFactory.getMetaDataLoader(ctx).clear(bosType, pk);
        }
    }

    public static boolean existInCache(Context ctx, BOSObjectType bosType, MetaDataPK pk) throws DataAccessException {
        return XMLAccessEngine.getXMLLoader(ctx).existInCache(bosType, pk);
    }

    public static void fillBusinessObject(BusinessObjectInfo bo) {
        if (bo.getType() == null) {
            int hash = bo.getRealFullName().hashCode();
            String type = Integer.toHexString(hash).toUpperCase();
            if (type.length() > 8) {
                type = type.substring(0, 8);
            } else if (type.length() < 8) {
                int n = type.length();
                for (int i = 0; i < 8 - n; ++i) {
                    type = "0" + type;
                }
            }
            bo.setType(BOSObjectType.create((String)type));
        }
        int n = bo.getMethods().size();
        MethodInfo method = null;
        for (int i = 0; i < n; ++i) {
            method = bo.getMethods().get(i);
            if (method.getString("innerID") != null) continue;
            method.setString("innerID", Uuid.create().toString());
        }
    }

    protected void fillPermissionID(Context ctx, PermissionInfo ov) {
        PermissionItemCollection its = ov.getPermissionItems();
        for (int i = 0; i < its.size(); ++i) {
            PermissionItemInfo pm = its.get(i);
            BizRefCollection brs = pm.getBizRefs();
            for (int j = 0; j < brs.size(); ++j) {
                BizRefInfo br = brs.get(j);
                if (!StringUtils.isEmpty((String)br.getString("id"))) continue;
                br.setString("id", Uuid.create().toString());
            }
        }
    }

    public void update4Mdbview(IObjectValue value) throws DataAccessException {
        if (this.bosType.equals((Object)MetaDataTypeList.METADATABRIEFVIEW)) {
            XMLAccessEngine.update4Mdbview(this.ctx, this.bosType, value);
        }
    }
}

