/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.xml.CoreMetaLoader;
import com.kingdee.bos.dao.xml.NoCachedMetaData;
import com.kingdee.bos.dao.xml.RelationManager;
import com.kingdee.bos.dao.xml.SolutionInfoLoader;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.XMLIOException;
import com.kingdee.bos.dao.xml.XMLParseException;
import com.kingdee.bos.dao.xml.XMLStore;
import com.kingdee.bos.dao.xml.impl.MetadataResourceLoader;
import com.kingdee.bos.metadata.HostType;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class XMLLoader {
    public static final boolean DEBUG = false;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.dao.xml.XMLLoader");
    private final MetaDataClassLoader metaDataSrc;
    private final Map<String, IObjectValue> coreMetas = CoreMetaLoader.getCoreMetas();
    public Map<String, IObjectValue> metas = new HashMap<String, IObjectValue>();
    private final Map<String, Map<String, IObjectValue>> caches = new HashMap<String, Map<String, IObjectValue>>();
    private Context ctx;
    private SolutionInfo slnInfo = null;
    private Locale[] locales;
    public static int ovCounter = 0;
    public static int ocCounter = 0;
    private static final String SPLIT_D = "[;" + File.pathSeparator + "]";

    public Context getContext() {
        return this.ctx;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public XMLLoader(Context ctx) {
        this.ctx = ctx;
        if (MDHostType.SPECIFY_METAMETA.isSameType((HostType)this.ctx.get(HostType.class))) {
            String path = (String)ctx.get((Object)"METADATAPATH");
            this.metaDataSrc = new MetadataResourceLoader(path.split(SPLIT_D));
        } else {
            this.metaDataSrc = new MetaDataClassLoader(Utils.getMetadataPath(ctx));
        }
    }

    public XMLLoader(Context ctx, String[] paths) {
        this.ctx = ctx;
        this.metaDataSrc = MDHostType.SPECIFY_METAMETA.isSameType((HostType)this.ctx.get(HostType.class)) ? new MetadataResourceLoader(paths) : new MetaDataClassLoader(paths);
    }

    public XMLLoader(Context ctx, MetaDataClassLoader cl) {
        this.ctx = ctx;
        this.metaDataSrc = cl;
    }

    public IObjectValue load(String bosType, IObjectPK pk) throws DataAccessException {
        return this.load(BOSObjectType.create((String)bosType), pk, false);
    }

    public IObjectValue loadMetametaData(IObjectPK pk) throws DataAccessException {
        return this.load(MetaDataTypeList.ENTITY, pk, true);
    }

    public IObjectValue load(BOSObjectType bosType, IObjectPK pk) throws DataAccessException {
        return this.load(bosType, pk, false);
    }

    public IObjectValue load(BOSObjectType bosType, InputStream is) throws DataAccessException {
        return this.load(bosType, is, false);
    }

    public IObjectValue load(BOSObjectType bosType, Element root) throws DataAccessException {
        return this.load(bosType, root, false);
    }

    private IObjectValue load(BOSObjectType bosType, IObjectPK pk, boolean isMeta) throws DataAccessException {
        IObjectValue ov = this.getObjectInCache(bosType, (IMetaDataPK)pk);
        if (ov != null) {
            return ov;
        }
        try {
            InputStream is = this.loadMetaInputStream(bosType, pk);
            ov = this.load(bosType, is, isMeta);
            is.close();
            if (isMeta) {
                if (ov instanceof EntityObjectInfo) {
                    this.putObjectInCache(bosType, (IMetaDataPK)pk, ov);
                    this.metas.put(((EntityObjectInfo)ov).getType().toString(), ov);
                    logger.debug((Object)("put metametadata in cache [" + pk.toString() + "]"));
                }
            } else if (MetaDataTypeList.SOLUTION.equals((Object)bosType)) {
                String ver1 = ((SolutionInfo)ov).getMetaVersion();
                String ver2 = this.metaDataSrc.getMDContext().metaVersion;
                if (!StringUtils.isEmpty((String)ver1)) {
                    if (!ver1.equals(ver2)) {
                        throw new IncompatibleClassChangeError("The MetaMetadata Version[" + ver2 + "] can NOT Parse the Metadata Version[" + ver1 + "]");
                    }
                } else {
                    ((SolutionInfo)ov).setMetaVersion(ver2);
                }
            }
            return ov;
        }
        catch (IOException fofe) {
            if (!MetaDataTypeList.UIOBJECT.equals((Object)bosType)) {
                logger.error((Object)"ERROR", (Throwable)fofe);
            }
            throw new XMLIOException(fofe);
        }
    }

    public InputStream loadMetaInputStream(BOSObjectType bosType, IObjectPK pk) throws FileNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("load(" + bosType + ", " + pk + ")"));
        }
        String suffix = Utils.getMetaDataSuffix(bosType);
        MetaDataPK filePK = null;
        filePK = pk instanceof MetaDataPK ? (MetaDataPK)pk : MetaDataPK.create("", pk.toString());
        String rsName = null;
        rsName = StringUtils.isEmpty((String)filePK.getPackage()) ? "/" + filePK.toString() + suffix : "/" + filePK.getPackage().replace('.', '/') + '/' + filePK.getName() + suffix;
        InputStream is = this.metaDataSrc.getResourceAsStream(rsName);
        if (is == null) {
            throw new FileNotFoundException("Cannot load metadata[" + rsName + "] type[" + bosType + "]");
        }
        return is;
    }

    private IObjectValue load(BOSObjectType bosType, InputStream is, boolean isMeta) throws DataAccessException {
        try {
            if (is == null) {
                throw new ObjectNotFoundException("Cannot found metadata!");
            }
            Element root = XMLParser.parseXML((InputStream)is).getRootElement();
            is.close();
            IObjectValue ov = this.load(bosType, root, isMeta);
            ov.setDefaultLocale(this.getContext().getLocale());
            if (!isMeta && RelationManager.isNeedInit()) {
                XMLAccessEngine.getRelationManager(this.ctx).modelLoad(ov);
            }
            return ov;
        }
        catch (JDOMException de) {
            logger.error((Object)("Param: bostype=" + bosType + ", isMeta=" + isMeta));
            logger.error((Object)"JDOM", (Throwable)de);
            throw new XMLParseException(de);
        }
        catch (IOException ioe) {
            logger.error((Object)"IOException", (Throwable)ioe);
            throw new XMLIOException(ioe);
        }
    }

    private synchronized IObjectValue load(BOSObjectType bosType, Element root, boolean isMeta) throws DataAccessException {
        Element rs = root.getChild("resource", root.getNamespace());
        Map<String, Map<String, String>> resource = this.getResource(rs);
        Map<String, Map<String, Map<String, String>>> extResource = this.getExtendedPropertyResource(resource);
        IObjectValue ov = this.load(bosType, root, resource, extResource, true, isMeta);
        ov.setDefaultLocale(this.getContext().getLocale());
        return ov;
    }

    private IObjectValue load(BOSObjectType bosType, Element root, Map<String, Map<String, String>> resource, Map<String, Map<String, Map<String, String>>> extResource, boolean isCache, boolean isMeta) throws DataAccessException {
        return this.load(null, null, null, bosType, root, resource, extResource, isCache, isMeta);
    }

    private IObjectValue load(IObjectValue parent, String name, IObjectCollection oc, BOSObjectType bosType, Element root, Map<String, Map<String, String>> resource, Map<String, Map<String, Map<String, String>>> extResource, boolean isCache, boolean isMeta) throws DataAccessException {
        IObjectValue ov;
        IObjectValue tmp;
        EntityObjectInfo entity;
        block13: {
            entity = this.loadMeta(bosType, root.getName());
            String objValueClass = entity.getObjectValueClass();
            tmp = null;
            ov = null;
            try {
                tmp = (IObjectValue)Class.forName(objValueClass).newInstance();
            }
            catch (Throwable e) {
                logger.error((Object)("Cannot load class :" + objValueClass), e);
                if ($assertionsDisabled) break block13;
                throw new AssertionError((Object)("Cannot load class :" + objValueClass));
            }
        }
        String suffix = null;
        Object pk = null;
        try {
            suffix = Utils.getMetaDataSuffix(entity.getType());
            LogicalKeyInfo logicKey = entity.getLogicalKey();
            if (logicKey.getKeyClass().equals("com.kingdee.bos.metadata.common.MetaDataPK")) {
                pk = MetaDataPK.create(root.getChildText("package", root.getNamespace()), root.getChildText("name", root.getNamespace()));
            } else {
                String temp = "";
                Iterator it = logicKey.getKeyPropertys().iterator();
                PropertyInfo prop = null;
                while (it.hasNext()) {
                    prop = (PropertyInfo)it.next();
                    temp = temp + root.getChildText(prop.getName(), root.getNamespace());
                }
                pk = MetaDataPK.create(null, temp);
            }
            ov = this.getObjectInCache(suffix, (IMetaDataPK)pk);
            if (ov != null && !NoCachedMetaData.contains(entity.getType())) {
                ov.clear();
            } else {
                ov = tmp;
            }
            ov.setDefaultLocale(this.getContext().getLocale());
            if (parent != null) {
                parent.put(name, ov);
            }
            if (isCache) {
                this.putObjectInCache(suffix, (IMetaDataPK)pk, ov);
            }
            if (oc != null) {
                oc.addObject(ov);
            }
            this.load(entity, ov, root, isMeta, resource, extResource);
        }
        catch (Exception e) {
            Map<String, IObjectValue> entries;
            logger.error((Object)"Exception", (Throwable)e);
            if (isCache && (entries = this.caches.get(suffix)) != null) {
                entries.remove(pk.toString().toLowerCase());
            }
            throw new ObjectNotFoundException("Cannot load bosType " + bosType + ", pk " + pk);
        }
        ov.setDefaultLocale(this.getContext().getLocale());
        ov.trimToSize();
        return ov;
    }

    private void load(EntityObjectInfo entity, IObjectValue ov, Element root, boolean isMeta, Map<String, Map<String, String>> resource, Map<String, Map<String, Map<String, String>>> extResource) throws DataAccessException {
        OwnPropertyInfo extendedProp = new OwnPropertyInfo();
        extendedProp.setName("extendedProperty");
        extendedProp.setDataType(DataType.STRING);
        if (root != null) {
            this.processOwnProperty(ov, extendedProp, root, resource, extResource);
        }
        PropertyCollection properties = entity.getInheritedPropertiesRuntime();
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            PropertyInfo prop = (PropertyInfo)it.next();
            if (prop instanceof OwnPropertyInfo) {
                this.processOwnProperty(ov, (OwnPropertyInfo)prop, root, resource, extResource);
                continue;
            }
            if (prop instanceof LinkPropertyInfo) {
                this.processLinkProperty(ov, (LinkPropertyInfo)prop, root, isMeta, resource, extResource);
                continue;
            }
            throw new InvalidDAOMetaDataException("Invalidate Property type" + prop.getClass().toString());
        }
    }

    private void processOwnProperty(IObjectValue ov, OwnPropertyInfo prop, Element root, Map<String, Map<String, String>> resource, Map<String, Map<String, Map<String, String>>> extResource) {
        DataType dataType = prop.getDataType();
        String name = prop.getName();
        String value = null;
        boolean isMultilingual = prop.isMultilingual();
        if (name.equalsIgnoreCase("extendedProperty")) {
            value = XMLStore.getMutlilingualKey(root) + "extendedProperty";
            Map<String, Map<String, String>> etProps = extResource.get(value);
            if (etProps == null) {
                value = XMLStore.getMutlilingualKey2(root) + "extendedProperty";
                etProps = extResource.get(value);
            }
            if (etProps != null) {
                block0: for (String key : etProps.keySet()) {
                    Map<String, String> values = etProps.get(key);
                    Iterator<String> propIt = values.keySet().iterator();
                    boolean extProcessed = false;
                    while (propIt.hasNext()) {
                        String postfix = propIt.next();
                        String extValue = values.get(postfix);
                        if (extProcessed) continue block0;
                        if (extValue == null || extValue.length() == 0 || "null".equalsIgnoreCase(extValue)) continue;
                        ov.setExtendedProperty(key, extValue);
                        extProcessed = true;
                        if (postfix.equalsIgnoreCase(this.getDefalutLocalePostfix())) {
                            ov.setExtendedProperty(key, values.get(postfix));
                            continue;
                        }
                        ov.setExtendedProperty(key, values.get(postfix), LocaleUtils.getLocale((String)postfix));
                    }
                }
            }
            return;
        }
        Element node = root.getChild(name, root.getNamespace());
        if (node != null) {
            value = node.getTextTrim();
        }
        if (value == null || value.length() <= 0) {
            return;
        }
        if (dataType.equals(DataType.BOOLEAN)) {
            ov.setBoolean(name, Boolean.valueOf(value));
        } else if (dataType.equals(DataType.INTEGER)) {
            ov.setInt(name, Integer.valueOf(value));
        } else if (dataType.equals(DataType.STRING)) {
            if (isMultilingual) {
                Map<String, String> map = resource.get(value);
                if (map == null) {
                    return;
                }
                for (String key : map.keySet()) {
                    String tmp = map.get(key);
                    if ("null".equalsIgnoreCase(tmp)) {
                        tmp = null;
                    }
                    ov.put(name, tmp, LocaleUtils.getLocale((String)key));
                }
            } else {
                ov.setString(name, value);
            }
        } else {
            ov.setString(name, value);
        }
    }

    private void processLinkProperty(IObjectValue ov, LinkPropertyInfo prop, Element root, boolean isMeta, Map<String, Map<String, String>> resource, Map<String, Map<String, Map<String, String>>> extResource) throws DataAccessException {
        RelationshipInfo relationship = prop.getRelationship();
        RelationshipType type = relationship.getType();
        CardinalityType supplierCardinality = relationship.getSupplierCardinality();
        Element node = root.getChild(prop.getName(), root.getNamespace());
        boolean isRef = false;
        if (type.equals((Object)RelationshipType.ASSOCIATION)) {
            isRef = true;
        } else if (type.equals((Object)RelationshipType.COMPOSITION)) {
            isRef = false;
        } else {
            throw new InvalidDAOMetaDataException("Unsupported relationship :" + (Object)((Object)type));
        }
        if (supplierCardinality == CardinalityType.ZERO_TO_ONE || supplierCardinality == CardinalityType.ONE) {
            ov.put(prop.getName(), this.processEntity(ov, prop, node, isRef, isMeta, resource, extResource));
        } else if (supplierCardinality.equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || supplierCardinality.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
            this.processCollection(ov, prop, node, isRef, isMeta, resource, extResource);
        } else {
            throw new InvalidDAOMetaDataException("Unsupported supplierCardinality");
        }
    }

    private IObjectValue processEntity(IObjectValue parent, LinkPropertyInfo prop, Element root, boolean isRef, boolean isMeta, Map<String, Map<String, String>> resource, Map<String, Map<String, Map<String, String>>> extResource) throws DataAccessException {
        return this.processEntity(parent, null, prop, root, isRef, isMeta, resource, extResource);
    }

    private IObjectValue processEntity(IObjectValue parent, IObjectCollection oc, LinkPropertyInfo prop, Element root, boolean isRef, boolean isMeta, Map<String, Map<String, String>> resource, Map<String, Map<String, Map<String, String>>> extResource) throws DataAccessException {
        BOSObjectType bosType = prop.getRelationship().getSupplierObject().getType();
        if (root == null) {
            return null;
        }
        String xmlNodeRelationship = prop.getRelationship().getString("xmlNodeRelationship");
        if (isRef) {
            if (StringUtils.isEmpty((String)xmlNodeRelationship)) {
                IMetaDataPK pk = XMLLoader.loadRefObjectPK(prop.getRelationship().getSupplierObject(), root);
                String suffix = Utils.getMetaDataSuffix(bosType);
                Map<String, IObjectValue> entries = this.caches.get(suffix);
                if (entries == null) {
                    try {
                        IObjectValue ov = this.load(bosType, pk, isMeta);
                        if (oc != null) {
                            oc.addObject(ov);
                        }
                        return ov;
                    }
                    catch (Exception e) {
                        IObjectValue ov = this.processEntity(prop.getRelationship().getSupplierObject(), pk);
                        if (oc != null) {
                            oc.addObject(ov);
                        }
                        return ov;
                    }
                }
                IObjectValue ov = entries.get(pk.toString().toLowerCase());
                if (ov == null) {
                    try {
                        ov = this.load(bosType, pk, isMeta);
                        if (oc != null) {
                            oc.addObject(ov);
                        }
                        return ov;
                    }
                    catch (Exception e) {
                        ov = this.processEntity(prop.getRelationship().getSupplierObject(), pk);
                        if (oc != null) {
                            oc.addObject(ov);
                        }
                        return ov;
                    }
                }
                if (oc != null) {
                    oc.addObject(ov);
                }
                return ov;
            }
            IObjectValue ov = this.getRefObject(prop, root, xmlNodeRelationship, isMeta);
            if (oc != null) {
                oc.addObject(ov);
            }
            return ov;
        }
        return this.load(parent, prop.getName(), oc, bosType, root, resource, extResource, false, isMeta);
    }

    private IObjectValue processEntity(EntityObjectInfo meta, IMetaDataPK pk) {
        IObjectValue temp;
        String[] fields;
        block3: {
            fields = pk.getKeyFields();
            temp = null;
            try {
                temp = (IObjectValue)Class.forName(meta.getObjectValueClass()).newInstance();
            }
            catch (Exception ie) {
                logger.error((Object)("Cannot instance " + meta.getObjectValueClass()), (Throwable)ie);
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("Cannot instance " + meta.getObjectValueClass()));
            }
        }
        for (int i = 0; i < fields.length; ++i) {
            temp.put(fields[i], pk.getKeyValue(fields[i]));
        }
        temp.setString("_state_", "true");
        return temp;
    }

    private void processCollection(IObjectValue parent, LinkPropertyInfo prop, Element root, boolean isRef, boolean isMeta, Map<String, Map<String, String>> resource, Map<String, Map<String, Map<String, String>>> extResource) throws DataAccessException {
        IObjectCollection oc;
        block4: {
            EntityObjectInfo entity = prop.getRelationship().getSupplierObject();
            String objCollectionClass = entity.getObjectCollectionClass();
            oc = null;
            try {
                oc = (IObjectCollection)Class.forName(objCollectionClass).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("Cannot load class " + objCollectionClass), (Throwable)e);
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)("Cannot load class " + objCollectionClass));
            }
        }
        if (root == null || root.getChildren().size() == 0) {
            parent.put(prop.getName(), oc);
            return;
        }
        parent.put(prop.getName(), oc);
        for (Element node : root.getChildren()) {
            this.processEntity(null, oc, prop, node, isRef, isMeta, resource, extResource);
        }
        ((AbstractObjectCollection)oc).updateIndex();
    }

    public EntityObjectInfo loadMeta(BOSObjectType bosType) throws MissingDAOMetaDataException {
        if (this.metas.containsKey(bosType.toString())) {
            return (EntityObjectInfo)this.metas.get(bosType.toString());
        }
        if (this.coreMetas.containsKey(bosType.toString())) {
            return (EntityObjectInfo)this.coreMetas.get(bosType.toString());
        }
        throw new MissingDAOMetaDataException("Cannot found metametadata [" + bosType + "], please load yourself!");
    }

    public EntityObjectInfo loadMeta(BOSObjectType bosType, String nodeName) throws MissingDAOMetaDataException {
        EntityObjectInfo meta = this.loadMeta(bosType);
        if (meta.getName().equalsIgnoreCase(nodeName)) {
            return meta;
        }
        HashMap<String, IObjectValue> allMetas = new HashMap<String, IObjectValue>(this.coreMetas);
        allMetas.putAll(this.metas);
        Iterator it = allMetas.keySet().iterator();
        while (it.hasNext()) {
            meta = (EntityObjectInfo)allMetas.get(it.next());
            if (meta.getType().equals((Object)bosType)) continue;
            EntityObjectInfo temp = null;
            if (!meta.getName().equals(nodeName)) continue;
            temp = meta;
            while (temp.getBaseEntity() != null) {
                if (!(temp = temp.getBaseEntity()).getType().equals((Object)bosType)) continue;
                return meta;
            }
        }
        return this.loadMeta(bosType);
    }

    public EntityObjectInfo loadMeta(BOSObjectType bosType, IObjectValue ov) throws MissingDAOMetaDataException {
        String modelClass;
        if (ov.getBOSType() != null && ov.getBOSType().equals((Object)bosType)) {
            EntityObjectInfo meta = this.loadMeta(bosType);
            if (meta != null) {
                return meta;
            }
            throw new MissingDAOMetaDataException("Can not found meta: [" + bosType + "]");
        }
        EntityObjectInfo meta = this.loadMeta(bosType);
        String ovClass = meta.getObjectValueClass();
        if (ovClass.equalsIgnoreCase(modelClass = ov.getClass().getName())) {
            return meta;
        }
        HashMap<String, IObjectValue> allMetas = new HashMap<String, IObjectValue>(this.coreMetas);
        allMetas.putAll(this.metas);
        Iterator it = allMetas.keySet().iterator();
        while (it.hasNext()) {
            meta = (EntityObjectInfo)allMetas.get(it.next());
            if (meta.getType().equals((Object)bosType)) continue;
            EntityObjectInfo temp = null;
            if (!meta.getObjectValueClass().equals(modelClass)) continue;
            temp = meta;
            while (temp.getBaseEntity() != null) {
                if (!(temp = temp.getBaseEntity()).getType().equals((Object)bosType)) continue;
                return meta;
            }
        }
        throw new MissingDAOMetaDataException("Can not found meta: [" + bosType + "," + modelClass + "]");
    }

    public Map<String, Map<String, String>> loadResource(BOSObjectType bosType, IObjectPK pk) throws XMLIOException, XMLParseException {
        MetaDataPK filePK = null;
        filePK = pk instanceof MetaDataPK ? (MetaDataPK)pk : MetaDataPK.create("", pk.toString());
        try {
            InputStream is = this.loadMetaInputStream(bosType, filePK);
            return this.loadResource(is);
        }
        catch (FileNotFoundException e) {
            throw new XMLIOException(e);
        }
    }

    public Map<String, Map<String, String>> loadResource(InputStream is) throws XMLIOException, XMLParseException {
        try {
            Element root = XMLParser.parseXML((InputStream)is).getRootElement();
            is.close();
            Element rs = root.getChild("resource", root.getNamespace());
            return this.getResource(rs);
        }
        catch (IOException ioe) {
            throw new XMLIOException(ioe);
        }
        catch (JDOMException dome) {
            throw new XMLParseException(dome);
        }
    }

    public MetaDataClassLoader getMetaDataClassLoader() {
        return this.metaDataSrc;
    }

    private SolutionInfo getSolutionInfo() {
        try {
            if (this.slnInfo == null) {
                return SolutionInfoLoader.loadSolution(this.ctx, this.metaDataSrc);
            }
            return this.slnInfo;
        }
        catch (Exception exception) {
            return CoreMetaLoader.getSolutionInfo();
        }
    }

    private Map<String, Map<String, String>> getResource(Element root) {
        HashMap<String, Map<String, String>> resource = new HashMap<String, Map<String, String>>();
        Iterator it = root.getChildren().iterator();
        Element rs = null;
        HashMap<String, String> langs = null;
        Iterator langIt = null;
        String key = null;
        while (it.hasNext()) {
            rs = (Element)it.next();
            key = rs.getAttributeValue("key");
            langs = new HashMap<String, String>(4);
            langIt = rs.getChildren().iterator();
            String locale = null;
            String value = null;
            Element lang = null;
            while (langIt.hasNext()) {
                lang = (Element)langIt.next();
                locale = lang.getAttributeValue("locale");
                value = lang.getAttributeValue("value");
                if (value.equalsIgnoreCase("null")) {
                    value = null;
                }
                if (StringUtils.isEmpty((String)locale)) break;
                langs.put(locale, value);
            }
            resource.put(key, langs);
        }
        return resource;
    }

    private Map<String, Map<String, Map<String, String>>> getExtendedPropertyResource(Map<String, Map<String, String>> resource) {
        HashMap<String, Map<String, Map<String, String>>> extResource = new HashMap<String, Map<String, Map<String, String>>>();
        Iterator<String> it = resource.keySet().iterator();
        String key = null;
        while (it.hasNext()) {
            key = it.next();
            int i = key.indexOf("extendedProperty.");
            if (i == -1) continue;
            String etKey = key.substring(0, i + 16);
            HashMap<String, Map<String, String>> etProps = (HashMap<String, Map<String, String>>)extResource.get(etKey);
            if (etProps == null) {
                etProps = new HashMap<String, Map<String, String>>();
                extResource.put(etKey, etProps);
            }
            Map<String, String> value = resource.get(key);
            etProps.put(key.substring(i + 17, key.length()), value);
            extResource.put(etKey, etProps);
        }
        return extResource;
    }

    static IMetaDataPK loadRefObjectPK(EntityObjectInfo entity, Element root) {
        MetaDataPK metaType = new MetaDataPK();
        LogicalKeyInfo logicalKey = entity.getLogicalKey();
        Iterator it = root.getChildren().iterator();
        Element node = null;
        if (logicalKey.getKeyClass().equalsIgnoreCase("com.kingdee.bos.metadata.common.MetaDataPK")) {
            while (it.hasNext()) {
                node = (Element)it.next();
                metaType.put(node.getAttributeValue("name"), node.getAttributeValue("value"));
            }
        } else {
            String temp = "";
            while (it.hasNext()) {
                node = (Element)it.next();
                temp = temp + node.getAttributeValue("value");
            }
            metaType.put("name", temp);
        }
        return metaType;
    }

    private Element getRootElement(Element node) {
        Element temp = node;
        while (temp.getParentElement() != null) {
            temp = temp.getParentElement();
        }
        return temp;
    }

    private IObjectValue getRefObject(LinkPropertyInfo prop, Element node, String script, boolean isMeta) throws DataAccessException {
        StringTokenizer token = new StringTokenizer(script, "$");
        Element temp = this.getRefObject1(node, token.nextToken());
        IObjectValue ov = null;
        ov = this.getRefObject2(temp, token.nextToken(), isMeta);
        IObjectValue refObj = this.getRefObject4(prop.getRelationship().getSupplierObject(), node, token.nextToken(), ov);
        return refObj;
    }

    private Element getRefObject1(Element node, String script) {
        Element elem = node;
        StringTokenizer token = new StringTokenizer(script, ".");
        String temp = null;
        while (token.hasMoreElements()) {
            temp = token.nextToken();
            elem = temp.equalsIgnoreCase("root") ? this.getRootElement(elem) : (temp.equalsIgnoreCase("parent") ? elem.getParentElement() : elem.getChild(temp, elem.getNamespace()));
            if (elem != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invalidate script " + script));
            }
            return null;
        }
        return elem;
    }

    private IObjectValue getRefObject2(Element node, String script, boolean isMeta) throws DataAccessException {
        String suffix;
        Map<String, IObjectValue> entries;
        String type = script.substring(1, 5);
        BOSObjectType bosType = BOSObjectType.create((String)type);
        EntityObjectInfo entity = this.loadMeta(bosType);
        LogicalKeyInfo logicalKey = entity.getLogicalKey();
        if (node == null) {
            return null;
        }
        IMetaDataPK pk = new MetaDataPK();
        if (logicalKey.getKeyClass().equalsIgnoreCase("com.kingdee.bos.metadata.common.MetaDataPK")) {
            pk = MetaDataPK.create(node.getChildText("package", node.getNamespace()), node.getChildText("name", node.getNamespace()));
            if (pk.toString() == null) {
                pk = XMLLoader.loadRefObjectPK(entity, node);
            }
        } else {
            String temp = "";
            PropertyInfo prop = null;
            Iterator it = logicalKey.getKeyPropertys().iterator();
            while (it.hasNext()) {
                prop = (PropertyInfo)it.next();
                temp = temp + node.getChildText(prop.getName(), node.getNamespace());
            }
            pk = MetaDataPK.create(null, temp);
        }
        if ((entries = this.caches.get(suffix = Utils.getMetaDataSuffix(bosType))) == null) {
            try {
                return this.load(bosType, pk, isMeta);
            }
            catch (Exception e) {
                block16: {
                    if (e instanceof XMLIOException && MetaDataTypeList.UIOBJECT.equals((Object)bosType)) {
                        try {
                            return this.load(MetaDataTypeList.WEBUIOBJECT, pk, isMeta);
                        }
                        catch (Exception e1) {
                            if (!(e1 instanceof XMLIOException) || !MetaDataTypeList.UIOBJECT.equals((Object)bosType)) break block16;
                            try {
                                return this.load(MetaDataTypeList.WEBPAGEOBJECT, pk, isMeta);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                return null;
            }
        }
        IObjectValue ov = entries.get(pk.toString().toLowerCase());
        if (ov == null) {
            try {
                return this.load(bosType, pk, isMeta);
            }
            catch (Exception e) {
                return null;
            }
        }
        return ov;
    }

    private IObjectValue getRefObject4(EntityObjectInfo meta, Element node, String script, IObjectValue refObj) throws MissingDAOMetaDataException {
        StringTokenizer token = new StringTokenizer(script, "/");
        IObjectValue ov = refObj;
        while (token.hasMoreTokens()) {
            String temp = token.nextToken();
            EntityObjectInfo entity = meta;
            if (temp.indexOf(40) != -1) {
                String type = temp.substring(1, 5);
                entity = this.loadMeta(BOSObjectType.create((String)type));
                temp = temp.substring(6, temp.length());
            }
            ov = this.getRefObject3(entity, node, temp, ov);
        }
        return ov;
    }

    private IObjectValue getRefObject3(EntityObjectInfo meta, Element node, String script, IObjectValue refObj) {
        String colName = script.substring(0, script.indexOf(91));
        String key = script.substring(script.indexOf(91) + 1, script.indexOf(93));
        IObjectValue matchObj = null;
        MetaDataPK pk = new MetaDataPK();
        if (node == null) {
            return this.processEntity(meta, pk);
        }
        Element root = null;
        if (key.length() != 0) {
            root = !key.equalsIgnoreCase("this") ? this.getRefObject1(node, key) : node;
        } else {
            if (refObj == null) {
                logger.warn((Object)"RefObject must be loaded first!");
                return this.processEntity(meta, pk);
            }
            matchObj = (IObjectValue)refObj.get(colName);
            if (matchObj != null) {
                return matchObj;
            }
            logger.warn((Object)"Refobject cannot be null!");
            return this.processEntity(meta, pk);
        }
        for (Element elem : root.getChildren()) {
            pk.put(elem.getAttributeValue("name"), elem.getAttributeValue("value"));
        }
        if (pk.getKeyFields()[0] == null) {
            pk = new MetaDataPK();
            int n = meta.getLogicalKey().getKeyPropertys().size();
            for (int i = 0; i < n; ++i) {
                String name = meta.getLogicalKey().getKeyPropertys().get(i).getName();
                String value = root.getChildText(name, root.getNamespace());
                pk.put(name, value);
            }
        }
        if (refObj == null) {
            return this.processEntity(meta, pk);
        }
        IObjectCollection coll = null;
        coll = refObj instanceof EntityObjectInfo && colName.equalsIgnoreCase("properties") ? ((EntityObjectInfo)refObj).getInheritedPropertyFromSelf() : (IObjectCollection)refObj.get(colName);
        if (coll != null) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                IObjectValue temp = (IObjectValue)it.next();
                String[] fields = pk.getKeyFields();
                boolean flag = false;
                for (int i = 0; i < fields.length; ++i) {
                    String name = fields[i];
                    String value = (String)pk.getKeyValue(name);
                    if (!value.equalsIgnoreCase(temp.getString(name))) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
                if (!flag) continue;
                matchObj = temp;
                break;
            }
        }
        if (matchObj == null) {
            return this.processEntity(meta, pk);
        }
        return matchObj;
    }

    void setSolutionInfo(SolutionInfo slnInfo) {
        this.slnInfo = slnInfo;
    }

    public void initLocales(LanguageInfo[] langs) {
        if (langs != null) {
            Locale[] locales = new Locale[langs.length];
            for (int i = 0; i < langs.length; ++i) {
                Locale l = langs[i].getOriginalLocale();
                String pf = langs[i].getPostfix();
                LocaleUtils.getLocale((String)pf);
                LocaleUtils.addShortCode((Locale)l, (String)pf);
                locales[i] = l;
            }
            this.locales = locales;
        }
    }

    void initLocales() {
        LanguageCollection langs = this.getSolutionInfo().getLanguages();
        LanguageInfo[] ls = new LanguageInfo[langs.size()];
        for (int i = 0; i < langs.size(); ++i) {
            ls[i] = langs.get(i);
        }
        this.initLocales(ls);
    }

    public Locale[] getSupportedLocales() {
        if (this.locales != null) {
            return this.locales;
        }
        this.initLocales();
        return this.locales;
    }

    Locale getDefaultLocale() {
        return this.ctx.getOriginLocale();
    }

    String getDefalutLocalePostfix() {
        return LocaleUtils.getLocaleString((Locale)this.getDefaultLocale());
    }

    IObjectValue getObjectInCache(BOSObjectType bosType, IMetaDataPK pk) {
        return this.getObjectInCache(Utils.getMetaDataSuffix(bosType), pk);
    }

    IObjectValue getObjectInCache(String suffix, IMetaDataPK pk) {
        Map<String, IObjectValue> entries = this.caches.get(suffix);
        if (entries == null) {
            return null;
        }
        return entries.get(pk.toString().toLowerCase());
    }

    void putObjectInCache(BOSObjectType bosType, IMetaDataPK pk, IObjectValue ov) {
        this.putObjectInCache(Utils.getMetaDataSuffix(bosType), pk, ov);
    }

    void putObjectInCache(String suffix, IMetaDataPK pk, IObjectValue ov) {
        String pkstr = pk.toString().toLowerCase();
        Map<String, IObjectValue> entries = this.caches.get(suffix);
        if (entries == null) {
            entries = new HashMap<String, IObjectValue>();
            entries.put(pkstr, ov);
            this.caches.put(suffix, entries);
        } else {
            IObjectValue oldOv = entries.get(pkstr);
            if (oldOv == null) {
                entries.put(pkstr, ov);
            } else if (oldOv != ov) {
                oldOv.putAll(ov);
            }
        }
    }

    public void clearCacheByType(BOSObjectType bosType) {
        Map<String, IObjectValue> entries = this.caches.get(Utils.getMetaDataSuffix(bosType));
        if (entries != null) {
            entries.clear();
        }
    }

    public void clearCacheByPK(BOSObjectType bosType, MetaDataPK pk) {
        Map<String, IObjectValue> entries = this.caches.get(Utils.getMetaDataSuffix(bosType));
        if (entries != null) {
            entries.remove(pk.toString().toLowerCase());
        }
    }

    public boolean existInCache(BOSObjectType bosType, MetaDataPK pk) {
        Map<String, IObjectValue> entries = this.caches.get(Utils.getMetaDataSuffix(bosType));
        if (entries != null) {
            return entries.containsKey(pk.toString().toLowerCase());
        }
        return false;
    }

    public IObjectValue findByPK(BOSObjectType bosType, IObjectPK pk) throws DataAccessException {
        InputStream is = null;
        try {
            is = this.loadMetaInputStream(bosType, pk);
        }
        catch (FileNotFoundException e) {
            throw new DataAccessException("get stream error. PK=" + pk, e);
        }
        return this.load(bosType, is, false);
    }

    public synchronized void close() {
        this.metaDataSrc.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

