/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.RelationManager;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.XMLIOException;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.dao.xml.XMLParseException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairCollection;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexCollection;
import com.kingdee.bos.metadata.data.IndexColumnCollection;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnCollection;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.service.log.define.LogBizRefCollection;
import com.kingdee.bos.service.log.define.LogBizRefInfo;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.bos.service.permission.metadata.DependenceCollection;
import com.kingdee.bos.service.permission.metadata.DependenceInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;

public class XMLStore {
    private NetFileFactory fileFactory = null;
    public XMLLoader xmlLoader = null;
    private static JDOMFactory jdfactory = new DefaultJDOMFactory();

    public XMLStore(Context ctx) throws DataAccessException {
        this.fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)Utils.getMetaDataFileSrc(ctx));
        this.xmlLoader = XMLAccessEngine.getXMLLoader(ctx);
    }

    public void store(BOSObjectType bosType, IObjectValue ov) throws DataAccessException {
        String suffix = Utils.getMetaDataSuffix(bosType);
        EntityObjectInfo entity = this.xmlLoader.loadMeta(bosType, ov);
        LogicalKeyInfo logicalKey = entity.getLogicalKey();
        MetaDataPK pk = null;
        if (logicalKey.getKeyClass().equals("com.kingdee.bos.metadata.common.MetaDataPK")) {
            pk = MetaDataPK.create(ov.getString("package"), ov.getString("name"));
        } else {
            String temp = "";
            Iterator it = logicalKey.getKeyPropertys().iterator();
            PropertyInfo prop = null;
            while (it.hasNext()) {
                prop = (PropertyInfo)it.next();
                temp = temp + ov.getString(prop.getName());
            }
            pk = MetaDataPK.create(null, temp);
        }
        try {
            NetFile file = this.fileFactory.createNetFile(((Object)pk).toString() + suffix);
            if (pk.getPackage() != null) {
                String pgPath = pk.getPackage().replace('.', File.separatorChar);
                NetFile temp = this.fileFactory.createNetFile(pgPath);
                temp.mkdirs();
            }
            OutputStream os = this.fileFactory.createNetFileOutputStream(file);
            this.store(bosType, ov, os);
            os.close();
        }
        catch (IOException fe) {
            throw new XMLIOException(fe);
        }
    }

    public void store(BOSObjectType bosType, IObjectValue ov, OutputStream os) throws DataAccessException {
        if (MetaDataTypeList.PERMISSION.equals((Object)bosType)) {
            PermissionInfo per = (PermissionInfo)ov;
            DependenceCollection dc = per.getDependences();
            if (null != dc) {
                for (int i = 0; i < dc.size(); ++i) {
                    DependenceInfo dep = dc.get(i);
                    PermissionItemInfo pii = dep.getReferedItem();
                    if (null == pii) continue;
                    dep.setString("id", pii.getInnerID());
                }
            }
        } else if (MetaDataTypeList.LOG.equals((Object)bosType)) {
            LogInfo log = (LogInfo)ov;
            LogItemCollection logs = log.getLogItems();
            if (null != logs) {
                for (int i = 0; i < logs.size(); ++i) {
                    LogItemInfo logItem = logs.get(i);
                    LogBizRefCollection bizs = logItem.getLogBizRefCollection();
                    if (null == bizs) continue;
                    for (int j = 0; j < bizs.size(); ++j) {
                        LogBizRefInfo biz = bizs.get(j);
                        if (!StringUtils.isEmpty((String)biz.getString("id"))) continue;
                        biz.setString("id", Uuid.create().toString());
                    }
                }
            }
        } else if (MetaDataTypeList.UNIONQUERY.equals((Object)bosType) || MetaDataTypeList.BASEQUERY.equals((Object)bosType)) {
            this.fixQueryLogicalKey(ov);
        } else if (MetaDataTypeList.JOINQUERY.equals((Object)bosType)) {
            this.fixQueryLogicalKey(ov);
            JoinQueryInfo joinQuery = (JoinQueryInfo)ov;
            JoinCollection joins = joinQuery.getJoins();
            if (joins != null) {
                for (int i = 0; i < joins.size(); ++i) {
                    JoinInfo join = joins.get(i);
                    JoinItemCollection joinItems = join.getJoinItems();
                    if (joinItems == null) continue;
                    for (int j = 0; j < joinItems.size(); ++j) {
                        JoinItemInfo item = joinItems.get(j);
                        String name = item.getName();
                        if (name != null && name.length() != 0) continue;
                        item.setName(Uuid.create().toString());
                    }
                }
            }
        } else if (MetaDataTypeList.DATATABLE.equals((Object)bosType) || MetaDataTypeList.EXTENDEDTABLE.equals((Object)bosType) || MetaDataTypeList.CROSSTABLE.equals((Object)bosType) || MetaDataTypeList.ABSTRACTTABLE.equals((Object)bosType)) {
            ForeignKeyCollection fks;
            PKColumnCollection pkcs;
            PrimaryKeyInfo pk;
            AbstractTableInfo table = (AbstractTableInfo)ov;
            IndexCollection indexs = table.getIndexes();
            if (indexs != null) {
                for (int i = 0; i < indexs.size(); ++i) {
                    IndexInfo index = indexs.get(i);
                    IndexColumnCollection ics = index.getIndexColumns();
                    if (ics == null) continue;
                    for (int j = 0; j < ics.size(); ++j) {
                        IndexColumnInfo ic = ics.get(j);
                        ic.setString("indexID", String.valueOf(j));
                    }
                }
            }
            if ((pk = table.getPrimaryKey()) != null && (pkcs = pk.getPKColumns()) != null) {
                for (int i = 0; i < pkcs.size(); ++i) {
                    PKColumnInfo pkc = pkcs.get(i);
                    pkc.setString("indexID", String.valueOf(i));
                }
            }
            if ((fks = table.getForeignKeys()) != null) {
                for (int i = 0; i < fks.size(); ++i) {
                    ForeignKeyInfo fk = fks.get(i);
                    FKColumnPairCollection fkcs = fk.getFKColumnPairs();
                    if (fkcs == null) continue;
                    for (int j = 0; j < fkcs.size(); ++j) {
                        FKColumnPairInfo fkc = fkcs.get(j);
                        fkc.setString("sequence", String.valueOf(j));
                    }
                }
            }
        }
        try {
            Document doc;
            Element root = this.generate(bosType, ov);
            if (RelationManager.isEnabled()) {
                XMLAccessEngine.getRelationManager(this.xmlLoader.getContext()).modelUpdate(ov);
            }
            if ((doc = root.getDocument()) == null) {
                doc = XMLStore.getJDOMFactory().document(root);
            }
            XmlUtils.output(root.getDocument(), os);
            if (!bosType.equals((Object)MetaDataTypeList.UIOBJECT)) {
                this.xmlLoader.putObjectInCache(Utils.getMetaDataSuffix(bosType), (IMetaDataPK)MetaDataPK.create(ov.getString("package"), ov.getString("name")), ov);
            }
        }
        catch (IOException ioe) {
            throw new XMLIOException(ioe);
        }
    }

    private void fixQueryLogicalKey(IObjectValue ov) {
        QueryInfo query = (QueryInfo)ov;
        PropertyUnitCollection propUnits = query.getUnits();
        if (propUnits != null) {
            for (int i = 0; i < propUnits.size(); ++i) {
                PropertyUnitInfo propUnit = propUnits.get(i);
                PropertyRefCollection refs = propUnit.getPropertyRefs();
                if (refs == null) continue;
                for (int j = 0; j < refs.size(); ++j) {
                    PropertyRefInfo prop = refs.get(j);
                    String key = prop.getString("key");
                    if (key != null && key.length() != 0) continue;
                    prop.setString("key", Uuid.create().toString());
                }
            }
        }
    }

    public Element generate(BOSObjectType bosType, IObjectValue ov) throws DataAccessException {
        Hashtable<String, Map<String, String>> resource = new Hashtable<String, Map<String, String>>();
        Element root = this.generate(bosType, ov, resource);
        Element rs = this.getResource(resource);
        root.addContent((Content)rs);
        return root;
    }

    private Element generate(BOSObjectType bosType, IObjectValue ov, Map<String, Map<String, String>> rs) throws DataAccessException {
        EntityObjectInfo entity = this.xmlLoader.loadMeta(bosType, ov);
        Element root = XMLStore.getJDOMFactory().element(entity.getName(), "com.kingdee.bos.metadata");
        this.generate(root, bosType, ov, rs);
        return root;
    }

    private void generate(Element root, BOSObjectType bosType, IObjectValue ov, Map<String, Map<String, String>> rs) throws DataAccessException {
        EntityObjectInfo entity = this.xmlLoader.loadMeta(bosType, ov);
        PropertyCollection props = entity.getInheritedPropertiesRuntime();
        Iterator it = props.iterator();
        while (it.hasNext()) {
            IObjectValue prop = (IObjectValue)it.next();
            if (prop instanceof OwnPropertyInfo) {
                this.generateOwnPropElem(root, (OwnPropertyInfo)prop, ov, rs);
                continue;
            }
            if (prop instanceof LinkPropertyInfo) {
                this.generateLinkPropElem(root, (LinkPropertyInfo)prop, ov, rs);
                continue;
            }
            throw new InvalidDAOMetaDataException("Invalidate property type");
        }
        if (!ov.isExtendedPropertiesEmpty()) {
            OwnPropertyInfo extendedProp = new OwnPropertyInfo();
            extendedProp.setName("extendedProperty");
            extendedProp.setDataType(DataType.STRING);
            this.generateExtendedProps(root, ov, rs);
        }
    }

    private void generateExtendedProps(Element root, IObjectValue ov, Map<String, Map<String, String>> rs) {
        int j;
        String key;
        if (ov.isExtendedPropertiesEmpty()) {
            return;
        }
        Iterator<Object> it = ov.getExtendedProperties().keySet().iterator();
        HashSet<String> keys = new HashSet<String>();
        Locale[] postfixes = this.xmlLoader.getSupportedLocales();
        while (it.hasNext()) {
            key = (String)it.next();
            boolean match = false;
            int len = postfixes.length;
            for (int i = 0; i < len; ++i) {
                j = key.lastIndexOf(LocaleUtils.getLocaleString((Locale)postfixes[i]));
                if (j == -1) continue;
                keys.add(key.substring(0, j - 1));
                match = true;
                break;
            }
            if (match) continue;
            keys.add(key);
        }
        key = XMLStore.getMutlilingualKey(root) + "extendedProperty.";
        String name = null;
        String value = null;
        it = keys.iterator();
        while (it.hasNext()) {
            HashMap<String, String> hash = new HashMap<String, String>();
            name = (String)it.next();
            for (j = 0; j < postfixes.length; ++j) {
                value = null;
                value = postfixes[j].equals(this.xmlLoader.getDefaultLocale()) ? ov.getExtendedProperty(name) : ov.getExtendedProperty(name, postfixes[j]);
                hash.put(LocaleUtils.getLocaleString((Locale)postfixes[j]), value);
            }
            rs.put(key + name, hash);
        }
    }

    private void generateOwnPropElem(Element root, OwnPropertyInfo ownProp, IObjectValue ov, Map<String, Map<String, String>> rs) {
        DataType dataType = ownProp.getDataType();
        String name = ownProp.getName();
        boolean isMultilingual = ownProp.isMultilingual();
        Element node = XMLStore.getJDOMFactory().element(name, "com.kingdee.bos.metadata");
        String value = null;
        if (dataType.equals(DataType.BOOLEAN)) {
            node.setText(ov.getBoolean(name) ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        } else if (dataType.equals(DataType.INTEGER)) {
            value = ov.getString(name);
            if (value == null) {
                value = "0";
            }
            node.setText(value);
        } else if (dataType.equals(DataType.STRING)) {
            if (isMultilingual) {
                String key = XMLStore.getMutlilingualKey(root) + name;
                HashMap<String, String> hash = new HashMap<String, String>(4);
                Locale[] postfixes = this.xmlLoader.getSupportedLocales();
                for (int i = 0; i < postfixes.length; ++i) {
                    value = null;
                    value = postfixes[i].equals(this.xmlLoader.getDefaultLocale()) ? ov.getString(name) : (String)ov.get(name, postfixes[i]);
                    hash.put(LocaleUtils.getLocaleString((Locale)postfixes[i]), value);
                }
                node.setText(key);
                rs.put(key, hash);
            } else if (ov.getString(name) == null) {
                node.setText("");
            } else {
                node.setText(ov.getString(name));
            }
        } else if (ov.getString(name) == null) {
            node.setText("");
        } else {
            node.setText(ov.getString(name));
        }
        root.addContent((Content)node);
    }

    private void generateLinkPropElem(Element root, LinkPropertyInfo linkProp, IObjectValue ov, Map<String, Map<String, String>> rs) throws DataAccessException {
        boolean isRef;
        RelationshipInfo relationship = linkProp.getRelationship();
        RelationshipType type = relationship.getType();
        CardinalityType spCty = relationship.getSupplierCardinality();
        if (type.equals((Object)RelationshipType.COMPOSITION)) {
            isRef = false;
        } else if (type.equals((Object)RelationshipType.ASSOCIATION)) {
            isRef = true;
        } else {
            throw new InvalidDAOMetaDataException("Unsupported relationsihp!");
        }
        if (spCty.equals((Object)CardinalityType.ZERO_TO_ONE) || spCty.equals((Object)CardinalityType.ONE)) {
            IObjectValue temp = (IObjectValue)ov.get(linkProp.getName());
            this.generateEntity(root, linkProp, temp, rs, isRef);
        } else if (spCty.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) || spCty.equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) {
            this.generateCollection(root, linkProp, ov, rs, isRef);
        } else {
            throw new InvalidDAOMetaDataException("Unsupported supplierCardinality");
        }
    }

    private void generateEntity(Element root, LinkPropertyInfo linkProp, IObjectValue ov, Map<String, Map<String, String>> rs, boolean isRef) throws DataAccessException {
        String name = linkProp.getName();
        this.generateEntity(root, linkProp, ov, rs, isRef, name);
    }

    private void generateEntity(Element root, LinkPropertyInfo linkProp, IObjectValue ov, Map<String, Map<String, String>> rs, boolean isRef, String name) throws DataAccessException {
        if (ov == null) {
            return;
        }
        Element elem = XMLStore.getJDOMFactory().element(name, "com.kingdee.bos.metadata");
        root.addContent((Content)elem);
        RelationshipInfo relationship = linkProp.getRelationship();
        EntityObjectInfo supObj = relationship.getSupplierObject();
        BOSObjectType bosType = supObj.getType();
        if (isRef) {
            LogicalKeyInfo logicalKey = supObj.getLogicalKey();
            Iterator it = logicalKey.getKeyPropertys().iterator();
            while (it.hasNext()) {
                PropertyInfo prop = (PropertyInfo)it.next();
                String attName = prop.getName();
                String attValue = ov.getString(attName);
                if (attValue == null) {
                    attValue = "";
                }
                Element key = XMLStore.getJDOMFactory().element("key", "com.kingdee.bos.metadata");
                key.setAttribute(XMLStore.getJDOMFactory().attribute("name", attName));
                key.setAttribute(XMLStore.getJDOMFactory().attribute("value", attValue));
                elem.addContent((Content)key);
            }
        } else {
            this.generate(elem, bosType, ov, rs);
        }
    }

    private void generateCollection(Element root, LinkPropertyInfo linkProp, IObjectValue ov, Map<String, Map<String, String>> rs, boolean isRef) throws DataAccessException {
        IObjectCollection temp = (IObjectCollection)ov.get(linkProp.getName());
        if (temp == null || temp.size() <= 0) {
            return;
        }
        Iterator it = temp.iterator();
        IObjectValue child = null;
        Element elem = XMLStore.getJDOMFactory().element(linkProp.getName(), "com.kingdee.bos.metadata");
        root.addContent((Content)elem);
        RelationshipInfo relationship = linkProp.getRelationship();
        String name = null;
        while (it.hasNext()) {
            child = (IObjectValue)it.next();
            if (isRef) {
                name = relationship.getSupplierObject().getName();
            } else {
                BOSObjectType bosType = relationship.getSupplierObject().getType();
                EntityObjectInfo entity = this.xmlLoader.loadMeta(bosType, child);
                name = entity.getName();
            }
            this.generateEntity(elem, linkProp, child, rs, isRef, name);
        }
    }

    public void storeResource(BOSObjectType bosType, IObjectPK pk, Map<String, Map<String, String>> hash) throws DataAccessException {
        String suffix = Utils.getMetaDataSuffix(bosType);
        MetaDataPK filePK = null;
        filePK = pk instanceof MetaDataPK ? (MetaDataPK)pk : MetaDataPK.create("", pk.toString());
        try {
            NetFile file = this.fileFactory.createNetFile(filePK.toString() + suffix);
            InputStream is = new BufferedInputStream(this.fileFactory.createNetFileInputStream(file));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int c = -1;
            while ((c = is.read()) != -1) {
                bos.write(c);
            }
            is.close();
            bos.flush();
            byte[] bs = bos.toByteArray();
            is = new ByteArrayInputStream(bs);
            OutputStream os = this.fileFactory.createNetFileOutputStream(file);
            this.storeResource(is, os, hash);
            is.close();
            os.close();
        }
        catch (IOException fe) {
            throw new XMLIOException(fe);
        }
    }

    public void storeResource(InputStream is, OutputStream os, Map<String, Map<String, String>> hash) throws DataAccessException {
        try {
            Element root = XMLParser.parseXML((InputStream)is).getRootElement();
            root.removeChild("resource", root.getNamespace());
            Element resource = this.getResource1(hash);
            root.addContent((Content)resource);
            Document doc = root.getDocument();
            if (doc == null) {
                doc = XMLStore.getJDOMFactory().document(root);
            }
            XmlUtils.output(root.getDocument(), os);
        }
        catch (IOException ioe) {
            throw new XMLIOException(ioe);
        }
        catch (JDOMException jdome) {
            throw new XMLParseException(jdome);
        }
    }

    private Element getResource(Map<String, Map<String, String>> hash) {
        Iterator<String> it = new TreeSet<String>(hash.keySet()).iterator();
        Element resource = XMLStore.getJDOMFactory().element("resource", "com.kingdee.bos.metadata");
        Element rs = null;
        while (it.hasNext()) {
            String key = it.next();
            rs = XMLStore.getJDOMFactory().element("rs", "com.kingdee.bos.metadata");
            rs.setAttribute(XMLStore.getJDOMFactory().attribute("key", key));
            Map<String, String> locales = hash.get(key);
            TreeSet<String> sorted = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            sorted.addAll(locales.keySet());
            for (Object e : sorted) {
                Element lang = XMLStore.getJDOMFactory().element("lang", "com.kingdee.bos.metadata");
                lang.setAttribute(XMLStore.getJDOMFactory().attribute("locale", e.toString()));
                String value = locales.get(e);
                lang.setAttribute(XMLStore.getJDOMFactory().attribute("value", value == null ? "null" : value.toString()));
                rs.addContent((Content)lang);
            }
            resource.addContent((Content)rs);
        }
        return resource;
    }

    private Element getResource1(Map<String, Map<String, String>> hash) {
        Iterator<String> it = new TreeSet<String>(hash.keySet()).iterator();
        Element resource = XMLStore.getJDOMFactory().element("resource", "com.kingdee.bos.metadata");
        Element rs = null;
        while (it.hasNext()) {
            String key = it.next();
            rs = XMLStore.getJDOMFactory().element("rs", "com.kingdee.bos.metadata");
            rs.setAttribute(XMLStore.getJDOMFactory().attribute("key", key));
            Map<String, String> locales = hash.get(key);
            TreeSet<String> sorted = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            sorted.addAll(locales.keySet());
            for (String o : sorted) {
                Element lang = XMLStore.getJDOMFactory().element("lang", "com.kingdee.bos.metadata");
                lang.setAttribute(XMLStore.getJDOMFactory().attribute("locale", o));
                String value = locales.get(o);
                lang.setAttribute(XMLStore.getJDOMFactory().attribute("value", value == null ? "null" : value.toString()));
                rs.addContent((Content)lang);
            }
            resource.addContent((Content)rs);
        }
        return resource;
    }

    public static String getMutlilingualKey(Element root) {
        Element temp = root;
        String result = "";
        do {
            String pgName = temp.getChildText("package", temp.getNamespace());
            String name = temp.getChildText("name", temp.getNamespace());
            String instanceName = null;
            if ("action".equalsIgnoreCase(temp.getName()) && !StringUtils.isEmpty((String)(instanceName = temp.getChildText("instanceName", temp.getNamespace())))) {
                name = instanceName;
            }
            if (StringUtils.isEmpty((String)pgName) && StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)instanceName)) {
                result = !StringUtils.isEmpty((String)result) ? temp.getName() + "." + result : temp.getName();
                temp = temp.getParentElement();
                continue;
            }
            String str = temp.getName() + "[";
            if (pgName != null) {
                str = str + pgName + ".";
            }
            if (name != null) {
                str = str + name;
            }
            str = str + "].";
            result = str + result;
            temp = temp.getParentElement();
        } while (temp != null);
        return result;
    }

    public static String getMutlilingualKey2(Element root) {
        Element temp = root;
        String result = "";
        do {
            String pgName = temp.getChildText("package", temp.getNamespace());
            String name = temp.getChildText("name", temp.getNamespace());
            String instanceName = null;
            if ("action".equalsIgnoreCase(temp.getName()) && !StringUtils.isEmpty((String)(instanceName = temp.getChildText("instanceName", temp.getNamespace())))) {
                name = instanceName;
            }
            if (StringUtils.isEmpty((String)pgName) && StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)instanceName)) {
                temp = temp.getParentElement();
                continue;
            }
            String str = temp.getName() + "[";
            if (pgName != null) {
                str = str + pgName + ".";
            }
            if (name != null) {
                str = str + name;
            }
            str = str + "].";
            result = str + result;
            temp = temp.getParentElement();
        } while (temp != null);
        return result;
    }

    private static JDOMFactory getJDOMFactory() {
        return jdfactory;
    }

    public void update4Mdbview(BOSObjectType bosType, IObjectValue ov) throws DataAccessException {
        String suffix = Utils.getMetaDataSuffix(bosType);
        EntityObjectInfo entity = this.xmlLoader.loadMeta(bosType, ov);
        LogicalKeyInfo logicalKey = entity.getLogicalKey();
        MetaDataPK pk = null;
        if (logicalKey.getKeyClass().equals("com.kingdee.bos.metadata.common.MetaDataPK")) {
            pk = MetaDataPK.create(ov.getString("package"), ov.getString("name"));
        } else {
            String temp = "";
            Iterator it = logicalKey.getKeyPropertys().iterator();
            PropertyInfo prop = null;
            while (it.hasNext()) {
                prop = (PropertyInfo)it.next();
                temp = temp + ov.getString(prop.getName());
            }
            pk = MetaDataPK.create(null, temp);
        }
        try {
            NetFile file = this.fileFactory.createNetFile(((Object)pk).toString() + suffix);
            if (pk.getPackage() != null) {
                String pgPath = pk.getPackage().replace('.', File.separatorChar);
                NetFile temp = this.fileFactory.createNetFile(pgPath);
                temp.mkdirs();
            }
            InputStream is = this.fileFactory.createNetFileInputStream(file);
            Document doc = XMLParser.parseXML((InputStream)is);
            is.close();
            this.update4Mdbview(ov, doc.getRootElement());
            OutputStream os = this.fileFactory.createNetFileOutputStream(file);
            XmlUtils.output(doc, os);
            os.close();
        }
        catch (Exception fe) {
            throw new XMLIOException(fe);
        }
    }

    private void update4Mdbview(IObjectValue ov, Element root) throws DataAccessException {
        HashMap<String, Map<String, String>> rs = new HashMap<String, Map<String, String>>();
        this.updateBrief4Mdbview(ov, root, rs);
        this.updateResource4Mdbview(root, rs);
    }

    private void updateBrief4Mdbview(IObjectValue ov, Element root, Map<String, Map<String, String>> rs) throws MissingDAOMetaDataException {
        Namespace ns = root.getNamespace();
        Element mdb = root.getChild("metaDataBriefs", ns);
        List mdbs = mdb.getChildren("metaDataBrief", ns);
        IObjectCollection oc = (IObjectCollection)ov.get("metaDataBriefs");
        Iterator ociter = oc.iterator();
        while (ociter.hasNext()) {
            IObjectValue temp = (IObjectValue)ociter.next();
            EntityObjectInfo entity = this.xmlLoader.loadMeta(BOSObjectType.create((String)"mobi"), temp);
            PropertyCollection pc = entity.getInheritedPropertiesRuntime();
            String pkgName = temp.getString("packageName");
            if (pkgName == null) {
                pkgName = "";
            }
            String ovkey = pkgName + temp.getString("name") + temp.getString("metaDataType");
            boolean find = false;
            for (Element element : mdbs) {
                pkgName = element.getChildText("packageName", ns);
                if (pkgName == null) {
                    pkgName = "";
                }
                String name = element.getChildText("name", ns);
                String elekey = pkgName + name + element.getChildText("metaDataType", ns);
                if (!elekey.equals(ovkey)) continue;
                Iterator iterator = pc.iterator();
                while (iterator.hasNext()) {
                    OwnPropertyInfo prop = (OwnPropertyInfo)iterator.next();
                    String propname = prop.getString("name");
                    if ("packageName".equals(propname) || "name".equals(propname) || "metaDataType".equals(propname)) continue;
                    boolean isMultilingual = prop.isMultilingual();
                    if (isMultilingual) {
                        String key = XMLStore.getMutlilingualKey(element) + propname;
                        HashMap<String, String> hash = new HashMap<String, String>(4);
                        Locale[] postfixes = this.xmlLoader.getSupportedLocales();
                        String value = null;
                        for (int i = 0; i < postfixes.length; ++i) {
                            value = null;
                            value = postfixes[i].equals(this.xmlLoader.getDefaultLocale()) ? temp.getString(propname) : (String)temp.get(propname, postfixes[i]);
                            hash.put(LocaleUtils.getLocaleString((Locale)postfixes[i]), value);
                        }
                        element.getChild(propname, ns).setText(key);
                        rs.put(key, hash);
                        continue;
                    }
                    String tmp = temp.getString(propname);
                    if (tmp == null) {
                        tmp = "";
                    }
                    element.getChild(propname, ns).setText(tmp);
                }
                find = true;
                break;
            }
            if (find) continue;
            Element node = XMLStore.getJDOMFactory().element("metaDataBrief", "com.kingdee.bos.metadata");
            mdb.addContent((Content)node);
            Iterator iterator = pc.iterator();
            while (iterator.hasNext()) {
                OwnPropertyInfo prop = (OwnPropertyInfo)iterator.next();
                Element ele = XMLStore.getJDOMFactory().element(prop.getName(), "com.kingdee.bos.metadata");
                String propname = prop.getName();
                boolean isMultilingual = prop.isMultilingual();
                if (isMultilingual) {
                    String key = XMLStore.getMutlilingualKey(node) + propname;
                    ele.setText(key);
                    HashMap<String, String> hash = new HashMap<String, String>(4);
                    Locale[] postfixes = this.xmlLoader.getSupportedLocales();
                    String value = null;
                    for (int i = 0; i < postfixes.length; ++i) {
                        value = null;
                        value = postfixes[i].equals(this.xmlLoader.getDefaultLocale()) ? temp.getString(propname) : (String)temp.get(propname, postfixes[i]);
                        hash.put(LocaleUtils.getLocaleString((Locale)postfixes[i]), value);
                    }
                    rs.put(key, hash);
                } else {
                    ele.setText(temp.getString(propname));
                }
                node.addContent((Content)ele);
            }
        }
    }

    private void updateResource4Mdbview(Element root, Map<String, Map<String, String>> rs) {
        Element resource = root.getChild("resource", root.getNamespace());
        List rsList = resource.getChildren();
        TreeSet<String> tset = new TreeSet<String>(rs.keySet());
        for (String rskey : tset) {
            Map<String, String> map = rs.get(rskey);
            boolean find = false;
            for (Element rsEle : rsList) {
                String kv = rsEle.getAttributeValue("key");
                if (!rskey.equals(kv)) continue;
                List lang = rsEle.getChildren();
                for (Element ele : lang) {
                    String ss = map.get(ele.getAttributeValue("locale"));
                    if (ss == null) {
                        ss = "null";
                    }
                    ele.setAttribute("value", ss);
                }
                find = true;
                break;
            }
            if (find) continue;
            Element rsele = XMLStore.getJDOMFactory().element("rs", "com.kingdee.bos.metadata");
            rsele.setAttribute(XMLStore.getJDOMFactory().attribute("key", rskey));
            TreeSet<String> ts = new TreeSet<String>(map.keySet());
            for (String langs : ts) {
                Element lang = XMLStore.getJDOMFactory().element("lang", "com.kingdee.bos.metadata");
                lang.setAttribute(XMLStore.getJDOMFactory().attribute("locale", langs));
                String value = map.get(langs);
                lang.setAttribute(XMLStore.getJDOMFactory().attribute("value", value == null ? "null" : value.toString()));
                rsele.addContent((Content)lang);
            }
            resource.addContent((Content)rsele);
        }
    }
}

