/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.DocumentStateEnum;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MapStateManager;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class DynamicStateManager
implements IStateManager,
IMarshalObject {
    private static Logger logger = Logger.getLogger(DynamicStateManager.class);
    private MetaDataPK2 pk;
    private DocumentStateEnum docState = DocumentStateEnum.WHOLE;
    private IStateManager master;
    private Map<String, IStateManager> slavers = new ConcurrentHashMap<String, IStateManager>(4);
    private static final IStateManager NULL = new NullStateManager();
    private static final ThreadLocal<Boolean> useMaster = new ThreadLocal();
    private Project.Projects projects;

    public static void beginUseMaster() {
        useMaster.set(true);
    }

    public static void endUseMaster() {
        useMaster.remove();
    }

    public DynamicStateManager() {
    }

    public DynamicStateManager(IStateManager sm) {
        this.master = sm;
    }

    public DynamicStateManager(MetaDataPK2 pk, IStateManager sm) {
        this(pk, sm, null);
    }

    public DynamicStateManager(MetaDataPK2 pk, IStateManager sm, DocumentStateEnum docState) {
        this.pk = pk;
        this.master = sm;
        this.docState = docState;
    }

    void addSlaver(String ais, IStateManager sm) {
        if (sm == null) {
            sm = NULL;
        }
        this.slavers.put(ais, sm);
    }

    @Override
    public void clear() {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            sm.clear();
        }
    }

    @Override
    public void clearExtendPropertyValues() {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            sm.clearExtendPropertyValues();
        }
    }

    @Override
    public boolean containsExtendedPropertyKey(String key) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.containsExtendedPropertyKey(key);
        }
        return false;
    }

    @Override
    public boolean containsKey(String key) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean containsLocaleKey(String key, String locale) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.containsLocaleKey(key, locale);
        }
        return false;
    }

    @Override
    public boolean containsStateKey(String key) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.containsStateKey(key);
        }
        return false;
    }

    @Override
    public Map getExtendedProperties() {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.getExtendedProperties();
        }
        return new HashMap();
    }

    @Override
    public Object getLocaleValue(String key, String locale) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.getLocaleValue(key, locale);
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String key) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.getPropertyValue(key);
        }
        return null;
    }

    @Override
    public Object getStateValue(String key) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.getStateValue(key);
        }
        if (this.pk != null) {
            if ("package".equals(key)) {
                return this.pk.getPackage();
            }
            if ("name".equals(key)) {
                return this.pk.getName();
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.isEmpty();
        }
        return false;
    }

    @Override
    public Enumeration keys() {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.keys();
        }
        return new Hashtable().elements();
    }

    @Override
    public Object removeLocaleValue(String key, String locale) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.removeLocaleValue(key, locale);
        }
        return null;
    }

    @Override
    public Object removePropertyValue(String key) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.removePropertyValue(key);
        }
        return null;
    }

    @Override
    public Object removeSateValue(String key) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.removeSateValue(key);
        }
        return null;
    }

    @Override
    public Object setLocaleValue(String key, Object value, String locale) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.setLocaleValue(key, value, locale);
        }
        return null;
    }

    @Override
    public Object setPropertyValue(String key, Object value) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.setPropertyValue(key, value);
        }
        return null;
    }

    @Override
    public Object setStateValue(String key, Object value) {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.setStateValue(key, value);
        }
        sm = new MapStateManager();
        Object obj = sm.setStateValue(key, value);
        this.addSlaver(ConfigMDUtil.getAIS(), sm);
        return obj;
    }

    @Override
    public int size() {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            return sm.size();
        }
        return 0;
    }

    @Override
    public void trimToSize() {
        IStateManager sm = this.getStateManager();
        if (!DynamicStateManager.isNull(sm)) {
            sm.trimToSize();
        }
    }

    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.pk);
        marshaller.writeObject((Object)this.docState);
        marshaller.writeObject((Object)this.master);
        marshaller.writeObject(this.slavers);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.pk = (MetaDataPK2)unmarshaller.readObject();
        this.docState = (DocumentStateEnum)((Object)unmarshaller.readObject());
        this.master = (IStateManager)unmarshaller.readObject();
        this.slavers = (Map)unmarshaller.readObject();
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }

    public static AbstractObjectCollection clone(AbstractObjectCollection oc) {
        Class<?> clazz = oc.getClass();
        AbstractObjectCollection clone = null;
        try {
            clone = (AbstractObjectCollection)clazz.newInstance();
        }
        catch (Exception e) {
            logger.warn((Object)e, (Throwable)e);
            return null;
        }
        Iterator iterator = oc.iterator();
        while (iterator.hasNext()) {
            IObjectValue ov = (IObjectValue)iterator.next();
            clone.addObject(ov);
        }
        return clone;
    }

    public boolean isNull() {
        if (this.master != null) {
            return false;
        }
        return this.slavers.size() == 0 || DynamicStateManager.isNull(this.getSlaver());
    }

    private void check(String ais) {
        if (this.slavers.containsKey(ais)) {
            return;
        }
        try {
            MDLoader.getInstance().loadDBConfig(this);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public DocumentStateEnum getDocState() {
        return this.docState;
    }

    public void setDocState(DocumentStateEnum docState) {
        this.docState = docState;
    }

    public MetaDataPK2 getPk() {
        return this.pk;
    }

    public Project.Projects getProjects() {
        return this.projects;
    }

    public void setProjects(Project.Projects projects) {
        this.projects = projects;
    }

    public int hashCode() {
        IStateManager sm;
        int h = 0;
        if (this.master != null) {
            h += this.master.hashCode();
        }
        if (!DynamicStateManager.isNull(sm = this.getSlaver())) {
            h += sm.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DynamicStateManager)) {
            return false;
        }
        DynamicStateManager dsm = (DynamicStateManager)obj;
        return this.equals(this.master, dsm.master) && this.equals(this.getSlaver(), dsm.getSlaver());
    }

    private boolean equals(IStateManager sm1, IStateManager sm2) {
        if (sm1 != null) {
            return sm1.equals(sm2);
        }
        return sm2 == null;
    }

    private static boolean isNull(IStateManager manager) {
        return manager == null || NULL.equals(manager);
    }

    public IStateManager getStateManager() {
        if (useMaster.get() != null) {
            return this.master;
        }
        IStateManager stateManager = this.getSlaver();
        if (DynamicStateManager.isNull(stateManager)) {
            stateManager = this.master;
        }
        return stateManager;
    }

    public IStateManager getSlaver(String ais) {
        this.check(ais);
        return this.slavers.get(ais);
    }

    public IStateManager getSlaver() {
        return this.getSlaver(ConfigMDUtil.getAIS());
    }

    static final class NullStateManager
    implements IStateManager {
        private static final long serialVersionUID = 8896966912677788711L;

        NullStateManager() {
        }

        @Override
        public Object getStateValue(String key) {
            return null;
        }

        @Override
        public Object setStateValue(String key, Object value) {
            return null;
        }

        @Override
        public Object removeSateValue(String key) {
            return null;
        }

        @Override
        public boolean containsStateKey(String key) {
            return false;
        }

        @Override
        public Object getLocaleValue(String key, String locale) {
            return null;
        }

        @Override
        public Object setLocaleValue(String key, Object value, String locale) {
            return null;
        }

        @Override
        public Object removeLocaleValue(String key, String locale) {
            return null;
        }

        @Override
        public boolean containsLocaleKey(String key, String locale) {
            return false;
        }

        @Override
        public Object getPropertyValue(String key) {
            return null;
        }

        @Override
        public Object setPropertyValue(String key, Object value) {
            return null;
        }

        @Override
        public Object removePropertyValue(String key) {
            return null;
        }

        @Override
        public void clearExtendPropertyValues() {
        }

        @Override
        public boolean containsExtendedPropertyKey(String key) {
            return false;
        }

        @Override
        public Map getExtendedProperties() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(String key) {
            return false;
        }

        @Override
        public Enumeration keys() {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public void trimToSize() {
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj || obj == null || obj instanceof NullStateManager;
        }

        public String toString() {
            return "NULL";
        }
    }
}

