/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DocumentProxyStateManager;
import com.kingdee.bos.dao.xml.impl.ILoaderProvider;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.ChangeType;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.MetadataChangeListenerManager;
import com.kingdee.bos.metadata.view.SubSystemUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.LRUCache;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

abstract class InnerMDLoader {
    private static final Logger logger = Logger.getLogger(InnerMDLoader.class);
    protected static final Object ERROR_MD = new Object();
    private static final InnerMDCache mdCache = new InnerMDCache();
    private CacheProvider provider = null;
    private static final DoubleMap<String> pkMapping = new DoubleMap();
    protected final ILoaderProvider loaderProvider;

    InnerMDLoader(ILoaderProvider loaderProvider) {
        this.loaderProvider = loaderProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMetaDataValue loadMD(MetaDataPK2 pk2) {
        if (this.provider == null) {
            this.provider = this.createCacheProvider();
            if (this.provider == null) {
                return null;
            }
        }
        if (MetaDataTypeList.SOLUTION.toString().equals(pk2.getType())) {
            pk2 = new MetaDataPK2(null, this.loaderProvider.getSolutionName(), MetaDataTypeList.SOLUTION.toString());
        }
        if (this.isMetaDataPKIllegal(pk2)) {
            return null;
        }
        String key = this.provider.getKey(pk2);
        Object foo = mdCache.get(this.provider, key);
        if (foo == ERROR_MD) {
            logger.error((Object)("met a ERROR_MD, pk2=" + key));
            return null;
        }
        AbstractMetaDataValue obj = (AbstractMetaDataValue)foo;
        if (obj == null) {
            InnerMDCache innerMDCache = mdCache;
            synchronized (innerMDCache) {
                foo = mdCache.get(this.provider, key);
                if (foo == ERROR_MD) {
                    logger.error((Object)("met a ERROR_MD, pk2=" + pk2.getKey()));
                    return null;
                }
                obj = (AbstractMetaDataValue)foo;
                if (obj == null) {
                    obj = this.createMDObject(pk2);
                    if (obj == null) {
                        logger.fatal((Object)("MDLoader loadMD pk2=[" + pk2 + "] error. Can't create info instance for type[" + pk2.getType() + "] "));
                        mdCache.put(this.provider, key, ERROR_MD);
                        return null;
                    }
                    DocumentProxyStateManager manager = new DocumentProxyStateManager(pk2.getPackage(), pk2.getName(), obj.getBOSType().toString());
                    this.processStateManager(manager);
                    obj.setStateManager(manager);
                    BOSObjectType rt = obj.getBOSType();
                    MetaDataPK2 rpk2 = new MetaDataPK2(pk2.getPackage(), pk2.getName(), rt.toString());
                    String key2 = this.provider.getKey(rpk2);
                    if (!key.equals(key2)) {
                        if (mdCache.containsKey(this.provider, key2)) {
                            obj = (AbstractMetaDataValue)mdCache.get(this.provider, key2);
                            mdCache.put(this.provider, key, obj);
                        } else {
                            mdCache.put(this.provider, key, obj);
                            mdCache.put(this.provider, key2, obj);
                        }
                        pkMapping.put(key, key2);
                    } else {
                        mdCache.put(this.provider, key, obj);
                    }
                }
            }
        }
        return obj;
    }

    static void clearOv(String ovPath) {
        String key = MetaDataPK2.fromPath(ovPath).getKey();
        InnerMDLoader.innerClearOv(key);
    }

    static void innerClearOv(String key) {
        if (key == null) {
            return;
        }
        List<Object> ovs = InnerMDLoader.clear(key);
        int size = ovs.size();
        for (int i = 0; i < size; ++i) {
            AbstractMDValue ov = (AbstractMDValue)ovs.get(i);
            if (ov == null) continue;
            if (ov instanceof AbstractMetaDataValue) {
                MetadataChangeListenerManager.notify((AbstractMetaDataValue)ov, null, ChangeType.UPDATE);
            }
            ov.clear();
        }
    }

    static void clearOv(String pk, String type) {
        String key = pk + "!" + type;
        InnerMDLoader.innerClearOv(key);
    }

    static void clear(MetaDataPK2 pk2) {
        InnerMDLoader.clear(pk2.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Object> clear(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        InnerMDCache innerMDCache = mdCache;
        synchronized (innerMDCache) {
            String mapping;
            List<Object> tmp = mdCache.remove(key);
            if (tmp != null) {
                list.addAll(tmp);
            }
            if ((mapping = pkMapping.remove(key)) != null && (tmp = mdCache.remove(mapping)) != null) {
                list.addAll(tmp);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clear(BOSObjectType bosType, Cleaner cleaner) {
        String[] keys;
        InnerMDCache innerMDCache = mdCache;
        synchronized (innerMDCache) {
            keys = mdCache.keys().toArray(new String[0]);
        }
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].endsWith(bosType.toString())) continue;
            cleaner.clear(keys[i]);
        }
    }

    public static int size() {
        return mdCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearAll() {
        InnerMDCache innerMDCache = mdCache;
        synchronized (innerMDCache) {
            if (ConfigMDUtil.isClient()) {
                String[] keys = mdCache.keys().toArray(new String[0]);
                String solutionSuffix = "!" + MetaDataTypeList.SOLUTION;
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i].endsWith(solutionSuffix)) continue;
                    InnerMDLoader.clear(keys[i]);
                }
            } else {
                mdCache.clear();
                pkMapping.clear();
            }
        }
    }

    abstract AbstractMetaDataValue createMDObject(MetaDataPK2 var1);

    abstract void processStateManager(IStateManager var1);

    abstract boolean isMetaDataPKIllegal(MetaDataPK2 var1);

    abstract CacheProvider createCacheProvider();

    static class DoubleMap<T> {
        private final Map<T, T> map = new HashMap<T, T>();

        DoubleMap() {
        }

        void put(T key, T value) {
            this.map.put(key, value);
            this.map.put(value, key);
        }

        T get(T keyOrValue) {
            return this.map.get(keyOrValue);
        }

        boolean contains(T obj) {
            return this.map.containsKey(obj);
        }

        T remove(T key) {
            T value = this.map.remove(key);
            if (value != null) {
                this.map.remove(value);
            }
            return value;
        }

        void clear() {
            this.map.clear();
        }
    }

    static class LevelCache {
        final Map<String, Object> cache;
        final LevelCache parent;
        private boolean leaf;

        LevelCache(LevelCache parent, int size) {
            this.cache = new HashMap<String, Object>(size);
            this.parent = parent;
            this.leaf = true;
        }

        LevelCache(LevelCache parent, Map<String, Object> cache) {
            this.cache = cache;
            this.parent = parent;
            this.leaf = true;
        }

        Object get(String key) {
            return this.cache.get(key);
        }

        void put(String key, Object value) {
            this.cache.put(key, value);
            if (value instanceof LevelCache) {
                this.leaf = false;
            }
        }

        boolean isLeaf() {
            return this.leaf;
        }

        boolean containsKey(String key) {
            return this.cache.containsKey(key);
        }

        Object remove(String key) {
            return this.cache.remove(key);
        }

        void clear() {
            this.cache.clear();
        }

        Set<String> keySet() {
            return this.cache.keySet();
        }

        Iterator<Object> valueSet() {
            return this.cache.values().iterator();
        }

        Iterator<Map.Entry<String, Object>> entrySet() {
            return this.cache.entrySet().iterator();
        }

        int size() {
            return this.cache.size();
        }
    }

    static class DefaultCacheProvider
    implements CacheProvider {
        private final String[] levels;

        DefaultCacheProvider(String[] levels) {
            this.levels = levels;
        }

        @Override
        public String getKey(MetaDataPK2 pk2) {
            return pk2.getKey();
        }

        @Override
        public String[] getLevels() {
            return this.levels;
        }
    }

    static interface CacheProvider {
        public String[] getLevels();

        public String getKey(MetaDataPK2 var1);
    }

    static class InnerMDCache {
        private LevelCache root = new LevelCache(null, 4);
        private static boolean IS_LRU_MDCACHE = "true".equalsIgnoreCase(SubSystemUtils.getProperty("IsLRUMDCache", "false"));
        private static int LRU_MDCACHE_MAX_SIZE = Integer.parseInt(SubSystemUtils.getProperty("LRUMDCacheMaxSize", "40000"));

        InnerMDCache() {
        }

        Object get(CacheProvider provider, MetaDataPK2 pk2) {
            if (provider == null) {
                return null;
            }
            return this.get(provider, provider.getKey(pk2));
        }

        Object get(CacheProvider provider, String key) {
            if (provider == null) {
                return null;
            }
            LevelCache leaf = InnerMDCache.getLevel(this.root, provider.getLevels(), false);
            if (leaf != null) {
                return leaf.get(key);
            }
            return null;
        }

        List<Object> remove(String key) {
            ArrayList<Object> result = new ArrayList<Object>();
            InnerMDCache.remove(this.root, key, result);
            return result;
        }

        private static void remove(LevelCache cache, String key, List<Object> result) {
            Object md = cache.remove(key);
            if (md != null) {
                result.add(md);
            }
            if (!cache.isLeaf()) {
                Iterator<Object> ite = cache.valueSet();
                while (ite.hasNext()) {
                    Object obj = ite.next();
                    if (!(obj instanceof LevelCache)) continue;
                    InnerMDCache.remove((LevelCache)obj, key, result);
                }
            }
        }

        void put(CacheProvider provider, String key, Object md) {
            if (md == null || provider == null) {
                return;
            }
            LevelCache leaf = InnerMDCache.getLevel(this.root, provider.getLevels(), true);
            if (leaf != null) {
                leaf.put(key, md);
            }
        }

        private static LevelCache getLevel(LevelCache root, String[] levels, boolean addnewWhenNotExist) {
            LevelCache leaf;
            if (levels == null || levels.length == 0) {
                leaf = root;
            } else {
                LevelCache tmpCache = root;
                for (int i = 0; i < levels.length; ++i) {
                    LevelCache tmp = (LevelCache)tmpCache.get(levels[i]);
                    if (tmp == null) {
                        if (addnewWhenNotExist) {
                            tmp = IS_LRU_MDCACHE ? new LevelCache(tmpCache, (Map<String, Object>)new LRUCache(LRU_MDCACHE_MAX_SIZE)) : new LevelCache(tmpCache, 10);
                            tmpCache.put(levels[i], tmp);
                        } else {
                            return null;
                        }
                    }
                    tmpCache = tmp;
                }
                leaf = tmpCache;
            }
            return leaf;
        }

        boolean containsKey(CacheProvider provider, String key) {
            if (provider == null) {
                return false;
            }
            LevelCache leaf = InnerMDCache.getLevel(this.root, provider.getLevels(), false);
            if (leaf != null) {
                return leaf.containsKey(key);
            }
            return false;
        }

        void clear() {
            this.root.clear();
        }

        int size() {
            return InnerMDCache.size(this.root);
        }

        private static int size(LevelCache cache) {
            if (cache.isLeaf()) {
                return cache.size();
            }
            int size = 0;
            Iterator<Map.Entry<String, Object>> ite = cache.entrySet();
            while (ite.hasNext()) {
                Map.Entry<String, Object> entry = ite.next();
                Object obj = entry.getValue();
                if (obj instanceof LevelCache) {
                    size += InnerMDCache.size((LevelCache)obj);
                    continue;
                }
                ++size;
            }
            return size;
        }

        Set<String> keys() {
            HashSet<String> result = new HashSet<String>();
            InnerMDCache.keys(this.root, result);
            return result;
        }

        private static void keys(LevelCache cache, Set<String> set) {
            if (cache.isLeaf()) {
                set.addAll(cache.keySet());
            } else {
                Iterator<Map.Entry<String, Object>> ite = cache.entrySet();
                while (ite.hasNext()) {
                    Map.Entry<String, Object> entry = ite.next();
                    Object obj = entry.getValue();
                    if (obj instanceof LevelCache) {
                        InnerMDCache.keys((LevelCache)obj, set);
                        continue;
                    }
                    set.add(entry.getKey());
                }
            }
        }
    }

    static interface Cleaner {
        public void clear(String var1);
    }
}

