/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.IMDCache;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class MDCache
implements IMDCache {
    private static final Logger logger = Logger.getLogger(MDCache.class);
    protected File rootDir;
    protected File dataDir;
    protected File metaDir;
    protected File srcDir;
    protected MetaDataClassLoader srcResLoader;

    public MDCache(File root) throws IOException {
        boolean needCreate = false;
        if (root == null) {
            logger.error((Object)"MDCache dir is NULL.");
            needCreate = true;
        } else if (!root.exists()) {
            logger.error((Object)("MDCache dir[" + root.getPath() + "] NOT exists."));
            needCreate = true;
        } else if (root.isFile() || !root.canWrite()) {
            logger.error((Object)("MDCache dir[" + root.getPath() + "] can NOT write."));
            needCreate = true;
        }
        if (needCreate) {
            throw new IllegalArgumentException("MDCache dir is not OK.");
        }
        this.rootDir = root;
        this.initDirs();
    }

    public MDCache(File root, MetaDataClassLoader cl, File srcRoot) throws IOException {
        this(root, cl);
        if (srcRoot.exists()) {
            this.srcDir = srcRoot;
        }
    }

    public MDCache(File root, MetaDataClassLoader cl) throws IOException {
        this(root);
        this.srcResLoader = cl;
    }

    private File createTemp() throws IOException {
        try {
            File file = File.createTempFile("MDCache", ".dir");
            file.delete();
            file.mkdir();
            file.deleteOnExit();
            return file;
        }
        catch (IOException e) {
            logger.error((Object)"Cant NOT create temp dir.");
            throw e;
        }
    }

    private void initDirs() {
        this.dataDir = new File(this.rootDir, "data");
        this.dataDir.mkdir();
        this.metaDir = new File(this.rootDir, ".meta");
        this.metaDir.mkdir();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("MDCache Root Dir = " + this.rootDir.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStateManager getEntry(String key) {
        InputStream is;
        block31: {
            String entryPath;
            is = null;
            try {
                MetaDataPK2 pk2 = new MetaDataPK2(key);
                entryPath = pk2.getPath();
                File f = new File(this.dataDir, entryPath);
                if (!f.exists()) {
                    IStateManager iStateManager = null;
                    return iStateManager;
                }
                long st = this.srcResLoader.lastModified(key);
                if (st > 0L && st == f.lastModified() && !ConfigureResourceLoader.exist(pk2.getPath2())) {
                    is = new BufferedInputStream(new FileInputStream(f));
                    break block31;
                }
                f.delete();
                IStateManager iStateManager = null;
                return iStateManager;
            }
            catch (Exception e) {
                entryPath = null;
                return entryPath;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"close BufferedInputStream error!", (Throwable)e);
                }
            }
        }
        if (is != null) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(is);
                Object rtv = ois.readObject();
                IStateManager iStateManager = (IStateManager)rtv;
                return iStateManager;
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Override
    public boolean containsEntry(String key) {
        return this.existEntryFile(key);
    }

    @Override
    public IStateManager putEntry(String key, IStateManager value) {
        if (!this.existEntryFile(key)) {
            return this.forcePutEntry(key, value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStateManager forcePutEntry(String key, IStateManager value) {
        block33: {
            if (value == null) {
                return null;
            }
            OutputStream os = null;
            File f = null;
            try {
                String entryPath = new MetaDataPK2(key).getPath2();
                f = new File(this.dataDir, entryPath);
                File dir = f.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (ConfigureResourceLoader.exist(entryPath)) {
                    f.delete();
                    IStateManager iStateManager = null;
                    return iStateManager;
                }
                os = new BufferedOutputStream(new FileOutputStream(f));
                if (os == null || f == null || !f.exists()) break block33;
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(os);
                    oos.writeObject(value);
                    oos.close();
                    long st = this.srcResLoader.lastModified(key);
                    if (st > 0L) {
                        f.setLastModified(st);
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)"", e);
                }
                finally {
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"close ObjectOutputStream error!", (Throwable)e);
                    }
                }
                IStateManager iStateManager = value;
                return iStateManager;
            }
            catch (Exception e) {
                IStateManager iStateManager = null;
                return iStateManager;
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"close BufferedOutputStream error!", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public boolean clearEntry(String key) {
        try {
            File f = new File(this.dataDir, new MetaDataPK2(key).getPath());
            return f.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean clearAll() {
        return false;
    }

    @Override
    public boolean clearStorage() {
        return this.clearAll();
    }

    private OutputStream getEntryOutputStream(String key) {
        try {
            File f = new File(this.dataDir, new MetaDataPK2(key).getPath());
            File dir = f.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return new BufferedOutputStream(new FileOutputStream(f));
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean existEntryFile(String key) {
        try {
            File f = new File(this.dataDir, new MetaDataPK2(key).getPath());
            return f.exists();
        }
        catch (Exception e) {
            return false;
        }
    }
}

