/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.DBConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.DocumentStateEnum;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.ElementProxyStateManager;
import com.kingdee.bos.dao.xml.impl.ILoaderProvider;
import com.kingdee.bos.dao.xml.impl.IMDDefiner;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MDParser;
import com.kingdee.bos.dao.xml.impl.MapStateManager;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

class MDDefiner
implements IMDDefiner {
    private static final Logger logger = Logger.getLogger(MDDefiner.class);
    private ILoaderProvider loaderProvider;
    private DocumentStateEnum docState;
    private Project.Projects projects;

    MDDefiner(ILoaderProvider loaderProvider, DocumentStateEnum docState, Project.Projects projects) {
        this.loaderProvider = loaderProvider;
        this.docState = docState;
        this.projects = projects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStateManager defineMD(MetaDataPK2 pk2) throws Exception {
        BOSObjectType type = BOSObjectType.create((String)pk2.getType());
        EntityObjectInfo meta = null;
        try {
            meta = this.loaderProvider.getMetaLoader().loadMeta(type);
        }
        catch (DataAccessException e) {
            logger.error((Object)("Can NOT find MetaMeta for BOSType[" + type + "]"), (Throwable)((Object)e));
            throw e;
        }
        MetaDataClassLoader cl = this.loaderProvider.getMetaDataClassLoader();
        MDParser parser = this.loaderProvider.getMDParser();
        InputStream is = null;
        InputStream isFrag = null;
        if (DocumentStateEnum.ONLY_CONFIGURE.equals((Object)this.docState)) {
            isFrag = this.loaderProvider.getConfigureResourceLoader().getResourceAsStream(pk2.getPath2());
        } else {
            is = cl.getResourceAsStream(pk2.getPath());
        }
        IStateManager sm = null;
        try {
            sm = parser.parseMDFromStream(meta, is, isFrag, this.projects);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
            try {
                if (isFrag != null) {
                    isFrag.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close InputStream error!", (Throwable)e);
            }
        }
        if (DocumentStateEnum.WHOLE.equals((Object)this.docState) || DocumentStateEnum.EDITING.equals((Object)this.docState)) {
            DynamicStateManager dsm = new DynamicStateManager(pk2, sm, this.docState);
            dsm.setProjects(this.projects);
            Map loaders = ConfigureResourceLoader.getAllLoaders();
            if (loaders.size() > 0) {
                for (Map.Entry entry : loaders.entrySet()) {
                    ConfigureResourceLoader loader = (ConfigureResourceLoader)entry.getValue();
                    isFrag = loader.getResourceAsStream(pk2.getPath2());
                    if (isFrag == null) continue;
                    try {
                        is = cl.getResourceAsStream(pk2.getPath());
                        IStateManager temp = parser.parseMDFromStream(meta, is, isFrag, this.projects);
                        if (temp == null) continue;
                        dsm.addSlaver((String)entry.getKey(), temp);
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            logger.error((Object)"close InputStream error!", (Throwable)e);
                        }
                        try {
                            if (isFrag == null) continue;
                            isFrag.close();
                        }
                        catch (IOException e) {
                            logger.error((Object)"close InputStream error!", (Throwable)e);
                        }
                    }
                }
            }
            if (ConfigMDUtil.isNeedLoadConfig(pk2.getType(), pk2.getFullName())) {
                String ais = ConfigMDUtil.getAIS();
                IStateManager temp = null;
                try {
                    InputStream[] iss = DBConfigureResourceLoader.getResourceAsStream(pk2, BOSObjectType.create((String)pk2.getType()), this.projects);
                    if (iss != null && iss.length > 0) {
                        try {
                            is = cl.getResourceAsStream(pk2.getPath());
                            temp = parser.parseMDFromStream(meta, is, iss, this.projects);
                        }
                        finally {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException e) {
                                logger.error((Object)"close InputStream error!", (Throwable)e);
                            }
                            if (iss != null && iss.length > 0) {
                                for (int i = 0; i < iss.length; ++i) {
                                    try {
                                        if (iss[i] == null) continue;
                                        iss[i].close();
                                        continue;
                                    }
                                    catch (IOException e) {
                                        logger.error((Object)"close InputStream error!", (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    if (ConfigMDUtil.isExMapContains(pk2.toString())) {
                        ConfigMDUtil.removeExMap(pk2.toString());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Metadata get resource from db error. and pk is " + pk2), (Throwable)e);
                    ConfigMDUtil.add2ExMap(pk2.toString(), e);
                }
                finally {
                    dsm.addSlaver(ais, temp);
                }
            }
            if (sm == null || !dsm.isNull()) {
                sm = dsm;
            }
        }
        IdentityHashMap seen = new IdentityHashMap();
        this.resolvElement(sm, seen);
        return sm;
    }

    private void resolvElement(IStateManager sm, Map seen) {
        if (seen.containsKey(sm)) {
            return;
        }
        seen.put(sm, null);
        if (sm instanceof ElementProxyStateManager) {
            ((ElementProxyStateManager)sm).removeRealDoc();
        }
        if (!(sm instanceof MapStateManager)) {
            return;
        }
        Enumeration en = sm.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object value = sm.getStateValue(key);
            if (value == null) continue;
            if (value instanceof AbstractMDValue) {
                this.resolvElement0((AbstractMDValue)value, seen);
                continue;
            }
            if (!(value instanceof IObjectCollection)) continue;
            IObjectCollection coll = (IObjectCollection)value;
            for (int i = 0; i < coll.size(); ++i) {
                AbstractMDValue ele = (AbstractMDValue)coll.getObject(i);
                this.resolvElement0(ele, seen);
            }
        }
    }

    private void resolvElement0(AbstractMDValue value, Map seen) {
        if (seen.containsKey(value)) {
            return;
        }
        seen.put(value, null);
        IStateManager sm = value.getStateManager();
        this.resolvElement(sm, seen);
    }
}

