/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MDCache;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import java.io.File;
import java.io.IOException;

public class MDSmartCache
extends MDCache {
    private String cacheDirName;
    private int entrys = 1;
    private boolean isStarted = false;
    private MDLoader loader;
    private static int delay = -1;

    public MDSmartCache(File dir, File srcDir, MDLoader loader) throws IOException {
        super(dir, loader.cl, srcDir);
        if (srcDir == null || !srcDir.isDirectory()) {
            throw new IllegalStateException("Only directory can be watched.");
        }
        if (loader == null) {
            throw new IllegalStateException("Loader will used for watch.");
        }
        this.loader = loader;
    }

    @Override
    public boolean containsEntry(String key) {
        this.keepCacheFresh(key);
        return super.containsEntry(key);
    }

    @Override
    public IStateManager getEntry(String key) {
        this.keepCacheFresh(key);
        return super.getEntry(key);
    }

    public synchronized void start() {
        if (!this.isStarted) {
            this.isStarted = true;
            Watcher t = new Watcher();
            t.setName("Metadata Smart Cache Watcher");
            t.setDaemon(true);
            t.setPriority(1);
            t.start();
        }
    }

    private void keepCacheFresh(String key) {
        File cache = new File(this.dataDir, new MetaDataPK2(key).getPath());
        long st = -1L;
        try {
            st = this.srcResLoader.lastModified(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (st > 0L) {
            long cts;
            if (cache.exists() && st > (cts = cache.lastModified())) {
                try {
                    cache.delete();
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                cache.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processEntry(File entry) throws IOException {
        ++this.entrys;
        String cfn = entry.getCanonicalPath();
        String fullname = cfn.substring(this.cacheDirName.length());
        File sf = new File(this.srcDir, fullname);
        if (sf.exists()) {
            long cts = entry.lastModified();
            long sts = sf.lastModified();
            if (sts > cts) {
                try {
                    entry.delete();
                    this.loader.clearOv(fullname);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void scan0(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("MDSmartCache scan dir error.");
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.scan0(file);
                continue;
            }
            this.processEntry(file);
        }
    }

    protected void scan() throws IOException {
        this.entrys = 1;
        this.cacheDirName = this.dataDir.getCanonicalPath();
        this.scan0(this.dataDir.getCanonicalFile());
    }

    static {
        try {
            String interval = System.getProperty("cache.interval");
            delay = Integer.parseInt(interval);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class Watcher
    extends Thread {
        private static final long DELAY_DELTA = 10000L;
        private static final long DELAY_GCD = 100L;
        private static final long DELAY_MAX = 20000L;

        private Watcher() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    MDSmartCache.this.scan();
                }
            }
            catch (IOException ioe) {
                return;
            }
        }

        private long computeDelay() {
            if (delay > 0) {
                return delay;
            }
            return 10000L + 20000L * (long)MDSmartCache.this.entrys / ((long)MDSmartCache.this.entrys + 100L);
        }
    }
}

