/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.IProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.SortedStringObjectMap;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class MapStateManager
implements IStateManager,
IMarshalObject {
    private static final int MAX_SIZE = 20;
    private static final int MIN_SIZE = 1;
    ConcurrentSortedStringObjectMap locales;
    ConcurrentSortedStringObjectMap properties;
    final ConcurrentSortedStringObjectMap values;

    public MapStateManager() {
        this(1);
    }

    public MapStateManager(int size) {
        if (size < 1) {
            size = 1;
        }
        if (size > 20) {
            size = 20;
        }
        this.values = new ConcurrentSortedStringObjectMap(size);
    }

    @Override
    public void clear() {
        this.values.clear();
        this.locales = null;
        this.properties = null;
    }

    @Override
    public boolean containsKey(String key) {
        if (this.values.containsKey(key)) {
            return true;
        }
        if ("_state_".equals(key)) {
            return this.values.containsKey(key);
        }
        int pos = key.lastIndexOf(95);
        if (pos == -1) {
            if (this.locales != null) {
                for (Map.Entry ls : this.locales.entrySet()) {
                    Map values = (Map)ls.getValue();
                    if (!values.containsKey(key)) continue;
                    return true;
                }
            }
        } else {
            String locale = key.substring(pos + 1);
            key = key.substring(0, pos);
            if (this.locales != null && this.locales.containsKey(locale) && ((Map)this.locales.get(locale)).containsKey(key)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getLocaleValue(String key, String locale) {
        if (this.locales == null) {
            return null;
        }
        Map localeMap = (Map)this.locales.get(locale);
        if (localeMap == null) {
            locale = LocaleUtils.getMappingLocals((String)locale);
            localeMap = (Map)this.locales.get(locale);
        }
        if (localeMap == null) {
            return null;
        }
        return localeMap.get(key);
    }

    @Override
    public Object getPropertyValue(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    @Override
    public Object getStateValue(String key) {
        return this.values.get(key);
    }

    @Override
    public boolean isEmpty() {
        if (!this.values.isEmpty()) {
            return false;
        }
        if (this.locales != null) {
            for (Map.Entry ls : this.locales.entrySet()) {
                Map values = (Map)ls.getValue();
                if (values.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Enumeration keys() {
        HashSet keys = new HashSet();
        keys.addAll(this.values.keySet());
        if (this.locales != null) {
            for (Map.Entry ls : this.locales.entrySet()) {
                Map values = (Map)ls.getValue();
                Iterator it2 = values.keySet().iterator();
                while (it2.hasNext()) {
                    keys.add(it2.next());
                }
            }
        }
        Object[] ks = keys.toArray();
        return new PropertyContainer.InnerEnumeration(ks);
    }

    @Override
    public Object setStateValue(String key, Object value) {
        return this.values.put(key, value);
    }

    public Object remove(String key) {
        return this.values.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setLocaleValue(String key, Object value, String locale) {
        Map localeMap;
        if (this.locales == null) {
            MapStateManager mapStateManager = this;
            synchronized (mapStateManager) {
                if (this.locales == null) {
                    this.locales = new ConcurrentSortedStringObjectMap(2);
                }
            }
        }
        if ((localeMap = (Map)this.locales.get(locale)) == null) {
            MapStateManager mapStateManager = this;
            synchronized (mapStateManager) {
                localeMap = (Map)this.locales.get(locale);
                if (localeMap == null) {
                    localeMap = new SortedStringObjectMap(3);
                    this.locales.put(locale, localeMap);
                }
            }
        }
        return localeMap.put(key, value);
    }

    @Override
    public Object setPropertyValue(String key, Object value) {
        this.checkProperties();
        return this.properties.put(key, value);
    }

    @Override
    public int size() {
        HashSet keys = new HashSet();
        keys.addAll(this.values.keySet());
        if (this.locales != null) {
            for (Map.Entry ls : this.locales.entrySet()) {
                Map values = (Map)ls.getValue();
                Iterator it2 = values.keySet().iterator();
                while (it2.hasNext()) {
                    keys.add(it2.next());
                }
            }
        }
        return keys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProperties() {
        if (this.properties != null) {
            return;
        }
        MapStateManager mapStateManager = this;
        synchronized (mapStateManager) {
            if (this.properties == null) {
                this.properties = new ConcurrentSortedStringObjectMap(1);
            }
        }
    }

    @Override
    public Object removeSateValue(String key) {
        return this.values.remove(key);
    }

    @Override
    public boolean containsStateKey(String key) {
        return this.values.containsKey(key);
    }

    @Override
    public Object removeLocaleValue(String key, String locale) {
        if (this.locales == null || !this.locales.containsKey(locale)) {
            return null;
        }
        return ((Map)this.locales.get(locale)).remove(key);
    }

    @Override
    public boolean containsLocaleKey(String key, String locale) {
        if (this.locales == null || !this.locales.containsKey(locale)) {
            return false;
        }
        return ((Map)this.locales.get(locale)).containsKey(key);
    }

    @Override
    public Object removePropertyValue(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.remove(key);
    }

    @Override
    public void clearExtendPropertyValues() {
        this.properties = null;
    }

    @Override
    public boolean containsExtendedPropertyKey(String key) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(key);
    }

    @Override
    public Map getExtendedProperties() {
        this.checkProperties();
        return this.properties;
    }

    @Override
    public void trimToSize() {
        this.values.trimToSize();
        if (this.properties != null) {
            this.properties.trimToSize();
        }
        if (this.locales != null) {
            this.locales.trimToSize();
            for (Map.Entry entry : this.locales.entrySet()) {
                SortedStringObjectMap sm = (SortedStringObjectMap)entry.getValue();
                if (sm == null) continue;
                sm.trimToSize();
            }
        }
    }

    public int hashCode() {
        int rtv = this.values.keySet().hashCode();
        if (this.locales != null) {
            rtv += this.locales.hashCode();
        }
        if (this.properties != null) {
            rtv += this.properties.hashCode();
        }
        return rtv;
    }

    private static IStateManager getMapStateManager(IStateManager stateManager) {
        if (stateManager == null) {
            return null;
        }
        IStateManager ism = stateManager;
        if (ism instanceof IProxyStateManager) {
            ism = ((IProxyStateManager)ism).getNoProxyDelegate();
        }
        if (ism instanceof DynamicStateManager) {
            ism = ((DynamicStateManager)ism).getStateManager();
        }
        return ism;
    }

    public boolean equals(Object that) {
        PropertyContainer.IdentityStack thisRefStack = new PropertyContainer.IdentityStack();
        PropertyContainer.IdentityStack thatRefStack = new PropertyContainer.IdentityStack();
        return MapStateManager.equalsValue(this, that, thisRefStack, thatRefStack);
    }

    private static final boolean equalsValue(MapStateManager thisObject, Object thatObject, PropertyContainer.IdentityStack thisRefStack, PropertyContainer.IdentityStack thatRefStack) {
        if (thatObject == thisObject) {
            return true;
        }
        if (thatObject == null || !(thatObject instanceof IStateManager)) {
            return false;
        }
        if ((thatObject = MapStateManager.getMapStateManager((IStateManager)thatObject)) == thisObject) {
            return true;
        }
        int thisRefDeepth = thisRefStack.search((Object)thisObject);
        int thatRefDeepth = thatRefStack.search(thatObject);
        if (thisRefDeepth >= 0) {
            return thisRefDeepth == thatRefDeepth;
        }
        thisRefStack.push((Object)thisObject);
        thatRefStack.push(thatObject);
        ConcurrentSortedStringObjectMap thisLocale = thisObject.locales;
        ConcurrentSortedStringObjectMap thatLocale = ((MapStateManager)thatObject).locales;
        if (thisLocale == null ? thatLocale != null : !thisLocale.equals((Object)thatLocale)) {
            return false;
        }
        ConcurrentSortedStringObjectMap thisProps = thisObject.properties;
        ConcurrentSortedStringObjectMap thatProps = ((MapStateManager)thatObject).properties;
        if (thisProps == null ? thatProps != null : !thisProps.equals((Object)thatProps)) {
            return false;
        }
        ConcurrentSortedStringObjectMap thisValues = thisObject.values;
        ConcurrentSortedStringObjectMap thatValues = ((MapStateManager)thatObject).values;
        if (thisValues.size() != thatValues.size()) {
            return false;
        }
        try {
            for (Map.Entry e : thisValues.entrySet()) {
                Object thisKey = e.getKey();
                Object thisValue = e.getValue();
                if (thisValue == null) {
                    if (thatValues.get(thisKey) == null && thatValues.containsKey(thisKey)) continue;
                    return false;
                }
                if (thisValue instanceof AbstractMDValue) {
                    Object thatValueObj = thatValues.get(thisKey);
                    if (thatValueObj != null && thatValueObj instanceof AbstractMDValue) {
                        IStateManager asm;
                        IStateManager ism = MapStateManager.getMapStateManager(((AbstractMDValue)thisValue).getStateManager());
                        if (MapStateManager.equalsValue((MapStateManager)ism, asm = ((AbstractMDValue)thatValueObj).getStateManager(), thisRefStack, thatRefStack)) continue;
                        return false;
                    }
                    return false;
                }
                if (!(thisValue instanceof IObjectCollection ? !MapStateManager.equalsCollection((IObjectCollection)thisValue, thatValues.get(thisKey), thisRefStack, thatRefStack) : !thisValue.equals(thatValues.get(thisKey)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        thisRefStack.pop();
        thatRefStack.pop();
        return true;
    }

    private static final boolean equalsCollection(IObjectCollection thisCollection, Object thatCollection, PropertyContainer.IdentityStack thisRefStack, PropertyContainer.IdentityStack thatRefStack) {
        if (thatCollection == null) {
            return false;
        }
        if (thatCollection == thisCollection) {
            return true;
        }
        if (!(thatCollection instanceof IObjectCollection)) {
            return false;
        }
        if (!thisCollection.getClass().getName().equals(thatCollection.getClass().getName())) {
            return false;
        }
        int size = thisCollection.size();
        if (((IObjectCollection)thatCollection).size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            AbstractObjectValue thisObject = (AbstractObjectValue)thisCollection.getObject(i);
            IObjectValue thatObject = ((IObjectCollection)thatCollection).getObject(i);
            IStateManager thisIsm = null;
            if (thisObject != null) {
                thisIsm = MapStateManager.getMapStateManager(((AbstractMDValue)thisObject).getStateManager());
            }
            IStateManager thatIsm = ((AbstractMDValue)thatObject).getStateManager();
            if (thisObject != null ? MapStateManager.equalsValue((MapStateManager)thisIsm, thatIsm, thisRefStack, thatRefStack) : thatObject == null) continue;
            return false;
        }
        return true;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        this.values.marshal(marshaller);
        marshaller.writeObject((Object)this.locales);
        marshaller.writeObject((Object)this.properties);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.values.unmarshal(unmarshaller);
        this.locales = (ConcurrentSortedStringObjectMap)((Object)unmarshaller.readObject());
        this.properties = (ConcurrentSortedStringObjectMap)((Object)unmarshaller.readObject());
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }

    Locale[] getCurrentLocales() {
        if (this.locales != null) {
            String[] locStrings = this.locales.keySet().toArray(new String[0]);
            Locale[] locs = new Locale[locStrings.length];
            int n = locs.length;
            for (int i = 0; i < n; ++i) {
                locs[i] = LocaleUtils.getLocale((String)locStrings[i]);
            }
            return locs;
        }
        return new Locale[0];
    }

    public String toString() {
        String s = this.getClass().getName();
        if (this.values != null) {
            s = s + "\n" + this.values.toString();
        }
        return s;
    }

    public static final class ConcurrentSortedStringObjectMap
    extends SortedStringObjectMap {
        private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

        public ConcurrentSortedStringObjectMap() {
        }

        public ConcurrentSortedStringObjectMap(int initialCapacity) {
            super(initialCapacity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object key, Object value) {
            this.rwl.writeLock().lock();
            try {
                Object object = super.put(key, value);
                return object;
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }

        public Object remove(Object key) {
            this.rwl.writeLock().lock();
            try {
                Object object = super.remove(key);
                return object;
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }

        public boolean containsKey(Object key) {
            this.rwl.readLock().lock();
            try {
                boolean bl = super.containsKey(key);
                return bl;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }

        public boolean containsValue(Object value) {
            this.rwl.readLock().lock();
            try {
                boolean bl = super.containsValue(value);
                return bl;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }

        public void clear() {
            this.rwl.writeLock().lock();
            try {
                super.clear();
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }

        public void trimToSize() {
            this.rwl.writeLock().lock();
            try {
                super.trimToSize();
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }

        public void marshal(Marshaller marshaller) throws IOException {
            this.rwl.readLock().lock();
            try {
                super.marshal(marshaller);
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }

        public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
            this.rwl.writeLock().lock();
            try {
                super.unmarshal(unmarshaller);
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
    }
}

