/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.difftool;

import com.kingdee.bos.engine.difftool.FileMetaInfo;
import com.kingdee.bos.engine.difftool.PathEntry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class DirPath
implements PathEntry {
    private final File root;
    private Map entrys = new HashMap();

    public DirPath(File dir) {
        this.root = dir;
    }

    @Override
    public void init() {
        Stack paths = new Stack();
        this.processDir(this.root, this.entrys, paths);
    }

    private void processDir(File dir, Map seen, Stack paths) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                paths.push(file.getName());
                this.processDir(file, seen, paths);
                paths.pop();
                continue;
            }
            if (!file.isFile()) continue;
            String name = file.getName();
            String fullname = DirPath.joinPath(paths, name);
            FileMetaInfo fmi = new FileMetaInfo();
            fmi.entryName = fullname;
            fmi.loader = this;
            fmi.length = file.length();
            fmi.st = file.lastModified();
            seen.put(fullname, fmi);
        }
    }

    @Override
    public Map getEntrysMap() {
        return this.entrys;
    }

    private static String joinPath(Stack paths, String name) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < paths.size(); ++i) {
            String path = (String)paths.get(i);
            buff.append(path);
            buff.append("/");
        }
        buff.append(name);
        return buff.toString();
    }

    @Override
    public InputStream getEntryInputStream(String name) throws IOException {
        File file = new File(this.root, name);
        if (file.isFile()) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        return null;
    }
}

