/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.difftool;

import com.kingdee.bos.engine.difftool.FileMetaInfo;
import com.kingdee.bos.metadata.util.XmlUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.jdom2.Document;

public class Log {
    private final File root;
    private File diff;

    Log(File root) {
        this.root = root;
        this.diff = new File(root, "diff");
        this.diff.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logFile(String entry, Document dom) throws IOException {
        File file = new File(this.diff, entry);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            XmlUtils.output(dom, os);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logFiles(Map entrys) throws IOException {
        Writer writer = null;
        Set logs = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File(this.root, "FileAdd.txt")));
            logs = (Set)entrys.get("Add");
            for (FileMetaInfo fmi : logs) {
                writer.write(fmi.entryName);
                writer.write("\n");
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException it) {}
                try {
                    writer.close();
                }
                catch (IOException it) {}
            }
        }
        try {
            writer = new BufferedWriter(new FileWriter(new File(this.root, "FileDel.txt")));
            logs = (Set)entrys.get("Del");
            for (FileMetaInfo fmi : logs) {
                writer.write(fmi.entryName);
                writer.write("\n");
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException it) {}
                try {
                    writer.close();
                }
                catch (IOException it) {}
            }
        }
        try {
            writer = new BufferedWriter(new FileWriter(new File(this.root, "FileMaybeModify.txt")));
            logs = (Set)entrys.get("Mod");
            for (FileMetaInfo fmi : logs) {
                writer.write(Log.detailMessage(fmi.status));
                writer.write(fmi.entryName);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException iOException) {}
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String detailMessage(int status) {
        switch (status) {
            case 3: {
                return "\nReal Changed    ";
            }
            case 2: {
                return "\nNOT  Changed    ";
            }
            case 1: {
                return "\nNOT XML Diff    ";
            }
        }
        return "\nMaybe Changed   ";
    }
}

