/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.difftool;

import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.engine.difftool.Differ;
import com.kingdee.bos.engine.difftool.InnerIDChangedMetaData;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.PKIndexs;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;

public class MDUpgradeChecker {
    private static Logger log = Logger.getLogger(MDUpgradeChecker.class);
    private static String comma = ",";
    private static String innerID = "innerID";
    public static final String M1_PRETREATMENT = "m1m";
    public static final String CHECK_RESTRICT = "checkRestrict";
    public static final String CHECK_TABLE_RESTRICT = "checkTableRestrict";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mdDelete(File source, File des) {
        log.info((Object)"mdDelete start...");
        LowTimer time = new LowTimer();
        PrintWriter writer = null;
        BufferedReader reader = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(des)));
            reader = new BufferedReader(new FileReader(source));
            writer.println("\u5305\u540d,\u88ab\u5220\u9664\u7684\u5143\u6570\u636e");
            String s = null;
            while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).equals("") || !MDUpgradeChecker.endsWith(s)) continue;
                int index = s.indexOf("/eas/");
                if (index == -1) {
                    index = s.indexOf("/bos/");
                }
                String pkg = s.substring(0, s.indexOf("/", index + 5));
                writer.print(pkg);
                writer.print(comma);
                writer.println(s);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
            if (writer != null) {
                writer.close();
            }
        }
        log.info((Object)("mdDelete used " + (int)time.Value() + " seconds"));
    }

    private static boolean endsWith(String s) {
        return s.endsWith("entity") || s.endsWith("facade") || s.endsWith("ui") || s.endsWith("table") || s.endsWith("relation") || s.endsWith("exception") || s.endsWith("enum") || s.endsWith("resource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mdModify(File path, File des) {
        log.info((Object)"mdModify start...");
        LowTimer time = new LowTimer();
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(des)));
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || MDUpgradeChecker.endsWith(pathname.getName());
                }
            };
            writer.println("\u5305\u540d,\u88ab\u4fee\u6539\u7684\u5143\u6570\u636e,\u8bf4\u660e");
            MDUpgradeChecker.mdModify0(path, filter, writer);
        }
        log.info((Object)("mdModify used " + (int)time.Value() + " seconds"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mdModify0(File file, FileFilter filter, PrintWriter writer) {
        File[] children = file.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                MDUpgradeChecker.mdModify0(child, filter, writer);
                continue;
            }
            int index = child.getName().lastIndexOf(46);
            String type = child.getName().substring(index + 1);
            HashMap info = new HashMap();
            FileInputStream is = null;
            Element root = null;
            try {
                is = new FileInputStream(child);
                root = XMLParser.parseXML((InputStream)is).getRootElement();
                Namespace ns = root.getNamespace();
                String pkg = root.getChildText("package", ns);
                String name = root.getChildText("name", ns);
                boolean restrict = true;
                if (type.equals("table")) {
                    restrict = MDUpgradeChecker.checkRestrict4TableOrResource(root, ns, "column", info);
                } else if (type.equals("resource")) {
                    restrict = MDUpgradeChecker.checkRestrict4TableOrResource(root, ns, "resourceItem", info);
                } else if (type.equals("entity")) {
                    restrict = MDUpgradeChecker.checkRestrict4Entity(root, ns, info);
                } else if (type.equals("facade")) {
                    restrict = MDUpgradeChecker.checkRestrict4Facade(root, ns, info);
                } else if (type.equals("ui")) {
                    restrict = MDUpgradeChecker.checkRestrict4UI(root, ns, info);
                } else if (type.equals("enum")) {
                    restrict = MDUpgradeChecker.checkRestrict4Enum(root, ns, info);
                } else if (type.equals("exception")) {
                    restrict = MDUpgradeChecker.checkRestrict4Exception(root, ns, info);
                } else {
                    List eles = root.getChildren();
                    for (Element childEle : eles) {
                        if (MDUpgradeChecker.checkRestrict(childEle)) continue;
                        restrict = false;
                    }
                }
                if (restrict) continue;
                int index2 = pkg.indexOf(".eas.");
                if (index2 == -1) {
                    index2 = pkg.indexOf(".bos.");
                }
                String tmp = pkg.substring(0, pkg.indexOf(".", index2 + 5));
                writer.print(tmp);
                writer.print(comma);
                writer.print(pkg.replaceAll("\\.", "/") + "/" + name + "." + type);
                writer.print(comma);
                if (info.size() > 0) {
                    for (Map.Entry entry : info.entrySet()) {
                        writer.print(entry.getKey() + "  ");
                        writer.print(entry.getValue() + "; ");
                    }
                } else {
                    writer.print("MODIFY");
                }
                writer.println();
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
    }

    private static boolean checkRestrict(Element ele) {
        String name = ele.getName();
        if (name.equals("package") || name.equals("name") || name.equals("resource")) {
            return true;
        }
        String diff = ele.getAttributeValue("_DIFF_RESULT");
        if ("DELETE".equals(diff) || "MODIFY".equals(diff)) {
            return false;
        }
        List children = ele.getChildren();
        for (Element childEle : children) {
            if (MDUpgradeChecker.checkRestrict(childEle)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkRestrict4TableOrResource(Element root, Namespace ns, String name, Map info) {
        boolean restrict = true;
        Element columns = root.getChild(name + "s", ns);
        if (columns != null) {
            List colList = columns.getChildren(name, ns);
            for (Element column : colList) {
                String diff = column.getAttributeValue("_DIFF_RESULT");
                if (!"DELETE".equals(diff) && !"MODIFY".equals(diff)) continue;
                restrict = false;
                info.put(name + " : " + column.getChildText("name", ns), diff);
            }
        }
        return restrict;
    }

    private static boolean checkRestrict4Entity(Element root, Namespace ns, Map info) {
        Element key;
        String diff;
        Element bentity;
        boolean restrict = true;
        if (!MDUpgradeChecker.check(root, ns, info, "properties")) {
            restrict = false;
        }
        if (!MDUpgradeChecker.checkMethodIgnoreInnerID(root, ns, info, "methods")) {
            restrict = false;
        }
        if (!MDUpgradeChecker.check(root, ns, info, "events")) {
            restrict = false;
        }
        if ((bentity = root.getChild("baseEntity", ns)) != null && ("DELETE".equals(diff = bentity.getAttributeValue("_DIFF_RESULT")) || "MODIFY".equals(diff))) {
            restrict = false;
            info.put(bentity.getName(), diff);
        }
        if ((key = root.getChild("logicalKey", ns)) != null) {
            restrict = false;
            info.put("logicalKey", "MODIFY");
        }
        return restrict;
    }

    private static boolean checkRestrict4Facade(Element root, Namespace ns, Map info) {
        String diff;
        Element bentity;
        boolean restrict = true;
        if (!MDUpgradeChecker.check(root, ns, info, "methods")) {
            restrict = false;
        }
        if ((bentity = root.getChild("baseEntity", ns)) != null && ("DELETE".equals(diff = bentity.getAttributeValue("_DIFF_RESULT")) || "MODIFY".equals(diff))) {
            restrict = false;
            info.put(bentity.getName(), diff);
        }
        return restrict;
    }

    private static boolean checkRestrict4UI(Element root, Namespace ns, Map info) {
        boolean restrict = true;
        if (!MDUpgradeChecker.check(root, ns, info, "components")) {
            restrict = false;
        }
        if (!MDUpgradeChecker.check(root, ns, info, "actions")) {
            restrict = false;
        }
        return restrict;
    }

    private static boolean checkRestrict4Enum(Element root, Namespace ns, Map info) {
        boolean restrict = true;
        if (!MDUpgradeChecker.check(root, ns, info, "enumValues")) {
            restrict = false;
        }
        return restrict;
    }

    private static boolean checkRestrict4Exception(Element root, Namespace ns, Map info) {
        boolean restrict = true;
        if (!MDUpgradeChecker.check(root, ns, info, "bizExceptionSubItems")) {
            restrict = false;
        }
        return restrict;
    }

    private static boolean check(Element root, Namespace ns, Map info, String eleName) {
        boolean restrict = true;
        Element elements = root.getChild(eleName, ns);
        if (elements != null) {
            List eleList = elements.getChildren();
            for (Element ele : eleList) {
                String diff = ele.getAttributeValue("_DIFF_RESULT");
                if (!"DELETE".equals(diff) && !"MODIFY".equals(diff)) continue;
                restrict = false;
                info.put(ele.getName() + " : " + ele.getChildText("name", ns), diff);
            }
        }
        return restrict;
    }

    private static boolean checkMethodIgnoreInnerID(Element root, Namespace ns, Map info, String eleName) {
        boolean restrict = true;
        Element elements = root.getChild(eleName, ns);
        if (elements != null) {
            List eleList = elements.getChildren("method", ns);
            ArrayList sign = new ArrayList();
            MDUpgradeChecker.sign(elements, ns, sign);
            int n = eleList.size();
            for (int i = 0; i < n; ++i) {
                String diff;
                Element ele = (Element)eleList.get(i);
                if (ele == null || !"ADD".equals(diff = ele.getAttributeValue("_DIFF_RESULT"))) continue;
                String name = ele.getChildText("name", ns);
                for (int j = 0; j < n; ++j) {
                    Element ele2 = (Element)eleList.get(i);
                    if (ele2 == null) continue;
                    String diff2 = ele2.getAttributeValue("_DIFF_RESULT");
                    String name2 = ele2.getChildText("name", ns);
                    if (!"DELETE".equals(diff2) || !name.equals(name2) || !sign.get(i).equals(sign.get(j))) continue;
                    eleList.set(j, null);
                }
            }
            for (Element ele : eleList) {
                String diff;
                if (ele == null || !"DELETE".equals(diff = ele.getAttributeValue("_DIFF_RESULT")) && !"MODIFY".equals(diff)) continue;
                restrict = false;
                info.put(ele.getName() + " : " + ele.getChildText("name", ns), diff);
            }
        }
        return restrict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getBigPackageName(File source, File des) {
        PrintWriter writer = null;
        BufferedReader reader = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(des)));
            reader = new BufferedReader(new FileReader(source));
            String s = null;
            while ((s = reader.readLine()) != null) {
                int index = (s = s.trim()).indexOf("/eas/");
                if (index == -1) {
                    index = s.indexOf("/bos/");
                }
                s = s.substring(0, s.indexOf("/", index + 5));
                writer.println(s);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void split(File source, File des1, File des2) {
        PrintWriter writer1 = null;
        PrintWriter writer2 = null;
        BufferedReader reader = null;
        try {
            writer1 = new PrintWriter(new BufferedWriter(new FileWriter(des1)));
            writer2 = new PrintWriter(new BufferedWriter(new FileWriter(des2)));
            reader = new BufferedReader(new FileReader(source));
            String s = null;
            while ((s = reader.readLine()) != null) {
                int index = (s = s.trim()).indexOf("    ");
                if (index > 0) {
                    writer1.println(s.substring(0, index));
                    writer2.println(s.substring(index + 4));
                    continue;
                }
                writer1.println(s);
                writer2.println();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (writer1 != null) {
                    writer1.close();
                }
                if (writer2 != null) {
                    writer2.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void methodInnerIDReplace(File m1, File m2) {
        log.info((Object)"Start methodInnerIDReplace...");
        HashMap idMap = new HashMap();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".entity");
            }
        };
        if (MDUpgradeChecker.containJar(m2)) {
            ArrayList jarList = new ArrayList();
            File sp = new File(m2, "sp");
            MDUpgradeChecker.addJarFile(sp, jarList);
            File industry = new File(m2, "industry");
            MDUpgradeChecker.addJarFile(industry, jarList);
            MDUpgradeChecker.addJarFile(m2, jarList);
            JarFile[] jf = new JarFile[jarList.size()];
            jarList.toArray(jf);
            MDUpgradeChecker.methodInnerIDReplace1(m1, jf, filter, idMap);
            for (int i = 0; i < jf.length; ++i) {
                try {
                    jf[i].close();
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        } else {
            MDUpgradeChecker.methodInnerIDReplace0(m1, m2, filter, idMap);
        }
        if (idMap.size() < 1) {
            log.info((Object)"End methodInnerIDReplace.");
            return;
        }
        log.info((Object)("innerIDMap : " + idMap));
        FileFilter filter2 = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".log") || pathname.getName().endsWith(".permission") || pathname.getName().endsWith(".function");
            }
        };
        MDUpgradeChecker.innerIDReplace(m1, filter2, idMap);
        log.info((Object)"End methodInnerIDReplace.");
    }

    private static void addJarFile(File dir, List jarList) {
        if (dir.exists()) {
            File[] children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (!MDUpgradeChecker.isJar(child)) continue;
                try {
                    jarList.add(new JarFile(child));
                    continue;
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private static boolean containJar(File dir) {
        boolean jar = false;
        File[] children = dir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory() || !child.getName().endsWith(".jar")) continue;
            jar = true;
            break;
        }
        return jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodInnerIDReplace0(File m1, File m2, FileFilter filter, Map idMap) {
        File[] childrenM1 = m1.listFiles(filter);
        File[] childrenM2 = m2.listFiles(filter);
        for (int i = 0; i < childrenM1.length; ++i) {
            File childM1 = childrenM1[i];
            File childM2 = null;
            for (int j = 0; j < childrenM2.length; ++j) {
                if (!childM1.getName().equalsIgnoreCase(childrenM2[j].getName())) continue;
                childM2 = childrenM2[j];
                break;
            }
            if (childM2 == null) continue;
            if (childM1.isDirectory()) {
                MDUpgradeChecker.methodInnerIDReplace0(childM1, childM2, filter, idMap);
                continue;
            }
            if (childM1.length() == childM2.length() && childM1.lastModified() == childM2.lastModified()) continue;
            FileInputStream fis1 = null;
            FileInputStream fis2 = null;
            try {
                fis1 = new FileInputStream(childM1);
                fis2 = new FileInputStream(childM2);
                MDUpgradeChecker.methodInnerIDReplace(fis1, fis2, idMap, childM1);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (fis1 != null) {
                        fis1.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close FileInputStream error!", (Throwable)e);
                }
                try {
                    if (fis2 != null) {
                        fis2.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close FileInputStream error!", (Throwable)e);
                }
            }
        }
    }

    private static void sign(Element methods, Namespace ns, Map sign) {
        List methodListM1 = methods.getChildren("method", ns);
        for (Element method : methodListM1) {
            StringBuffer sb = new StringBuffer(method.getChildText("name", ns));
            sb.append("(");
            Element parameters = method.getChild("parameters", ns);
            if (parameters != null) {
                List paraList = parameters.getChildren("parameter", ns);
                for (Element para : paraList) {
                    sb.append(para.getChildText("dataType", ns)).append(";");
                }
            }
            sb.append(")");
            sign.put(sb.toString(), method);
        }
    }

    private static void sign(Element methods, Namespace ns, List sign) {
        List methodListM1 = methods.getChildren("method", ns);
        int n = methodListM1.size();
        for (int i = 0; i < n; ++i) {
            Element method = (Element)methodListM1.get(i);
            StringBuffer sb = new StringBuffer(method.getChildText("name", ns));
            sb.append("(");
            Element parameters = method.getChild("parameters", ns);
            if (parameters != null) {
                List paraList = parameters.getChildren("parameter", ns);
                for (Element para : paraList) {
                    sb.append(para.getChildText("dataType", ns)).append(";");
                }
            }
            sb.append(")");
            sign.add(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void innerIDReplace(File m1, FileFilter filter, Map idMap, Pattern pattern) {
        File[] childrenM1 = m1.listFiles(filter);
        for (int i = 0; i < childrenM1.length; ++i) {
            File childM1 = childrenM1[i];
            if (childM1.isDirectory()) {
                MDUpgradeChecker.innerIDReplace(childM1, filter, idMap, pattern);
                continue;
            }
            boolean modify = false;
            PrintWriter writer = null;
            BufferedReader reader = null;
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(childM1), Charset.forName("UTF-8")));
                String s = null;
                while ((s = reader.readLine()) != null) {
                    sb.append(s).append("\r\n");
                }
                reader.close();
                Matcher m = pattern.matcher(sb);
                while (m.find()) {
                    m.appendReplacement(sb2, (String)idMap.get(m.group()));
                    modify = true;
                }
                m.appendTail(sb2);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
            try {
                if (!modify) continue;
                writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(childM1), Charset.forName("UTF-8"))));
                writer.print(sb2.toString());
                log.info((Object)(childM1 + " is modified!"));
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private static void innerIDReplace(File m1, FileFilter filter, Map idMap) {
        File[] childrenM1 = m1.listFiles(filter);
        for (int i = 0; i < childrenM1.length; ++i) {
            File childM1 = childrenM1[i];
            if (childM1.isDirectory()) {
                MDUpgradeChecker.innerIDReplace(childM1, filter, idMap);
                continue;
            }
            try {
                MDUpgradeChecker.innerIDReplace0(new FileInputStream(childM1), idMap, childM1);
                continue;
            }
            catch (FileNotFoundException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void innerIDReplace0(InputStream m1Is, Map idMap, File out) {
        boolean modify = false;
        PrintWriter writer = null;
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer();
        try {
            reader = new BufferedReader(new InputStreamReader(m1Is, Charset.forName("UTF-8")));
            String s = null;
            while ((s = reader.readLine()) != null) {
                for (Map.Entry entry : idMap.entrySet()) {
                    String innerID = (String)entry.getKey();
                    if (s.indexOf(innerID) < 0) continue;
                    s = s.replaceAll(innerID, (String)entry.getValue());
                    modify = true;
                    break;
                }
                sb.append(s).append("\r\n");
            }
            reader.close();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        try {
            if (modify) {
                if (!out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), Charset.forName("UTF-8"))));
                writer.print(sb.toString());
                log.info((Object)(out + " is modified!"));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodInnerIDReplace1(File m1, JarFile[] m2, FileFilter filter, Map idMap) {
        File[] childrenM1 = m1.listFiles(filter);
        for (int i = 0; i < childrenM1.length; ++i) {
            File childM1 = childrenM1[i];
            if (childM1.isDirectory()) {
                MDUpgradeChecker.methodInnerIDReplace1(childM1, m2, filter, idMap);
                continue;
            }
            String name = childM1.getPath().substring(childM1.getPath().indexOf("com"));
            name = name.replaceAll("\\\\", "/");
            JarFile jar = null;
            ZipEntry jarEntry = null;
            for (int j = 0; j < m2.length && ((jar = m2[j]) == null || (jarEntry = jar.getJarEntry(name)) == null); ++j) {
            }
            if (jarEntry == null || childM1.length() == jarEntry.getSize() && childM1.lastModified() == jarEntry.getTime()) continue;
            InputStream is = null;
            try {
                is = jar.getInputStream(jarEntry);
                MDUpgradeChecker.methodInnerIDReplace(new FileInputStream(childM1), is, idMap, childM1);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private static void methodInnerIDReplace(InputStream isM1, InputStream isM2, Map idMap, File out) throws Exception {
        BufferedInputStream bisM1 = new BufferedInputStream(isM1);
        Document docM1 = XMLParser.parseXML((InputStream)bisM1);
        bisM1.close();
        Element rootM1 = docM1.getRootElement();
        BufferedInputStream bisM2 = new BufferedInputStream(isM2);
        Element rootM2 = XMLParser.parseXML((InputStream)bisM2).getRootElement();
        bisM2.close();
        Namespace nsM1 = rootM1.getNamespace();
        Namespace nsM2 = rootM2.getNamespace();
        Element methodsM1 = rootM1.getChild("methods", nsM1);
        Element methodsM2 = rootM2.getChild("methods", nsM2);
        if (methodsM1 == null || methodsM2 == null) {
            return;
        }
        HashMap signM1 = new HashMap();
        MDUpgradeChecker.sign(methodsM1, nsM1, signM1);
        HashMap signM2 = new HashMap();
        MDUpgradeChecker.sign(methodsM2, nsM2, signM2);
        boolean modify = false;
        HashMap<String, String> tmpIdMap = new HashMap<String, String>();
        for (Map.Entry entry : signM1.entrySet()) {
            Element methodM2;
            String innerIDM2;
            Element methodM1;
            String innerIDM1;
            String key = (String)entry.getKey();
            if (!signM2.containsKey(key) || (innerIDM1 = (methodM1 = (Element)entry.getValue()).getChildText(innerID, nsM1)).equals(innerIDM2 = (methodM2 = (Element)signM2.get(key)).getChildText(innerID, nsM2))) continue;
            idMap.put(innerIDM1, innerIDM2);
            tmpIdMap.put(innerIDM1, innerIDM2);
            Element clone = methodM2.clone();
            methodsM1.removeContent((Content)methodM1);
            methodsM1.addContent((Content)clone);
            modify = true;
        }
        if (modify) {
            if (!out.getParentFile().exists()) {
                out.getParentFile().mkdirs();
            }
            MDUpgradeChecker.outToFile(out, docM1);
            log.info((Object)(out + " is modified!"));
            MDUpgradeChecker.innerIDReplace0(new FileInputStream(out), tmpIdMap, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outToFile(File childM1, Document docM1) throws FileNotFoundException, IOException {
        FilterOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(childM1));
            XmlUtils.output(docM1, os);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"close BufferedOutputStream error!", (Throwable)e);
            }
        }
    }

    public static void innerIDReplace(File m1, File m2) {
        LowTimer time = new LowTimer();
        MDUpgradeChecker.methodInnerIDReplace(m1, m2);
        MDUpgradeChecker.itemInnerIDReplace(m1, m2, "log", "items", false);
        MDUpgradeChecker.itemInnerIDReplace(m1, m2, "permission", "permissionItems", true);
        log.info((Object)("innerIDReplace used " + (int)time.Value() + " seconds"));
    }

    private static boolean isJar(File f) {
        return !f.isDirectory() && f.getName().endsWith(".jar");
    }

    public static void checkTableRestrict(File m0, File m1OrM2, File out) {
        log.info((Object)"checkTableRestrict begin...");
        LowTimer time = new LowTimer();
        File[] children0 = m0.listFiles();
        JarFile[] jf0 = new JarFile[children0.length];
        for (int i = 0; i < children0.length; ++i) {
            File child = children0[i];
            if (!MDUpgradeChecker.isJar(child)) continue;
            try {
                jf0[i] = new JarFile(child);
                continue;
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (MDUpgradeChecker.containJar(m1OrM2)) {
            int i;
            File[] children = m1OrM2.listFiles();
            JarFile[] jfs = new JarFile[children.length];
            HashMap<JarFile, JarFile> jarMap = new HashMap<JarFile, JarFile>(children.length);
            for (i = 0; i < children.length; ++i) {
                File child = children[i];
                String name = child.getName();
                if (!MDUpgradeChecker.isJar(child)) continue;
                try {
                    jfs[i] = new JarFile(child);
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
                for (int j = 0; j < jf0.length; ++j) {
                    if (jf0[j] == null || !jf0[j].getName().endsWith(name)) continue;
                    jarMap.put(jfs[i], jf0[j]);
                }
            }
            MDUpgradeChecker.checkTableRestrict0(jf0, jfs, jarMap, out);
            for (i = 0; i < jfs.length; ++i) {
                try {
                    if (jfs[i] == null) continue;
                    jfs[i].close();
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        } else {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(out)));
                writer.println("\u8868\u540d,\u5217\u540d,\u5217\u5c5e\u6027,\u65e7\u503c,\u65b0\u503c");
            }
            catch (IOException e1) {
                log.error((Object)e1, (Throwable)e1);
            }
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !pathname.getName().equalsIgnoreCase("demo") || pathname.getName().endsWith(".table");
                }
            };
            MDUpgradeChecker.checkTableRestrict1(jf0, m1OrM2, writer, filter);
            writer.close();
        }
        log.info((Object)("checkTableRestrict used " + (int)time.Value() + " seconds"));
    }

    private static void checkTableRestrict1(JarFile[] jf0, File m1OrM2, PrintWriter writer, FileFilter filter) {
        File[] children = m1OrM2.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                MDUpgradeChecker.checkTableRestrict1(jf0, child, writer, filter);
                continue;
            }
            int com = child.getPath().indexOf("com");
            String name = com > 0 ? child.getPath().substring(com) : child.getName();
            name = name.replaceAll("\\\\", "/");
            JarFile jar = null;
            ZipEntry jarEntry = null;
            for (int j = 0; j < jf0.length && ((jar = jf0[j]) == null || (jarEntry = jar.getJarEntry(name)) == null); ++j) {
            }
            if (jarEntry == null || child.length() == jarEntry.getSize() && child.lastModified() == jarEntry.getTime()) continue;
            try {
                InputStream is = new BufferedInputStream(new FileInputStream(child));
                Document doc = XMLParser.parseXML((InputStream)is);
                is.close();
                Element root = doc.getRootElement();
                is = jar.getInputStream(jarEntry);
                Document doc0 = XMLParser.parseXML((InputStream)is);
                is.close();
                Element root0 = doc0.getRootElement();
                Namespace ns = root.getNamespace();
                Element columns = root.getChild("columns", ns);
                Namespace ns0 = root0.getNamespace();
                Element columns0 = root0.getChild("columns", ns0);
                if (columns == null || columns0 == null) continue;
                List colEles = columns.getChildren("column", ns);
                List colEles0 = columns0.getChildren("column", ns0);
                HashMap<String, Element> tmpMap = new HashMap<String, Element>();
                for (Element colEle : colEles0) {
                    tmpMap.put(colEle.getChildText("name", ns0), colEle);
                }
                for (Element colEle : colEles) {
                    int len0;
                    String sqlType;
                    String isNull0;
                    String colName = colEle.getChildText("name", ns);
                    Element colEle0 = (Element)tmpMap.get(colName);
                    if (colEle0 == null) continue;
                    String isNull = colEle.getChildText("isNullable", ns);
                    if ("false".equalsIgnoreCase(isNull) && "true".equalsIgnoreCase(isNull0 = colEle0.getChildText("isNullable", ns0))) {
                        writer.println(jarEntry.getName() + comma + colName + comma + "isNullable" + comma + "true" + comma + "false");
                    }
                    if ("NUMERIC".equals(sqlType = colEle.getChildText("sqlType", ns))) {
                        int precision = Integer.parseInt(colEle.getChildText("precision", ns));
                        int scale = Integer.parseInt(colEle.getChildText("scale", ns));
                        int precision0 = Integer.parseInt(colEle0.getChildText("precision", ns));
                        int scale0 = Integer.parseInt(colEle0.getChildText("scale", ns));
                        if (precision < precision0) {
                            writer.println(jarEntry.getName() + comma + colName + comma + "precision" + comma + precision0 + comma + precision);
                        }
                        if (scale >= scale0) continue;
                        writer.println(jarEntry.getName() + comma + colName + comma + "scale" + comma + scale0 + comma + scale);
                        continue;
                    }
                    String length = colEle.getChildText("length", ns);
                    String length0 = colEle0.getChildText("length", ns0);
                    int len = Integer.parseInt(length);
                    if (len >= (len0 = Integer.parseInt(length0))) continue;
                    writer.println(jarEntry.getName() + comma + colName + comma + "length" + comma + len0 + comma + len);
                }
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private static void checkTableRestrict0(JarFile[] m0, JarFile[] m1OrM2, Map jarMap, File out) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(out)));
            writer.println("\u8868\u540d,\u5217\u540d,\u5217\u5c5e\u6027,\u65e7\u503c,\u65b0\u503c");
        }
        catch (IOException e1) {
            log.error((Object)e1, (Throwable)e1);
        }
        for (int i = 0; i < m1OrM2.length; ++i) {
            JarFile jar = m1OrM2[i];
            if (jar == null) continue;
            JarFile jar0 = (JarFile)jarMap.get(jar);
            Enumeration<JarEntry> enu = jar.entries();
            while (enu.hasMoreElements()) {
                JarEntry entry = enu.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".table")) continue;
                try {
                    InputStream is = jar.getInputStream(entry);
                    Document doc = XMLParser.parseXML((InputStream)is);
                    is.close();
                    Element root = doc.getRootElement();
                    JarEntry entry0 = null;
                    if (jar0 != null) {
                        entry0 = (JarEntry)jar0.getEntry(entry.getName());
                    } else {
                        for (int j = 0; j < m0.length; ++j) {
                            if (m0[j] == null || (entry0 = (JarEntry)m0[j].getEntry(entry.getName())) == null) continue;
                            jar0 = m0[j];
                            break;
                        }
                    }
                    if (entry0 == null || entry.getSize() == entry0.getSize() && entry.getTime() == entry.getTime()) continue;
                    InputStream is0 = jar0.getInputStream(entry0);
                    Document doc0 = XMLParser.parseXML((InputStream)is0);
                    is0.close();
                    Element root0 = doc0.getRootElement();
                    Namespace ns = root.getNamespace();
                    Element columns = root.getChild("columns", ns);
                    Namespace ns0 = root0.getNamespace();
                    Element columns0 = root0.getChild("columns", ns0);
                    if (columns == null || columns0 == null) continue;
                    List colEles = columns.getChildren("column", ns);
                    List colEles0 = columns0.getChildren("column", ns0);
                    HashMap<String, Element> tmpMap = new HashMap<String, Element>();
                    for (Element colEle : colEles0) {
                        tmpMap.put(colEle.getChildText("name", ns0), colEle);
                    }
                    for (Element colEle : colEles) {
                        int len0;
                        String sqlType;
                        String isNull0;
                        String colName = colEle.getChildText("name", ns);
                        Element colEle0 = (Element)tmpMap.get(colName);
                        if (colEle0 == null) continue;
                        String isNull = colEle.getChildText("isNullable", ns);
                        if ("false".equalsIgnoreCase(isNull) && "true".equalsIgnoreCase(isNull0 = colEle0.getChildText("isNullable", ns0))) {
                            writer.println(entry.getName() + comma + colName + comma + "isNullable" + comma + "true" + comma + "false");
                        }
                        if ("NUMERIC".equals(sqlType = colEle.getChildText("sqlType", ns))) {
                            int precision = Integer.parseInt(colEle.getChildText("precision", ns));
                            int scale = Integer.parseInt(colEle.getChildText("scale", ns));
                            int precision0 = Integer.parseInt(colEle0.getChildText("precision", ns));
                            int scale0 = Integer.parseInt(colEle0.getChildText("scale", ns));
                            if (precision < precision0) {
                                writer.println(entry.getName() + comma + colName + comma + "precision" + comma + precision0 + comma + precision);
                            }
                            if (scale >= scale0) continue;
                            writer.println(entry.getName() + comma + colName + comma + "scale" + comma + scale0 + comma + scale);
                            continue;
                        }
                        String length = colEle.getChildText("length", ns);
                        String length0 = colEle0.getChildText("length", ns0);
                        int len = Integer.parseInt(length);
                        if (len >= (len0 = Integer.parseInt(length0))) continue;
                        writer.println(entry.getName() + comma + colName + comma + "length" + comma + len0 + comma + len);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        writer.close();
    }

    public static void checkRestrict(String outDir, String m0, String m1OrM2) {
        File m0f;
        File out = new File(outDir);
        if (!out.exists()) {
            out.mkdirs();
        }
        if (MDUpgradeChecker.containJar(m0f = new File(m0))) {
            m0 = m0 + "/*.jar";
        }
        String[] args = new String[]{outDir, m1OrM2, m0};
        try {
            Differ.main(args);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        if (outDir.endsWith("/") || outDir.endsWith("\\")) {
            outDir = outDir.substring(0, outDir.length() - 1);
        }
        File source = new File(outDir + "/FileDel.txt");
        File des = new File(outDir + "/MetaDataDelete.csv");
        MDUpgradeChecker.mdDelete(source, des);
        File path = new File(outDir + "/diff");
        des = new File(outDir + "/MetaDataModify.csv");
        MDUpgradeChecker.mdModify(path, des);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkBizUnit(File mdDir, File out) {
        LowTimer time = new LowTimer();
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedWriter(new FileWriter(out)));
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !pathname.getName().equalsIgnoreCase("demo") || pathname.getName().endsWith(".bizunit");
                }
            };
            writer.println("\u5143\u6570\u636e,\u5c5e\u6027,\u5efa\u8bae\u503c,\u5176\u5b83(\u4e1a\u52a1\u5355\u5143\u5f15\u7528\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5982\u679c\u5f15\u7528\u7684entity\u6216\u8005editUI\u4e0d\u5b58\u5728\uff0c\u4e00\u822c\u8fd9\u4e2a\u4e1a\u52a1\u5355\u5143\u5c31\u662f\u4e2a\u9519\u8bef\u7684\u4e1a\u52a1\u5355\u5143\u6216\u8005\u5df2\u7ecf\u5e9f\u5f03\u4e0d\u7528\u4e86\uff0c\u5efa\u8bae\u5220\u9664)");
            MDUpgradeChecker.checkBizUnit0(mdDir, mdDir, filter, writer);
        }
        log.info((Object)("checkBizUnit used " + (int)time.Value() + " seconds"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkBizUnit0(File mdDir, File current, FileFilter filter, PrintWriter writer) {
        File[] children = current.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                MDUpgradeChecker.checkBizUnit0(mdDir, child, filter, writer);
                continue;
            }
            FileInputStream is = null;
            Element root = null;
            try {
                is = new FileInputStream(child);
                root = XMLParser.parseXML((InputStream)is).getRootElement();
                Namespace ns = root.getNamespace();
                String pkg = root.getChildText("package", ns);
                String name = root.getChildText("name", ns);
                String gc = root.getChildText("genImplementCode", ns);
                if (!"false".equalsIgnoreCase(gc)) {
                    writer.println(pkg + "." + name + ".bizunit,genImplementCode,false");
                }
                MDUpgradeChecker.checkAssociate(mdDir, writer, root, pkg + "." + name, "entityPK", ".entity");
                MDUpgradeChecker.checkAssociate(mdDir, writer, root, pkg + "." + name, "listUIPK", ".ui");
                MDUpgradeChecker.checkAssociate(mdDir, writer, root, pkg + "." + name, "editUIPK", ".ui");
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAssociate(File mdDir, PrintWriter writer, Element root, String bizunit, String eleName, String suffix) {
        FileInputStream is = null;
        String pk = root.getChildText(eleName, root.getNamespace());
        try {
            if (!StringUtils.isEmpty((String)pk)) {
                String tmp = pk.replaceAll("\\.", "/") + suffix;
                File file = new File(mdDir + "/" + tmp);
                if (!file.exists()) {
                    writer.println(pk + suffix + ",bizUnitPK," + bizunit + ",not exists");
                    return;
                }
                is = new FileInputStream(file);
                Element root2 = XMLParser.parseXML((InputStream)is).getRootElement();
                String bizUnitPK = root2.getChildText("bizUnitPK", root2.getNamespace());
                if (StringUtils.isEmpty((String)bizUnitPK)) {
                    writer.println(pk + suffix + ",bizUnitPK," + bizunit);
                }
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            writer.println(pk + suffix + ",bizUnitPK," + bizunit + ",not exists");
        }
        catch (JDOMException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private static void itemInnerIDReplace(File m1, File m2, final String suffix, String eleName, boolean replaceInSelf) {
        log.info((Object)("Start " + suffix + " itemInnerIDReplace..."));
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith("." + suffix);
            }
        };
        if (MDUpgradeChecker.containJar(m2)) {
            ArrayList jarList = new ArrayList();
            File sp = new File(m2, "sp");
            MDUpgradeChecker.addJarFile(sp, jarList);
            File industry = new File(m2, "industry");
            MDUpgradeChecker.addJarFile(industry, jarList);
            MDUpgradeChecker.addJarFile(m2, jarList);
            JarFile[] jf = new JarFile[jarList.size()];
            jarList.toArray(jf);
            MDUpgradeChecker.itemInnerIDReplace1(m1, jf, filter, eleName, replaceInSelf);
            for (int i = 0; i < jf.length; ++i) {
                try {
                    if (jf[i] == null) continue;
                    jf[i].close();
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        } else {
            MDUpgradeChecker.itemInnerIDReplace0(m1, m2, filter, eleName, replaceInSelf);
        }
        log.info((Object)("End " + suffix + " itemInnerIDReplace..."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void itemInnerIDReplace0(File m1, File m2, FileFilter filter, String eleName, boolean replaceInSelf) {
        File[] childrenM1 = m1.listFiles(filter);
        File[] childrenM2 = m2.listFiles(filter);
        for (int i = 0; i < childrenM1.length; ++i) {
            File childM1 = childrenM1[i];
            File childM2 = null;
            for (int j = 0; j < childrenM2.length; ++j) {
                if (!childM1.getName().equalsIgnoreCase(childrenM2[j].getName())) continue;
                childM2 = childrenM2[j];
                break;
            }
            if (childM2 == null) continue;
            if (childM1.isDirectory()) {
                MDUpgradeChecker.itemInnerIDReplace0(childM1, childM2, filter, eleName, replaceInSelf);
                continue;
            }
            if (childM1.length() == childM2.length() && childM1.lastModified() == childM2.lastModified()) continue;
            FileInputStream fis1 = null;
            FileInputStream fis2 = null;
            try {
                fis1 = new FileInputStream(childM1);
                fis2 = new FileInputStream(childM2);
                MDUpgradeChecker.itemInnerIDReplace(fis1, fis2, eleName, replaceInSelf, childM1);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (fis1 != null) {
                        fis1.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close FileInputStream error!", (Throwable)e);
                }
                try {
                    if (fis2 != null) {
                        fis2.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close FileInputStream error!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void itemInnerIDReplace1(File m1, JarFile[] m2, FileFilter filter, String eleName, boolean replaceInSelf) {
        File[] childrenM1 = m1.listFiles(filter);
        for (int i = 0; i < childrenM1.length; ++i) {
            File childM1 = childrenM1[i];
            if (childM1.isDirectory()) {
                MDUpgradeChecker.itemInnerIDReplace1(childM1, m2, filter, eleName, replaceInSelf);
                continue;
            }
            int com = childM1.getPath().indexOf("com");
            String name = com > 0 ? childM1.getPath().substring(com) : childM1.getName();
            name = name.replaceAll("\\\\", "/");
            JarFile jar = null;
            ZipEntry jarEntry = null;
            for (int j = 0; j < m2.length && ((jar = m2[j]) == null || (jarEntry = jar.getJarEntry(name)) == null); ++j) {
            }
            if (jarEntry == null || childM1.length() == jarEntry.getSize() && childM1.lastModified() == jarEntry.getTime()) continue;
            InputStream is = null;
            FileInputStream fis = null;
            try {
                is = jar.getInputStream(jarEntry);
                fis = new FileInputStream(childM1);
                MDUpgradeChecker.itemInnerIDReplace(fis, is, eleName, replaceInSelf, childM1);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close InputStream error!", (Throwable)e);
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close FileInputStream error!", (Throwable)e);
                }
            }
        }
    }

    private static void itemInnerIDReplace(InputStream isM1, InputStream isM2, String eleName, boolean replaceInSelf, File out) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(isM1);
        Document docM1 = XMLParser.parseXML((InputStream)bis);
        Element rootM1 = docM1.getRootElement();
        bis = new BufferedInputStream(isM2);
        Document docM2 = XMLParser.parseXML((InputStream)bis);
        Element rootM2 = docM2.getRootElement();
        Namespace nsM1 = rootM1.getNamespace();
        Namespace nsM2 = rootM2.getNamespace();
        Element itemsM1 = rootM1.getChild(eleName, nsM1);
        Element itemsM2 = rootM2.getChild(eleName, nsM2);
        if (itemsM1 == null || itemsM2 == null) {
            return;
        }
        HashMap name2ElementM1 = new HashMap();
        MDUpgradeChecker.nameMap(itemsM1, nsM1, name2ElementM1);
        HashMap name2ElementM2 = new HashMap();
        MDUpgradeChecker.nameMap(itemsM2, nsM2, name2ElementM2);
        boolean modify = false;
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (Map.Entry entry : name2ElementM1.entrySet()) {
            String nameM1 = (String)entry.getKey();
            Element idM1 = (Element)entry.getValue();
            Element idM2 = (Element)name2ElementM2.get(nameM1);
            if (idM2 == null || idM1.getText().equals(idM2.getText())) continue;
            idMap.put(idM1.getText(), idM2.getText());
            idM1.setText(idM2.getText());
            modify = true;
        }
        if (modify) {
            MDUpgradeChecker.outToFile(out, docM1);
            log.info((Object)(out + " is modified!"));
            if (replaceInSelf) {
                MDUpgradeChecker.innerIDReplace0(isM1, idMap, out);
            }
        }
        bis.close();
        bis.close();
    }

    private static void nameMap(Element items, Namespace ns, Map name2Element) {
        List itemsList = items.getChildren();
        for (Element item : itemsList) {
            String name = item.getChildText("name", ns);
            name2Element.put(name, item.getChild(innerID, ns));
        }
    }

    public static void innerIDCheck(String[] oldSources, String[] newSources) {
        LowTimer time = new LowTimer();
        MetaDataClassLoader oldLoader = new MetaDataClassLoader(oldSources);
        MetaDataClassLoader newLoader = new MetaDataClassLoader(newSources);
        List errors = MDUpgradeChecker.methodInnerIDCheck(oldLoader, newLoader);
        if (errors.size() > 0) {
            log.error((Object)"Some entity innerID changed! Please correct them!");
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                log.error((Object)iterator.next().toString());
            }
            log.info((Object)("innerIDCheck used " + (int)time.Value() + " seconds"));
            throw new RuntimeException("innerID changed");
        }
        oldLoader.close();
        newLoader.close();
        log.info((Object)("innerIDCheck used " + (int)time.Value() + " seconds"));
    }

    public static List methodInnerIDCheck(MetaDataClassLoader oldLoader, MetaDataClassLoader newLoader) {
        log.info((Object)"Start methodInnerIDCheck...");
        ArrayList<InnerIDChangedMetaData> result = new ArrayList<InnerIDChangedMetaData>();
        IMetaDataPK[] newPKs = newLoader.getMDContext().pkIndexs.getMetaDataPKs(MetaDataTypeList.ENTITY);
        for (int i = 0; i < newPKs.length; ++i) {
            IMetaDataPK pk = newPKs[i];
            String spk = pk.toString().replaceAll("\\\\", "/");
            try {
                MetaDataPK2 pk2 = new MetaDataPK2(pk.getFullName(), MetaDataTypeList.ENTITY.toString());
                if (newLoader.lastModified(pk2.toString()) == oldLoader.lastModified(pk2.toString())) continue;
                URL newUrl = newLoader.findResource(spk + "." + "entity");
                URL oldUrl = oldLoader.findResource(spk + "." + "entity");
                if (oldUrl == null) continue;
                Document newdoc = XMLParser.parseXML((InputStream)newUrl.openStream());
                Element newRoot = newdoc.getRootElement();
                Element oldRoot = XMLParser.parseXML((InputStream)oldUrl.openStream()).getRootElement();
                Namespace newNs = newRoot.getNamespace();
                Namespace nsM2 = oldRoot.getNamespace();
                Element newMethods = newRoot.getChild("methods", newNs);
                Element oldMethods = oldRoot.getChild("methods", nsM2);
                if (newMethods == null || oldMethods == null) continue;
                HashMap newSign = new HashMap();
                MDUpgradeChecker.sign(newMethods, newNs, newSign);
                HashMap oldSign = new HashMap();
                MDUpgradeChecker.sign(oldMethods, nsM2, oldSign);
                for (Map.Entry entry : newSign.entrySet()) {
                    Element oldMethod;
                    String oldInnerID;
                    Element newMethod;
                    String newInnerID;
                    String key = (String)entry.getKey();
                    if (!oldSign.containsKey(key) || (newInnerID = (newMethod = (Element)entry.getValue()).getChildText(innerID, newNs)).equals(oldInnerID = (oldMethod = (Element)oldSign.get(key)).getChildText(innerID, nsM2))) continue;
                    result.add(new InnerIDChangedMetaData(pk, key, oldInnerID, newInnerID));
                }
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        log.info((Object)"End methodInnerIDCheck.");
        return result;
    }

    public static List validate(String m0, String m1, String m2) {
        log.info((Object)"Start validate...");
        LowTimer time = new LowTimer();
        ArrayList<String> rtv = new ArrayList<String>();
        String[] m0s = m0.split(";");
        String[] m1s = m1.split(";");
        String[] m2s = m2.split(";");
        for (int i = 0; i < m0s.length; ++i) {
            if (!m0s[i].endsWith("sp-bim-metas.jar")) continue;
            rtv.add("\u57fa\u7ebf\u5143\u6570\u636e\u4e0d\u5e94\u8be5\u5305\u542bsp-bim-metas.jar\uff01");
        }
        MetaDataClassLoader loader0 = new MetaDataClassLoader(m0s);
        PKIndexs pkIndexs0 = loader0.getMDContext().pkIndexs;
        IMetaDataPK[] pks = pkIndexs0.getMetaDataPKs(MetaDataTypeList.SOLUTION);
        if (pks.length == 0) {
            rtv.add("\u57fa\u7ebf\u5143\u6570\u636e\u4e0d\u5b8c\u6574: \u627e\u4e0d\u5230\u89e3\u51b3\u65b9\u6848\uff01");
        }
        if ((pks = pkIndexs0.getMetaDataPKs(MetaDataTypeList.PACKAGE)).length < 100) {
            rtv.add("\u57fa\u7ebf\u5143\u6570\u636e\u4e0d\u5b8c\u6574: \u5305\u592a\u5c11\u4e86\uff01");
        }
        MetaDataClassLoader loader1 = new MetaDataClassLoader(m1s);
        PKIndexs pkIndexs1 = loader1.getMDContext().pkIndexs;
        IMetaDataPK[] pks1 = pkIndexs1.getMetaDataPKs(MetaDataTypeList.SOLUTION);
        if (pks.length == 0) {
            rtv.add("\u5ba2\u6237\u5316\u5143\u6570\u636e\u4e0d\u5b8c\u6574: \u627e\u4e0d\u5230\u89e3\u51b3\u65b9\u6848\uff01");
        }
        if ((pks1 = pkIndexs1.getMetaDataPKs(MetaDataTypeList.PACKAGE)).length < 100) {
            rtv.add("\u5ba2\u6237\u5316\u5143\u6570\u636e\u4e0d\u5b8c\u6574: \u5305\u592a\u5c11\u4e86\uff01");
        }
        for (int i = 0; i < m2s.length; ++i) {
            if (!m2s[i].endsWith("sp-bim-metas.jar")) continue;
            rtv.add("\u65b0\u7248\u672c\u5143\u6570\u636e\u4e0d\u5e94\u8be5\u5305\u542bsp-bim-metas.jar\uff01");
        }
        MetaDataClassLoader loader2 = new MetaDataClassLoader(m2s);
        PKIndexs pkIndexs2 = loader2.getMDContext().pkIndexs;
        IMetaDataPK[] pks2 = pkIndexs2.getMetaDataPKs(MetaDataTypeList.SOLUTION);
        if (pks2.length == 0) {
            rtv.add("\u65b0\u7248\u672c\u5143\u6570\u636e\u4e0d\u5b8c\u6574: \u627e\u4e0d\u5230\u89e3\u51b3\u65b9\u6848\uff01");
        }
        if ((pks2 = pkIndexs2.getMetaDataPKs(MetaDataTypeList.PACKAGE)).length < 100) {
            rtv.add("\u65b0\u7248\u672c\u5143\u6570\u636e\u4e0d\u5b8c\u6574: \u5305\u592a\u5c11\u4e86\uff01");
        }
        loader0.close();
        loader1.close();
        loader2.close();
        log.info((Object)("End validate. used " + (int)time.Value() + "s"));
        return rtv;
    }

    public static void innerIDReplace(String m1, String m2, String mn) {
        LowTimer time = new LowTimer();
        String[] m1s = m1.split(";");
        String[] m2s = m2.split(";");
        mn = mn + "/" + M1_PRETREATMENT;
        new File(mn).mkdirs();
        MetaDataClassLoader loader1 = new MetaDataClassLoader(m1s);
        MetaDataClassLoader loader2 = new MetaDataClassLoader(m2s);
        MDUpgradeChecker.methodInnerIDReplace(loader1, loader2, mn);
        MDUpgradeChecker.itemInnerIDReplace(loader1, loader2, mn, MetaDataTypeList.LOG, "log", "items", false);
        MDUpgradeChecker.itemInnerIDReplace(loader1, loader2, mn, MetaDataTypeList.PERMISSION, "permission", "permissionItems", true);
        loader1.close();
        loader2.close();
        log.info((Object)("innerIDReplace used " + (int)time.Value() + " seconds"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void methodInnerIDReplace(MetaDataClassLoader loader1, MetaDataClassLoader loader2, String mn) {
        log.info((Object)"Start methodInnerIDReplace...");
        HashMap idMap = new HashMap();
        PKIndexs pkIndexs1 = loader1.getMDContext().pkIndexs;
        IMetaDataPK[] pks = pkIndexs1.getMetaDataPKs(MetaDataTypeList.ENTITY);
        for (int i = 0; i < pks.length; ++i) {
            IMetaDataPK pk = pks[i];
            MetaDataPK2 pk2 = new MetaDataPK2(pk.getFullName(), MetaDataTypeList.ENTITY.toString());
            InputStream is1 = null;
            InputStream is2 = null;
            try {
                if (loader1.lastModified(pk2.toString()) == loader2.lastModified(pk2.toString()) || loader2.lastModified(pk2.toString()) == -1L) continue;
                String resName = pk.getFullName().replaceAll("\\.", "/") + "." + "entity";
                is1 = loader1.getResourceAsStream(resName);
                is2 = loader2.getResourceAsStream(resName);
                MDUpgradeChecker.methodInnerIDReplace(is1, is2, idMap, new File(mn, resName));
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (is1 != null) {
                        is1.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close InputStream error!", (Throwable)e);
                }
                try {
                    if (is2 != null) {
                        is2.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close InputStream error!", (Throwable)e);
                }
            }
        }
        if (idMap.size() < 1) {
            log.info((Object)"End methodInnerIDReplace.");
            return;
        }
        log.info((Object)("innerIDMap : " + idMap));
        pks = pkIndexs1.getMetaDataPKs(MetaDataTypeList.LOG);
        MDUpgradeChecker.innerIDReplace2(pks, loader1, "log", mn, idMap);
        pks = pkIndexs1.getMetaDataPKs(MetaDataTypeList.PERMISSION);
        MDUpgradeChecker.innerIDReplace2(pks, loader1, "permission", mn, idMap);
        pks = pkIndexs1.getMetaDataPKs(MetaDataTypeList.FUNCTION);
        MDUpgradeChecker.innerIDReplace2(pks, loader1, "function", mn, idMap);
        log.info((Object)"End methodInnerIDReplace.");
    }

    private static void innerIDReplace2(IMetaDataPK[] pks, MetaDataClassLoader loader1, String suffix, String mn, Map idMap) {
        for (int i = 0; i < pks.length; ++i) {
            IMetaDataPK pk = pks[i];
            String resName = pk.getFullName().replaceAll("\\.", "/") + "." + suffix;
            MDUpgradeChecker.innerIDReplace0(loader1.getResourceAsStream(resName), idMap, new File(mn, resName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void itemInnerIDReplace(MetaDataClassLoader loader1, MetaDataClassLoader loader2, String mn, BOSObjectType type, String suffix, String eleName, boolean replaceInSelf) {
        log.info((Object)("Start " + type + " itemInnerIDReplace..."));
        IMetaDataPK[] pks = loader1.getMDContext().pkIndexs.getMetaDataPKs(type);
        for (int i = 0; i < pks.length; ++i) {
            IMetaDataPK pk = pks[i];
            MetaDataPK2 pk2 = new MetaDataPK2(pk.getFullName(), type.toString());
            InputStream is1 = null;
            InputStream is2 = null;
            try {
                if (loader1.lastModified(pk2.toString()) == loader2.lastModified(pk2.toString()) || loader2.lastModified(pk2.toString()) == -1L) continue;
                String resName = pk.getFullName().replaceAll("\\.", "/") + "." + suffix;
                is1 = loader1.getResourceAsStream(resName);
                is2 = loader2.getResourceAsStream(resName);
                MDUpgradeChecker.itemInnerIDReplace(is1, is2, eleName, replaceInSelf, new File(mn, resName));
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (is1 != null) {
                        is1.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close InputStream error!", (Throwable)e);
                }
                try {
                    if (is2 != null) {
                        is2.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"close InputStream error!", (Throwable)e);
                }
            }
        }
        log.info((Object)("End " + type + " itemInnerIDReplace..."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length >= 1) {
            if (CHECK_TABLE_RESTRICT.equalsIgnoreCase(args[0])) {
                if (args.length >= 3) {
                    File m0 = new File(args[1]);
                    File m1OrM2 = new File(args[2]);
                    File out = args.length > 3 ? new File(args[3]) : new File("\u8fdd\u53cd\u6570\u636e\u5e93\u7ea6\u675f\u5217\u8868.csv");
                    MDUpgradeChecker.checkTableRestrict(m0, m1OrM2, out);
                } else {
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream("checkTableRestrict.properties");
                        Properties prop = new Properties();
                        prop.load(is);
                        ((InputStream)is).close();
                        File m0 = new File(prop.getProperty("base").trim());
                        System.out.println("base metadata dir is " + m0.getCanonicalPath());
                        File m1OrM2 = new File(prop.getProperty("customerOrNew").trim());
                        System.out.println("customer or new metadata dir is " + m1OrM2.getCanonicalPath());
                        String ou = prop.getProperty("out");
                        File out = ou != null ? new File(ou.trim()) : new File("\u8fdd\u53cd\u6570\u636e\u5e93\u7ea6\u675f\u5217\u8868.csv");
                        System.out.println("Out file is " + out.getCanonicalPath());
                        MDUpgradeChecker.checkTableRestrict(m0, m1OrM2, out);
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                        return;
                    }
                    finally {
                        try {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                        }
                        catch (IOException e) {
                            log.error((Object)"close InputStream error!", (Throwable)e);
                        }
                    }
                }
                return;
            }
            if (CHECK_RESTRICT.equalsIgnoreCase(args[0])) {
                if (args.length > 3) {
                    MDUpgradeChecker.checkRestrict(args[3], args[1], args[2]);
                } else {
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream("checkRestrict.properties");
                        Properties prop = new Properties();
                        prop.load(is);
                        String m0 = prop.getProperty("base").trim();
                        String logdir = prop.getProperty("logdir");
                        String m1OrM2 = prop.getProperty("customerOrNew").trim();
                        MDUpgradeChecker.checkRestrict(logdir, m0, m1OrM2);
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                        return;
                    }
                    finally {
                        try {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                        }
                        catch (IOException e) {
                            log.error((Object)"close InputStream error!", (Throwable)e);
                        }
                    }
                }
                return;
            }
        }
    }
}

