/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.difftool;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PathsHelper {
    private static final Logger logger = Logger.getLogger(PathsHelper.class);
    private static Pattern p = Pattern.compile("[Ss][Pp][-]([!#$%&'+-.=@^`~\\w])*[-][Mm][Ee][Tt][Aa][Ss].jar");
    public static final String SPLIT_D = "[;" + File.pathSeparator + "]";
    public static final String SP_BIM_METAS = "sp-bim-metas.jar";
    public static final String SP_INDUSTRY_METAS = "sp-industry-metas.jar";

    public static File[] paths2File(String paths) throws IOException {
        String[] items = paths.split(SPLIT_D);
        File[] rtv = new File[items.length];
        for (int i = 0; i < items.length; ++i) {
            rtv[i] = new File(items[i]);
        }
        return rtv;
    }

    public static List expandPaths(String paths) throws IOException {
        int i;
        String[] items = paths.split(SPLIT_D);
        LinkedList rtv = new LinkedList();
        for (i = 0; i < items.length; ++i) {
            PathsHelper.expendPath(items[i], rtv);
        }
        int size = rtv.size();
        for (i = 0; i < size; ++i) {
            if (!rtv.get(i).toString().endsWith(SP_BIM_METAS)) continue;
            Object spBim = rtv.remove(i);
            rtv.add(0, spBim);
            break;
        }
        int m = -1;
        int n = -1;
        int size2 = rtv.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            if (m < 0 && rtv.get(i2).toString().endsWith(SP_INDUSTRY_METAS)) {
                m = i2;
            }
            if (n < 0 && rtv.get(i2).toString().indexOf("industry") > 0 && !rtv.get(i2).toString().endsWith(SP_INDUSTRY_METAS)) {
                n = i2;
            }
            if (m >= 0 && n >= 0) break;
        }
        if (m >= 0 && n >= 0 && m > n) {
            Object spInd = rtv.remove(m);
            rtv.add(n, spInd);
        }
        return rtv;
    }

    public static String expandPathstoString(String paths) throws IOException {
        List temp = PathsHelper.expandPaths(paths);
        StringBuffer buff = new StringBuffer();
        for (File file : temp) {
            buff.append(file.getCanonicalPath());
            buff.append(";");
        }
        return buff.toString();
    }

    private static void expendPath(String path, Collection rtv) throws IOException {
        String suffix;
        if (path == null || path.length() == 0 || path.indexOf("configure") >= 0) {
            return;
        }
        int pos = path.indexOf("*");
        if (pos == -1) {
            File testFile = new File(path);
            if (testFile.exists()) {
                try {
                    rtv.add(testFile.getCanonicalFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return;
        }
        String dir = path.substring(0, pos);
        File fdir = new File(dir);
        File[] files = fdir.listFiles(new FilenameFilter(suffix = path.substring(pos + 1)){
            final /* synthetic */ String val$suffix;
            {
                this.val$suffix = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(this.val$suffix);
            }
        });
        if (files == null) {
            logger.warn((Object)(dir + " has't " + suffix));
            return;
        }
        LinkedList<File> spJarFiles = new LinkedList<File>();
        LinkedList<File> normalJarFiles = new LinkedList<File>();
        for (int i = 0; i < files.length; ++i) {
            if (PathsHelper.isSpJarFile(files[i])) {
                spJarFiles.add(files[i].getCanonicalFile());
                continue;
            }
            normalJarFiles.add(files[i].getCanonicalFile());
        }
        Comparator fileTimeStampComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                long l2;
                assert (File.class.isInstance(o1) && File.class.isInstance(o2));
                long l1 = ((File)o1).lastModified();
                if (l1 > (l2 = ((File)o2).lastModified())) {
                    return -1;
                }
                if (1L == l2) {
                    return 0;
                }
                return 1;
            }
        };
        Collections.sort(spJarFiles, fileTimeStampComparator);
        Collections.sort(normalJarFiles, fileTimeStampComparator);
        rtv.addAll(spJarFiles);
        rtv.addAll(normalJarFiles);
    }

    private static boolean isSpJarFile(File file) {
        return p.matcher(file.getName()).matches();
    }

    public static String expandPathstoString(String paths, String excludeFile) throws IOException {
        List temp = PathsHelper.expandPaths(paths);
        StringBuffer buff = new StringBuffer();
        for (File file : temp) {
            if (file.getCanonicalPath().endsWith(excludeFile)) continue;
            buff.append(file.getCanonicalPath());
            buff.append(";");
        }
        return buff.toString();
    }

    public static String expandPathstoString(String paths, List excludeFiles) throws IOException {
        List temp = PathsHelper.expandPaths(paths);
        StringBuffer buff = new StringBuffer();
        for (File file : temp) {
            String cp = file.getCanonicalPath();
            boolean exclude = false;
            for (String excludeFile : excludeFiles) {
                if (!cp.endsWith(excludeFile)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            buff.append(file.getCanonicalPath());
            buff.append(";");
        }
        return buff.toString();
    }
}

