/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.impl;

import com.kingdee.bos.engine.impl.IResBase;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.util.BOSObjectType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Deployer {
    final IResBase root;
    Properties entityMap;
    boolean entityDirty = false;
    Properties facadeMap;
    boolean facadeDirty = false;

    Deployer(IResBase root) {
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateEntry(String entry, Document dom) throws IOException {
        OutputStream os = null;
        try {
            os = this.root.getOutputStream(entry);
            XmlUtils.output(dom, os);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (IOException iOException) {}
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    boolean addMapping(AbstractMetaDataValue metadata) {
        BOSObjectType type = metadata.getBOSType();
        if (this.check()) {
            if (MetaDataTypeList.ENTITY.equals((Object)type)) {
                BusinessObjectInfo md = (BusinessObjectInfo)metadata;
                String key = md.getType().toString();
                this.entityMap.put(key, metadata.getFullName());
                this.entityDirty = true;
                this.saveMap();
            } else if (MetaDataTypeList.FACADE.equals((Object)type)) {
                BusinessObjectInfo md = (BusinessObjectInfo)metadata;
                String key = md.getType().toString();
                this.facadeMap.put(key, metadata.getFullName());
                this.facadeDirty = true;
                this.saveMap();
            }
        }
        return false;
    }

    boolean addMapping(Document dom) {
        if (this.check()) {
            Element root = dom.getRootElement();
            Namespace ns = root.getNamespace();
            if ("entityObject".equals(root.getName())) {
                String pkg = root.getChildTextTrim("package", ns);
                String name = root.getChildTextTrim("name", ns);
                String key = root.getChildTextTrim("bosType", ns);
                this.entityMap.put(key, MetaDataPK.create(pkg, name).getFullName());
                this.entityDirty = true;
                this.saveMap();
            } else if ("facade".equals(root.getName())) {
                String pkg = root.getChildTextTrim("package", ns);
                String name = root.getChildTextTrim("name", ns);
                String key = root.getChildTextTrim("bosType", ns);
                this.facadeMap.put(key, MetaDataPK.create(pkg, name).getFullName());
                this.facadeDirty = true;
                this.saveMap();
            }
        }
        return false;
    }

    void deleteVO(BOSObjectType type, IMetaDataPK pk, String entry) throws IOException {
        this.root.deleteEntry(entry);
        if (this.check()) {
            if (MetaDataTypeList.ENTITY.equals((Object)type)) {
                String fn = pk.getFullName();
                String key = null;
                for (Map.Entry<Object, Object> item : this.entityMap.entrySet()) {
                    if (!fn.equals(item.getValue())) continue;
                    key = (String)item.getKey();
                    break;
                }
                if (key != null) {
                    this.entityMap.remove(key);
                    this.entityDirty = true;
                }
                this.saveMap();
            } else if (MetaDataTypeList.FACADE.equals((Object)type)) {
                String fn = pk.getFullName();
                String key = null;
                for (Map.Entry<Object, Object> item : this.facadeMap.entrySet()) {
                    if (!fn.equals(item.getValue())) continue;
                    key = (String)item.getKey();
                    break;
                }
                if (key != null) {
                    this.facadeMap.remove(key);
                    this.facadeDirty = true;
                }
                this.saveMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean check() {
        try {
            InputStream is;
            if (this.entityMap == null) {
                this.entityMap = new Properties();
                if (this.root.entryExist("entity_pkmapping.properties")) {
                    is = null;
                    try {
                        is = this.root.getInputStream("entity_pkmapping.properties");
                        this.entityMap.load(is);
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    this.entityDirty = false;
                }
            }
            if (this.facadeMap == null) {
                this.facadeMap = new Properties();
                if (this.root.entryExist("facade_pkmapping.properties")) {
                    is = null;
                    try {
                        is = this.root.getInputStream("facade_pkmapping.properties");
                        this.facadeMap.load(is);
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    this.facadeDirty = false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveMap() {
        if (!this.check()) {
            return false;
        }
        try {
            OutputStream os;
            if (this.entityDirty) {
                os = null;
                try {
                    os = this.root.getOutputStream("entity_pkmapping.properties");
                    this.entityMap.store(os, "Entity pk <==> bosType");
                }
                finally {
                    if (os != null) {
                        try {
                            os.flush();
                        }
                        catch (IOException iOException) {}
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                this.entityDirty = false;
            }
            if (this.facadeDirty) {
                os = null;
                try {
                    os = this.root.getOutputStream("facade_pkmapping.properties");
                    this.facadeMap.store(os, "Facade pk <==> bosType");
                }
                finally {
                    if (os != null) {
                        try {
                            os.flush();
                        }
                        catch (IOException iOException) {}
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                this.facadeDirty = false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

