/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.impl;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.engine.DevMDException;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.engine.MDLoaderException;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.engine.MDParseError;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.engine.MetadataState;
import com.kingdee.bos.engine.impl.BOSTypeHelper;
import com.kingdee.bos.engine.impl.DBWriter;
import com.kingdee.bos.engine.impl.Deployer;
import com.kingdee.bos.engine.impl.DirResBase;
import com.kingdee.bos.engine.impl.IResBase;
import com.kingdee.bos.engine.impl.JarResBase;
import com.kingdee.bos.engine.impl.MDParser2;
import com.kingdee.bos.engine.impl.MetadataXMLAssembler;
import com.kingdee.bos.engine.impl.ResEntry;
import com.kingdee.bos.engine.impl.Saver2;
import com.kingdee.bos.engine.impl.UIAssembler;
import com.kingdee.bos.engine.impl.UILoader;
import com.kingdee.bos.engine.impl.XMLException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.RuleSetCtrl;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.metadata.webcomponent.WebComponentObjectAssembler;
import com.kingdee.bos.metadata.webcomponent.WebComponentObjectCtrl;
import com.kingdee.bos.metadata.webcomponent.WebComponentObjectInfo;
import com.kingdee.bos.metadata.webcontrol.WebControlObjectAssembler;
import com.kingdee.bos.metadata.webcontrol.WebControlObjectCtrl;
import com.kingdee.bos.metadata.webcontrol.WebControlObjectInfo;
import com.kingdee.bos.metadata.webpage.WebPageObjectAssembler;
import com.kingdee.bos.metadata.webpage.WebPageObjectCtrl;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectCtrl;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class Loader2
implements IDevMetadataLoader {
    private static final Logger logger = Logger.getLogger(Loader2.class);
    public final SortedMap caches = new TreeMap();
    private final MDParser2 parser;
    private final MetadataXMLAssembler assembler;
    private final UIAssembler uiass;
    private final Saver2 saver;
    String solutionName;
    String solutionEntry;
    private SolutionInfo solution;
    Set<String> localeNames;
    private volatile int engineState = 0;
    XMLLoader metametaLoader = null;
    BOSTypeHelper typeHelper = null;
    private Deployer deployer;
    private IResBase workDir;
    private IResBase[] bases;
    private boolean merge = true;
    private ThreadLocal l = new ThreadLocal();
    private ThreadLocal link = new ThreadLocal();
    private static String USE_GLOBAL_CACHE = "useGlobalCache";
    public static final String IGNORE_SELF_JAR = "ignoreSelfJar";
    private ThreadLocal m = new ThreadLocal();
    private int count = 0;
    private PrintWriter csvWriter = null;
    private DBWriter dbWriter = null;
    private String pkgName = null;
    private boolean useCache = false;

    public Loader2(File saveDir, File[] basePaths, File exportDir, File baseTemp) {
        this(saveDir, basePaths, exportDir, baseTemp, true);
    }

    public Loader2(File saveDir, File[] basePaths, File exportDir, File baseTemp, boolean merge) {
        XMLLoader xmlLoader;
        this.merge = merge;
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)"");
        this.metametaLoader = xmlLoader = new XMLLoader(ctx, new String[0]);
        this.typeHelper = new BOSTypeHelper(xmlLoader);
        this.parser = new MDParser2(this);
        this.saver = new Saver2(this);
        this.assembler = new MetadataXMLAssembler(this.metametaLoader);
        this.uiass = new UIAssembler(this);
        if (basePaths != null) {
            ArrayList<DirResBase> tempBase = new ArrayList<DirResBase>();
            for (int i = basePaths.length - 1; i >= 0; --i) {
                IResBase res;
                File base = basePaths[i];
                if (base.isDirectory()) {
                    res = new DirResBase(base);
                    tempBase.add((DirResBase)res);
                    this.processDir(base, res, false);
                    continue;
                }
                if (!base.isFile()) continue;
                res = new JarResBase(base);
                tempBase.add((DirResBase)res);
                this.processJar(base, res);
            }
            this.bases = tempBase.toArray(new IResBase[tempBase.size()]);
        }
        if (saveDir == null) {
            throw new IllegalArgumentException("\u8bbe\u7f6e\u7684\u5f53\u524d\u5143\u6570\u636e\u5de5\u4f5c\u533a\u4e3anull\u3002");
        }
        if (!saveDir.isDirectory()) {
            throw new IllegalArgumentException("\u8bbe\u7f6e\u7684\u5f53\u524d\u5143\u6570\u636e\u5de5\u4f5c\u533a\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\u3002Detail File=" + saveDir.getPath());
        }
        this.workDir = new DirResBase(saveDir);
        this.processDir(saveDir, this.workDir, true);
        if (exportDir != null && exportDir.isDirectory()) {
            this.deployer = new Deployer(new DirResBase(exportDir));
        }
        if (!"false".equalsIgnoreCase(System.getProperty(USE_GLOBAL_CACHE))) {
            System.setProperty(USE_GLOBAL_CACHE, "true");
        }
        try {
            this.bootSolution2();
            BOSLocaleUtil.init(this.getSolution());
        }
        catch (Exception e) {
            logger.warn((Object)e, (Throwable)e);
        }
    }

    private void processJar(File file, IResBase res) {
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Enumeration<JarEntry> e = jar.entries();
            String entryName = null;
            while (e.hasMoreElements()) {
                entryName = e.nextElement().toString();
                int pos = entryName.lastIndexOf(".");
                String suffix = "";
                if (pos != -1) {
                    suffix = entryName.substring(pos);
                }
                if (!this.typeHelper.allSuffixs.contains(suffix)) continue;
                ResEntry resEntry = this.ensureTrue(entryName);
                resEntry.b = res;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Init Metadata Jar:" + file.getAbsolutePath() + " Error.");
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void processDir(File dir, IResBase res, boolean isFrag) {
        Stack paths = new Stack();
        this.processDir0(dir, res, paths, isFrag);
    }

    private void processDir0(File dir, IResBase res, Stack paths, boolean isFrag) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                paths.push(file.getName());
                this.processDir0(file, res, paths, isFrag);
                paths.pop();
                continue;
            }
            if (!file.isFile()) continue;
            String name = file.getName();
            int pos = name.lastIndexOf(".");
            String suffix = "";
            if (pos != -1) {
                suffix = name.substring(pos);
            }
            if (!this.typeHelper.allSuffixs.contains(suffix)) continue;
            String fullname = this.joinPath(paths, name);
            ResEntry resEntry = this.ensureTrue(fullname);
            if (this.merge) {
                if (isFrag) {
                    resEntry.f = res;
                    continue;
                }
                resEntry.b = res;
                continue;
            }
            if (isFrag) {
                resEntry.f = res;
                resEntry.b = null;
                continue;
            }
            resEntry.b = res;
        }
    }

    private void processDir1(File dir, IResBase res, boolean isFrag) {
        this.processDir0(dir, res, isFrag);
    }

    private void processDir0(File dir, IResBase res, boolean isFrag) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.processDir0(file, res, isFrag);
                continue;
            }
            if (!file.isFile()) continue;
            String name = file.getName();
            int pos = name.lastIndexOf(".");
            String suffix = "";
            if (pos != -1) {
                suffix = name.substring(pos);
            }
            if (!this.typeHelper.allSuffixs.contains(suffix)) continue;
            String fullname = file.getPath().substring(res.getBase().getPath().length() + 1);
            fullname = fullname.replaceAll("\\\\", "/");
            ResEntry resEntry = this.ensureTrue(fullname);
            if (this.merge) {
                if (isFrag) {
                    resEntry.f = res;
                    continue;
                }
                resEntry.b = res;
                continue;
            }
            if (isFrag) {
                resEntry.f = res;
                resEntry.b = null;
                continue;
            }
            resEntry.b = res;
        }
    }

    private String joinPath(Stack paths, String name) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < paths.size(); ++i) {
            String path = (String)paths.get(i);
            if (StringUtils.isEmpty((String)path)) continue;
            buff.append(path);
            buff.append("/");
        }
        buff.append(name);
        return buff.toString();
    }

    private void bootSolution() throws MDNotFoundException {
        String entry = this.findBootSolutionEntry();
        if (entry == null) {
            throw new MDNotFoundException("\u627e\u4e0d\u5230solution");
        }
        ResEntry solutionEntry = this.ensure(entry);
        this.solutionEntry = entry;
        if (solutionEntry.getState() == 0 || solutionEntry.getState() == 2) {
            IResBase res = null;
            if (solutionEntry.f != null) {
                res = solutionEntry.f;
            } else if (solutionEntry.b != null) {
                res = solutionEntry.b;
            }
            try {
                Document dom = this.loadDOM(res, entry);
                this.initLocales(dom);
            }
            catch (Exception e) {
                throw new RuntimeException("\u65e0\u6cd5\u6b63\u786e\u89e3\u6790\u8d77\u59cb\u7684solution\u4fe1\u606f", e);
            }
        }
        if (solutionEntry.getState() == 1) {
            try {
                Document domFrag = this.loadDOM(solutionEntry.f, entry);
                Document domBase = this.loadDOM(solutionEntry.b, entry);
                Document dom = this.assembler.merge(this.metametaLoader.loadMeta(MetaDataTypeList.SOLUTION), domBase, domFrag);
                this.initLocales(dom);
            }
            catch (Exception e) {
                throw new RuntimeException("\u65e0\u6cd5\u6b63\u786e\u89e3\u6790\u8d77\u59cb\u7684solution\u4fe1\u606f", e);
            }
        }
    }

    private String findBootSolutionEntry() {
        for (String key : this.caches.keySet()) {
            if (!key.endsWith(".solution")) continue;
            return key;
        }
        return null;
    }

    @Override
    public synchronized void initSolution(SolutionInfo sln) throws IllegalArgumentException, IllegalStateException {
        if (this.engineState == 1) {
            throw new IllegalStateException("\u5f15\u64ce\u5df2\u7ecf\u88c5\u8f7d\u4e86\u5143\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21initSolution");
        }
        if (sln == null) {
            throw new IllegalArgumentException("initSolution\u4e2dSolutionInfo==null");
        }
        try {
            this.solutionName = sln.getName();
            this.localeNames = new HashSet<String>(3);
            LanguageCollection langs = sln.getLanguages();
            if (langs != null) {
                for (int i = 0; i < langs.size(); ++i) {
                    LanguageInfo lang = langs.get(i);
                    String sn = lang.getPostfix();
                    LocaleUtils.getLocale((String)sn);
                    LocaleUtils.addShortCode((Locale)lang.getOriginalLocale(), (String)sn);
                    this.localeNames.add(lang.getLocaleString());
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("initSolution\u65e0\u6cd5\u627e\u5230\u6b63\u786e\u7684lang\u4fe1\u606f\u3002");
        }
        this.engineState = 1;
    }

    private void initEngineState() {
        if (this.engineState != 1) {
            this.bootSolution2();
        }
    }

    @Override
    public SolutionInfo getSolution() throws MDNotFoundException {
        this.initEngineState();
        if (this.solution == null) {
            MetaDataPK pk = null;
            pk = this.solutionEntry != null ? MetaDataPK.create(Loader2.entryName2PK(this.solutionEntry)) : MetaDataPK.create(this.solutionName);
            this.solution = (SolutionInfo)this.loadMetadata(MetaDataTypeList.SOLUTION, pk);
        }
        return this.solution;
    }

    private synchronized void initLocales(Document dom) {
        Element root = dom.getRootElement();
        this.solutionName = root.getChildTextTrim("name", root.getNamespace());
        this.localeNames = new HashSet<String>(3);
        List ls = root.getChild("languages", root.getNamespace()).getChildren("language", root.getNamespace());
        for (int i = 0; i < ls.size(); ++i) {
            Element lang = (Element)ls.get(i);
            String shortName = lang.getChildText("postfix", root.getNamespace()).toLowerCase();
            String longName = lang.getChildText("localeString", root.getNamespace());
            LocaleUtils.getLocale((String)shortName);
            LocaleUtils.addShortCode((Locale)LocaleUtils.getLocale((String)longName), (String)shortName);
            this.localeNames.add(longName);
        }
    }

    @Override
    public synchronized boolean isLoaderValidate() {
        return this.engineState == 1;
    }

    @Override
    public synchronized UIObjectInfo loadAssmebledUIObject(IMetaDataPK pk) throws MDNotFoundException {
        UIObjectInfo ui = (UIObjectInfo)this.loadMetadata(MetaDataTypeList.UIOBJECT, pk);
        ui.setDirty(true);
        ui = (UIObjectInfo)this.uiass.assembleUI(ui);
        ui.setDirty(true);
        this.setLastModified(ui);
        return ui;
    }

    @Override
    public synchronized WebUIObjectInfo loadAssmebledWebUIObject(IMetaDataPK pk) throws MDNotFoundException {
        WebUIObjectInfo ui = (WebUIObjectInfo)this.loadMetadata(MetaDataTypeList.WEBUIOBJECT, pk);
        ui.setDirty(true);
        ui = (WebUIObjectInfo)this.uiass.assembleUI(ui);
        ui.setDirty(true);
        this.setLastModified(ui);
        return ui;
    }

    public synchronized AbstractMetaDataValue loadMetadata(String entry) throws MDNotFoundException {
        return this.loadMetadata(Loader2.entryName2BOSType(entry), MetaDataPK.create(Loader2.entryName2PK(entry)));
    }

    public void setCsvWriter(PrintWriter csvWriter) {
        this.csvWriter = csvWriter;
    }

    public void setPkgName(String pkgName) {
        this.pkgName = pkgName;
    }

    public void setDbWriter(DBWriter dbWriter) {
        this.dbWriter = dbWriter;
    }

    @Override
    public synchronized AbstractMetaDataValue loadMetadata(BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        return this.loadMetadata(type, pk, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public synchronized AbstractMetaDataValue loadMetadata(BOSObjectType type, IMetaDataPK pk, boolean clearCache) throws MDNotFoundException {
        block79: {
            block77: {
                block78: {
                    block76: {
                        block74: {
                            block75: {
                                this.initEngineState();
                                start = System.currentTimeMillis();
                                first = false;
                                fromCache = false;
                                entry = Loader2.entryName(type, pk);
                                ++this.count;
                                if (this.l.get() == null) {
                                    first = true;
                                    visted = new HashSet<String>();
                                    this.l.set(visted);
                                    this.m.set(pk + Utils.getMetaDataSuffix(type));
                                } else {
                                    visted = (HashSet<String>)this.l.get();
                                }
                                res = this.ensure(entry);
                                vo = res.obj;
                                cacheDom = null;
                                if (vo == null || !visted.contains(entry) && !"true".equalsIgnoreCase(System.getProperty(Loader2.USE_GLOBAL_CACHE)) && !this.useCache && !MetaDataTypeList.SOLUTION.equals((Object)type)) ** GOTO lbl55
                                ensured = null;
                                if (this.link.get() == null) {
                                    first = true;
                                    ensured = new HashMap<K, V>();
                                    this.link.set(ensured);
                                } else {
                                    ensured = (HashMap<K, V>)this.link.get();
                                }
                                if (this.isDirty(vo, ensured, true, true)) break block74;
                                fromCache = true;
                                var14_14 = vo;
                                --this.count;
                                if (this.count != 0 || "true".equalsIgnoreCase(System.getProperty(Loader2.USE_GLOBAL_CACHE)) || !clearCache || this.useCache) break block75;
                                visted = (HashSet)this.l.get();
                                for (String tmp : visted) {
                                    try {
                                        res = this.ensure(tmp);
                                        res.obj = null;
                                    }
                                    catch (MDNotFoundException res) {}
                                }
                            }
                            if (first && clearCache && !this.useCache) {
                                this.l.set(null);
                                this.m.set(null);
                            }
                            if (this.count == 0 && clearCache && !this.useCache) {
                                this.link.set(null);
                            }
                            return var14_14;
                        }
                        if (!this.isDirty(vo)) {
                            cacheDom = this.save(vo);
                        }
                        {
                            catch (MDSaveException e) {
                                Loader2.logger.warn((Object)e, (Throwable)e);
                            }
                        }
lbl55:
                        // 3 sources

                        if (!visted.contains(entry)) {
                            visted.add(entry);
                        }
                        meta = null;
                        try {
                            meta = this.metametaLoader.loadMeta(type);
                        }
                        catch (MissingDAOMetaDataException e) {
                            throw new MDParseError("\u65e0\u6cd5\u88c5\u8f7d\u5143\u5143\u6570\u636e\u7c7b\u578b[" + type + "]", (Throwable)e);
                        }
                        dom = null;
                        if (cacheDom != null) {
                            dom = cacheDom;
                        } else {
                            try {
                                if (res.getState() == 0) {
                                    dom = this.loadDOM(res.b, entry);
                                    break block76;
                                }
                                if (res.getState() == 2) {
                                    dom = this.loadDOM(res.f, entry);
                                    break block76;
                                }
                                if (res.getState() == 1) {
                                    domFrag = this.loadDOM(res.f, entry);
                                    domBase = this.loadDOM(res.b, entry);
                                    dom = this.assembler.merge(this.metametaLoader.loadMeta(type), domBase, domFrag);
                                    break block76;
                                }
                                if (res.getState() == 3) {
                                    throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u65e0\u5bf9\u5e94\u7684\u4efb\u4f55\u8d44\u6e90\uff01");
                                }
                                throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90\u5728\u63d2\u4ef6\u76ee\u5f55\u51b2\u7a81\uff01");
                            }
                            catch (IOException e) {
                                throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u5b58\u53d6IO\u5f02\u5e38", e);
                            }
                            catch (JDOMException e) {
                                throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u89e3\u6790DOM\u5f02\u5e38", e);
                            }
                            catch (XMLException e) {
                                throw new MDNotFoundException("\u5408\u5e76\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u51fa\u73b0\u5f02\u5e38", e);
                            }
                            catch (MissingDAOMetaDataException e) {
                                throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u7684[BOSType=" + type + "]\u4e0d\u5b58\u5728\u5143\u5143\u6570\u636e", (Throwable)e);
                            }
                        }
                    }
                    if (dom == null) {
                        try {
                            if (this.merge) {
                                domFrag = this.loadDOM(res.f, entry);
                                domBase = this.loadDOM(res.b, entry);
                                dom = this.assembler.merge(this.metametaLoader.loadMeta(type), domBase, domFrag);
                            } else if (res.f.entryExist(entry)) {
                                dom = this.loadDOM(res.f, entry);
                            } else {
                                if (this.bases != null) {
                                    for (i = 0; i < this.bases.length; ++i) {
                                        base = this.bases[i];
                                        if (!base.entryExist(entry)) continue;
                                        res.b = base;
                                        break;
                                    }
                                }
                                if (res.b != null) {
                                    dom = this.loadDOM(res.b, entry);
                                }
                            }
                        }
                        catch (Exception e) {
                            Loader2.logger.warn((Object)e, (Throwable)e);
                        }
                    }
                    if (dom != null) break block77;
                    e = null;
                    --this.count;
                    if (this.count != 0 || "true".equalsIgnoreCase(System.getProperty(Loader2.USE_GLOBAL_CACHE)) || !clearCache || this.useCache) break block78;
                    visted = (HashSet)this.l.get();
                    for (String tmp : visted) {
                        try {
                            res = this.ensure(tmp);
                            res.obj = null;
                        }
                        catch (MDNotFoundException res) {}
                    }
                }
                if (first && clearCache && !this.useCache) {
                    this.l.set(null);
                    this.m.set(null);
                }
                if (this.count == 0 && clearCache && !this.useCache) {
                    this.link.set(null);
                }
                return e;
            }
            try {
                meta = this.typeHelper.getRealMeta(meta, dom.getRootElement().getName());
                res.obj = vo = (AbstractMetaDataValue)this.typeHelper.getRealVO(meta);
                if (this.link.get() != null && ((HashMap)this.link.get()).get(entry) != null && ((Boolean)((HashMap)this.link.get()).get(entry)).booleanValue()) {
                    ((HashMap)this.link.get()).put(entry, Boolean.FALSE);
                }
                this.parser.parseMDFromDOM(vo, meta, dom.getRootElement());
                if (MetaDataTypeList.UIOBJECT.equals((Object)type)) {
                    UILoader.afterLoad((UIObjectInfo)vo);
                    if (clearCache) {
                        vo.setDirty(true);
                    }
                } else if (MetaDataTypeList.WEBUIOBJECT.equals((Object)type)) {
                    if (clearCache) {
                        vo.setDirty(true);
                    }
                } else if (vo instanceof RuleSetInfo) {
                    RuleSetCtrl.afterLoad((RuleSetInfo)vo);
                } else if (vo instanceof BizUnitInfo) {
                    try {
                        BizUnitCtrl.afterLoad((BizUnitInfo)vo);
                    }
                    catch (BIMException e) {
                        Loader2.logger.error((Object)e, (Throwable)e);
                    }
                } else if (MetaDataTypeList.WEBPAGEOBJECT.equals((Object)type)) {
                    if (clearCache) {
                        vo.setDirty(true);
                    }
                } else if (MetaDataTypeList.WEBCOMPONENTOBJECT.equals((Object)type) && clearCache) {
                    vo.setDirty(true);
                }
                this.setLastModified(vo);
                var15_27 = vo;
                --this.count;
                if (this.count != 0 || "true".equalsIgnoreCase(System.getProperty(Loader2.USE_GLOBAL_CACHE)) || !clearCache || this.useCache) break block79;
            }
            catch (Throwable var20_41) {
                --this.count;
                if (this.count == 0 && !"true".equalsIgnoreCase(System.getProperty(Loader2.USE_GLOBAL_CACHE)) && clearCache && !this.useCache) {
                    visted = (HashSet)this.l.get();
                    for (String tmp : visted) {
                        try {
                            res = this.ensure(tmp);
                            res.obj = null;
                        }
                        catch (MDNotFoundException var24_46) {}
                    }
                }
                if (first && clearCache && !this.useCache) {
                    this.l.set(null);
                    this.m.set(null);
                }
                if (this.count == 0 && clearCache && !this.useCache) {
                    this.link.set(null);
                }
                throw var20_41;
            }
            visted = (HashSet)this.l.get();
            for (String tmp : visted) {
                try {
                    res = this.ensure(tmp);
                    res.obj = null;
                }
                catch (MDNotFoundException var19_40) {}
            }
        }
        if (first && clearCache && !this.useCache) {
            this.l.set(null);
            this.m.set(null);
        }
        if (this.count == 0 && clearCache && !this.useCache) {
            this.link.set(null);
        }
        return var15_27;
    }

    @Override
    public synchronized boolean exist(BOSObjectType type, IMetaDataPK pk) {
        this.initEngineState();
        if (this.engineState != 1) {
            return false;
        }
        String entry = Loader2.entryName(type, pk);
        try {
            this.ensure(entry);
            return true;
        }
        catch (MDNotFoundException e) {
            return false;
        }
    }

    @Override
    public synchronized void saveMetadata(AbstractMetaDataValue metadata) throws MDSaveException {
        this.saveMetadata(metadata, null);
    }

    @Override
    public synchronized void saveMetadata(AbstractMetaDataValue metadata, OutputStream os) throws MDSaveException {
        this.initEngineState();
        BOSObjectType type = metadata.getBOSType();
        if (this.engineState != 1 && !MetaDataTypeList.SOLUTION.equals((Object)type)) {
            throw new MDSaveException("\u5143\u6570\u636e\u5f15\u64ce\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u5b58\u50a8\u5143\u6570\u636e");
        }
        MetaDataPK pk = MetaDataPK.create(metadata.getPackage(), metadata.getName());
        String entry = Loader2.entryName(type, pk);
        ResEntry res = (ResEntry)this.caches.get(entry);
        if (res == null) {
            if (MetaDataTypeList.SOLUTION.equals((Object)type)) {
                this.solutionEntry = entry;
            }
            res = new ResEntry();
            res.obj = metadata;
            this.caches.put(entry, res);
        }
        try {
            AbstractMetaDataValue original = null;
            if (metadata instanceof UIObjectInfo || metadata instanceof WebUIObjectInfo) {
                original = metadata;
                if (metadata instanceof UIObjectInfo) {
                    this.clear(MetaDataTypeList.UIOBJECT);
                    UIObjectCtrl.beforeSave((UIObjectInfo)metadata);
                } else if (metadata instanceof WebUIObjectInfo) {
                    this.clear(MetaDataTypeList.WEBUIOBJECT);
                    WebUIObjectCtrl.beforeSave((WebUIObjectInfo)metadata);
                }
                metadata = this.uiass.parseUI((AbstractUIObjectInfo)metadata);
            } else if (metadata instanceof RuleSetInfo) {
                RuleSetCtrl.beforeSave((RuleSetInfo)metadata);
            } else if (metadata instanceof BizUnitInfo) {
                BizUnitCtrl.beforeSave((BizUnitInfo)metadata);
            } else if (metadata instanceof WebPageObjectInfo || metadata instanceof WebComponentObjectInfo || metadata instanceof WebControlObjectInfo) {
                if (metadata instanceof WebComponentObjectInfo) {
                    this.clear(MetaDataTypeList.WEBCOMPONENTOBJECT);
                    WebComponentObjectCtrl.beforeSave((WebComponentObjectInfo)metadata);
                    metadata = WebComponentObjectAssembler.parseWebComponent(ConfigMDUtil.getContext(), (WebComponentObjectInfo)metadata);
                } else if (metadata instanceof WebPageObjectInfo) {
                    this.clear(MetaDataTypeList.WEBPAGEOBJECT);
                    WebPageObjectCtrl.beforeSave((WebPageObjectInfo)metadata);
                    metadata = WebPageObjectAssembler.parseWebPage(ConfigMDUtil.getContext(), (WebPageObjectInfo)metadata);
                } else if (metadata instanceof WebControlObjectInfo) {
                    this.clear(MetaDataTypeList.WEBCONTROLOBJECT);
                    WebControlObjectCtrl.beforeSave((WebControlObjectInfo)metadata);
                    metadata = WebControlObjectAssembler.parseWebControl(ConfigMDUtil.getContext(), (WebControlObjectInfo)metadata);
                }
            }
            Document bigDom = this.saver.store(metadata);
            if (metadata instanceof BizUnitInfo) {
                BizUnitCtrl.afterSave((BizUnitInfo)metadata);
            }
            if (this.merge && (res.getState() == 0 || res.getState() == 1)) {
                Document saveDom = null;
                Document baseDom = this.loadDOM(res.b, entry);
                try {
                    saveDom = this.assembler.diff(this.metametaLoader.loadMeta(metadata.getBOSType()), bigDom, baseDom);
                }
                catch (MissingDAOMetaDataException e) {
                    throw new MDSaveException("diff\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u7684[BOSType=" + metadata.getBOSType() + "]\u4e0d\u5b58\u5728\u5143\u5143\u6570\u636e", (Throwable)((Object)e));
                }
                catch (XMLException e) {
                    throw new MDSaveException("diff\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u51fa\u73b0\u5f02\u5e38", e);
                }
                if (saveDom == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("diff\u5143\u6570\u636e[" + entry + "]\u4e0ebase\u76f8\u540c\uff0c\u4e0d\u5b58\u50a8\u6269\u5c55\u3002"));
                    }
                    if (res.getState() == 1) {
                        this.workDir.deleteEntry(entry);
                        res.f = null;
                        if (this.deployer != null) {
                            this.deployer.deleteVO(type, pk, entry);
                        }
                    }
                    return;
                }
                if (res.getState() == 0) {
                    res.f = this.workDir;
                    if (this.deployer != null) {
                        this.deployer.addMapping(metadata);
                    }
                }
                this.saveDOM(res.f, entry, saveDom, os);
                if (this.deployer != null) {
                    this.deployer.updateEntry(entry, bigDom);
                }
            } else if (!this.merge || res.getState() == 3 || res.getState() == 2) {
                if (res.getState() == 3 && this.deployer != null) {
                    this.deployer.addMapping(metadata);
                }
                res.f = this.workDir;
                if (!this.merge) {
                    res.b = null;
                }
                this.saveDOM(res.f, entry, bigDom, os);
                if (this.deployer != null) {
                    this.deployer.updateEntry(entry, bigDom);
                }
            } else {
                throw new MDSaveException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90\u5728\u63d2\u4ef6\u76ee\u5f55\u51b2\u7a81\uff01");
            }
            if (MetaDataTypeList.SOLUTION.equals((Object)type)) {
                this.solution = (SolutionInfo)metadata;
            }
            res.obj = metadata;
            try {
                this.setLastModified(metadata);
                if (original != null) {
                    this.setLastModified(original);
                }
            }
            catch (MDNotFoundException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new MDSaveException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u5b58\u53d6IO\u5f02\u5e38", e);
        }
        catch (JDOMException e) {
            throw new MDSaveException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90[BaseDir=" + res.b + " FragDir=" + res.f + "]\u89e3\u6790DOM\u5f02\u5e38", e);
        }
    }

    @Override
    public void setLastModified(AbstractMetaDataValue metadata) throws MDNotFoundException {
        MetaDataPK pk;
        if (metadata == null) {
            return;
        }
        BOSObjectType type = metadata.getBOSType();
        String entry = Loader2.entryName(type, pk = MetaDataPK.create(metadata.getPackage(), metadata.getName()));
        ResEntry res = (ResEntry)this.caches.get(entry);
        if (res == null) {
            logger.warn((Object)(entry + "    has error, please check it."));
            return;
        }
        metadata.setLong("Resource_Last_Modified", res.entryLastModified(entry));
    }

    @Override
    public synchronized boolean deleteMetadata(BOSObjectType type, IMetaDataPK pk) throws DevMDException, MDSaveException {
        String entry = Loader2.entryName(type, pk);
        ResEntry res = this.ensure(entry);
        try {
            if (res.f != null) {
                this.workDir.deleteEntry(entry);
                res.f = null;
                res.obj = null;
                if (this.deployer != null) {
                    this.deployer.deleteVO(type, pk, entry);
                }
                if (!this.merge && this.bases != null) {
                    for (int i = 0; i < this.bases.length; ++i) {
                        IResBase base = this.bases[i];
                        if (!base.entryExist(entry)) continue;
                        res.b = base;
                        break;
                    }
                }
            }
            if (res.b != null) {
                return false;
            }
            this.caches.remove(entry);
            HashSet visted = (HashSet)this.l.get();
            if (visted != null) {
                visted.remove(entry);
            }
            return true;
        }
        catch (IOException e) {
            throw new MDSaveException("\u5220\u9664\u5143\u6570\u636e[" + entry + "]\u65f6\u51fa\u73b0IO\u5f02\u5e38\u3002");
        }
    }

    static String entryName(BOSObjectType type, IMetaDataPK pk) {
        String suffix = Utils.getMetaDataSuffix(type);
        String pkg = pk.getPackage();
        if (pkg == null || pkg.length() == 0) {
            return pk.getName() + suffix;
        }
        return pkg.replaceAll("\\.", "/") + "/" + pk.getName() + suffix;
    }

    static BOSObjectType entryName2BOSType(String entry) {
        int pos = entry.lastIndexOf(".");
        if (pos != -1) {
            String suffix = entry.substring(pos + 1);
            return BOSObjectType.create((String)Utils.getBOSTypeBySuffix(suffix));
        }
        return null;
    }

    static String entryName2PK(String entry) {
        int pos = entry.lastIndexOf(".");
        if (pos != -1) {
            String pk = entry.substring(0, pos);
            return pk.replaceAll("/", "\\.");
        }
        return entry.replaceAll("/", "\\.");
    }

    @Override
    public synchronized MetadataState getMetadataState(BOSObjectType type, IMetaDataPK pk) throws DevMDException {
        this.initEngineState();
        if (this.engineState != 1) {
            throw new MDLoaderException("\u5143\u6570\u636e\u5f15\u64ce\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u5b58\u50a8\u5143\u6570\u636e");
        }
        String entry = Loader2.entryName(type, pk);
        ResEntry res = this.ensure(entry);
        return new MetadataState(type, pk, res.getState());
    }

    @Override
    public SortedMap getMetadataByPackage(String pkg, BOSObjectType[] including, BOSObjectType[] excluding, boolean deep) throws DevMDException {
        pkg = pkg.replace('.', '/');
        pkg = pkg.replace('\\', '/');
        String key1 = null;
        String key2 = null;
        SortedMap subs = this.caches;
        if (pkg != null && pkg.length() > 0) {
            if (pkg.endsWith("/")) {
                key1 = pkg;
                key2 = pkg.substring(0, pkg.length() - 1) + "0";
            } else {
                key1 = pkg + "/";
                key2 = pkg + "0";
            }
            subs = subs.subMap(key1, key2);
        }
        return Collections.unmodifiableSortedMap(subs);
    }

    @Override
    public synchronized void cleanExportDir() throws IllegalStateException, IOException {
        this.cleanExportDir(true);
    }

    @Override
    public synchronized void cleanExportDir(boolean rebuild) throws IllegalStateException, IOException {
        if (this.deployer == null) {
            throw new IllegalStateException("export\u76ee\u5f55\u6ca1\u6709\u8bbe\u7f6e\u3002");
        }
        this.deployer.root.clean();
        if (rebuild) {
            Iterator it = this.caches.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    String pk;
                    String key;
                    Map.Entry item = it.next();
                    ResEntry res = (ResEntry)item.getValue();
                    String entry = (String)item.getKey();
                    BOSObjectType type = Loader2.entryName2BOSType(entry);
                    if (res.f == null) continue;
                    Document bigDom = null;
                    if (res.b == null) {
                        bigDom = this.loadDOM(res.f, entry);
                    } else {
                        Document domFrag = this.loadDOM(res.f, entry);
                        Document domBase = this.loadDOM(res.b, entry);
                        bigDom = this.assembler.merge(this.metametaLoader.loadMeta(type), domBase, domFrag);
                    }
                    if (this.deployer == null) continue;
                    this.deployer.updateEntry(entry, bigDom);
                    if (MetaDataTypeList.ENTITY.equals((Object)type)) {
                        key = bigDom.getRootElement().getChildText("bosType", bigDom.getRootElement().getNamespace());
                        pk = Loader2.entryName2PK(entry);
                        this.deployer.entityMap.put(key, pk);
                        this.deployer.entityDirty = true;
                        continue;
                    }
                    if (!MetaDataTypeList.FACADE.equals((Object)type)) continue;
                    key = bigDom.getRootElement().getChildText("bosType", bigDom.getRootElement().getNamespace());
                    pk = Loader2.entryName2PK(entry);
                    this.deployer.facadeMap.put(key, pk);
                    this.deployer.facadeDirty = true;
                }
                catch (Exception exception) {}
            }
            if (this.deployer != null) {
                this.deployer.saveMap();
            }
        }
    }

    @Override
    public synchronized void clear() {
        for (ResEntry item : this.caches.values()) {
            item.obj = null;
        }
    }

    @Override
    public synchronized void clear(BOSObjectType type) {
        String suffix = Utils.getMetaDataSuffix(type);
        for (Map.Entry entry : this.caches.entrySet()) {
            String s = (String)entry.getKey();
            if (!s.endsWith(suffix)) continue;
            ResEntry item = (ResEntry)entry.getValue();
            item.obj = null;
        }
    }

    @Override
    public synchronized void clear(BOSObjectType type, IMetaDataPK pk) {
        String entry = Loader2.entryName(type, pk);
        ResEntry res = (ResEntry)this.caches.get(entry);
        if (res != null) {
            res.obj = null;
        }
    }

    @Override
    public synchronized void refresh() throws IOException {
        this.engineState = 0;
        this.caches.clear();
        this.solutionName = null;
        this.solutionEntry = null;
        this.localeNames = null;
        LocaleUtils.clear();
        if (this.bases != null) {
            for (int i = this.bases.length - 1; i >= 0; --i) {
                IResBase rb = this.bases[i];
                File base = rb.getBase();
                if (base.isDirectory()) {
                    this.processDir(base, rb, false);
                    continue;
                }
                if (!base.isFile()) continue;
                this.processJar(base, rb);
            }
        }
        this.processDir(this.workDir.getBase(), this.workDir, true);
        this.cleanExportDir(true);
        this.bootSolution2();
    }

    private void bootSolution2() {
        try {
            this.bootSolution();
            this.engineState = 1;
        }
        catch (Exception e) {
            logger.error((Object)"\u5237\u65b0\u4e00\u4e2a\u5143\u6570\u636e\u89e3\u51b3\u65b9\u6848\uff0c\u4f46\u662f\u65e0\u6cd5\u521d\u59cb\u5316SolutionInfo\uff0c\u8bf7initSolution\u3002", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void refresh(File dir) {
        if (!dir.isDirectory()) {
            if (dir.getParent() == null) {
                return;
            }
            if (!(dir = dir.getParentFile()).exists()) {
                return;
            }
        }
        try {
            String longName = dir.getCanonicalPath();
            String langBase = this.workDir.getBase().getCanonicalPath();
            if (longName.startsWith(langBase)) {
                String subName = longName.substring(langBase.length());
                if (subName.startsWith("\\") || subName.startsWith("/")) {
                    subName = subName.substring(1);
                }
                subName = subName.replace('\\', '/');
                ArrayList keys = new ArrayList();
                this.getWorkEntries(this.workDir.getBase().getAbsolutePath(), dir, keys);
                for (String key : keys) {
                    ResEntry res = this.ensureTrue(key);
                    res.f = null;
                }
                String[] subs = subName.split("\\\\");
                Stack<String> paths = new Stack<String>();
                for (int i = 0; i < subs.length; ++i) {
                    paths.push(subs[i]);
                }
                this.processDir0(dir, this.workDir, paths, true);
            }
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public synchronized void rebase(File[] basePaths) throws IOException {
        this.caches.clear();
        this.bases = null;
        if (basePaths != null) {
            ArrayList<DirResBase> tempBase = new ArrayList<DirResBase>();
            for (int i = basePaths.length - 1; i >= 0; --i) {
                IResBase res;
                File base = basePaths[i];
                if (base.isDirectory()) {
                    res = new DirResBase(base);
                    tempBase.add((DirResBase)res);
                    this.processDir(base, res, false);
                    continue;
                }
                if (!base.isFile()) continue;
                res = new JarResBase(base);
                tempBase.add((DirResBase)res);
                this.processJar(base, res);
            }
            this.bases = tempBase.toArray(new IResBase[tempBase.size()]);
        }
        this.processDir(this.workDir.getBase(), this.workDir, true);
        this.cleanExportDir(true);
    }

    @Override
    public synchronized void export2Stream(BOSObjectType type, IMetaDataPK pk, OutputStream os) throws IOException, MDNotFoundException {
        Document dom;
        AbstractMetaDataValue vo = this.loadMetadata(type, pk);
        try {
            dom = this.saver.store(vo);
        }
        catch (MDSaveException e) {
            throw new IOException("\u65e0\u6cd5\u5e8f\u5217\u5316\u5143\u6570\u636e[pk=" + pk + "]");
        }
        XmlUtils.output(dom, os);
    }

    @Override
    public long getSolutionLastModified() throws MDLoaderException {
        return -1L;
    }

    @Override
    public long getMetadataLastModified(BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        return -1L;
    }

    @Override
    public synchronized boolean isExtendedMetadata(BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        String entry = Loader2.entryName(type, pk);
        ResEntry res = this.ensure(entry);
        return res.f != null;
    }

    @Override
    public synchronized boolean isBaseMetadata(BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        return !this.isExtendedMetadata(type, pk);
    }

    @Override
    public synchronized void setMetametaLoader(XMLLoader metametaLoader) throws IllegalArgumentException, IllegalStateException {
    }

    @Override
    public synchronized XMLLoader getMetametaLoader() {
        return this.metametaLoader;
    }

    @Override
    public synchronized void setSaveDir(File saveDir) throws IllegalArgumentException, IllegalStateException {
    }

    @Override
    public synchronized File getSaveDir() {
        return this.workDir.getBase();
    }

    @Override
    public void setExportDir(File exportDir) throws IllegalArgumentException, IllegalStateException {
    }

    @Override
    public File getExportDir() {
        if (this.deployer != null) {
            return this.deployer.root.getBase();
        }
        return null;
    }

    @Override
    public void setBasePaths(File[] basePaths) throws IllegalArgumentException, IllegalStateException {
    }

    @Override
    public File[] getBasePaths() throws IllegalArgumentException, IllegalStateException {
        if (this.bases != null) {
            File[] rtv = new File[this.bases.length];
            for (int i = 0; i < rtv.length; ++i) {
                rtv[i] = this.bases[i].getBase();
            }
            return rtv;
        }
        return new File[0];
    }

    @Override
    public void setBaseTempDir(File tempDir) throws IllegalArgumentException, IllegalStateException {
    }

    @Override
    public File getBaseTempDir() throws IllegalStateException {
        return null;
    }

    private ResEntry ensure(String entry) throws MDNotFoundException {
        ResEntry res = (ResEntry)this.caches.get(entry);
        if (res == null) {
            File file = new File(this.workDir.getBase(), entry);
            this.refresh(file);
            res = (ResEntry)this.caches.get(entry);
        }
        if (res == null) {
            throw new MDNotFoundException("\u6574\u4e2a\u5143\u6570\u636e\u89e3\u51b3\u65b9\u6848\u4e2d\u6ca1\u6709\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90");
        }
        return res;
    }

    private ResEntry ensureTrue(String entry) {
        ResEntry res = (ResEntry)this.caches.get(entry);
        if (res == null) {
            res = new ResEntry();
            this.caches.put(entry, res);
        }
        return res;
    }

    @Override
    public synchronized Map loadResource(BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        TreeMap rtv = new TreeMap();
        String entry = Loader2.entryName(type, pk);
        ResEntry res = this.ensure(entry);
        try {
            Document dom;
            if (res.getState() == 0) {
                dom = this.loadDOM(res.b, entry);
            } else if (res.getState() == 2) {
                dom = this.loadDOM(res.f, entry);
            } else if (res.getState() == 1) {
                Document domFrag = this.loadDOM(res.f, entry);
                Document domBase = this.loadDOM(res.b, entry);
                dom = this.assembler.merge(this.metametaLoader.loadMeta(type), domBase, domFrag);
            } else {
                if (res.getState() == 3) {
                    throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u65e0\u5bf9\u5e94\u7684\u4efb\u4f55\u8d44\u6e90\uff01");
                }
                throw new MDNotFoundException("\u5143\u6570\u636e[" + entry + "]\u5bf9\u5e94\u7684\u8d44\u6e90\u5728\u63d2\u4ef6\u76ee\u5f55\u51b2\u7a81\uff01");
            }
            this.parseResource(dom, rtv);
        }
        catch (Exception e) {
            if (e instanceof MDNotFoundException) {
                throw (MDNotFoundException)e;
            }
            throw new RuntimeException(e);
        }
        return rtv;
    }

    private void parseResource(Document dom, Map bag) {
        try {
            Element root = dom.getRootElement();
            Element rss = root.getChild("resource", root.getNamespace());
            if (rss != null) {
                List rsEles = rss.getChildren("rs", rss.getNamespace());
                for (Element rs : rsEles) {
                    String key = rs.getAttributeValue("key");
                    TreeMap<String, String> lvalue = (TreeMap<String, String>)bag.get(key);
                    if (lvalue == null) {
                        lvalue = new TreeMap<String, String>();
                        bag.put(key, lvalue);
                    }
                    List locales = rs.getChildren("lang", rs.getNamespace());
                    for (Element lang : locales) {
                        String locale = lang.getAttributeValue("locale");
                        String value = lang.getAttributeValue("value");
                        lvalue.put(locale, value);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void serResource(Element rss, Map bag) {
        DefaultJDOMFactory factory = new DefaultJDOMFactory();
        try {
            rss.removeContent();
            for (Map.Entry item : bag.entrySet()) {
                String key = (String)item.getKey();
                Map values = (Map)item.getValue();
                Element rs = factory.element("rs", rss.getNamespace());
                rs.setAttribute("key", key);
                rss.addContent((Content)rs);
                for (Map.Entry lang : values.entrySet()) {
                    String localeKey = (String)lang.getKey();
                    String localeValue = (String)lang.getValue();
                    Element langEle = factory.element("lang", rs.getNamespace());
                    langEle.setAttribute("locale", localeKey);
                    langEle.setAttribute("value", localeValue);
                    rs.addContent((Content)langEle);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Document loadDOM(IResBase res, String entry) throws IOException, JDOMException {
        if (res == null) {
            return null;
        }
        InputStream is = res.getInputStream(entry);
        if (is == null) {
            return null;
        }
        Document dom = XMLParser.parseXML((InputStream)is);
        is.close();
        if (this.csvWriter != null || this.dbWriter != null) {
            String associatePkgName = "";
            if (res instanceof JarResBase) {
                associatePkgName = res.getBase().getName();
            }
            if (!associatePkgName.equalsIgnoreCase(this.pkgName) || "false".equalsIgnoreCase(System.getProperty(IGNORE_SELF_JAR))) {
                if (!"/".equals(File.separator)) {
                    entry = entry.replace('/', File.separatorChar);
                }
                if (this.count == 2) {
                    if (this.csvWriter != null) {
                        this.csvWriter.println(this.pkgName + "," + this.m.get() + ",direct," + associatePkgName + "," + entry);
                    }
                    if (this.dbWriter != null) {
                        try {
                            this.dbWriter.println(this.pkgName, this.m.get().toString(), "direct", associatePkgName, entry);
                        }
                        catch (SQLException e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                } else if (this.count > 2) {
                    if (this.csvWriter != null) {
                        this.csvWriter.println(this.pkgName + "," + this.m.get() + ",indirect," + associatePkgName + "," + entry);
                    }
                    if (this.dbWriter != null) {
                        try {
                            this.dbWriter.println(this.pkgName, this.m.get().toString(), "indirect", associatePkgName, entry);
                        }
                        catch (SQLException e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                }
            }
        }
        return dom;
    }

    private void saveDOM(IResBase res, String entry, Document dom, OutputStream os) throws IOException {
        if (os == null) {
            os = res.getOutputStream(entry);
        }
        XmlUtils.output(dom, os);
        os.flush();
        os.close();
    }

    @Override
    public synchronized void saveResource(BOSObjectType type, IMetaDataPK pk, Map resources) throws MDSaveException, MDNotFoundException {
        this.saveResource(type, pk, resources, null);
    }

    @Override
    public synchronized void saveResource(BOSObjectType type, IMetaDataPK pk, Map resources, OutputStream os) throws MDSaveException, MDNotFoundException {
        String entry = Loader2.entryName(type, pk);
        ResEntry res = this.ensure(entry);
        Document bigDom = null;
        try {
            if (res.f != null && res.b == null) {
                bigDom = this.loadDOM(res.f, entry);
                Element rss = bigDom.getRootElement().getChild("resource", bigDom.getRootElement().getNamespace());
                this.serResource(rss, resources);
                this.saveDOM(res.f, entry, bigDom, os);
                if (this.deployer != null) {
                    this.deployer.updateEntry(entry, bigDom);
                }
            } else if (res.b != null) {
                if (res.f != null) {
                    Document domFrag = this.loadDOM(res.f, entry);
                    Document domBase = this.loadDOM(res.b, entry);
                    EntityObjectInfo meta = this.metametaLoader.loadMeta(type);
                    bigDom = this.assembler.merge(meta, domBase, domFrag);
                    this.serResource(bigDom.getRootElement().getChild("resource", bigDom.getRootElement().getNamespace()), resources);
                    Document diffDoc = this.assembler.diff(meta, bigDom, domBase);
                    if (diffDoc != null) {
                        this.saveDOM(res.f, entry, diffDoc, os);
                        if (this.deployer != null) {
                            this.deployer.updateEntry(entry, bigDom);
                        }
                    } else {
                        res.f.deleteEntry(entry);
                        res.f = null;
                        if (this.deployer != null) {
                            this.deployer.deleteVO(type, pk, entry);
                        }
                    }
                } else {
                    Document domBase = this.loadDOM(res.b, entry);
                    bigDom = domBase.clone();
                    this.serResource(bigDom.getRootElement().getChild("resource", bigDom.getRootElement().getNamespace()), resources);
                    EntityObjectInfo meta = this.metametaLoader.loadMeta(type);
                    Document diffDoc = this.assembler.diff(meta, bigDom, domBase);
                    if (diffDoc != null) {
                        res.f = this.workDir;
                        this.saveDOM(res.f, entry, diffDoc, os);
                        if (this.deployer != null) {
                            this.deployer.updateEntry(entry, bigDom);
                            this.deployer.addMapping(bigDom);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void tagExtend(BOSObjectType type, IMetaDataPK pk) throws MDNotFoundException {
        this.tagExtend(type, pk, null);
    }

    private synchronized void tagExtend(BOSObjectType type, IMetaDataPK pk, OutputStream os) throws MDNotFoundException {
        this.initEngineState();
        if (this.engineState != 1) {
            throw new MDNotFoundException("\u5143\u6570\u636e\u5f15\u64ce\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u64cd\u4f5c\u5143\u6570\u636e");
        }
        String entry = Loader2.entryName(type, pk);
        ResEntry res = this.ensure(entry);
        if (res.f != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5143\u6570\u636e[" + entry + "]\u5df2\u7ecf\u662f\u4fee\u6539\u72b6\u6001"));
            }
            return;
        }
        if (res.b == null) {
            logger.error((Object)("\u5143\u6570\u636e[" + entry + "]\u7684\u8d44\u6e90\u72b6\u6001\u9519\u8bef\uff0c\u65e0base\u8d44\u6e90\u3002"));
            throw new IllegalStateException("\u5143\u6570\u636e[" + entry + "]\u7684\u8d44\u6e90\u72b6\u6001\u9519\u8bef\uff0c\u65e0base\u8d44\u6e90\u3002");
        }
        try {
            Document dom = this.loadDOM(res.b, entry);
            Element root = dom.getRootElement();
            DefaultJDOMFactory factory = new DefaultJDOMFactory();
            Element root2 = factory.element(root.getName(), root.getNamespace());
            Document dom2 = factory.document(root2);
            Element lk = null;
            lk = factory.element("package", root2.getNamespace());
            lk.setText(root.getChildTextTrim("package", root.getNamespace()));
            root2.addContent((Content)lk);
            lk = factory.element("name", root2.getNamespace());
            lk.setText(root.getChildTextTrim("name", root.getNamespace()));
            root2.addContent((Content)lk);
            root2.addContent((Content)factory.element("resource", root2.getNamespace()));
            res.f = this.workDir;
            this.saveDOM(res.f, entry, dom2, os);
        }
        catch (Exception e) {
            logger.error((Object)("\u64cd\u4f5c\u5143\u6570\u636e[" + entry + "]\u7684\u6269\u5c55\u8d44\u6e90\u9519\u8bef\u3002"));
            throw new IllegalStateException("\u64cd\u4f5c\u5143\u6570\u636e[" + entry + "]\u7684\u6269\u5c55\u8d44\u6e90\u9519\u8bef\u3002");
        }
    }

    @Override
    public synchronized AbstractMetaDataValue[] loadMetadata(MetaDataPK2[] pks) throws MDNotFoundException {
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            if (pks[i] != null) {
                MetaDataPK pk = MetaDataPK.create(pks[i].getFullName());
                BOSObjectType type = BOSObjectType.create((String)pks[i].getType());
                mds[i] = this.loadMetadata(type, pk, false);
                continue;
            }
            mds[i] = null;
        }
        this.clearCache();
        return mds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() throws MDNotFoundException {
        try {
            HashSet visted;
            if (!"true".equalsIgnoreCase(System.getProperty(USE_GLOBAL_CACHE)) && (visted = (HashSet)this.l.get()) != null) {
                for (String entry : visted) {
                    try {
                        ResEntry res = this.ensure(entry);
                        res.obj = null;
                    }
                    catch (MDNotFoundException mDNotFoundException) {}
                }
            }
        }
        finally {
            this.l.set(null);
            this.m.set(null);
            this.link.set(null);
        }
    }

    @Override
    public IMetaDataPK[] getMetaDataPKsByType(BOSObjectType type, String pkgName, boolean deep) {
        if (pkgName != null && !(pkgName = pkgName.replace('.', '/')).endsWith("/")) {
            pkgName = pkgName + "/";
        }
        Set keys = this.caches.keySet();
        HashSet<MetaDataPK> pks = new HashSet<MetaDataPK>();
        for (String entry : keys) {
            if (!entry.endsWith(Utils.getMetaDataSuffix(type))) continue;
            String pkg = null;
            if (entry.indexOf(46) > 0) {
                pkg = entry.substring(0, entry.lastIndexOf(47) + 1);
            }
            MetaDataPK pk = MetaDataPK.create(entry.substring(0, entry.lastIndexOf(46)));
            if (pkgName == null && pkg == null) {
                if (!this.entryExist(type, pk)) continue;
                pks.add(pk);
                continue;
            }
            if (pkgName == null || pkg == null || (!deep || !pkg.startsWith(pkgName)) && (deep || !pkg.equalsIgnoreCase(pkgName)) || !this.entryExist(type, pk)) continue;
            pks.add(pk);
        }
        return pks.toArray(new IMetaDataPK[0]);
    }

    private boolean entryExist(BOSObjectType type, IMetaDataPK pk) {
        String entry = Loader2.entryName(type, pk);
        try {
            ResEntry res = this.ensure(entry);
            return res.entryExist(entry);
        }
        catch (MDNotFoundException e) {
            return false;
        }
    }

    @Override
    public AbstractMetaDataValue[] loadMetadataByPackage(BOSObjectType bosType, String pkgName, boolean deep) throws MDNotFoundException {
        IMetaDataPK[] pks = this.getMetaDataPKsByType(bosType, pkgName, deep);
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            mds[i] = this.loadMetadata(bosType, pks[i], false);
        }
        this.clearCache();
        return mds;
    }

    @Override
    public AbstractMetaDataValue[] loadMetadata(BOSObjectType type, IMetaDataPK[] pks) throws MDNotFoundException {
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            mds[i] = pks[i] != null ? this.loadMetadata(type, pks[i], false) : null;
        }
        this.clearCache();
        return mds;
    }

    @Override
    public synchronized void openCache() {
        this.useCache = true;
    }

    @Override
    public synchronized void closeCache() {
        this.useCache = false;
        if (!"true".equalsIgnoreCase(System.getProperty(USE_GLOBAL_CACHE))) {
            this.clear();
        }
        this.link.set(null);
    }

    @Override
    public synchronized boolean isOpenCache() {
        return this.useCache;
    }

    @Override
    public synchronized void saveResource(AbstractMetaDataValue metadata, Map resources) throws MDSaveException, MDNotFoundException {
        this.saveResource(metadata, resources, null);
    }

    @Override
    public void saveResource(AbstractMetaDataValue metadata, Map resources, OutputStream os) throws MDSaveException, MDNotFoundException {
        BOSObjectType type = metadata.getBOSType();
        MetaDataPK pk = MetaDataPK.create(metadata.getPackage(), metadata.getName());
        this.saveResource(type, pk, resources, os);
        this.setLastModified(metadata);
    }

    public boolean isDirty(AbstractMetaDataValue metadata, boolean checkSelf, boolean deep) throws MDNotFoundException, MDSaveException {
        return this.isDirty(metadata, new HashMap(), checkSelf, deep);
    }

    private boolean isDirty(AbstractMetaDataValue metadata, Map visted, boolean checkSelf, boolean deep) throws MDNotFoundException, MDSaveException {
        BOSObjectType type = metadata.getBOSType();
        if (metadata.isDirty() && (MetaDataTypeList.UIOBJECT.equals((Object)type) || MetaDataTypeList.WEBUIOBJECT.equals((Object)type) || MetaDataTypeList.WEBPAGEOBJECT.equals((Object)type))) {
            return true;
        }
        MetaDataPK pk = MetaDataPK.create(metadata.getPackage(), metadata.getName());
        String entry = Loader2.entryName(type, pk);
        if (visted.containsKey(entry)) {
            if (visted.get(entry) != null) {
                return (Boolean)visted.get(entry);
            }
            return false;
        }
        visted.put(entry, null);
        if (checkSelf && this.isDirty(metadata)) {
            visted.put(entry, Boolean.TRUE);
            return true;
        }
        EntityObjectInfo meta = null;
        try {
            meta = this.metametaLoader.loadMeta(type);
        }
        catch (MissingDAOMetaDataException e) {
            throw new MDParseError("\u65e0\u6cd5\u88c5\u8f7d\u5143\u5143\u6570\u636e\u7c7b\u578b[" + type + "]", (Throwable)((Object)e));
        }
        PropertyCollection props = meta.getInheritedPropertiesRuntime();
        for (int i = 0; i < props.size(); ++i) {
            MetaDataPK pk1;
            BOSObjectType type1;
            String entry1;
            AbstractMetaDataValue child;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
            RelationshipInfo relation = linkProp.getRelationship();
            CardinalityType car = relation.getSupplierCardinality();
            if (CardinalityType.ONE_TO_UNBOUNDED.equals((Object)car) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)car)) {
                IObjectCollection coll = (IObjectCollection)metadata.get(prop.getName());
                if (coll == null) continue;
                int size = coll.size();
                for (int j = 0; j < size; ++j) {
                    IObjectValue temp = coll.getObject(j);
                    if (temp instanceof AbstractMetaDataValue) {
                        MetaDataPK pk12;
                        AbstractMetaDataValue child2 = (AbstractMetaDataValue)temp;
                        BOSObjectType type12 = child2.getBOSType();
                        String entry12 = Loader2.entryName(type12, pk12 = MetaDataPK.create(child2.getPackage(), child2.getName()));
                        if (visted.get(entry12) != null) continue;
                        if (deep && this.isDirty(child2, visted, true, deep)) {
                            visted.put(entry12, Boolean.TRUE);
                            visted.put(entry, Boolean.TRUE);
                            return true;
                        }
                        if (deep || !this.isDirty(child2)) continue;
                        visted.put(entry12, Boolean.TRUE);
                        visted.put(entry, Boolean.TRUE);
                        return true;
                    }
                    if (!(temp instanceof AbstractMDElement)) continue;
                    Enumeration enu = temp.keys();
                    while (enu.hasMoreElements()) {
                        MetaDataPK pk13;
                        AbstractMetaDataValue child3;
                        BOSObjectType type13;
                        String entry13;
                        Object o = temp.get((String)enu.nextElement());
                        if (!(o instanceof AbstractMetaDataValue) || visted.get(entry13 = Loader2.entryName(type13 = (child3 = (AbstractMetaDataValue)o).getBOSType(), pk13 = MetaDataPK.create(child3.getPackage(), child3.getName()))) != null) continue;
                        if (deep && this.isDirty(child3, visted, true, deep)) {
                            visted.put(entry13, Boolean.TRUE);
                            visted.put(entry, Boolean.TRUE);
                            return true;
                        }
                        if (deep || !this.isDirty(child3)) continue;
                        visted.put(entry13, Boolean.TRUE);
                        visted.put(entry, Boolean.TRUE);
                        return true;
                    }
                }
                continue;
            }
            IObjectValue temp = (IObjectValue)metadata.get(prop.getName());
            if (!(temp instanceof AbstractMetaDataValue) || (child = (AbstractMetaDataValue)temp) == null || visted.get(entry1 = Loader2.entryName(type1 = child.getBOSType(), pk1 = MetaDataPK.create(child.getPackage(), child.getName()))) != null) continue;
            if (deep && this.isDirty(child, visted, true, deep)) {
                visted.put(entry1, Boolean.TRUE);
                visted.put(entry, Boolean.TRUE);
                return true;
            }
            if (deep || !this.isDirty(child)) continue;
            visted.put(entry1, Boolean.TRUE);
            visted.put(entry, Boolean.TRUE);
            return true;
        }
        visted.put(entry, Boolean.FALSE);
        return false;
    }

    private boolean isDirty(AbstractMetaDataValue metadata) {
        BOSObjectType type = metadata.getBOSType();
        MetaDataPK pk = MetaDataPK.create(metadata.getPackage(), metadata.getName());
        String entry = Loader2.entryName(type, pk);
        if (metadata.isDirty()) {
            return true;
        }
        ResEntry res = (ResEntry)this.caches.get(entry);
        if (res == null) {
            logger.warn((Object)(entry + "    has error, please check it."));
            return false;
        }
        long time = 0L;
        try {
            time = res.entryLastModified(entry);
        }
        catch (MDNotFoundException e1) {
            logger.warn((Object)e1, (Throwable)e1);
        }
        return metadata.get("Resource_Last_Modified") != null && metadata.getLong("Resource_Last_Modified") < time;
    }

    private synchronized Document save(AbstractMetaDataValue metadata) throws MDSaveException {
        if (metadata instanceof UIObjectInfo || metadata instanceof WebUIObjectInfo) {
            metadata = this.uiass.parseUI((AbstractUIObjectInfo)metadata);
        } else if (metadata instanceof RuleSetInfo) {
            RuleSetCtrl.beforeSave((RuleSetInfo)metadata);
        } else if (metadata instanceof BizUnitInfo) {
            BizUnitCtrl.beforeSave((BizUnitInfo)metadata);
        } else if (metadata instanceof WebPageObjectInfo) {
            metadata = WebPageObjectAssembler.parseWebPage(ConfigMDUtil.getContext(), (WebPageObjectInfo)metadata);
        } else if (metadata instanceof WebComponentObjectInfo) {
            metadata = WebComponentObjectAssembler.parseWebComponent(ConfigMDUtil.getContext(), (WebComponentObjectInfo)metadata);
        } else if (metadata instanceof WebControlObjectInfo) {
            metadata = WebControlObjectAssembler.parseWebControl(ConfigMDUtil.getContext(), (WebControlObjectInfo)metadata);
        }
        Document bigDom = this.saver.store(metadata);
        if (metadata instanceof BizUnitInfo) {
            BizUnitCtrl.afterSave((BizUnitInfo)metadata);
        }
        return bigDom;
    }

    @Override
    public AbstractMetaDataValue refreshMetadata(AbstractMetaDataValue vo) throws MDNotFoundException, MDSaveException {
        AbstractMetaDataValue[] ret = this.refreshMetadata(new AbstractMetaDataValue[]{vo});
        return ret[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AbstractMetaDataValue[] refreshMetadata(AbstractMetaDataValue[] vos) throws MDNotFoundException, MDSaveException {
        if (vos == null || vos.length == 0) {
            return null;
        }
        AbstractMetaDataValue[] ret = new AbstractMetaDataValue[vos.length];
        try {
            for (int i = 0; i < vos.length; ++i) {
                AbstractMetaDataValue vo = vos[i];
                if (!this.isDirty(vo, false, true)) {
                    ret[i] = vo;
                    continue;
                }
                Document dom = this.save(vo);
                BOSObjectType type = vo.getBOSType();
                MetaDataPK pk = MetaDataPK.create(vo.getPackage(), vo.getName());
                String entry = Loader2.entryName(type, pk);
                ResEntry res = this.ensure(entry);
                AbstractMetaDataValue temp = res.obj;
                boolean dirty = vo.isDirty();
                vo.setDirty(false);
                res.obj = vo;
                EntityObjectInfo meta = null;
                try {
                    meta = this.metametaLoader.loadMeta(type);
                }
                catch (MissingDAOMetaDataException e) {
                    throw new MDParseError("\u65e0\u6cd5\u88c5\u8f7d\u5143\u5143\u6570\u636e\u7c7b\u578b[" + type + "]", (Throwable)((Object)e));
                }
                meta = this.typeHelper.getRealMeta(meta, dom.getRootElement().getName());
                this.count = 1;
                this.parser.parseMDFromDOM(vo, meta, dom.getRootElement());
                if (MetaDataTypeList.UIOBJECT.equals((Object)type)) {
                    UILoader.afterLoad((UIObjectInfo)vo);
                } else if (vo instanceof RuleSetInfo) {
                    RuleSetCtrl.afterLoad((RuleSetInfo)vo);
                } else if (vo instanceof BizUnitInfo) {
                    try {
                        BizUnitCtrl.afterLoad((BizUnitInfo)vo);
                    }
                    catch (BIMException e) {
                        logger.error((Object)e, (Throwable)((Object)e));
                    }
                }
                vo.setDirty(dirty);
                res.obj = temp;
                ret[i] = vo;
            }
        }
        finally {
            this.count = 0;
            this.link.set(null);
        }
        return ret;
    }

    @Override
    public boolean lastModifiedChanged(AbstractMetaDataValue metadata) {
        MetaDataPK pk;
        if (metadata == null) {
            return false;
        }
        BOSObjectType type = metadata.getBOSType();
        String entry = Loader2.entryName(type, pk = MetaDataPK.create(metadata.getPackage(), metadata.getName()));
        ResEntry res = (ResEntry)this.caches.get(entry);
        if (res == null) {
            return false;
        }
        long time = 0L;
        try {
            time = res.entryLastModified(entry);
        }
        catch (MDNotFoundException e1) {
            logger.warn((Object)e1, (Throwable)e1);
        }
        if (metadata.get("Resource_Last_Modified") != null && metadata.getLong("Resource_Last_Modified") < time) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("lastModifiedChanged: " + pk));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean lastModifiedChanged(AbstractMetaDataValue[] mds) {
        for (int i = 0; i < mds.length; ++i) {
            if (!this.lastModifiedChanged(mds[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public ValidateList validate() {
        ValidateMetaData vld = new ValidateMetaData();
        if (this.bases != null && this.bases.length > 0) {
            List entries = this.getWorkEntries();
            for (String entry : entries) {
                try {
                    this.loadMetadata(entry);
                }
                catch (Throwable e) {
                    vld.addError(StringUtils.stackToString((Throwable)e));
                }
            }
        }
        return vld.getValidateList();
    }

    private List getWorkEntries() {
        ArrayList entries = new ArrayList();
        this.getWorkEntries(this.workDir.getBase().getAbsolutePath(), this.workDir.getBase(), entries);
        return entries;
    }

    private void getWorkEntries(String base, File dir, List entries) {
        File[] children = dir.listFiles();
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (child.isFile()) {
                    String name = child.getName();
                    int pos = name.lastIndexOf(".");
                    String suffix = "";
                    if (pos != -1) {
                        suffix = name.substring(pos);
                    }
                    if (!this.typeHelper.allSuffixs.contains(suffix)) continue;
                    String s = child.getAbsolutePath();
                    if ((s = s.substring(base.length())).startsWith("/") || s.startsWith("\\")) {
                        s = s.substring(1);
                    }
                    s = s.replace('\\', '/');
                    entries.add(s);
                    continue;
                }
                this.getWorkEntries(base, child, entries);
            }
        }
    }

    @Override
    public void close() {
        if (this.bases != null && this.bases.length > 0) {
            for (int i = 0; i < this.bases.length; ++i) {
                this.bases[i].close();
            }
        }
    }

    @Override
    public WebComponentObjectInfo loadAssmebledUIComponentObject(MetaDataPK metaDataPK) throws MDNotFoundException {
        WebComponentObjectInfo ui = (WebComponentObjectInfo)this.loadMetadata(MetaDataTypeList.WEBCOMPONENTOBJECT, metaDataPK);
        ui.setDirty(true);
        ui = WebComponentObjectAssembler.assembleWebComponent(ConfigMDUtil.getContext(), ui);
        ui.setDirty(true);
        this.setLastModified(ui);
        return ui;
    }

    @Override
    public WebControlObjectInfo loadAssmebledUIControlObject(MetaDataPK metaDataPK) throws MDNotFoundException {
        WebControlObjectInfo ui = (WebControlObjectInfo)this.loadMetadata(MetaDataTypeList.WEBCONTROLOBJECT, metaDataPK);
        ui.setDirty(true);
        ui = WebControlObjectAssembler.assembleWebControl(ConfigMDUtil.getContext(), ui);
        ui.setDirty(true);
        this.setLastModified(ui);
        return ui;
    }

    @Override
    public WebPageObjectInfo loadAssmebledWebPageObject(IMetaDataPK metaDataPK) throws MDNotFoundException {
        WebPageObjectInfo ui = (WebPageObjectInfo)this.loadMetadata(MetaDataTypeList.WEBPAGEOBJECT, metaDataPK);
        ui.setDirty(true);
        ui = WebPageObjectAssembler.assembleWebPage(ConfigMDUtil.getContext(), ui);
        ui.setDirty(true);
        this.setLastModified(ui);
        return ui;
    }
}

