/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.impl;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.engine.impl.Loader2;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.EventBindingCollection;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemCollection;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.ui.UIControlOrderHelper;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.UIUtils;
import com.kingdee.bos.metadata.webui.ScriptCollection;
import com.kingdee.bos.metadata.webui.ScriptInfo;
import com.kingdee.bos.metadata.webui.StyleSheetCollection;
import com.kingdee.bos.metadata.webui.StyleSheetInfo;
import com.kingdee.bos.metadata.webui.WebMetaCollection;
import com.kingdee.bos.metadata.webui.WebMetaInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class UIAssembler {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.engine.impl.UIAssembler");
    private Loader2 loader;

    UIAssembler(Loader2 loader) {
        this.loader = loader;
    }

    private List<Locale> getSolutionLocales() {
        LinkedList<Locale> rtv = new LinkedList<Locale>();
        for (String lname : this.loader.localeNames) {
            rtv.add(LocaleUtils.getLocale((String)lname));
        }
        return rtv;
    }

    public AbstractUIObjectInfo parseUI(AbstractUIObjectInfo completeModel) {
        UIAssembler.compatibleHandleComponentTree(completeModel);
        if (UIUtils.getParent(completeModel) == null) {
            return completeModel;
        }
        long startTime = System.currentTimeMillis();
        AbstractUIObjectInfo resultModel = null;
        if (completeModel instanceof UIObjectInfo) {
            resultModel = new UIObjectInfo();
        } else if (completeModel instanceof WebUIObjectInfo) {
            resultModel = new WebUIObjectInfo();
        }
        List<Locale> locales = this.getSolutionLocales();
        UIAssembler.initUIInfo(completeModel, resultModel, locales);
        resultModel.setComponents(UIAssembler.parseComposites(completeModel.getComponents(), locales));
        resultModel.setActions(UIAssembler.parseActions(completeModel.getActions()));
        resultModel.setDataObjects(UIAssembler.parseDataObjects(completeModel.getDataObjects()));
        if (resultModel instanceof WebUIObjectInfo && completeModel instanceof WebUIObjectInfo) {
            ((WebUIObjectInfo)resultModel).setScripts(UIAssembler.parseScripts(((WebUIObjectInfo)completeModel).getScripts()));
            ((WebUIObjectInfo)resultModel).setMetas(UIAssembler.parseWebMetas(((WebUIObjectInfo)completeModel).getMetas()));
            ((WebUIObjectInfo)resultModel).setStyleSheets(UIAssembler.parseStyleSheets(((WebUIObjectInfo)completeModel).getStyleSheets()));
        }
        resultModel.setStatuses(UIAssembler.parseStatuses(completeModel.getStatuses(), locales));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u89e3\u6790UI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        resultModel.put("Resource_Last_Modified", completeModel.get("Resource_Last_Modified"));
        return resultModel;
    }

    private static void compatibleHandleComponentTree(AbstractUIObjectInfo completeModel) {
        ComponentCollection collections = completeModel.getComponents();
        if (collections == null || collections.size() == 0) {
            return;
        }
        Iterator iter = collections.iterator();
        ComponentInfo info = null;
        LinkedList<ComponentInfo> list = new LinkedList<ComponentInfo>();
        while (iter.hasNext()) {
            info = (ComponentInfo)iter.next();
            list.add(info);
        }
        if (list.isEmpty()) {
            return;
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            UIAssembler.compatibleHandleComponentTree(completeModel, (ComponentInfo)iter.next());
        }
    }

    private static void compatibleHandleComponentTree(AbstractUIObjectInfo completeModel, ComponentInfo parentInfo) {
        if (parentInfo == null) {
            return;
        }
        ComponentCollection collections = parentInfo.getComponents();
        if (collections == null || collections.size() == 0) {
            return;
        }
        Iterator iter = collections.iterator();
        ComponentInfo info = null;
        while (iter.hasNext()) {
            info = (ComponentInfo)iter.next();
            if (completeModel.containsComponentInfo(info)) continue;
            completeModel.getComponents().add(info);
            UIAssembler.compatibleHandleComponentTree(completeModel, info);
        }
    }

    public StatusCollection getAllStatus(AbstractUIObjectInfo originalModel) {
        List<Locale> locales = this.getSolutionLocales();
        return UIStatusNameAssemble.getAllStatus(locales, originalModel);
    }

    public AbstractUIObjectInfo assembleUI(AbstractUIObjectInfo originalModel) {
        return this.assembleUI(originalModel, false);
    }

    public AbstractUIObjectInfo assembleUI(AbstractUIObjectInfo originalModel, boolean needCompositePropBinding) {
        if (originalModel.isAssembled()) {
            return originalModel;
        }
        if (UIUtils.getParent(originalModel) == null) {
            UIAssembler.handleParentChildRelation(originalModel);
            UIControlOrderHelper.getInstance().orderUIControl(originalModel);
            originalModel.setAssembled(true);
            return originalModel;
        }
        AbstractUIObjectInfo originalModelClone = (AbstractUIObjectInfo)originalModel.clone();
        long startTime = System.currentTimeMillis();
        Stack<AbstractUIObjectInfo> parentStack = new Stack<AbstractUIObjectInfo>();
        AbstractUIObjectInfo parent = null;
        AbstractUIObjectInfo child = originalModelClone;
        AbstractUIObjectInfo completeModel = null;
        if (originalModel instanceof UIObjectInfo) {
            completeModel = new UIObjectInfo();
        } else if (originalModel instanceof WebUIObjectInfo) {
            completeModel = new WebUIObjectInfo();
        }
        List<Locale> locales = this.getSolutionLocales();
        UIAssembler.initUIInfo(originalModelClone, completeModel, locales);
        while ((parent = UIUtils.getParent(child)) != null) {
            parentStack.push(parent);
            child = parent;
        }
        while (!parentStack.isEmpty()) {
            UIAssembler.assembleParentUI(completeModel, (AbstractUIObjectInfo)parentStack.pop(), locales, needCompositePropBinding);
        }
        UIAssembler.setHeritedPropty(completeModel, true);
        UIAssembler.setOverridePropty(originalModelClone, true);
        UIAssembler.assembleParentUI(completeModel, originalModelClone, locales, needCompositePropBinding);
        UIAssembler.handleParentChildRelation(completeModel);
        UIControlOrderHelper.getInstance().orderUIControl(completeModel);
        UIAssembler.handleTolerantDefault(completeModel);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u88c5\u914dUI\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        completeModel.setAssembled(true);
        completeModel.put("Resource_Last_Modified", originalModel.get("Resource_Last_Modified"));
        return completeModel;
    }

    private static void assembleParentUI(AbstractUIObjectInfo completeModel, AbstractUIObjectInfo parentModel, List locales, boolean needCompositePropBinding) {
        UIAssembler.assembleComposite(completeModel, completeModel.getComponents(), parentModel.getComponents(), locales, needCompositePropBinding);
        UIAssembler.assembleDataObjects(completeModel.getDataObjects(), parentModel.getDataObjects(), locales);
        if (completeModel instanceof WebUIObjectInfo && parentModel instanceof WebUIObjectInfo) {
            UIAssembler.assembleScripts(((WebUIObjectInfo)completeModel).getScripts(), ((WebUIObjectInfo)parentModel).getScripts(), locales);
            UIAssembler.assembleWebMetas(((WebUIObjectInfo)completeModel).getMetas(), ((WebUIObjectInfo)parentModel).getMetas(), locales);
            UIAssembler.assembleStyleSheets(((WebUIObjectInfo)completeModel).getStyleSheets(), ((WebUIObjectInfo)parentModel).getStyleSheets(), locales);
        }
        UIAssembler.assembleActions(completeModel.getActions(), parentModel.getActions(), locales);
        UIAssembler.assembleStatuses(completeModel.getStatuses(), parentModel.getStatuses(), locales);
        UIAssembler.assembleComponent(completeModel, parentModel);
    }

    private static void assembleComponent(AbstractUIObjectInfo completeModel, AbstractUIObjectInfo originalModelClone) {
        ComponentCollection desComponents = completeModel.getComponents();
        ComponentCollection originalComponents = originalModelClone.getComponents();
        ComponentInfo desComponent = null;
        ComponentInfo originalComponent = null;
        Iterator desiter = desComponents.iterator();
        while (!(!desiter.hasNext() || (desComponent = (ComponentInfo)desiter.next()) != null && "tree".equals(desComponent.getName()) && "com.kingdee.bos.ctrl.web.Tree".equals(desComponent.getClassType()))) {
            desComponent = null;
        }
        Iterator originaliter = originalComponents.iterator();
        while (!(!originaliter.hasNext() || (originalComponent = (ComponentInfo)originaliter.next()) != null && "tree".equals(originalComponent.getName()) && "com.kingdee.bos.ctrl.web.Tree".equals(originalComponent.getClassType()))) {
            originalComponent = null;
        }
        if (desComponent != null && originalComponent != null) {
            desComponent.setEventBindings(originalComponent.getEventBindings());
        }
    }

    private static void assembleComposite(AbstractUIObjectInfo ui, ComponentCollection completeModel, ComponentCollection currentModel, List locales, boolean needCompositePropBinding) {
        assert (currentModel != null && completeModel != null);
        Iterator iter = currentModel.iterator();
        ComponentInfo currentComponent = null;
        ComponentInfo completeComponent = null;
        ComponentInfo tempComponent = null;
        ComponentInfo tempParent = null;
        while (iter.hasNext()) {
            String alias;
            LayoutInfo layoutInfo;
            int tabIndex;
            Object constraint;
            currentComponent = (ComponentInfo)iter.next();
            completeComponent = completeModel.getComponentInfo(currentComponent.getName());
            if (completeComponent == null) {
                completeModel.add(currentComponent);
                continue;
            }
            if (ui instanceof WebUIObjectInfo) {
                completeModel.insertObject(completeModel.size() - 1, (IObjectValue)completeComponent);
            }
            if ((tempComponent = currentComponent.getParent()) != null) {
                tempParent = completeModel.getComponentInfo(tempComponent.getName());
                if (tempParent == null) {
                    tempParent = currentModel.getComponentInfo(tempComponent.getName());
                }
                completeComponent.setParent(tempParent);
                completeComponent.setOverrideParent(currentComponent.isOverrideParent());
            }
            if ((constraint = currentComponent._getConstraint()) != null) {
                completeComponent.setConstraint(constraint, false);
                completeComponent.setOverrideConstraint(currentComponent.isOverrideConstraint());
            }
            if ((tabIndex = currentComponent.getTabIndex()) > 0) {
                completeComponent.setTabIndex(tabIndex);
                completeComponent.setOverrideTabIndex(currentComponent.isOverrideTabIndex());
            }
            if ((layoutInfo = currentComponent.getLayoutInfo()) != null) {
                completeComponent.setLayoutInfo(layoutInfo);
            }
            if (!StringUtils.isEmpty((String)(alias = currentComponent.getAlias()))) {
                completeComponent.setAlias(alias);
            }
            if (locales != null) {
                Iterator localIter = locales.iterator();
                Locale locale = null;
                while (localIter.hasNext()) {
                    locale = (Locale)localIter.next();
                    alias = currentComponent.getAlias(locale);
                    if (StringUtils.isEmpty((String)alias)) continue;
                    completeComponent.setAlias(alias, locale);
                }
            }
            PropertyCollection childComponentProperties = currentComponent.getProperties();
            for (int j = 0; j < childComponentProperties.size(); ++j) {
                PropertyInfo currentComponentProp = childComponentProperties.get(j);
                PropertyInfo completeComponentProp = completeComponent.getProperties().get(currentComponentProp.getName());
                if (completeComponentProp == null) {
                    completeComponent.getProperties().add(currentComponentProp);
                    continue;
                }
                completeComponentProp.setOverride(currentComponentProp.isOverride());
                completeComponentProp.setValue(currentComponentProp.getValue());
                if (!currentComponentProp.isMultiLanguage() || locales == null) continue;
                Iterator localIter = locales.iterator();
                Locale locale = null;
                while (localIter.hasNext()) {
                    locale = (Locale)localIter.next();
                    completeComponentProp.setValue(currentComponentProp.getValue(locale), locale);
                }
            }
            PropertyBindingCollection currentComponentPropertyBindings = currentComponent.getPropertyBindings();
            for (int j = 0; j < currentComponentPropertyBindings.size(); ++j) {
                PropertyBindingInfo currentPBInfo = currentComponentPropertyBindings.get(j);
                PropertyBindingInfo completePBInfo = (PropertyBindingInfo)completeComponent.getPropertyBindings().getObject(currentPBInfo.getPropertyName());
                if (completePBInfo == null) {
                    completeComponent.getPropertyBindings().add(currentPBInfo);
                    continue;
                }
                completePBInfo.setOverride(currentPBInfo.isOverride());
                completePBInfo.setBindingObject(currentPBInfo.getBindingObject());
                completePBInfo.setBingdingField(currentPBInfo.getBingdingField());
            }
            EventBindingCollection currentEventBindings = currentComponent.getEventBindings();
            for (int j = 0; j < currentEventBindings.size(); ++j) {
                EventBindingInfo currentEBInfo = currentEventBindings.get(j);
                EventBindingInfo completeEBInfo = (EventBindingInfo)completeComponent.getEventBindings().getObject(currentEBInfo.getEventName());
                if (completeEBInfo == null) {
                    completeComponent.getEventBindings().add(currentEBInfo);
                    continue;
                }
                completeEBInfo.setCode(currentEBInfo.getCode());
                completeEBInfo.setOverride(currentEBInfo.isOverride());
            }
            completeComponent.setRules(currentComponent.getRules());
        }
    }

    private static void assembleWebMetas(WebMetaCollection completeModel, WebMetaCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        WebMetaInfo currentInfo = null;
        WebMetaInfo completeInfo = null;
        while (iter.hasNext()) {
            currentInfo = (WebMetaInfo)iter.next();
            completeInfo = completeModel.getMetaByName(currentInfo.getName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setOverride(currentInfo.isOverride());
            completeInfo.setHttpEquiv(currentInfo.getHttpEquiv());
            completeInfo.setContent(currentInfo.getContent());
        }
    }

    private static void assembleStyleSheets(StyleSheetCollection completeModel, StyleSheetCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        StyleSheetInfo currentInfo = null;
        StyleSheetInfo completeInfo = null;
        while (iter.hasNext()) {
            currentInfo = (StyleSheetInfo)iter.next();
            completeInfo = completeModel.getStyleSheetByName(currentInfo.getName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setOverride(currentInfo.isOverride());
            completeInfo.setReference(currentInfo.getReference());
        }
    }

    private static void assembleScripts(ScriptCollection completeModel, ScriptCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        ScriptInfo currentScriptInfo = null;
        ScriptInfo completeScriptInfo = null;
        while (iter.hasNext()) {
            currentScriptInfo = (ScriptInfo)iter.next();
            completeScriptInfo = completeModel.getScriptByName(currentScriptInfo.getName());
            if (completeScriptInfo == null) {
                completeModel.add(currentScriptInfo);
                continue;
            }
            completeScriptInfo.setOverride(currentScriptInfo.isOverride());
            completeScriptInfo.setType(currentScriptInfo.getType());
            completeScriptInfo.setReference(currentScriptInfo.getReference());
            completeScriptInfo.setScript(currentScriptInfo.getScript());
        }
    }

    private static void assembleDataObjects(DataObjectCollection completeModel, DataObjectCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        DataObjectInfo currentDataObjInfo = null;
        DataObjectInfo completeDataObjInfo = null;
        while (iter.hasNext()) {
            currentDataObjInfo = (DataObjectInfo)iter.next();
            completeDataObjInfo = completeModel.getDataObject(currentDataObjInfo.getName());
            if (completeDataObjInfo == null) {
                completeModel.add(currentDataObjInfo);
                continue;
            }
            completeDataObjInfo.setOverride(currentDataObjInfo.isOverride());
            completeDataObjInfo.setType(currentDataObjInfo.getType());
            completeDataObjInfo.setDescription(currentDataObjInfo.getDescription());
            completeDataObjInfo.setDescription(currentDataObjInfo.getDescription());
        }
    }

    private static void assembleActions(ActionCollection completeModel, ActionCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        ActionInfo currentInfo = null;
        ActionInfo completeInfo = null;
        while (iter.hasNext()) {
            currentInfo = (ActionInfo)iter.next();
            completeInfo = completeModel.getActionByName(currentInfo.getName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setAcceleratorKey(currentInfo.getAcceleratorKey());
            completeInfo.setActionCommandKey(currentInfo.getActionCommandKey());
            completeInfo.setActionExtendProperty(currentInfo.getActionExtendProperty());
            completeInfo.setActionPerformed(currentInfo.getActionPerformed());
            completeInfo.setBeforeActionPerformed(currentInfo.getBeforeActionPerformed());
            completeInfo.setAfterActionPerformed(currentInfo.getAfterActionPerformed());
            completeInfo.setFinallyActionPerformed(currentInfo.getFinallyActionPerformed());
            completeInfo.setMnemonicKey(currentInfo.getMnemonicKey());
            completeInfo.setServices(currentInfo.getServices());
            completeInfo.setBindWorkFlow(currentInfo.isBindWorkFlow());
            completeInfo.setDaemonRun(currentInfo.isDaemonRun());
            completeInfo.setEnabled(currentInfo.isEnabled());
            completeInfo.setOverride(currentInfo.isOverride());
            completeInfo.setOprtIntent(currentInfo.getOprtIntent());
            completeInfo.setNextUI(currentInfo.getNextUI());
            completeInfo.setUIPNavigator(currentInfo.isUIPNavigator());
            completeInfo.setBatchAction(currentInfo.isBatchAction());
            completeInfo.setEntryAction(currentInfo.isEntryAction());
            completeInfo.setBatchMethodName(currentInfo.getBatchMethodName());
            completeInfo.setActionBinding(currentInfo.getActionBinding());
            completeInfo.setControlName(currentInfo.getControlName());
            completeInfo.setShortDesc(currentInfo.getShortDesc());
            completeInfo.setLongDesc(currentInfo.getLongDesc());
            completeInfo.setSmallIcon(currentInfo.getSmallIcon());
            if (locales != null) {
                Iterator localeIter = locales.iterator();
                Locale locale = null;
                while (localeIter.hasNext()) {
                    locale = (Locale)localeIter.next();
                    completeInfo.setControlName(currentInfo.getControlName(locale), locale);
                    completeInfo.setShortDesc(currentInfo.getShortDesc(locale), locale);
                    completeInfo.setLongDesc(currentInfo.getLongDesc(locale), locale);
                    completeInfo.setSmallIcon(currentInfo.getSmallIcon(locale), locale);
                }
            }
            completeInfo.setRules(currentInfo.getRules());
        }
    }

    private static void assembleStatuses(StatusCollection completeModel, StatusCollection currentModel, List locales) {
        assert (completeModel != null && currentModel != null);
        Iterator iter = currentModel.iterator();
        Iterator itemIter = null;
        StatusInfo currentInfo = null;
        StatusInfo completeInfo = null;
        StatusItemInfo currentItem = null;
        StatusItemInfo completeItem = null;
        StatusItemCollection currentItems = null;
        StatusItemCollection completeItems = null;
        Locale locale2 = null;
        Iterator localeIter = null;
        while (iter.hasNext()) {
            currentInfo = (StatusInfo)iter.next();
            completeInfo = completeModel.getStatusByName(currentInfo.getName());
            if (completeInfo == null) {
                completeModel.add(currentInfo);
                continue;
            }
            completeInfo.setAlias(currentInfo.getAlias());
            completeInfo.setDescription(currentInfo.getDescription());
            if (locales != null) {
                for (Locale locale2 : locales) {
                    completeInfo.setAlias(currentInfo.getAlias(locale2), locale2);
                    completeInfo.setDescription(currentInfo.getDescription(locale2), locale2);
                }
            }
            currentItems = currentInfo.getStatusItems();
            completeItems = completeInfo.getStatusItems();
            itemIter = currentItems.iterator();
            while (itemIter.hasNext()) {
                currentItem = (StatusItemInfo)itemIter.next();
                completeItem = completeItems.get(currentItem.getName());
                if (completeItem == null) {
                    completeItems.add(currentItem);
                    continue;
                }
                completeItem.setOverride(currentItem.isOverride());
                completeItem.setEnabled(currentItem.getEnabled());
                completeItem.setVisible(currentItem.getVisible());
            }
        }
    }

    private static void setHeritedPropty(AbstractUIObjectInfo model, boolean isHerited) {
        ComponentCollection components = model.getComponents();
        Iterator iter = components.iterator();
        Iterator pbIter = null;
        Iterator ebIter = null;
        ComponentInfo component = null;
        EventBindingInfo ebInfo = null;
        while (iter.hasNext()) {
            component = (ComponentInfo)iter.next();
            component.setHerited(isHerited);
            component.setAllHeritedProperties((PropertyCollection)component.getProperties().clone());
            PropertyBindingCollection propBindings = component.getPropertyBindings();
            pbIter = propBindings.iterator();
            while (pbIter.hasNext()) {
                ((PropertyBindingInfo)pbIter.next()).setHerited(isHerited);
            }
            EventBindingCollection eventBindings = component.getEventBindings();
            ebIter = eventBindings.iterator();
            while (ebIter.hasNext()) {
                ebInfo = (EventBindingInfo)ebIter.next();
                ebInfo.setHerited(isHerited);
                ebInfo.setCode("");
            }
        }
        iter = model.getDataObjects().iterator();
        while (iter.hasNext()) {
            ((DataObjectInfo)iter.next()).setHerited(isHerited);
        }
        iter = model.getActions().iterator();
        while (iter.hasNext()) {
            ((ActionInfo)iter.next()).setHerited(isHerited);
        }
        iter = model.getStatuses().iterator();
        StatusInfo status = null;
        while (iter.hasNext()) {
            status = (StatusInfo)iter.next();
            status.setHerited(isHerited);
            pbIter = status.getStatusItems().iterator();
            while (pbIter.hasNext()) {
                ((StatusItemInfo)pbIter.next()).setHerited(isHerited);
            }
        }
        if (model instanceof WebUIObjectInfo) {
            iter = ((WebUIObjectInfo)model).getStyleSheets().iterator();
            while (iter.hasNext()) {
                ((StyleSheetInfo)iter.next()).setHerited(isHerited);
            }
            iter = ((WebUIObjectInfo)model).getScripts().iterator();
            while (iter.hasNext()) {
                ((ScriptInfo)iter.next()).setHerited(isHerited);
            }
            iter = ((WebUIObjectInfo)model).getMetas().iterator();
            while (iter.hasNext()) {
                ((WebMetaInfo)iter.next()).setHerited(isHerited);
            }
        }
    }

    private static void setOverridePropty(AbstractUIObjectInfo model, boolean isOverride) {
        ComponentCollection components = model.getComponents();
        Iterator iter = components.iterator();
        Iterator pbIter = null;
        ComponentInfo component = null;
        EventBindingInfo ebInfo = null;
        while (iter.hasNext()) {
            component = (ComponentInfo)iter.next();
            if (component._getConstraint() != null) {
                component.setOverrideConstraint(isOverride);
            }
            if (component.getParent() != null && !StringUtils.isEmpty((String)component.getParent().getName())) {
                component.setOverrideParent(isOverride);
            }
            if (component.getTabIndex() > 0) {
                component.setOverrideTabIndex(isOverride);
            }
            if (component.getLayoutInfo() != null) {
                component.getLayoutInfo().setOverride(isOverride);
            }
            PropertyCollection props = component.getProperties();
            pbIter = props.iterator();
            while (pbIter.hasNext()) {
                ((PropertyInfo)pbIter.next()).setOverride(isOverride);
            }
            PropertyBindingCollection propBindings = component.getPropertyBindings();
            pbIter = propBindings.iterator();
            while (pbIter.hasNext()) {
                ((PropertyBindingInfo)pbIter.next()).setOverride(isOverride);
            }
            EventBindingCollection eventBindings = component.getEventBindings();
            pbIter = eventBindings.iterator();
            while (pbIter.hasNext()) {
                ebInfo = (EventBindingInfo)pbIter.next();
                ebInfo.setOverride(isOverride);
            }
        }
        iter = model.getDataObjects().iterator();
        while (iter.hasNext()) {
            ((DataObjectInfo)iter.next()).setOverride(isOverride);
        }
        iter = model.getActions().iterator();
        while (iter.hasNext()) {
            ((ActionInfo)iter.next()).setOverride(isOverride);
        }
        iter = model.getStatuses().iterator();
        StatusInfo status = null;
        while (iter.hasNext()) {
            status = (StatusInfo)iter.next();
            status.setOverride(isOverride);
            pbIter = status.getStatusItems().iterator();
            while (pbIter.hasNext()) {
                ((StatusItemInfo)pbIter.next()).setOverride(isOverride);
            }
        }
        if (model instanceof WebUIObjectInfo) {
            iter = ((WebUIObjectInfo)model).getStyleSheets().iterator();
            while (iter.hasNext()) {
                ((StyleSheetInfo)iter.next()).setOverride(isOverride);
            }
            iter = ((WebUIObjectInfo)model).getScripts().iterator();
            while (iter.hasNext()) {
                ((ScriptInfo)iter.next()).setOverride(isOverride);
            }
            iter = ((WebUIObjectInfo)model).getMetas().iterator();
            while (iter.hasNext()) {
                ((WebMetaInfo)iter.next()).setOverride(isOverride);
            }
        }
    }

    private static void handleParentChildRelation(AbstractUIObjectInfo model) {
        ComponentCollection components = model.getComponents();
        Iterator iter = components.iterator();
        ComponentInfo component = null;
        ComponentInfo parentComponent = null;
        String parentName = null;
        while (iter.hasNext()) {
            component = (ComponentInfo)iter.next();
            if (component.getParent() == null || StringUtils.isEmpty((String)(parentName = component.getParent().getName())) || (parentComponent = components.getComponentInfo(parentName)) == null) continue;
            component.setParent(parentComponent);
            parentComponent.getComponents().add(component);
        }
    }

    private static void initUIInfo(AbstractUIObjectInfo sourceModel, AbstractUIObjectInfo targetModel, List locales) {
        targetModel.setPKField(sourceModel.getPKField());
        targetModel.setName(sourceModel.getName());
        targetModel.setPackage(sourceModel.getPackage());
        UIUtils.setParent(targetModel, UIUtils.getParent(sourceModel));
        targetModel.setParentFullName(sourceModel.getParentFullName());
        targetModel.setReleaseClass(sourceModel.getReleaseClass());
        targetModel.setReleasePackage(sourceModel.getReleasePackage());
        targetModel.setDefaultButton(sourceModel.getDefaultButton());
        targetModel.setAlias(sourceModel.getAlias());
        targetModel.setDescription(sourceModel.getDescription());
        targetModel.setTitle(sourceModel.getTitle());
        if (locales != null) {
            Iterator iter = locales.iterator();
            Locale locale = null;
            while (iter.hasNext()) {
                locale = (Locale)iter.next();
                targetModel.setAlias(sourceModel.getAlias(locale), locale);
                targetModel.setDescription(sourceModel.getDescription(locale), locale);
                targetModel.setTitle(sourceModel.getTitle(locale), locale);
            }
        }
        targetModel.setRuleSet(sourceModel.getRuleSet());
        UIAssembler.copyExtendedProperties(sourceModel, targetModel);
        targetModel.setBizUnitPK(sourceModel.getBizUnitPK());
        targetModel.setUserDefined(sourceModel.isUserDefined());
    }

    private static void copyExtendedProperties(IObjectValue srcObj, IObjectValue desObj) {
        if (srcObj == null || desObj == null) {
            return;
        }
        Map extProps = srcObj.getExtendedProperties();
        for (Object key : extProps.keySet()) {
            desObj.getExtendedProperties().put(key, extProps.get(key));
        }
    }

    private static ComponentCollection parseComposites(ComponentCollection completeModel, List locales) {
        assert (completeModel != null);
        ComponentCollection resultModel = new ComponentCollection();
        Iterator iter = completeModel.iterator();
        ComponentInfo tempComponent = null;
        while (iter.hasNext()) {
            tempComponent = UIAssembler.parseComponent((ComponentInfo)iter.next(), locales);
            if (tempComponent == null) continue;
            resultModel.add(tempComponent);
        }
        return resultModel;
    }

    private static StyleSheetCollection parseStyleSheets(StyleSheetCollection completeModel) {
        assert (completeModel != null);
        StyleSheetCollection resultModel = new StyleSheetCollection();
        Iterator iter = completeModel.iterator();
        StyleSheetInfo info = null;
        while (iter.hasNext()) {
            info = (StyleSheetInfo)iter.next();
            if (info.isHerited() && !info.isOverride()) continue;
            resultModel.add(info);
        }
        return resultModel;
    }

    private static WebMetaCollection parseWebMetas(WebMetaCollection completeModel) {
        assert (completeModel != null);
        WebMetaCollection resultModel = new WebMetaCollection();
        Iterator iter = completeModel.iterator();
        WebMetaInfo info = null;
        while (iter.hasNext()) {
            info = (WebMetaInfo)iter.next();
            if (info.isHerited() && !info.isOverride()) continue;
            resultModel.add(info);
        }
        return resultModel;
    }

    private static ScriptCollection parseScripts(ScriptCollection completeModel) {
        assert (completeModel != null);
        ScriptCollection resultModel = new ScriptCollection();
        Iterator iter = completeModel.iterator();
        ScriptInfo info = null;
        while (iter.hasNext()) {
            info = (ScriptInfo)iter.next();
            if (info.isHerited() && !info.isOverride()) continue;
            resultModel.add(info);
        }
        return resultModel;
    }

    private static DataObjectCollection parseDataObjects(DataObjectCollection completeModel) {
        assert (completeModel != null);
        DataObjectCollection resultModel = new DataObjectCollection();
        Iterator iter = completeModel.iterator();
        DataObjectInfo sourceInfo = null;
        while (iter.hasNext()) {
            sourceInfo = (DataObjectInfo)iter.next();
            if (sourceInfo.isHerited() && !sourceInfo.isOverride()) continue;
            resultModel.add(sourceInfo);
        }
        return resultModel;
    }

    private static StatusCollection parseStatuses(StatusCollection completeModel, List locales) {
        assert (completeModel != null);
        StatusCollection resultModel = new StatusCollection();
        Iterator iter = completeModel.iterator();
        Iterator localeIter = null;
        Iterator itemIter = null;
        StatusInfo sourceStatus = null;
        StatusInfo targetStatus = null;
        StatusItemInfo sourceItem = null;
        Locale locale2 = null;
        StatusItemCollection targetStatusItems = null;
        boolean isOverride = false;
        while (iter.hasNext()) {
            sourceStatus = (StatusInfo)iter.next();
            if (!sourceStatus.isHerited()) {
                resultModel.add(sourceStatus);
                continue;
            }
            targetStatus = new StatusInfo();
            targetStatus.setName(sourceStatus.getName());
            targetStatus.setAlias(sourceStatus.getAlias());
            targetStatus.setDescription(sourceStatus.getDescription());
            if (locales != null) {
                for (Locale locale2 : locales) {
                    targetStatus.setAlias(sourceStatus.getAlias(locale2), locale2);
                    targetStatus.setDescription(sourceStatus.getDescription(locale2), locale2);
                }
            }
            itemIter = sourceStatus.getStatusItems().iterator();
            targetStatusItems = new StatusItemCollection();
            while (itemIter.hasNext()) {
                sourceItem = (StatusItemInfo)itemIter.next();
                if (sourceItem.isHerited() && !sourceItem.isOverride()) continue;
                targetStatusItems.add(sourceItem);
                isOverride = true;
            }
            if (!isOverride) continue;
            targetStatus.setStatusItems(targetStatusItems);
            resultModel.add(targetStatus);
        }
        return resultModel;
    }

    private static ActionCollection parseActions(ActionCollection completeModel) {
        assert (completeModel != null);
        ActionCollection resultModel = new ActionCollection();
        Iterator iter = completeModel.iterator();
        ActionInfo sourceInfo = null;
        while (iter.hasNext()) {
            sourceInfo = (ActionInfo)iter.next();
            sourceInfo.setBeforeActionPerformed(sourceInfo.getBeforeAction().getCode());
            sourceInfo.setAfterActionPerformed(sourceInfo.getAfterAction().getCode());
            sourceInfo.setFinallyActionPerformed(sourceInfo.getFinallyAction().getCode());
            if (sourceInfo.isHerited() && !sourceInfo.isOverride()) continue;
            resultModel.add(sourceInfo);
        }
        return resultModel;
    }

    private static void initComponent(ComponentInfo sourceModel, ComponentInfo targetModel, List locales) {
        assert (sourceModel != null && targetModel != null);
        targetModel.setName(sourceModel.getName());
        targetModel.setContainer(sourceModel.isContainer());
        targetModel.setClassType(sourceModel.getClassType());
        targetModel.setRules(sourceModel.getRules());
        targetModel.setUserDefined(sourceModel.isUserDefined());
    }

    private static ComponentInfo parseComponent(ComponentInfo completeModel, List locales) {
        Object tempConstraint;
        LayoutInfo layoutInfo;
        assert (completeModel != null);
        if (!completeModel.isHerited()) {
            return completeModel;
        }
        ComponentInfo resultModel = new ComponentInfo();
        boolean isOverride = false;
        UIAssembler.initComponent(completeModel, resultModel, locales);
        if (completeModel.isOverrideParent() && completeModel.getParent() != null) {
            resultModel.setParent(completeModel.getParent());
            isOverride = true;
        }
        if ((layoutInfo = completeModel.getLayoutInfo()) != null && layoutInfo.isOverride()) {
            resultModel.setLayoutInfo(layoutInfo);
            isOverride = true;
        }
        if (completeModel.isOverrideConstraint() && (tempConstraint = completeModel.getConstraint()) != null) {
            resultModel.setConstraint(tempConstraint, false);
            isOverride = true;
        }
        if (completeModel.isOverrideTabIndex()) {
            resultModel.setTabIndex(completeModel.getTabIndex());
            isOverride = true;
        }
        Iterator iter = completeModel.getProperties().iterator();
        PropertyInfo sourceProp = null;
        PropertyCollection resultProps = resultModel.getProperties();
        while (iter.hasNext()) {
            sourceProp = (PropertyInfo)iter.next();
            if (!sourceProp.isOverride() && (!"com.kingdee.bos.ctrl.web.DataGrid".equals(resultModel.getClassType()) || !"binding".equals(sourceProp.getName()))) continue;
            resultProps.add(sourceProp);
            isOverride = true;
        }
        iter = completeModel.getPropertyBindings().iterator();
        PropertyBindingInfo sourcePropBinding = null;
        PropertyBindingCollection resultPBs = resultModel.getPropertyBindings();
        while (iter.hasNext()) {
            sourcePropBinding = (PropertyBindingInfo)iter.next();
            if (sourcePropBinding.isHerited() && !sourcePropBinding.isOverride()) continue;
            resultPBs.add(sourcePropBinding);
            isOverride = true;
        }
        iter = completeModel.getEventBindings().iterator();
        EventBindingInfo sourceEB = null;
        EventBindingCollection resultEBs = resultModel.getEventBindings();
        while (iter.hasNext()) {
            sourceEB = (EventBindingInfo)iter.next();
            if (sourceEB.isHerited() && !sourceEB.isOverride()) continue;
            resultEBs.add(sourceEB);
            isOverride = true;
        }
        if (completeModel.isOverrideRules()) {
            isOverride = true;
        }
        if (isOverride) {
            return resultModel;
        }
        return null;
    }

    private static void handleTolerantDefault(AbstractUIObjectInfo completeModel) {
        ComponentInfo tempInfo2 = null;
        String tempStr = null;
        Vector<ComponentInfo> badComps = new Vector<ComponentInfo>();
        Iterator iter = completeModel.getComponents().iterator();
        while (iter.hasNext()) {
            tempInfo2 = (ComponentInfo)iter.next();
            tempStr = tempInfo2.getClassType();
            if (StringUtils.isEmpty((String)tempStr)) {
                badComps.add(tempInfo2);
                continue;
            }
            if (tempInfo2.getParent() != null || "com.kingdee.bos.ctrl.swing.KDPanel".equals(tempStr) || "com.kingdee.bos.ctrl.swing.KDToolBar".equals(tempStr) || "com.kingdee.bos.ctrl.swing.KDMenuBar".equals(tempStr) || "com.kingdee.bos.ctrl.web.RootPane".equals(tempStr)) continue;
            badComps.add(tempInfo2);
        }
        for (ComponentInfo tempInfo2 : badComps) {
            completeModel.getComponents().remove(tempInfo2);
        }
        badComps.clear();
    }

    private static class UIStatusNameAssemble {
        private UIStatusNameAssemble() {
        }

        private static StatusCollection getAllStatus(List locales, AbstractUIObjectInfo originalModel) {
            StatusCollection ret = new StatusCollection();
            if (originalModel.isAssembled() || UIUtils.getParent(originalModel) == null) {
                StatusCollection temp = originalModel.getStatuses();
                Iterator iter = temp.iterator();
                while (iter.hasNext()) {
                    ret.add(UIStatusNameAssemble.copySimpleStatusProp((StatusInfo)iter.next(), locales));
                }
                return ret;
            }
            Stack<AbstractUIObjectInfo> parentStack = new Stack<AbstractUIObjectInfo>();
            AbstractUIObjectInfo parent = null;
            AbstractUIObjectInfo child = originalModel;
            while ((parent = UIUtils.getParent(child)) != null) {
                parentStack.push(parent);
                child = parent;
            }
            while (!parentStack.isEmpty()) {
                UIStatusNameAssemble.assembleStatusesSimpleProp(ret, ((AbstractUIObjectInfo)parentStack.pop()).getStatuses(), locales);
            }
            return ret;
        }

        private static StatusInfo copySimpleStatusProp(StatusInfo source, List locales) {
            assert (locales != null && source != null);
            StatusInfo newStatus = new StatusInfo();
            newStatus.setName(source.getName());
            for (Locale locale : locales) {
                newStatus.setAlias(source.getAlias(locale), locale);
                newStatus.setDescription(source.getDescription(locale), locale);
            }
            return newStatus;
        }

        private static void assembleStatusesSimpleProp(StatusCollection target, StatusCollection source, List locales) {
            Iterator iter = source.iterator();
            while (iter.hasNext()) {
                StatusInfo tempSrc = (StatusInfo)iter.next();
                StatusInfo tempTarget = target.getStatusByName(tempSrc.getName());
                if (tempTarget == null) {
                    target.add(UIStatusNameAssemble.copySimpleStatusProp(tempSrc, locales));
                    continue;
                }
                for (Locale locale : locales) {
                    tempTarget.setAlias(tempSrc.getAlias(locale), locale);
                    tempTarget.setDescription(tempSrc.getDescription(locale), locale);
                }
            }
        }
    }
}

