/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.config;

import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.sql.shell.IKSQLSetting;
import com.kingdee.bos.sql.shell.Repository;
import com.kingdee.util.ConfigurationItem;

public class KSQLSetting
implements IKSQLSetting {
    private int fetchSize = 100;
    private int sqlExecute_TimeOut = 3600;
    private int queryExecute_TimeOut;
    private int testConnection_TimeOut = 10000;
    private static final ThreadLocal<Repository> currentRepository = new ThreadLocal();

    public KSQLSetting() {
        ConfigurationItem configItem = DeployInfoManagerFactory.getDeployInfoManager().getConfigItem("JDBCSetting");
        if (configItem != null) {
            String fs = configItem.getProperty("fetchSize");
            if (fs != null) {
                try {
                    this.fetchSize = Integer.parseInt(fs);
                }
                catch (Exception e) {
                    this.fetchSize = 100;
                }
            }
            if ((fs = configItem.getProperty("sqlExecute_TimeOut")) != null) {
                try {
                    this.sqlExecute_TimeOut = Integer.parseInt(fs);
                }
                catch (Exception e) {
                    this.sqlExecute_TimeOut = 3600;
                }
            }
            this.queryExecute_TimeOut = this.sqlExecute_TimeOut;
            fs = configItem.getProperty("queryExecute_TimeOut");
            if (fs != null) {
                try {
                    this.queryExecute_TimeOut = Integer.parseInt(fs);
                }
                catch (Exception e) {
                    this.queryExecute_TimeOut = this.sqlExecute_TimeOut;
                }
            }
            if ((fs = configItem.getProperty("testConnection_TimeOut")) != null) {
                try {
                    this.testConnection_TimeOut = Integer.parseInt(fs);
                }
                catch (Exception e) {
                    this.testConnection_TimeOut = 10000;
                }
            }
            try {
                Class.forName("com.kingdee.bos.db.PostgresTableManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getSQLExecute_TimeOut() {
        return this.sqlExecute_TimeOut;
    }

    public int getQueryExecute_TimeOut() {
        return this.queryExecute_TimeOut;
    }

    public Repository setCurrentRepository(Repository repo) {
        Repository r = currentRepository.get();
        currentRepository.set(repo);
        return r;
    }

    public Repository getCurrentRepository() {
        return currentRepository.get();
    }

    public int getTestConnection_TimeOut() {
        return this.testConnection_TimeOut;
    }
}

