/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.IServerLoginContextFilter;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class LoginContextInterceptor {
    protected static final Logger logger = Logger.getLogger(LoginContextInterceptor.class);
    private static IServerLoginContextFilter[] filters;
    public static final String CONFIGITEM_LOGIN_CONTEXT_FILTERS = "loginContextFilters";

    public static void doFilters(Context userContext) throws BOSLoginException {
        LoginContextInterceptor.initFilters();
        for (int i = 0; i < filters.length; ++i) {
            filters[i].doFilter(userContext);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Invoke LoginModule Filter [" + filters[i].getClass().getName() + "] OK"));
        }
    }

    private static synchronized void initFilters() throws BOSLoginException {
        if (filters != null) {
            return;
        }
        ArrayList<IServerLoginContextFilter> tempFilters = new ArrayList<IServerLoginContextFilter>();
        try {
            ConfigurationItem loginCtxFilesItem = Configuration.getInstance().getConfigItem(CONFIGITEM_LOGIN_CONTEXT_FILTERS);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Start init LoginModule filters ... ");
            }
            TreeMap filtersName = new TreeMap(loginCtxFilesItem.getProperties());
            Iterator iterator = filtersName.entrySet().iterator();
            while (iterator.hasNext()) {
                Class<?> clazz;
                String filterName;
                block15: {
                    filterName = (String)iterator.next().getValue();
                    ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                    if (tcl == null) {
                        tcl = ClassLoader.getSystemClassLoader();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Can NOT get TCL, SystemClassLoader replaced.");
                        }
                    }
                    clazz = null;
                    try {
                        clazz = tcl.loadClass(filterName);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Filter[" + filterName + "] loaded use TCL or SystemClassLoader."));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (clazz == null) {
                        try {
                            clazz = Class.forName(filterName);
                            if (!logger.isDebugEnabled()) break block15;
                            logger.debug((Object)("Filter[" + filterName + "] loaded use CallerClassLoader."));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Can NOT load Filter Class[" + filterName + "]"));
                            continue;
                        }
                    }
                }
                try {
                    IServerLoginContextFilter filter = (IServerLoginContextFilter)clazz.newInstance();
                    tempFilters.add(filter);
                }
                catch (Exception e) {
                    logger.error((Object)("Filter class[" + filterName + "] new instance error"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        filters = tempFilters.toArray(new IServerLoginContextFilter[tempFilters.size()]);
    }
}

