/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.hotdeploy;

import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WatchDog
implements Runnable {
    private static final Logger logger = Logger.getLogger(WatchDog.class);
    private long interval = -1L;
    private boolean stopped = false;
    private File watchDir;
    private MDLoader mdLoader;
    private List trash;
    private boolean daemon = true;
    private FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (pathname.isFile()) {
                return Utils.acceptSuffix(pathname.getName());
            }
            return true;
        }
    };
    private Map lm = new HashMap();

    public WatchDog(String watchPath, MDLoader mdLoader, long interval) {
        this.trash = new ArrayList();
        if (interval < 1L) {
            throw new IllegalArgumentException("interval less than 1.");
        }
        if (mdLoader == null) {
            throw new IllegalArgumentException("mdLoader cannot be null");
        }
        this.mdLoader = mdLoader;
        this.interval = interval;
        File f = new File(watchPath);
        if (f.exists()) {
            this.watchDir = f;
        } else {
            f.mkdir();
            this.watchDir = f;
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("watchPath not a dir");
        }
    }

    private void init() {
        this.init(this.watchDir);
    }

    private void init(File dir) {
        File[] children = dir.listFiles(this.filter);
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (child.isFile()) {
                    this.lm.put(child.getPath(), new Long(child.lastModified()));
                    continue;
                }
                this.init(child);
            }
        }
    }

    protected final void scan() {
        File[] files = this.listChangedFiles(this.watchDir);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            String path = f.getPath();
            path = path.substring(this.watchDir.getPath().length());
            this.mdLoader.clearOv(path);
        }
    }

    private File[] listChangedFiles(File dir) {
        ArrayList list = new ArrayList();
        this.listAllFiles(dir, list);
        return list.toArray(new File[0]);
    }

    private void listAllFiles(File dir, List list) {
        File[] children = dir.listFiles(this.filter);
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (child.isFile()) {
                    String path = child.getPath();
                    if (this.lm.containsKey(path) && child.lastModified() == ((Long)this.lm.get(path)).longValue()) continue;
                    list.add(child);
                    this.lm.put(child.getPath(), new Long(child.lastModified()));
                    continue;
                }
                this.listAllFiles(children[i], list);
            }
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "BOS-HotDeploy-WatchDog");
        t.setDaemon(this.daemon);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)("BOS HotDeploy WatchDog start watching dir " + this.watchDir.getAbsolutePath()));
        this.init();
        WatchDog watchDog = this;
        synchronized (watchDog) {
            while (!this.stopped) {
                long now;
                long until = System.currentTimeMillis() + this.interval;
                while (!this.stopped && until > (now = System.currentTimeMillis())) {
                    try {
                        this.wait(until - now);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.stopped) continue;
                this.scan();
            }
        }
    }
}

