/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.xml.CheckReport;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.DynamicMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataContainer;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.deployfile.DeployFileFactory;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.application.MetaDataCollection;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.io.OutputStream;

public abstract class AbstractMetaDataContainer
extends AbstractMetaDataCtrl
implements IMetaDataContainer {
    public AbstractMetaDataContainer() {
        this.registerInterface(IMetaDataContainer.class, this);
    }

    public AbstractMetaDataContainer(Context ctx) {
        super(ctx);
        this.registerInterface(IMetaDataContainer.class, this);
    }

    @Override
    public void check(String name, CheckReportFilter filter, ICheckReport report, OutputStream os) throws DataAccessException {
        this.inner_check(this.getMetaDatas(name), filter, report, os);
    }

    @Override
    public void check(CheckReportFilter filter, ICheckReport report, OutputStream os) throws DataAccessException {
        this.inner_check(this.getMetaDatas(), filter, report, os);
    }

    @Override
    public void deploy(CheckReportFilter filter, ICheckReport report, OutputStream os, DeployOptionInfo options) throws DataAccessException {
        this.inner_deploy(this.getMetaDatas(), filter, report, os, options);
    }

    @Override
    public void deploy(String name, CheckReportFilter filter, ICheckReport report, OutputStream os, DeployOptionInfo options) throws DataAccessException {
        this.inner_deploy(this.getMetaDatas(name), filter, report, os, options);
    }

    protected void inner_check(MetaDataCollection metas, CheckReportFilter filter, ICheckReport report, OutputStream os) throws DataAccessException {
        try {
            for (int i = 0; i < metas.size(); ++i) {
                MetaDataInfo meta = metas.get(i);
                DynamicMetaDataCtrl ctrl = DynamicMetaDataCtrl.getMetadataCtrl(this.getContext(), BOSObjectType.create((String)meta.getMetaDataType()));
                ctrl.check(MetaDataPK.create(meta.getPackage(), meta.getName()), filter, report, os);
            }
        }
        catch (BOSException bose) {
            throw new DataAccessException(bose);
        }
    }

    protected void inner_deploy(MetaDataCollection metas, CheckReportFilter filter, ICheckReport report, OutputStream os, DeployOptionInfo options) throws DataAccessException {
        if (options.getDeployLevel() == 0) {
            throw new DataAccessException("You must define a deploy level!");
        }
        try {
            DynamicMetaDataCtrl ctrl;
            MetaDataInfo meta;
            int i;
            if (report == null && os == null) {
                os = System.out;
            }
            if (report == null) {
                report = new CheckReport();
            }
            report.getItems().clear();
            for (i = 0; i < metas.size(); ++i) {
                meta = metas.get(i);
                ctrl = DynamicMetaDataCtrl.getMetadataCtrl(this.getContext(), BOSObjectType.create((String)meta.getMetaDataType()));
                ctrl.check(MetaDataPK.create(meta.getPackage(), meta.getName()), filter, report, os);
                if (report.getItems().size() <= 0) continue;
                return;
            }
            for (i = 0; i < metas.size(); ++i) {
                meta = metas.get(i);
                ctrl = DynamicMetaDataCtrl.getMetadataCtrl(this.getContext(), BOSObjectType.create((String)meta.getMetaDataType()));
                ctrl.deploy(MetaDataPK.create(meta.getPackage(), meta.getName()), options);
            }
            if (options.isDeployMetadata()) {
                DeployFileFactory.generateBOIndex(this.getContext(), metas, options);
            }
        }
        catch (BOSException bose) {
            throw new DataAccessException(bose);
        }
    }
}

