/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.IORWException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.AbstractXMLController;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.IXMLDAO;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLIOException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.service.netfile.InvalidateNetFileSourceException;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractMetaDataCtrl
extends AbstractXMLController
implements IMetaDataCtrl {
    private static Logger logger = Logger.getLogger(AbstractMetaDataCtrl.class);

    protected AbstractMetaDataCtrl() {
        this.registerInterface(IMetaDataCtrl.class, this);
    }

    protected AbstractMetaDataCtrl(Context ctx) {
        super(ctx);
        this.registerInterface(IMetaDataCtrl.class, this);
    }

    protected void loadSelfMetametaData(IMetaDataPK pk) {
        try {
            ((IXMLDAO)this.getDAO()).loadMetametaData(pk);
        }
        catch (DataAccessException dae) {
            logger.error((Object)dae, (Throwable)((Object)dae));
            throw new AssertionError((Object)("Cannot load metametadata [" + pk + "]"));
        }
    }

    @Override
    public void remove(IMetaDataPK metaDataPK) throws BOSException {
        this.getDAO().delete(metaDataPK);
    }

    @Override
    public boolean exists(IMetaDataPK metaDataPK) throws BOSException {
        return this.getDAO().exists(metaDataPK);
    }

    @Override
    public IMetaDataPK[] getPKList() throws BOSException {
        IObjectPK[] opks = this.getDAO().getPKList();
        if (opks != null) {
            ArrayList<IObjectPK> pks = new ArrayList<IObjectPK>();
            for (int i = 0; i < opks.length; ++i) {
                if (!(opks[i] instanceof IMetaDataPK)) continue;
                pks.add(opks[i]);
            }
            return pks.toArray(new IMetaDataPK[0]);
        }
        return null;
    }

    @Override
    public IMetaDataPK[] getPKList(String pgName) throws BOSException {
        return (IMetaDataPK[])((IXMLDAO)this.getDAO()).getPKList(pgName);
    }

    @Override
    public Map loadResource(IMetaDataPK pk) throws BOSException {
        return ((IXMLDAO)this.getDAO()).loadResource(pk);
    }

    @Override
    public Map loadResource(InputStream is) throws BOSException {
        return ((IXMLDAO)this.getDAO()).loadResource(is);
    }

    @Override
    public void storeResource(IMetaDataPK pk, Map resource) throws BOSException {
        ((IXMLDAO)this.getDAO()).storeResource(pk, resource);
    }

    public void storeResource(IObjectValue ov, Map resource) throws BOSException {
        ((IXMLDAO)this.getDAO()).storeResource(ov, resource);
    }

    @Override
    public void storeResource(InputStream is, OutputStream os, Map resource) throws BOSException {
        ((IXMLDAO)this.getDAO()).storeResource(is, os, resource);
    }

    @Override
    public void check(IMetaDataPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        ((IXMLDAO)this.getDAO()).check(pk, filter, report, os);
    }

    @Override
    public void check(IMetaDataPK pk, CheckReportFilter filter, ICheckReport report) throws BOSException {
        ((IXMLDAO)this.getDAO()).check((IObjectPK)pk, filter, report);
    }

    @Override
    public void check(IMetaDataPK pk, CheckReportFilter filter, OutputStream os) throws BOSException {
        ((IXMLDAO)this.getDAO()).check((IObjectPK)pk, filter, os);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        ((IXMLDAO)this.getDAO()).check(ui, filter, report, os);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report) throws BOSException {
        ((IXMLDAO)this.getDAO()).check(ui, filter, report);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, OutputStream os) throws BOSException {
        ((IXMLDAO)this.getDAO()).check(ui, filter, os);
    }

    @Override
    public void deploy(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        if (options.isDeployMetadata()) {
            this.deployMetaDataFile(pk, options);
        }
    }

    @Override
    public void deploy(AbstractMetaDataValue ui, DeployOptionInfo options) throws BOSException {
        if (options.isDeployMetadata()) {
            this.deployMetaDataFile(MetaDataPK.create(ui.getFullName()), options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void deployMetaDataFile(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        int BUFF_SIZE = 1000;
        byte[] buffer = new byte[BUFF_SIZE];
        InputStream in = null;
        OutputStream out = null;
        NetFile srcFile = null;
        NetFile targetFile = null;
        long srcST = 0L;
        boolean copyed = false;
        try {
            NetFile pg;
            String fileName = pk.toString() + Utils.getMetaDataSuffix(this.getType());
            String uri = options.getMetaDataRepository();
            NetFileSource targetFileSrc = new NetFileSource(new File(uri).toURL().toString());
            NetFileFactory targetFileFactory = NetFileHelper.getNetFileFactory((NetFileSource)targetFileSrc);
            NetFileSource sourceFileSrc = null;
            if (options.getDevLevel() == 0) {
                sourceFileSrc = Utils.getMetaDataFileSrcWithExist(this.getContext(), fileName);
                if (sourceFileSrc == null) {
                    logger.info((Object)(fileName + " deploy fail before the metadata source file no found"));
                    return;
                }
            } else {
                String EXT_SOLUTION_EXPORT_TEMP_DIR = "exporttemp";
                String ext_meta_path = this.getContext().get((Object)EXT_SOLUTION_EXPORT_TEMP_DIR).toString();
                sourceFileSrc = new NetFileSource(new File(ext_meta_path).toURL().toString());
            }
            NetFileFactory sourceFileFactory = NetFileHelper.getNetFileFactory((NetFileSource)sourceFileSrc);
            srcFile = sourceFileFactory.createNetFile(fileName);
            targetFile = targetFileFactory.createNetFile(fileName);
            srcST = srcFile.lastModified();
            if (srcST == targetFile.lastModified() && srcFile.length() == targetFile.length()) {
                return;
            }
            in = sourceFileFactory.createNetFileInputStream(srcFile);
            if (pk.getPackage() != null && !(pg = targetFileFactory.createNetFile(pk.getPackage().replace('.', File.separatorChar))).exists()) {
                pg.mkdirs();
            }
            out = targetFileFactory.createNetFileOutputStream(targetFile);
            while (true) {
                byte[] byArray = buffer;
                // MONITORENTER : buffer
                int amountRead = in.read(buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : byArray
                    copyed = true;
                    return;
                }
                out.write(buffer, 0, amountRead);
                // MONITOREXIT : byArray
            }
        }
        catch (InvalidateNetFileSourceException e) {
            throw new IORWException(e.getMessage());
        }
        catch (MalformedURLException me) {
            throw new IORWException(me.getMessage());
        }
        catch (IOException ioe) {
            logger.info((Object)("System property metadata.path: " + System.getProperty("metadata.path")));
            Context ctx = this.getContext();
            if (ctx == null) {
                logger.info((Object)"AbstractMetaDataCtrl current context is null");
            } else {
                logger.info((Object)("AbstractMetaDataCtrl current Context.METADATAPATH: " + ctx.get((Object)"METADATAPATH")));
            }
            logger.error((Object)ioe, (Throwable)ioe);
            throw new XMLIOException(ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            try {
                if (copyed) {
                    targetFile.setLastModified(srcST);
                }
            }
            catch (Exception exception) {}
        }
    }

    public IObjectValue load(InputStream is) throws DataAccessException {
        return ((IXMLDAO)this.getDAO()).load(is);
    }

    public void store(IObjectValue ov, OutputStream os) throws DataAccessException {
        ((IXMLDAO)this.getDAO()).store(ov, os);
    }
}

