/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.RelationManager;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.DynamicMetaDataContainer;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.IPackageCtrl;
import com.kingdee.bos.metadata.management.application.IAppViewCtrl;
import com.kingdee.bos.metadata.management.application.MetaDataCollection;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.metadata.mr.MetadataParser;
import com.kingdee.bos.metadata.mr.Ref;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DeployManager {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.metadata.DeployManager");
    public static final FileFilter filter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (pathname.isFile()) {
                return Utils.acceptSuffix(pathname.getName());
            }
            return true;
        }
    };

    public static void deploy(String path, String packageName, DeployOptionInfo option) throws BOSException {
        DeployManager.deploy(path, packageName, null, null, null, option);
    }

    public static void deploy(String path, DeployOptionInfo option) throws BOSException {
        DeployManager.deploy(path, null, null, null, option);
    }

    public static void deployApplicatoin(String path, String appName, DeployOptionInfo option) throws BOSException {
        DeployManager.deployApplication(path, appName, null, null, null, option);
    }

    public static void deployApplication(String path, String appName, CheckReportFilter filter, ICheckReport report, OutputStream os, DeployOptionInfo option) throws BOSException {
        Context ctx = ContextManager.getContext();
        ctx.put((Object)"METADATAPATH", (Object)path);
        IAppViewCtrl appCtrl = (IAppViewCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.APPVIEW);
        MetaDataCollection ms = appCtrl.getMetaDatas(appName);
        MetaDataInfo[] mds = new MetaDataInfo[ms.size()];
        for (int i = 0; i < mds.length; ++i) {
            mds[i] = ms.get(i);
        }
        DeployManager.deployMetas(path, mds, filter, report, os, option);
    }

    public static void deploy(String path, CheckReportFilter filter, ICheckReport report, OutputStream os, DeployOptionInfo options) throws BOSException {
        DeployManager.deploy(path, null, filter, report, os, options);
    }

    public static void deploy(String path, String name, CheckReportFilter filter, ICheckReport report, OutputStream os, DeployOptionInfo options) throws BOSException {
        DeployManager.deploy(path, name, filter, report, os, options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deploy(String path, String name, CheckReportFilter filter, ICheckReport report, OutputStream os, DeployOptionInfo options, List fileNameList) throws BOSException {
        ConfigMDUtil.setNoAIS(true);
        try {
            MetaDataCollection ms = DeployManager.getMetaDatas(path, name, fileNameList);
            MetaDataInfo[] mds = new MetaDataInfo[ms.size()];
            for (int i = 0; i < mds.length; ++i) {
                mds[i] = ms.get(i);
            }
            DeployManager.deployMetas(path, mds, filter, report, os, options, fileNameList);
        }
        finally {
            ConfigMDUtil.setNoAIS(false);
        }
    }

    private static MetaDataCollection getMetaDatas(String path, String name, List fileNameList) throws BOSException {
        Context ctx = ContextManager.getContext();
        ctx.put((Object)"METADATAPATH", (Object)path);
        IPackageCtrl pgCtrl = (IPackageCtrl)((Object)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.PACKAGE));
        MetaDataCollection allms = null;
        if (fileNameList != null && fileNameList.size() > 0) {
            allms = new MetaDataCollection();
            MetaDataCollection ms = null;
            String packageName = null;
            ArrayList packageNameList = new ArrayList();
            int n = fileNameList.size();
            for (int i = 0; i < n; ++i) {
                packageName = DeployManager.getMetadataPackageName((String)fileNameList.get(i));
                DeployManager.addPackageName(packageNameList, packageName);
            }
            StringBuffer buf = new StringBuffer();
            for (int i = packageNameList.size() - 1; i >= 0; --i) {
                packageName = (String)packageNameList.get(i);
                buf.append(packageName + ";");
                ms = pgCtrl.getMetaDatas(packageName);
                allms.addObjectCollection(ms);
                if (ms != null) {
                    buf.append(ms.size() + ";");
                    continue;
                }
                buf.append("null;");
            }
            logger.info((Object)("package list:" + buf.toString()));
        } else {
            allms = pgCtrl.getMetaDatas(name);
        }
        return allms;
    }

    private static void addPackageName(List packageNameList, String name) {
        if (StringUtils.isEmpty((String)name) || packageNameList.contains(name)) {
            return;
        }
        for (int i = packageNameList.size() - 1; i >= 0; --i) {
            String packageName = (String)packageNameList.get(i);
            if (packageName.indexOf(name + ".") >= 0) {
                packageNameList.remove(i);
                continue;
            }
            if (name.indexOf(packageName + ".") < 0) continue;
            logger.info((Object)("addPackageName skip :" + name));
            return;
        }
        packageNameList.add(name);
    }

    private static String getMetadataPackageName(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return null;
        }
        String packageName = fullName;
        int dotIndex = packageName.lastIndexOf(".");
        if (dotIndex <= 0) {
            return null;
        }
        packageName = packageName.substring(0, dotIndex);
        dotIndex = packageName.lastIndexOf(".");
        if (dotIndex <= 0) {
            return null;
        }
        packageName = packageName.substring(0, dotIndex);
        if (packageName.endsWith(".app")) {
            packageName = packageName.substring(0, packageName.length() - 4);
        } else if (packageName.endsWith(".client")) {
            packageName = packageName.substring(0, packageName.length() - 7);
        }
        return packageName;
    }

    public static void deployMeta(String path, MetaDataInfo meta, DeployOptionInfo option) throws BOSException {
        DeployManager.deployMetas(path, new MetaDataInfo[]{meta}, option);
    }

    public static void deployMetas(String path, MetaDataInfo[] metas, DeployOptionInfo options) throws BOSException {
        DeployManager.deployMetas(path, metas, null, null, null, options);
    }

    public static void deployMetas(String path, MetaDataInfo[] metas, CheckReportFilter filter, ICheckReport report, OutputStream os, DeployOptionInfo options) throws BOSException {
        DeployManager.deployMetas(path, metas, filter, report, os, options, null);
    }

    public static void deployMetas(String path, MetaDataInfo[] metas, CheckReportFilter filter, ICheckReport report, OutputStream os, DeployOptionInfo options, List fileNameList) throws BOSException {
        ConfigMDUtil.setNoAIS(true);
        if (metas == null) {
            return;
        }
        Context ctx = ContextManager.getContext();
        ctx.put((Object)"METADATAPATH", (Object)path);
        logger.info((Object)("metadata path:" + path));
        metas = DeployManager.getFilterMetadatas(metas, fileNameList);
        logger.info((Object)("after filter metadata's size:" + metas.length));
        DynamicMetaDataContainer dyCtrl = new DynamicMetaDataContainer(ctx);
        if (options.isIncrementDeploy()) {
            logger.info((Object)("\n\n\u8bf7\u6c42\u53d1\u5e03\u7684\u539f\u59cb\u5143\u6570\u636e\u4e2a\u6570[" + metas.length + "]"));
            String target = options.getMetaDataRepository();
            try {
                int i;
                NetFileSource targetFileSrc = new NetFileSource(new File(target).toURL().toString());
                NetFileFactory targetFileFactory = NetFileHelper.getNetFileFactory((NetFileSource)targetFileSrc);
                NetFileSource sourceFileSrc = Utils.getMetaDataFileSrc(ctx);
                NetFileFactory sourceFileFactory = NetFileHelper.getNetFileFactory((NetFileSource)sourceFileSrc);
                NetFile srcFile = null;
                NetFile targetFile = null;
                int count = 0;
                MetaDataInfo[] realMetas = new MetaDataInfo[metas.length];
                for (i = 0; i < metas.length; ++i) {
                    MetaDataInfo md = metas[i];
                    String filename = md.getFullName().replace('.', File.separatorChar) + Utils.getMetaDataSuffix(BOSObjectType.create((String)md.getMetaDataType()));
                    srcFile = sourceFileFactory.createNetFile(filename);
                    targetFile = targetFileFactory.createNetFile(filename);
                    if (srcFile.lastModified() == targetFile.lastModified() && srcFile.length() == targetFile.length()) continue;
                    realMetas[count] = md;
                    ++count;
                }
                logger.info((Object)("\n\u53d8\u5316\u4e86\u7684\u5143\u6570\u636e\u4e2a\u6570[" + count + "]"));
                for (i = 0; i < count; ++i) {
                    logger.debug((Object)("\t" + realMetas[i].getFullName()));
                }
                MetaDataInfo[] realMetas2 = new MetaDataInfo[count];
                System.arraycopy(realMetas, 0, realMetas2, 0, count);
                realMetas = null;
                RelationManager rm = XMLAccessEngine.getRelationManager(ctx);
                Collection linkeds = new ArrayList();
                if (realMetas2.length > 0) {
                    rm.loadRelation();
                    linkeds = rm.relationTree().getAllLinked(MetadataParser.info2ref(realMetas2));
                    logger.info((Object)("\n\u4f9d\u8d56\u4e8e\u53d8\u5316\u7684\u5143\u6570\u636e\u4e2a\u6570[" + linkeds.size() + "]"));
                    Iterator it = linkeds.iterator();
                    while (it.hasNext()) {
                        logger.debug((Object)("\t" + ((Ref)it.next()).getFullName()));
                    }
                }
                MetaDataInfo[] result = new MetaDataInfo[realMetas2.length + linkeds.size()];
                System.arraycopy(realMetas2, 0, result, 0, count);
                realMetas2 = null;
                logger.info((Object)("\n\u5b8c\u6574\u4f9d\u8d56\u96c6\u7684\u5143\u6570\u636e\u4e2a\u6570[" + result.length + "]"));
                Iterator it = linkeds.iterator();
                while (it.hasNext()) {
                    result[count++] = MetadataParser.ref2info((Ref)it.next());
                }
                metas = result;
            }
            catch (Throwable e) {
                logger.error((Object)e, e);
            }
        }
        for (int i = 0; i < metas.length; ++i) {
            dyCtrl.addMetaData(metas[i]);
        }
        dyCtrl.deploy(filter, report, os, options);
    }

    public static void check(String path) throws BOSException {
        DeployManager.check(path, null);
    }

    public static void check(String path, String packageName) throws BOSException {
        DeployManager.check(path, packageName, null, null, null);
    }

    public static void check(String path, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        DeployManager.check(path, null, filter, report, os);
    }

    public static void check(String path, String packageName, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        Context ctx = ContextManager.getContext();
        ctx.put((Object)"METADATAPATH", (Object)path);
        IPackageCtrl pgCtrl = (IPackageCtrl)((Object)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.PACKAGE));
        pgCtrl.check(packageName, filter, report, os);
    }

    public static void checkApplicatoin(String path, String appName) throws BOSException {
        DeployManager.checkApplication(path, appName, null, null, null);
    }

    public static void checkApplication(String path, String appName, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        Context ctx = ContextManager.getContext();
        ctx.put((Object)"METADATAPATH", (Object)path);
        IAppViewCtrl appCtrl = (IAppViewCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.APPVIEW);
        appCtrl.check(appName, filter, report, os);
    }

    public static void checkMeta(String path, MetaDataInfo meta) throws BOSException {
        DeployManager.checkMetas(path, new MetaDataInfo[]{meta});
    }

    public static void checkMetas(String path, MetaDataInfo[] metas) throws BOSException {
        DeployManager.checkMetas(path, metas, null, null, null);
    }

    public static void checkMetas(String path, MetaDataInfo[] metas, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        if (metas == null) {
            return;
        }
        Context ctx = ContextManager.getContext();
        ctx.put((Object)"METADATAPATH", (Object)path);
        DynamicMetaDataContainer dyCtrl = new DynamicMetaDataContainer(ctx);
        for (int i = 0; i < metas.length; ++i) {
            dyCtrl.addMetaData(metas[i]);
        }
        dyCtrl.check(filter, report, os);
    }

    public String[] getRTCommonMetaExtendNames() {
        return new String[]{"datax", "entity", "enum", "exception", "facade", "function", "mdbview", "mdquery", "package", "permission", "query", "relation", "report", "solution", "table", "ui"};
    }

    public String[] getRTClientMetaExtendNames() {
        return new String[0];
    }

    public String[] getRTServerMetasExtendNames() {
        return new String[0];
    }

    public String[] getDTMetasExtendNames() {
        return new String[]{"bizdatatype", "resource", "imageresource", "rule", "ruleset", "biztemplate", "bizfieldtemplateset", "bizunit", "log"};
    }

    private static MetaDataInfo[] getFilterMetadatas(MetaDataInfo[] src) {
        return DeployManager.getFilterMetadatas(src, null);
    }

    private static MetaDataInfo[] getFilterMetadatas(MetaDataInfo[] src, List fileNameList) {
        Vector<MetaDataInfo> temp = new Vector<MetaDataInfo>();
        NetFileFactory[] netFileFactorys = DeployManager.getNetFileFactorys(ContextManager.getContext());
        for (int i = 0; i < src.length; ++i) {
            MetaDataInfo mdi = src[i];
            String fileName = new MetaDataPK(mdi.getFullName()).toString() + Utils.getMetaDataSuffix(BOSObjectType.create((String)mdi.getMetaDataType()));
            String fullName = StringUtils.replace((String)fileName, (String)"\\", (String)".");
            fullName = StringUtils.replace((String)fullName, (String)"/", (String)".");
            if (fileNameList != null && !fileNameList.contains(fullName) || !DeployManager.isFileExist(netFileFactorys, fileName)) continue;
            temp.add(mdi);
        }
        MetaDataInfo[] mds = new MetaDataInfo[temp.size()];
        for (int i = 0; i < mds.length; ++i) {
            mds[i] = (MetaDataInfo)temp.get(i);
        }
        return mds;
    }

    private static NetFileFactory[] getNetFileFactorys(Context ctx) {
        int i;
        String[] userDir = Utils.getMetadataPath(ctx);
        NetFileFactory[] netFileFactorys = new NetFileFactory[userDir.length];
        try {
            int n = userDir.length;
            for (i = 0; i < n; ++i) {
                NetFileSource netFileSource = new NetFileSource(new File(userDir[i]).toURL().toString());
                netFileFactorys[i] = NetFileHelper.getNetFileFactory((NetFileSource)netFileSource);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new Error("Invalidate NetFileSource: " + userDir[i]);
        }
        return netFileFactorys;
    }

    private static boolean isFileExist(NetFileFactory[] netFileFactory, String fileName) {
        if (netFileFactory == null || StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        int n = netFileFactory.length;
        for (int i = 0; i < n; ++i) {
            if (!netFileFactory[i].createNetFile(fileName).exists()) continue;
            return true;
        }
        return false;
    }

    public static void deploy(String path, DeployOptionInfo option, String needDeployPath, ICheckReport report) throws BOSException {
        ArrayList list = new ArrayList();
        File base = new File(needDeployPath);
        DeployManager.getMetadatas(base.getAbsolutePath(), base, list);
        MetaDataInfo[] mds = list.toArray(new MetaDataInfo[0]);
        DeployManager.deployMetas(path, mds, null, report, null, option);
    }

    private static void getMetadatas(String base, File path, List list) {
        File[] children = path.listFiles(filter);
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (child.isFile()) {
                    String s = child.getAbsolutePath();
                    if ((s = s.substring(base.length())).startsWith("/") || s.startsWith("\\")) {
                        s = s.substring(1);
                    }
                    int j = s.lastIndexOf(46);
                    String suffix = s.substring(j);
                    String type = Utils.getBOSTypeBySuffix(suffix);
                    s = s.substring(0, j);
                    s = s.replace('/', '.');
                    s = s.replace('\\', '.');
                    MetaDataInfo mdi = new MetaDataInfo(new MetaDataPK(s), BOSObjectType.create((String)type));
                    list.add(mdi);
                    continue;
                }
                DeployManager.getMetadatas(base, child, list);
            }
        }
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        try {
            DeployOptionInfo option = new DeployOptionInfo();
            option.setMetaDataRepository("D:\\temp\\deploy\\meta");
            option.setJavaOutputDir("D:\\temp\\deploy\\code");
            option.setOverrideDeployFile(true);
            option.setTargetAppServer(2);
            option.setOverrideDeployFile(true);
            option.setDeployLevel(3);
            StringBuffer buff = new StringBuffer();
            buff.append("D:\\temp\\yyy;");
            File[] bases = new File("w:\\eas\\Server\\server\\metas").listFiles();
            for (int i = 0; i < bases.length; ++i) {
                buff.append(bases[i].getAbsolutePath());
                buff.append(";");
            }
            DeployManager.check(buff.toString(), "com.kingdee.eas.fi.fa.basedata.app");
            DeployManager.deploy(buff.toString(), "com.kingdee.eas.fi.fa.basedata.app", option);
        }
        catch (BOSException bose) {
            logger.error((Object)bose);
        }
    }
}

