/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.DeployException;
import com.kingdee.bos.metadata.IMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.ISolutionCtrl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.application.AppViewInfo;
import com.kingdee.bos.metadata.management.application.IAppViewCtrl;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.mutex.IMutexCtrl;
import com.kingdee.bos.service.mutex.MutexInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeployMetaDataCache {
    protected Map metaCache = new HashMap();
    protected Map ctrlCache = new HashMap();
    private Context ctx = null;
    private SolutionInfo slnInfo = null;
    private MutexInfo mutexInfo = null;
    private AppViewInfo appViewInfo = null;
    private static DeployMetaDataCache dMetaCache = null;
    private static boolean isEffective = false;
    private static Logger logger = Logger.getLogger(DeployMetaDataCache.class);

    protected DeployMetaDataCache(Context ctx) {
        this.ctx = ctx;
        isEffective = true;
    }

    public void clearCache() {
        dMetaCache = null;
        isEffective = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destoryInstance(Context ctx) {
        Class<DeployMetaDataCache> clazz = DeployMetaDataCache.class;
        synchronized (DeployMetaDataCache.class) {
            DeployMetaDataCache.getInstance(ctx).clearCache();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeployMetaDataCache getInstance(Context ctx) {
        if (dMetaCache != null) {
            return dMetaCache;
        }
        Class<DeployMetaDataCache> clazz = DeployMetaDataCache.class;
        synchronized (DeployMetaDataCache.class) {
            if (dMetaCache != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return dMetaCache;
            }
            dMetaCache = new DeployMetaDataCache(ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dMetaCache;
        }
    }

    public IObjectValue get(BOSObjectType bosType, IMetaDataPK pk) throws DeployException {
        try {
            IObjectValue ov;
            if (bosType.equals((Object)MetaDataTypeList.SOLUTION)) {
                if (this.slnInfo != null) {
                    return this.slnInfo;
                }
                this.slnInfo = ((ISolutionCtrl)this.getObjectCtrl(bosType)).getValue();
                return this.slnInfo;
            }
            if (bosType.equals((Object)MetaDataTypeList.APPVIEW)) {
                if (this.appViewInfo != null) {
                    return this.appViewInfo;
                }
                this.appViewInfo = ((IAppViewCtrl)this.getObjectCtrl(bosType)).getValue();
                return this.appViewInfo;
            }
            if (bosType.equals((Object)MetaDataTypeList.MUTEX)) {
                if (this.mutexInfo != null) {
                    return this.mutexInfo;
                }
                this.mutexInfo = ((IMutexCtrl)this.getObjectCtrl(bosType)).getValue();
            }
            if ((ov = this.getFromCache(bosType, pk)) != null) {
                return ov;
            }
            String methodName = "getValue";
            if (MetaDataTypeList.UIOBJECT.equals((Object)bosType) || MetaDataTypeList.WEBUIOBJECT.equals((Object)bosType) || MetaDataTypeList.WEBPAGEOBJECT.equals((Object)bosType) || MetaDataTypeList.WEBCOMPONENTOBJECT.equals((Object)bosType)) {
                methodName = "getAllValue";
            }
            Method getValue = this.getObjectCtrl(bosType).getClass().getMethod(methodName, IMetaDataPK.class);
            ov = (IObjectValue)getValue.invoke((Object)this.getObjectCtrl(bosType), pk);
            this.putObjectIntoCache(bosType, pk, ov);
            return ov;
        }
        catch (Exception e) {
            logger.warn((Object)e, (Throwable)e);
            throw new DeployException(e.getMessage(), e);
        }
    }

    public IObjectValue get(MetaDataInfo metaRef) throws DeployException {
        return this.get(BOSObjectType.create((String)metaRef.getMetaDataType()), MetaDataPK.create(metaRef.getPackage(), metaRef.getName()));
    }

    protected IObjectValue getFromCache(BOSObjectType bosType, IMetaDataPK pk) {
        return (IObjectValue)this.getObjectCache(bosType).get(pk);
    }

    protected Map getObjectCache(BOSObjectType bosType) {
        HashMap objCache = (HashMap)this.metaCache.get(bosType);
        if (objCache == null) {
            objCache = new HashMap();
            this.metaCache.put(bosType, objCache);
        }
        return objCache;
    }

    public IMetaDataCtrl getObjectCtrl(BOSObjectType bosType) throws BOSException {
        if (this.ctrlCache.get(bosType) != null) {
            return (IMetaDataCtrl)this.ctrlCache.get(bosType);
        }
        IMetaDataCtrl objCtrl = (IMetaDataCtrl)BOSObjectFactory.createBOSObject(this.getContext(), bosType);
        this.ctrlCache.put(bosType, objCtrl);
        return objCtrl;
    }

    public void putObjectIntoCache(BOSObjectType bosType, IMetaDataPK pk, IObjectValue ov) {
        this.getObjectCache(bosType).put(pk, ov);
    }

    public Context getContext() {
        return this.ctx;
    }

    public static boolean isEffective() {
        return isEffective;
    }

    public static void setEffective(boolean b) {
        isEffective = b;
    }
}

