/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.ISolutionCtrl;
import com.kingdee.bos.metadata.management.application.IAppViewCtrl;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.service.mutex.IMutexCtrl;
import com.kingdee.bos.util.BOSObjectType;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicMetaDataCtrl
implements IMetaDataCtrl {
    private static Logger logger = Logger.getLogger(DynamicMetaDataCtrl.class);
    private static Map ctrlCacheWithContext = new HashMap();
    private static String DEFAULT = "default";
    private BOSObjectType bosType;
    private IMetaDataCtrl innerCtrl;

    private DynamicMetaDataCtrl(BOSObjectType bosType, IMetaDataCtrl innerCtrl) {
        this.bosType = bosType;
        this.innerCtrl = innerCtrl;
    }

    public static DynamicMetaDataCtrl getMetadataCtrl(Context ctx, BOSObjectType bosType) throws BOSException {
        Map ctrlCache;
        Object key = (String)ctx.get((Object)"METADATAPATH");
        if (ctx.get((Object)"DEVMETADATALOADER") != null) {
            IDevMetadataLoader loader = (IDevMetadataLoader)ctx.get((Object)"DEVMETADATALOADER");
            key = loader.getSaveDir();
        }
        if (key == null) {
            key = DEFAULT;
        }
        if (ctrlCacheWithContext.containsKey(key)) {
            ctrlCache = (Map)ctrlCacheWithContext.get(key);
        } else {
            ctrlCache = new HashMap();
            ctrlCacheWithContext.put(key, ctrlCache);
        }
        return DynamicMetaDataCtrl.getObjectCtrl(ctx, ctrlCache, bosType);
    }

    public static void clearCache(Context ctx) {
        Object key = (String)ctx.get((Object)"METADATAPATH");
        if (ctx.get((Object)"DEVMETADATALOADER") != null) {
            IDevMetadataLoader loader = (IDevMetadataLoader)ctx.get((Object)"DEVMETADATALOADER");
            key = loader.getSaveDir();
            ctrlCacheWithContext.remove(key);
        }
    }

    public IObjectValue getValue(IMetaDataPK pk) throws BOSException {
        try {
            if (this.bosType.equals((Object)MetaDataTypeList.SOLUTION)) {
                return ((ISolutionCtrl)this.innerCtrl).getValue();
            }
            if (this.bosType.equals((Object)MetaDataTypeList.APPVIEW)) {
                return ((IAppViewCtrl)this.innerCtrl).getValue();
            }
            if (this.bosType.equals((Object)MetaDataTypeList.MUTEX)) {
                return ((IMutexCtrl)this.innerCtrl).getValue();
            }
            String methodName = "getValue";
            if (MetaDataTypeList.UIOBJECT.equals((Object)this.bosType) || MetaDataTypeList.WEBUIOBJECT.equals((Object)this.bosType) || MetaDataTypeList.WEBPAGEOBJECT.equals((Object)this.bosType) || MetaDataTypeList.WEBCOMPONENTOBJECT.equals((Object)this.bosType)) {
                methodName = "getAllValue";
            }
            Method getValue = this.innerCtrl.getClass().getMethod(methodName, IMetaDataPK.class);
            IObjectValue ov = (IObjectValue)getValue.invoke((Object)this.innerCtrl, pk);
            return ov;
        }
        catch (Exception e) {
            logger.warn((Object)e, (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private static DynamicMetaDataCtrl getObjectCtrl(Context ctx, Map ctrlCache, BOSObjectType bosType) throws BOSException {
        if (ctrlCache.get(bosType) != null) {
            return (DynamicMetaDataCtrl)ctrlCache.get(bosType);
        }
        IMetaDataCtrl objCtrl = (IMetaDataCtrl)BOSObjectFactory.createBOSObject(ctx, bosType);
        DynamicMetaDataCtrl dynamicCtrl = new DynamicMetaDataCtrl(bosType, objCtrl);
        ctrlCache.put(bosType, dynamicCtrl);
        return dynamicCtrl;
    }

    @Override
    public void check(IMetaDataPK pk, CheckReportFilter filter, OutputStream os) throws BOSException {
        this.innerCtrl.check(pk, filter, os);
    }

    @Override
    public void check(IMetaDataPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        this.innerCtrl.check(pk, filter, report, os);
    }

    @Override
    public void check(IMetaDataPK pk, CheckReportFilter filter, ICheckReport report) throws BOSException {
        this.innerCtrl.check(pk, filter, report);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, OutputStream os) throws BOSException {
        this.innerCtrl.check(ui, filter, os);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report, OutputStream os) throws BOSException {
        this.innerCtrl.check(ui, filter, report, os);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report) throws BOSException {
        this.innerCtrl.check(ui, filter, report);
    }

    @Override
    public void deploy(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        this.innerCtrl.deploy(pk, options);
    }

    @Override
    public void deploy(AbstractMetaDataValue ui, DeployOptionInfo options) throws BOSException {
        this.innerCtrl.deploy(ui, options);
    }

    @Override
    public boolean exists(IMetaDataPK metaType) throws BOSException {
        return this.innerCtrl.exists(metaType);
    }

    @Override
    public IMetaDataPK[] getPKList(String pgName) throws BOSException {
        return this.innerCtrl.getPKList(pgName);
    }

    @Override
    public IMetaDataPK[] getPKList() throws BOSException {
        return this.innerCtrl.getPKList();
    }

    @Override
    public Map loadResource(IMetaDataPK pk) throws BOSException {
        return this.innerCtrl.loadResource(pk);
    }

    @Override
    public Map loadResource(InputStream is) throws BOSException {
        return this.innerCtrl.loadResource(is);
    }

    @Override
    public void remove(IMetaDataPK metaType) throws BOSException {
        this.innerCtrl.remove(metaType);
    }

    @Override
    public void storeResource(IMetaDataPK pk, Map resource) throws BOSException {
        this.innerCtrl.storeResource(pk, resource);
    }

    @Override
    public void storeResource(InputStream is, OutputStream os, Map resource) throws BOSException {
        this.innerCtrl.storeResource(is, os, resource);
    }

    @Override
    public Context getContext() {
        return this.innerCtrl.getContext();
    }

    @Override
    public String getName() {
        return this.innerCtrl.getName();
    }

    @Override
    public BOSObjectType getType() {
        return this.innerCtrl.getType();
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this.innerCtrl.queryInterface(type);
    }
}

