/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMDReference;
import com.kingdee.bos.metadata.MDEvent;
import com.kingdee.bos.metadata.MDListener;
import com.kingdee.bos.metadata.MDProvider;
import java.util.ArrayList;
import java.util.List;

class MDReference<T extends AbstractMetaDataValue>
implements IMDReference<T> {
    private final MDProvider<T> provider;
    private volatile T md = null;
    private volatile T configueMD = null;
    private volatile int count = 0;
    private final List<MDListener> listeners = new ArrayList<MDListener>(2);

    MDReference(MDProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("MDProvider can not be null.");
        }
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        ++this.count;
        if (this.md != null) {
            return this.md;
        }
        MDProvider<T> mDProvider = this.provider;
        synchronized (mDProvider) {
            if (this.md == null) {
                this.md = this.provider.loadMD();
            }
        }
        return this.md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getConfigure() {
        ++this.count;
        if (this.configueMD != null) {
            return this.configueMD;
        }
        MDProvider<T> mDProvider = this.provider;
        synchronized (mDProvider) {
            if (this.configueMD == null) {
                this.configueMD = this.provider.loadConfigureMD();
            }
        }
        return this.configueMD;
    }

    @Override
    public void release() {
        if (this.count > 0) {
            --this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        this.count = 0;
        MDProvider<T> mDProvider = this.provider;
        synchronized (mDProvider) {
            this.md = null;
            this.configueMD = null;
            this.provider.clear();
            this.fireClearEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recycle() {
        if (this.count <= 0) {
            MDProvider<T> mDProvider = this.provider;
            synchronized (mDProvider) {
                this.md = null;
                this.configueMD = null;
                this.provider.clear();
            }
        }
    }

    @Override
    public void addMDListener(MDListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    private void fireClearEvent() {
        MDEvent e = new MDEvent(0);
        for (MDListener l : this.listeners) {
            l.performed(e);
        }
    }
}

