/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMDReference;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDListener;
import com.kingdee.bos.metadata.MDMonitor;
import com.kingdee.bos.metadata.MDProvider;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MultiMDReference;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.service.log.define.LogCollection;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionCollection;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import java.util.Map;
import java.util.Set;

public class MDReferenceFactory {
    private static final IMDReference<LogInfo> logRef = new MultiMDReference<LogInfo>(new LogProvider());
    private static final IMDReference<PermissionInfo> permRef = new MultiMDReference<PermissionInfo>(new PermissionProvider());

    public static LogInfo getLog() {
        return logRef.get();
    }

    public static LogInfo getConfigureLog() {
        return logRef.getConfigure();
    }

    public static void releaseLog() {
        logRef.release();
    }

    public static void addLogListener(MDListener l) {
        logRef.addMDListener(l);
    }

    public static void clearLog() {
        logRef.clear();
    }

    public static PermissionInfo getPermission() {
        return permRef.get();
    }

    public static PermissionInfo getConfigurePermission() {
        return permRef.getConfigure();
    }

    public static void releasePermission() {
        permRef.release();
    }

    public static void clearPermission() {
        permRef.clear();
    }

    static {
        MDMonitor.getInstance().addMonitor(new Runnable(){

            @Override
            public void run() {
                logRef.recycle();
                permRef.recycle();
            }
        }, 600000L);
    }

    static class PermissionProvider
    extends AbstractMDProvider<PermissionInfo> {
        private boolean isGetted = false;

        PermissionProvider() {
        }

        @Override
        public void clear() {
            if (this.isGetted) {
                this.getMDLoader().clear(MetaDataTypeList.PERMISSION);
                this.isGetted = false;
            }
        }

        @Override
        public PermissionInfo loadMD() {
            PermissionInfo allPermission = new PermissionInfo();
            allPermission.setName("service");
            PermissionCollection perms = (PermissionCollection)this.getMDLoader().getCollection(MetaDataTypeList.PERMISSION, null, true);
            if (perms == null) {
                return allPermission;
            }
            Set<IMetaDataPK> permPks = this.getMetaDataPKs(MetaDataTypeList.PERMISSION);
            int n = perms.size();
            for (int i = 0; i < n; ++i) {
                PermissionInfo p = perms.get(i);
                if (p == null) continue;
                this.addAll(allPermission, p, permPks != null && permPks.contains(MetaDataPK.create(p.getFullName())));
            }
            this.isGetted = true;
            return allPermission;
        }

        @Override
        public PermissionInfo loadConfigureMD() {
            PermissionInfo allPermission = new PermissionInfo();
            allPermission.setName("service");
            Set<IMetaDataPK> permPks = this.getMetaDataPKs(MetaDataTypeList.PERMISSION);
            if (permPks != null) {
                String type = MetaDataTypeList.PERMISSION.toString();
                for (IMetaDataPK pk : permPks) {
                    PermissionInfo perm = (PermissionInfo)this.getMDLoader().loadMD(new MetaDataPK2(pk.getFullName(), type));
                    this.addAll(allPermission, perm, true);
                }
            }
            this.isGetted = true;
            return allPermission;
        }

        private void addAll(PermissionInfo allPermission, PermissionInfo perm, boolean userDefined) {
            if (allPermission == null || perm == null) {
                return;
            }
            if (!perm.getName().equalsIgnoreCase("service")) {
                PermissionItemCollection allCol = allPermission.getPermissionItems();
                PermissionItemCollection col = perm.getPermissionItems();
                if (col != null) {
                    int size = col.size();
                    for (int i = 0; i < size; ++i) {
                        col.get(i).setUserDefined(userDefined);
                        allCol.add(col.get(i));
                    }
                }
                allPermission.getDependences().addObjectCollection(perm.getDependences());
            }
        }
    }

    static class LogProvider
    extends AbstractMDProvider<LogInfo> {
        private boolean isGetted = false;

        LogProvider() {
        }

        @Override
        public void clear() {
            if (this.isGetted) {
                this.getMDLoader().clear(MetaDataTypeList.LOG);
                this.isGetted = false;
            }
        }

        @Override
        public LogInfo loadMD() {
            LogInfo allLog = new LogInfo();
            allLog.setName("service");
            LogCollection logs = (LogCollection)this.getMDLoader().getCollection(MetaDataTypeList.LOG, null, true);
            if (logs == null || logs.size() == 0) {
                return allLog;
            }
            Set<IMetaDataPK> logPks = this.getMetaDataPKs(MetaDataTypeList.LOG);
            int n = logs.size();
            for (int i = 0; i < n; ++i) {
                LogInfo info = logs.get(i);
                if (info == null) continue;
                this.addAll(allLog, info, logPks != null && logPks.contains(MetaDataPK.create(info.getFullName())));
            }
            this.isGetted = true;
            return allLog;
        }

        @Override
        public LogInfo loadConfigureMD() {
            LogInfo allLog = new LogInfo();
            allLog.setName("service");
            Set<IMetaDataPK> logPks = this.getMetaDataPKs(MetaDataTypeList.LOG);
            if (logPks != null) {
                String type = MetaDataTypeList.LOG.toString();
                for (IMetaDataPK pk : logPks) {
                    LogInfo log = (LogInfo)this.getMDLoader().loadMD(new MetaDataPK2(pk.getFullName(), type));
                    this.addAll(allLog, log, true);
                }
            }
            this.isGetted = true;
            return allLog;
        }

        private void addAll(LogInfo allLog, LogInfo log, boolean userDefined) {
            if (log == null || allLog == null) {
                return;
            }
            LogItemCollection allCol = allLog.getLogItems();
            LogItemCollection col = log.getLogItems();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                col.get(i).setUserDefined(userDefined);
                allCol.add(col.get(i));
            }
        }
    }

    static abstract class AbstractMDProvider<T extends AbstractMetaDataValue>
    implements MDProvider<T> {
        AbstractMDProvider() {
        }

        MDLoader getMDLoader() {
            if (ConfigMDUtil.isClient()) {
                MetaDataLoaderFactory.getRemoteMetaDataLoader();
            }
            return MDLoader.getInstance();
        }

        Set<IMetaDataPK> getMetaDataPKs(BOSObjectType metaType) {
            Map<BOSObjectType, Set<IMetaDataPK>> pks = this.getMDLoader().cl.getMDContext().pkIndexs.getMetaDataPKsFromDB(null);
            if (pks != null) {
                return pks.get(metaType);
            }
            return null;
        }
    }
}

