/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.Identity;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class MetaDataPK
extends ObjectMultiPK
implements IMetaDataPK,
Identity {
    private static final long serialVersionUID = -65534L;
    private static final MetaDataPK EMPTY = new MetaDataPK();
    private static final PrototypePool pool = new PrototypePool(60);
    private String fullName = null;
    private int packLen = -1;
    private static final ConcurrentMap dynInstances = new ConcurrentMap(new LRUMap());
    private static final ConcurrentMap instances = new ConcurrentMap(new HashMap<MetaDataPK, MetaDataPK>());
    private int h = 0;

    public MetaDataPK() {
    }

    protected MetaDataPK(boolean pk2) {
    }

    public MetaDataPK(String fullName) {
        this(fullName, fullName.lastIndexOf(46));
    }

    private MetaDataPK(String fullName, int packLen) {
        this.fullName = fullName;
        this.packLen = packLen;
    }

    public MetaDataPK(String packageName, String name) {
        this.setPackage(packageName);
        this.setName(name);
    }

    public static MetaDataPK create(String packageName, String name) {
        if (packageName == null && name == null) {
            return EMPTY;
        }
        return MetaDataPK.getInstance(packageName, name);
    }

    public static MetaDataPK create(String fullName) {
        if (fullName == null) {
            return EMPTY;
        }
        return MetaDataPK.getInstance(fullName);
    }

    public static MetaDataPK create(IMetaDataPK pk) {
        if (pk == null) {
            return null;
        }
        MetaDataPK npk = pk instanceof MetaDataPK ? MetaDataPK.innerGetInstance((MetaDataPK)pk, false) : MetaDataPK.create(pk.getFullName());
        return npk;
    }

    private static MetaDataPK innerGetInstance(MetaDataPK newPk, boolean isNew) {
        if (newPk == null) {
            return null;
        }
        if (newPk.getPackage() == null) {
            return dynInstances.get(newPk, isNew);
        }
        return instances.get(newPk, isNew);
    }

    private static final MetaDataPK getInstance(String packageName, String name) {
        MetaDataPK prototype = pool.getPrototype();
        prototype.setPackage(packageName);
        prototype.setName(name);
        MetaDataPK pk = MetaDataPK.innerGetInstance(prototype, true);
        pool.recycle(prototype);
        return pk;
    }

    private static final MetaDataPK getInstance(String fullName) {
        MetaDataPK prototype = pool.getPrototype();
        int i = fullName.lastIndexOf(46);
        prototype.fullName = fullName;
        prototype.packLen = i;
        MetaDataPK pk = MetaDataPK.innerGetInstance(prototype, true);
        pool.recycle(prototype);
        return pk;
    }

    @Override
    public String getName() {
        if (this.fullName == null || this.fullName.length() == this.packLen) {
            return null;
        }
        return this.fullName.substring(this.packLen + 1);
    }

    @Override
    public String getPackage() {
        if (this.fullName == null || this.packLen <= 0) {
            return null;
        }
        return this.fullName.substring(0, this.packLen);
    }

    @Override
    public String toString() {
        if (this.fullName != null) {
            return this.fullName.replace('.', File.separatorChar);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetaDataPK)) {
            return false;
        }
        MetaDataPK that = (MetaDataPK)o;
        if (this.fullName != null) {
            return this.fullName.equalsIgnoreCase(that.fullName);
        }
        return that.fullName == null;
    }

    public void put(String key, String value) {
        this.setKeyValue(key, value);
    }

    public String get(String key) {
        return (String)this.getKeyValue(key);
    }

    private void setName(String name) {
        this.fullName = this.fullName == null || this.packLen < 0 ? name : (StringUtils.isEmpty((String)name) ? this.fullName.substring(0, this.packLen) : this.fullName.substring(0, this.packLen) + "." + name);
    }

    private void setPackage(String pack) {
        if (this.fullName == null || this.fullName.length() == this.packLen) {
            this.fullName = pack;
            this.packLen = StringUtils.isEmpty((String)pack) ? -1 : pack.length();
        } else if (StringUtils.isEmpty((String)pack)) {
            this.fullName = this.fullName.substring(this.packLen + 1);
            this.packLen = -1;
        } else {
            this.fullName = pack + "." + this.fullName.substring(this.packLen + 1);
            this.packLen = pack.length();
        }
    }

    @Override
    protected void valueChanged(String key, Object value) {
        super.valueChanged(key, value);
        if ("name".equals(key)) {
            this.setName((String)value);
            return;
        }
        if ("package".equals(key)) {
            this.setPackage((String)value);
            return;
        }
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public int hashCode() {
        if (this.h == 0 && this.fullName != null) {
            this.h = this.fullName.hashCode();
        }
        return this.h;
    }

    @Override
    public void clear() {
        super.clear();
        this.fullName = null;
        this.packLen = -1;
        this.h = 0;
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        boolean isFullNameNull = this.fullName == null;
        marshaller.writeBoolean(isFullNameNull);
        if (!isFullNameNull) {
            marshaller.writeObject((Object)this.fullName);
        }
        marshaller.writeInt(this.packLen);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        boolean isFullNameNull = unmarshaller.readBoolean();
        if (!isFullNameNull) {
            this.fullName = (String)unmarshaller.readObject();
        }
        this.packLen = unmarshaller.readInt();
    }

    public Object getIdentity() {
        return this.getFullName();
    }

    private static class ConcurrentMap {
        private final Map<MetaDataPK, MetaDataPK> map;
        private final ReentrantLock lock = new ReentrantLock();

        ConcurrentMap(Map<MetaDataPK, MetaDataPK> map) {
            this.map = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MetaDataPK get(MetaDataPK key, boolean isNew) {
            MetaDataPK pk = null;
            if (!(this.map instanceof LinkedHashMap) && (pk = this.map.get(key)) != null) {
                return pk;
            }
            this.lock.lock();
            try {
                pk = this.map.get(key);
                if (pk == null) {
                    pk = isNew ? new MetaDataPK(key.fullName, key.packLen) : key;
                    this.map.put(pk, pk);
                }
            }
            finally {
                this.lock.unlock();
            }
            return pk;
        }
    }

    private static class LRUMap
    extends LinkedHashMap<MetaDataPK, MetaDataPK> {
        private static final long serialVersionUID = -5881065647792137878L;
        private static final int MAX_SIZE = 5000;

        LRUMap() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<MetaDataPK, MetaDataPK> arg0) {
            return this.size() > 5000;
        }
    }

    private static class PrototypePool {
        private static final int IDLE = -1;
        private static final int GET = 0;
        private static final int RECYCLE = 1;
        final int count;
        final LinkedList<MetaDataPK> list;
        private final AtomicInteger state;

        PrototypePool(int count) {
            this.count = count;
            this.list = new LinkedList();
            for (int i = 0; i < count; ++i) {
                this.list.add(new MetaDataPK());
            }
            this.state = new AtomicInteger(-1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized MetaDataPK getPrototype() {
            MetaDataPK pk;
            block6: {
                pk = null;
                int i = 0;
                do {
                    ++i;
                    if (!this.state.compareAndSet(-1, 0)) continue;
                    try {
                        pk = this.list.isEmpty() ? new MetaDataPK() : this.list.removeFirst();
                        break block6;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block6;
                    }
                    finally {
                        this.state.set(-1);
                    }
                } while (i <= 10);
                return new MetaDataPK();
            }
            return pk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void recycle(MetaDataPK pk) {
            pk.clear();
            int i = 0;
            while (true) {
                ++i;
                if (this.state.compareAndSet(-1, 1)) {
                    try {
                        if (this.list.size() >= this.count) break;
                        this.list.addLast(pk);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                    finally {
                        this.state.set(-1);
                    }
                }
                if (i <= 2147473647) continue;
                i = 0;
                this.state.set(-1);
            }
        }
    }
}

