/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.upgrade.MetaCtrlFactory;
import com.kingdee.bos.metadata.upgrade.Solution;
import com.kingdee.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;

public class MetadataNameAudit {
    private static final String LOG_FILE_NAME = "name_audit.log";
    private static Writer os;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: NameVerify metadataPath");
            System.out.println("           result in name_verify.log");
        }
        Solution s = new Solution(args[0]);
        MetadataNameAudit.log("# [Define in metadata package + name + bosType]  ", "  [storage location filename]");
        boolean hasError = false;
        Enumeration en = s.getEntrys();
        while (en.hasMoreElements()) {
            MetadataNameAudit.needReleaseMemory();
            String entry = (String)en.nextElement();
            if (StringUtils.isEmpty((String)entry) || entry.endsWith("/") || entry.indexOf("CVS/") != -1 || entry.endsWith(".properties") || entry.endsWith(".txt") || entry.endsWith("/MANIFEST.MF") || entry.indexOf("/.") != -1) continue;
            try {
                IObjectValue ov = s.getObjectValue(entry);
                if (!(ov instanceof AbstractMetaDataValue)) continue;
                AbstractMetaDataValue m = (AbstractMetaDataValue)ov;
                String name = m.getFullName().replace('.', '/');
                String suffix = Utils.getMetaDataSuffix(m.getBOSType());
                if ((name = name + suffix).equals(entry)) continue;
                MetadataNameAudit.log(name, entry);
                hasError = true;
            }
            catch (Exception exception) {}
        }
        os.flush();
        os.close();
        if (hasError) {
            System.exit(1);
        }
    }

    private static boolean needReleaseMemory() {
        Runtime rt = Runtime.getRuntime();
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        long max = rt.maxMemory();
        if (max - (total - free) < 0x800000L) {
            MetaCtrlFactory.clearCtrls();
            return true;
        }
        return false;
    }

    private static void log(String objectName, String storeDir) throws Exception {
        os.write(objectName + " -- " + storeDir + "\n");
    }

    static {
        try {
            os = new FileWriter(LOG_FILE_NAME);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

