/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.Ref;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.apache.log4j.Logger;

public class RefImpl
implements Ref {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.RefImpl");
    private final String pk;
    private final String type;
    private transient Context ctx;
    private transient Object pin;
    private transient Lock findLock = new Lock();
    private transient Reference ref;

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.findLock = new Lock();
    }

    public RefImpl(String pk, String type) {
        this(pk, type, null);
    }

    public RefImpl(String pk, String type, Context ctx) {
        if (StringUtils.isEmpty((String)pk)) {
            throw new IllegalArgumentException("MetaDataPK is null");
        }
        this.pk = pk;
        if (StringUtils.isEmpty((String)type)) {
            throw new IllegalArgumentException("BOSType is null");
        }
        this.type = type;
        this.ctx = ctx;
    }

    public RefImpl(IMetaDataPK pk, BOSObjectType type) {
        this(pk, type, null);
    }

    public RefImpl(IMetaDataPK pk, BOSObjectType type, Context ctx) {
        if (pk == null || StringUtils.isEmpty((String)pk.getFullName())) {
            throw new IllegalArgumentException("MetaDataPK is null");
        }
        this.pk = pk.getFullName();
        if (type == null || StringUtils.isEmpty((String)type.toString())) {
            throw new IllegalArgumentException("BOSType is null");
        }
        this.type = type.toString();
        this.ctx = ctx;
    }

    public RefImpl(String pk, BOSObjectType type) {
        this(pk, type, null);
    }

    public RefImpl(String pk, BOSObjectType type, Context ctx) {
        if (StringUtils.isEmpty((String)pk)) {
            throw new IllegalArgumentException("MetaDataPK is null");
        }
        this.pk = pk;
        if (type == null || StringUtils.isEmpty((String)type.toString())) {
            throw new IllegalArgumentException("BOSType is null");
        }
        this.type = type.toString();
        this.ctx = ctx;
    }

    public RefImpl(IMetaDataPK pk, String type) {
        this(pk, type, null);
    }

    public RefImpl(IMetaDataPK pk, String type, Context ctx) {
        if (pk == null || StringUtils.isEmpty((String)pk.getFullName())) {
            throw new IllegalArgumentException("MetaDataPK is null");
        }
        this.pk = pk.getFullName();
        if (StringUtils.isEmpty((String)type)) {
            throw new IllegalArgumentException("BOSType is null");
        }
        this.type = type;
        this.ctx = ctx;
    }

    private AbstractMetaDataValue internalFindMetaData(Context newCtx) throws DataAccessException {
        IObjectValue rtv = XMLAccessEngine.find(newCtx, BOSObjectType.create((String)this.type), MetaDataPKFactory.getMetaDataPK(this.pk));
        return (AbstractMetaDataValue)rtv;
    }

    @Override
    public synchronized void clearMetaData() {
        this.unpinObject();
        this.ref = null;
    }

    @Override
    public synchronized Context getResolveContext() {
        return this.ctx;
    }

    @Override
    public synchronized IMetaDataPK getResolvePK() {
        return MetaDataPKFactory.getMetaDataPK(this.pk);
    }

    @Override
    public synchronized String getResolvePKName() {
        return this.pk;
    }

    @Override
    public synchronized BOSObjectType getResolveType() {
        return BOSObjectType.create((String)this.type);
    }

    @Override
    public synchronized String getResolveTypeName() {
        return this.type;
    }

    @Override
    public synchronized void resetResolveContext(Context ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Context is null");
        }
        this.ctx = ctx;
    }

    @Override
    public AbstractMetaDataValue resolveMetaData() {
        return this.resolveMetaData(this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractMetaDataValue resolveMetaData(Context newCtx) {
        Lock lock = this.findLock;
        synchronized (lock) {
            AbstractMetaDataValue rtv;
            while (true) {
                rtv = null;
                if (this.ref != null) {
                    rtv = (AbstractMetaDataValue)this.ref.get();
                }
                if (rtv != null) {
                    return rtv;
                }
                if (!this.findLock.isFinding) break;
                try {
                    this.findLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.findLock.isFinding = true;
            try {
                rtv = this.internalFindMetaData(newCtx);
                this.ref = new SoftReference<AbstractMetaDataValue>(rtv);
            }
            catch (DataAccessException e) {
                logger.error((Object)e);
            }
            finally {
                this.findLock.isFinding = false;
                this.findLock.notifyAll();
            }
            return rtv;
        }
    }

    @Override
    public synchronized boolean isPined() {
        return this.pin != null;
    }

    @Override
    public synchronized void pinObject() {
        if (this.pin == null) {
            this.pin = this.resolveMetaData();
        }
    }

    @Override
    public synchronized void unpinObject() {
        this.pin = null;
    }

    public int hashCode() {
        return this.pk.hashCode() + this.type.hashCode();
    }

    public boolean equals(Object x) {
        if (x == null || !(x instanceof Ref)) {
            return false;
        }
        Ref xx = (Ref)x;
        return this.pk.equals(xx.getResolvePKName()) && this.type.equals(xx.getResolveTypeName());
    }

    public String toString() {
        return "{PK=" + this.pk + " and Type=" + this.type + "}";
    }

    private static class Lock {
        boolean isFinding = false;

        private Lock() {
        }
    }
}

