/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MDSetting;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class SourceFiles {
    private static final Logger logger = Logger.getLogger(SourceFiles.class);
    private File[] innerSrcs;
    private JarFile[] jarSrcs;
    private Set<File> isFileInnerSrcs = new HashSet<File>();
    private final MDContext mdCtx;

    SourceFiles(MDContext mdCtx) {
        this.mdCtx = mdCtx;
        mdCtx.setSourceFiles(this);
        this.innerSrcs = new File[0];
        this.jarSrcs = new JarFile[0];
    }

    SourceFiles(MDContext mdCtx, MDSetting setting) {
        int i;
        this.mdCtx = mdCtx;
        mdCtx.setSourceFiles(this);
        String[] sources = setting.getMetadataPath().paths;
        if (sources == null || sources.length == 1 && StringUtils.isEmpty((String)sources[0])) {
            sources = new String[]{};
        }
        this.innerSrcs = new File[sources.length];
        this.jarSrcs = new JarFile[this.innerSrcs.length];
        int len = sources.length;
        for (i = 0; i < len; ++i) {
            this.innerSrcs[i] = new File(sources[i]);
            if (this.innerSrcs[i].exists()) continue;
            logger.warn((Object)("Metadata source path[" + sources[i] + "] NOT exist!"));
        }
        len = this.innerSrcs.length;
        for (i = 0; i < len; ++i) {
            if (this.innerSrcs[i].isFile()) {
                try {
                    this.jarSrcs[i] = new JarFile(this.innerSrcs[i]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error Meta Jar:" + this.innerSrcs[i].getAbsolutePath() + ". Cause:" + e.getMessage());
                }
                this.isFileInnerSrcs.add(this.innerSrcs[i]);
                mdCtx.pkIndexs.loadFileToBase(this.innerSrcs[i]);
                continue;
            }
            if (this.innerSrcs[i].isDirectory()) {
                mdCtx.pkIndexs.loadDirectoryToBase(this.innerSrcs[i]);
                continue;
            }
            assert (false) : "Invalidate metadata path[" + this.innerSrcs[i].toString() + "]";
        }
    }

    public synchronized void addSource(String jarFile) throws IOException {
        File file = new File(jarFile);
        if (file.exists()) {
            File[] newInnerSrcs = new File[this.innerSrcs.length + 1];
            for (int i = 0; i < this.innerSrcs.length; ++i) {
                newInnerSrcs[i] = this.innerSrcs[i];
            }
            newInnerSrcs[this.innerSrcs.length] = file;
            JarFile[] newJarSrcs = new JarFile[this.jarSrcs.length + 1];
            for (int i = 0; i < this.jarSrcs.length; ++i) {
                newJarSrcs[i] = this.jarSrcs[i];
            }
            newJarSrcs[this.jarSrcs.length] = new JarFile(file);
            this.mdCtx.pkIndexs.loadFileToBase(newInnerSrcs[newInnerSrcs.length - 1]);
            this.innerSrcs = newInnerSrcs;
            this.jarSrcs = newJarSrcs;
        }
    }

    public String getMetaDataSavePath() {
        int len = this.innerSrcs.length;
        for (int i = 0; i < len; ++i) {
            if (!this.innerSrcs[i].isDirectory()) continue;
            return this.innerSrcs[i].toString();
        }
        throw new IllegalStateException("Please set metadataSavePath");
    }

    public File[] getInnerSrcs() {
        return this.innerSrcs;
    }

    public JarFile[] getJarSrcs() {
        return this.jarSrcs;
    }

    public Set<File> getIsFileInnerSrcs() {
        return this.isFileInnerSrcs;
    }

    public void close() {
        if (this.jarSrcs != null) {
            for (int i = 0; i < this.jarSrcs.length; ++i) {
                try {
                    if (this.jarSrcs[i] == null) continue;
                    this.jarSrcs[i].close();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(this.jarSrcs[i].getName() + " is closed."));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }
}

